/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.auxacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.client.AbstractAccountSelectUI;
import com.kingdee.eas.basedata.master.auxacct.client.AuxAccountEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JButton;

public class AccountSelectUI
extends AbstractAccountSelectUI {
    public String resClassName = "com.kingdee.eas.basedata.master.auxacct.client.AuxAcctResource";
    AccountTableInfo accountTableInfo = null;
    CompanyOrgUnitInfo companyInfo = null;
    protected IObjectPK[] selectedPKs = null;
    protected boolean isCanceled = false;
    AuxAccountEditUI auxAccountEditUI = null;

    protected JButton getDefaultButton() {
        return this.btnSelected;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadContext();
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        this.mainQuery.setFilter(this.getAccountsFilter());
    }

    private void loadContext() {
        this.accountTableInfo = (AccountTableInfo)this.getUIContext().get("table");
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        this.auxAccountEditUI = (AuxAccountEditUI)((Object)this.getUIContext().get("Owner"));
    }

    private FilterInfo getAccountsFilter() throws BOSException, EASBizException {
        Set noDealAccountNumberSet;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", this.companyInfo != null ? this.companyInfo.getId().toString() : null));
        filterInfo.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Boolean(false), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Boolean(false), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", this.accountTableInfo != null ? this.accountTableInfo.getId().toString() : null));
        filterInfo.getFilterItems().add(new FilterItemInfo("CAA.id", null, CompareType.EQUALS));
        if (this.accountTableInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resClassName, (String)"AccountTableIsNull"));
            SysUtil.abort();
        }
        if ((noDealAccountNumberSet = AccountViewFactory.getRemoteInstance().getNoDealAccountNumberSet(this.companyInfo.getId(), this.accountTableInfo.getId())) != null && noDealAccountNumberSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)noDealAccountNumberSet, CompareType.INNER));
        }
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSelected_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelected_actionPerformed(e);
        this.isCanceled = false;
        this.auxAccountEditUI.isCanceled = false;
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID != null && rowID.length > 0) {
            this.selectedPKs = new IObjectPK[rowID.length];
            this.auxAccountEditUI.selectedPKs = new IObjectPK[rowID.length];
            for (int i = 0; i < rowID.length; ++i) {
                String strID = this.tblMain.getRow(rowID[i]).getCell(0).getValue().toString();
                this.selectedPKs[i] = new ObjectUuidPK(strID);
                this.auxAccountEditUI.selectedPKs[i] = new ObjectUuidPK(strID);
            }
        }
        this.getUIWindow().close();
    }

    @Override
    protected void Cancel_actionPerformed(ActionEvent e) throws Exception {
        super.Cancel_actionPerformed(e);
        this.isCanceled = true;
        this.auxAccountEditUI.isCanceled = true;
        this.getUIWindow().close();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        } else if (e.getClickCount() == 2) {
            this.btnSelected_actionPerformed(null);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("GAA.name"));
        sic.add(new SelectorItemInfo("GAA.number"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        return sic;
    }
}

