/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.auxacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.client.AbstractAuxAccountEditUI;
import com.kingdee.eas.basedata.master.auxacct.client.AsstActTypeUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class AuxAccountEditUI
extends AbstractAuxAccountEditUI {
    public String resClassName = "com.kingdee.eas.basedata.master.auxacct.client.AuxAcctResource";
    private AccountViewCollection accountViewCollectionTemp = null;
    CtrlUnitInfo currentCtrlUnit = null;
    CompanyOrgUnitInfo currentCompanyOrgUnit = null;
    protected boolean dirty = false;
    AccountViewCollection accounts = null;
    public HashMap map = new HashMap();
    public boolean isCanceled = false;
    public IObjectPK[] selectedPKs = null;

    public void onLoad() throws Exception {
        this.setupKDTable();
        SysContext context = SysContext.getSysContext();
        this.currentCtrlUnit = context.getCurrentCtrlUnit();
        this.currentCompanyOrgUnit = context.getCurrentFIUnit();
        this.accountTablePrompBox.setHasCUDefaultFilter(false);
        OrgUnitInfo company = context.getCurrentOrgUnit();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        this.accountTablePrompBox.setEntityViewInfo(evi);
        if (company.isIsCompanyOrgUnit() && context.getCurrentFIUnit().getAccountTable() != null) {
            AccountTableInfo table = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(context.getCurrentFIUnit().getAccountTable().getId()));
            this.accountTablePrompBox.setData((Object)table);
        } else {
            QueryAgent qa = this.accountTablePrompBox.getQueryAgent();
            IRowSet rs = qa.executeQuery(0, 1);
            if (rs.next()) {
                AccountTableInfo at = new AccountTableInfo();
                at.setId(BOSUuid.read((String)rs.getString("id")));
                at.setNumber(rs.getString("number"));
                at.setName(rs.getString("name"));
                this.accountTablePrompBox.setValue((Object)at);
            }
        }
        super.onLoad();
        this.initMyControl();
        this.initMyIcon();
    }

    private void initMyControl() {
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnFirst.setVisible(false);
    }

    private void initMyIcon() {
        this.setUITitle(EASResource.getString((String)this.resClassName, (String)"AsstAccountList"));
        this.btnUpdateAccouts.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAdd.setText(null);
        Icon addnewbg = EASResource.getIcon((String)"imgTbtn_addline");
        this.btnAdd.setIcon(addnewbg);
        this.btnDeleteLine.setText(null);
        Icon cancelbg = EASResource.getIcon((String)"imgTbtn_deleteline");
        this.btnDeleteLine.setIcon(cancelbg);
    }

    private void setupKDTable() {
        this.kDTable1.checkParsed();
        this.kDTable1.getColumn(1).getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn(2).getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn(3).getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn(4).getStyleAttributes().setLocked(false);
    }

    @Override
    public void actionUpdateAccounts_actionPerformed(ActionEvent e) throws Exception {
        AccountViewCollection acounts = this.getModifiedAccounts();
        if (acounts == null || acounts.size() <= 0) {
            return;
        }
        AsstAccountInfo asstAccountInfo = (AsstAccountInfo)this.asstAccountPromptBox.getValue();
        for (int i = 0; i < acounts.size(); ++i) {
            AccountViewInfo acctInfo = acounts.get(i);
            String warnStr = AccountFacadeFactory.getRemoteInstance().checkCompanyAuxAccount(acctInfo.getId().toString(), asstAccountInfo.getId().toString());
            if (StringUtils.isEmpty((String)warnStr)) continue;
            MsgBox.showWarning((String)warnStr);
            SysUtil.abort();
        }
        try {
            if (this.asstAccountPromptBox.getValue() == null) {
                MsgBox.showError((String)EASResource.getString((String)(this.resClassName + ".pleaseAsstTypeNumber")));
                return;
            }
            if (this.accountTablePrompBox.getValue() == null) {
                MsgBox.showError((String)EASResource.getString((String)(this.resClassName + ".pleaseAccountTable")));
                return;
            }
            if (this.runUpdateAccounts(acounts)) {
                MsgBox.showInfo((String)EASResource.getString((String)"saveSuccessed"));
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)err);
        }
        this.loadAccounts();
    }

    private AccountViewCollection getModifiedAccounts() throws Exception {
        StringBuffer msg = new StringBuffer();
        String res = EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_1");
        String res_2 = EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_2");
        String res_4 = EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_4");
        AccountViewCollection accounts = new AccountViewCollection();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            AccountViewInfo old = (AccountViewInfo)row.getUserObject();
            if (!this.isAccountModified(row)) continue;
            AccountViewInfo newAccount = (AccountViewInfo)old.clone();
            newAccount.setAC(((Boolean)row.getCell(4).getValue()).booleanValue());
            newAccount.setCAA((AsstAccountInfo)row.getCell(3).getValue());
            if (!AccountTools.checkAccountHasReference(null, (AccountViewInfo)newAccount)) {
                accounts.add(newAccount);
                continue;
            }
            if (msg.length() > 0) {
                msg.append(res);
            } else {
                msg.append(res_2);
            }
            msg.append(newAccount.getNumber()).append(newAccount.getName());
        }
        for (AccountViewInfo old : this.accountViewCollectionTemp) {
            AccountViewInfo newAccount = (AccountViewInfo)old.clone();
            newAccount.setCAA(null);
            if (!AccountTools.checkAccountHasReference(null, (AccountViewInfo)newAccount)) {
                accounts.add(newAccount);
                continue;
            }
            if (msg.length() > 0) {
                msg.append(res);
            } else {
                msg.append(res_2);
            }
            msg.append(newAccount.getNumber()).append(newAccount.getName());
        }
        if (msg.length() > 0) {
            String res_10 = EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_10");
            msg.append(res_4).append("\n\n\n").append(res_10);
            int result = MsgBox.showConfirm2((String)msg.toString());
            if (result != 0) {
                SysUtil.abort();
            }
        }
        return accounts;
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        KDTSelectBlock selectBlock = this.kDTable1.getSelectManager().get();
        if (selectBlock != null) {
            StringBuffer msg = new StringBuffer();
            int top = selectBlock.getTop();
            int bot = selectBlock.getBottom();
            for (int i = top; i < bot + 1; ++i) {
                row = this.kDTable1.getRow(i);
                if (row == null) continue;
                AccountViewInfo account = (AccountViewInfo)row.getUserObject();
                boolean isNew = true;
                for (int j = 0; j < this.accounts.size(); ++j) {
                    if (!this.accounts.get(j).getId().equals((Object)account.getId())) continue;
                    isNew = false;
                    break;
                }
                if (isNew) {
                    row.getCell(3).setValue(null);
                    this.kDTable1.removeRow(row.getRowIndex());
                    continue;
                }
                if (!AccountTools.checkAccountHasReference(null, (AccountViewInfo)account)) {
                    row.getCell(3).setValue(null);
                    this.accountViewCollectionTemp.add(account);
                    this.kDTable1.removeRow(row.getRowIndex());
                    continue;
                }
                msg.append(account.getName()).append(EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_1"));
            }
            if (msg.length() > 0) {
                msg.deleteCharAt(msg.length() - 1);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"HasBiz"), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_2") + msg + EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_4")), (int)2);
            }
        }
    }

    private boolean isAccountModified(IRow row) {
        AccountViewInfo old = (AccountViewInfo)row.getUserObject();
        boolean isAC = false;
        if (row.getCell(4).getValue() instanceof Boolean) {
            isAC = (Boolean)row.getCell(4).getValue();
        } else {
            row.getCell(4).setValue((Object)Boolean.FALSE);
        }
        AsstAccountInfo caa = (AsstAccountInfo)row.getCell(3).getValue();
        return old.isAC() != isAC || !AuxAccountEditUI.isObjectBaseInfoEqual((ObjectBaseInfo)old.getCAA(), (ObjectBaseInfo)caa);
    }

    public static boolean isObjectBaseInfoEqual(ObjectBaseInfo obj1, ObjectBaseInfo obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.getId().toString().equals(obj2.getId().toString());
    }

    private boolean runUpdateAccounts(AccountViewCollection accounts) throws EASBizException, BOSException {
        if (accounts != null) {
            for (int i = 0; i < accounts.size(); ++i) {
                int result;
                boolean isSame;
                AccountViewInfo account = accounts.get(i);
                if (account.getCAA() != null && !(isSame = AsstActTypeUtils.isSameMeasureWithAccount(account.getId().toString(), account.getCAA().getId().toString(), null, null)) && (result = MsgBox.showConfirm2((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.AUXACCTAutoGenerateResource", (String)"13_AuxAccountEditUI") + account.getNumber() + EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.AUXACCTAutoGenerateResource", (String)"14_AuxAccountEditUI")))) != 0) {
                    SysUtil.abort();
                }
                IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
                iAccountView.updateAcctounProperties((IObjectPK)new ObjectUuidPK(account.getId().toString()), (IObjectValue)account);
            }
        } else {
            SysUtil.abort();
            return false;
        }
        CacheServiceFactory.getInstance().discardType(BOSObjectType.create((String)"9DA99826"));
        return true;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.asstAccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstAccountForRefQuery");
        this.asstAccountPromptBox.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                EntityViewInfo evi = AuxAccountEditUI.this.getAsstAccountReferenceFilter(SysContext.getSysContext().getCurrentFIUnit());
                return evi.getFilter();
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
        this.asstAccountPromptBox.setData((Object)this.editData);
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.kDBizMultiLangBox1, (IObjectValue)this.editData, (String)"name");
    }

    private EntityViewInfo getCompanyAccountsEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        AsstAccountInfo asstaccountInfo = (AsstAccountInfo)this.asstAccountPromptBox.getData();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CAA.id", asstaccountInfo != null && asstaccountInfo.getId() != null ? asstaccountInfo.getId().toString() : null));
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", this.currentCompanyOrgUnit != null ? this.currentCompanyOrgUnit.getId().toString() : null));
        if (this.accountTablePrompBox.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)((AccountTableInfo)this.accountTablePrompBox.getData()).getId().toString()));
        }
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("CAA.number"));
        evi.getSelector().add(new SelectorItemInfo("CAA.name"));
        return evi;
    }

    protected void loadAccounts() throws EASBizException, BOSException {
        this.kDTable1.removeRows();
        this.accounts = AccountViewFactory.getRemoteInstance().getAccountViewCollection(this.getCompanyAccountsEntityViewInfo());
        for (int i = 0; i < this.accounts.size(); ++i) {
            AccountViewInfo account = this.accounts.get(i);
            IRow row = this.kDTable1.addRow();
            row.setUserObject((Object)account);
            row.getCell(0).setValue((Object)account.getId().toString());
            row.getCell(1).setValue((Object)account.getNumber());
            row.getCell(2).setValue((Object)account.getName());
            row.getCell(3).setValue((Object)account.getCAA());
            row.getCell(4).setValue((Object)new Boolean(account.isAC()));
        }
        this.accountViewCollectionTemp = new AccountViewCollection();
    }

    @Override
    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AsstAccountFactory.getRemoteInstance();
    }

    @Override
    protected void asstAccountPromptBox_dataChanged(DataChangeEvent e) throws Exception {
        AsstAccountInfo asstaccountInfo = (AsstAccountInfo)this.asstAccountPromptBox.getData();
        if (asstaccountInfo != null) {
            this.kDBizMultiLangBox1.setSelectedItemData((Object)asstaccountInfo.getName());
        } else {
            this.kDBizMultiLangBox1.setSelectedItemData(null);
        }
        if (asstaccountInfo != null) {
            this.loadAccounts();
        }
    }

    @Override
    protected void accountTablePrompBox_dataChanged(DataChangeEvent e) throws Exception {
        this.asstAccountPromptBox_dataChanged(e);
    }

    public SelectorItemCollection getAccountSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("GAA.number"));
        sic.add(new SelectorItemInfo("GAA.name"));
        return sic;
    }

    private IRow getSelectedRow() {
        IRow row = null;
        KDTSelectBlock selectBlock = this.kDTable1.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            row = this.kDTable1.getRow(rowIndex);
        }
        return row;
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.map.put("Owner", this);
        this.map.put("table", this.accountTablePrompBox.getData());
        this.map.put("company", this.currentCompanyOrgUnit);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.basedata.master.auxacct.client.AccountSelectUI", (Map)this.map);
        uiWindow.show();
        if (!this.isCanceled) {
            this.addSelectedAccounts(this.selectedPKs);
        }
    }

    private void addSelectedAccounts(IObjectPK[] selectedPKs) throws EASBizException, BOSException {
        StringBuffer msg = new StringBuffer();
        if (selectedPKs != null) {
            for (int i = 0; i < selectedPKs.length; ++i) {
                IObjectPK pk = selectedPKs[i];
                if (this.isInTable(pk)) continue;
                AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo(pk, this.getAccountSelectors());
                AsstAccountInfo caa = account.getCAA();
                account.setCAA((AsstAccountInfo)this.asstAccountPromptBox.getData());
                if (!AccountTools.checkAccountHasReference(null, (AccountViewInfo)account)) {
                    this.checkAACM(account, selectedPKs);
                    IRow row = this.kDTable1.addRow();
                    row.setUserObject((Object)account);
                    row.getCell(0).setValue((Object)account.getId().toString());
                    row.getCell(1).setValue((Object)account.getNumber());
                    row.getCell(2).setValue((Object)account.getName());
                    row.getCell(3).setValue((Object)((AsstAccountInfo)this.asstAccountPromptBox.getData()));
                    row.getCell(4).setValue((Object)new Boolean(account.isAC()));
                } else {
                    msg.append(account.getNumber()).append(account.getName()).append(EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_1"));
                }
                account.setCAA(caa);
            }
            if (msg.length() > 0) {
                msg.deleteCharAt(msg.length() - 1);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"HasBiz"), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_2") + msg + EASResource.getString((String)"com.kingdee.eas.basedata.master.auxacct.auxResource", (String)"res_3")), (int)2);
            }
        }
    }

    private void checkAACM(AccountViewInfo accountViewInfo, IObjectPK[] selectedPKs) throws BOSException, EASBizException {
        ObjectUuidPK pkParent;
        ObjectUuidPK pkCompany;
        ObjectUuidPK pkUpper;
        IAsstAccount iAsstAccount;
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        if (accountViewInfo.getGAA() != null && accountViewInfo.getCAA() == null) {
            throw new AccountException(AccountException.NOT_INCLUDE_UPPER_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getGAA() != null && accountViewInfo.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getRemoteInstance()).compare((IObjectPK)(pkUpper = new ObjectUuidPK(accountViewInfo.getGAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId())))) {
            throw new AccountException(AccountException.NOT_INCLUDE_UPPER_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() == null) {
            throw new AccountException(AccountException.NOT_INCLUDE_PARENT_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getParentAA() != null && accountViewInfo.getCAA() != null && !(iAsstAccount = AsstAccountFactory.getRemoteInstance()).compare((IObjectPK)(pkParent = new ObjectUuidPK(accountViewInfo.getParentAA().getId())), (IObjectPK)(pkCompany = new ObjectUuidPK(accountViewInfo.getCAA().getId())))) {
            throw new AccountException(AccountException.NOT_INCLUDE_PARENT_ASST, new Object[]{accountViewInfo.getNumber(), ""});
        }
        if (accountViewInfo.getId() != null && accountViewInfo.getId().toString().length() > 0) {
            EntityViewInfo eviForChild = new EntityViewInfo();
            FilterInfo filterForChild = new FilterInfo();
            eviForChild.setFilter(filterForChild);
            filterForChild.getFilterItems().add(new FilterItemInfo("parent", (Object)accountViewInfo.getId().toString()));
            filterForChild.getFilterItems().add(new FilterItemInfo("companyID", (Object)accountViewInfo.getCompanyID().getId().toString()));
            AccountViewCollection children = iAccountView.getAccountViewCollection(eviForChild);
            if (children != null) {
                int count = children.size();
                for (int i = 0; i < count; ++i) {
                    AccountViewInfo child = children.get(i);
                    child.getId().toString();
                    boolean check = true;
                    for (int j = 0; j < selectedPKs.length; ++j) {
                        IObjectPK pk = selectedPKs[j];
                        if (!pk.toString().equals(child.getId().toString())) continue;
                        check = false;
                        break;
                    }
                    if (check && child.getCAA() == null && accountViewInfo.getCAA() != null) {
                        throw new AccountException(AccountException.CHILD_NOT_INCLUDE_ASST, new Object[]{child.getNumber(), accountViewInfo.getNumber()});
                    }
                    if (child.getCAA() == null || accountViewInfo.getCAA() == null) continue;
                    IAsstAccount iAsstAccount2 = AsstAccountFactory.getRemoteInstance();
                    ObjectUuidPK pkChild = new ObjectUuidPK(child.getCAA().getId());
                    ObjectUuidPK pkCompany2 = new ObjectUuidPK(accountViewInfo.getCAA().getId());
                    if (iAsstAccount2.compare((IObjectPK)pkCompany2, (IObjectPK)pkChild)) continue;
                    throw new AccountException(AccountException.CHILD_NOT_INCLUDE_ASST, new Object[]{child.getNumber(), accountViewInfo.getNumber()});
                }
            }
            EntityViewInfo eviForInferior = new EntityViewInfo();
            FilterInfo filterForInferior = new FilterInfo();
            eviForInferior.setFilter(filterForInferior);
            filterForInferior.getFilterItems().add(new FilterItemInfo("upper", (Object)accountViewInfo.getId().toString()));
            filterForInferior.getFilterItems().add(new FilterItemInfo("companyID", (Object)accountViewInfo.getCompanyID().getId().toString()));
            AccountViewCollection inferiors = iAccountView.getAccountViewCollection(eviForInferior);
            if (inferiors != null) {
                int count = inferiors.size();
                for (int i = 0; i < count; ++i) {
                    AccountViewInfo inferior = inferiors.get(i);
                    if (inferior.getCAA() == null && accountViewInfo.getCAA() != null) {
                        throw new AccountException(AccountException.DOWN_NOT_INCLUDE_ASST, new Object[]{inferior.getNumber(), accountViewInfo.getNumber()});
                    }
                    if (inferior.getCAA() == null || accountViewInfo.getCAA() == null) continue;
                    IAsstAccount iAsstAccount3 = AsstAccountFactory.getRemoteInstance();
                    ObjectUuidPK pkInferior = new ObjectUuidPK(inferior.getCAA().getId());
                    ObjectUuidPK pkCompany3 = new ObjectUuidPK(accountViewInfo.getCAA().getId());
                    if (iAsstAccount3.compare((IObjectPK)pkCompany3, (IObjectPK)pkInferior)) continue;
                    throw new AccountException(AccountException.DOWN_NOT_INCLUDE_ASST, new Object[]{inferior.getNumber(), accountViewInfo.getNumber()});
                }
            }
        }
    }

    private boolean isInTable(IObjectPK pk) {
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            if (!pk.toString().equals(this.kDTable1.getRow(i).getCell(0).getValue().toString())) continue;
            return true;
        }
        return false;
    }

    private EntityViewInfo getAsstAccountReferenceFilter(CompanyOrgUnitInfo companyInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyLongNumber = companyInfo.getLongNumber();
        String[] companyNumber = companyLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < companyNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
            }
            sb.append(companyNumber[i]);
            compareLongNumber.append(sb.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("assignCompany.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        return evi;
    }

    private EntityViewInfo getAsstAccountReferenceFilter(CtrlUnitInfo cuInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String cuLongNumber = cuInfo.getLongNumber();
        String[] cuNumber = cuLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cuNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
            }
            sb.append(cuNumber[i]);
            compareLongNumber.append(sb.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("assignCU.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        return evi;
    }

    public boolean isModify() {
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (!this.isAccountModified(row)) continue;
            return true;
        }
        if (this.accountViewCollectionTemp != null && this.accountViewCollectionTemp.size() > 0) {
            return true;
        }
        return super.isModify();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionUpdateAccounts_actionPerformed(e);
    }
}

