/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.auxacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountReferenceCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountReferenceFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccountReference;
import com.kingdee.eas.basedata.master.auxacct.client.AbstractAuxAccountListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class AuxAccountListUI
extends AbstractAuxAccountListUI {
    private static final long serialVersionUID = -7926732269258091494L;
    public String resClassName = "com.kingdee.eas.basedata.master.auxacct.client.AuxAcctResource";
    private static final String FILTERFIELD_COMPANYID = "company.id";
    private AsstAccountCollection markReferenceCollection = new AsstAccountCollection();
    private String currentCUID = null;
    private String currentCompanyID = null;
    private String currentCompanyCUID = null;
    private static final String CONTROL_TYPE_NAME = "controlType";
    private static final String FILTERFIELD_CUID = "CU.id";
    private static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";
    private static final String CONTROLTYPE_S1 = "S1";
    private static final String CONTROLTYPE_S2 = "S2";
    private static final String CONTROLTYPE_S3 = "S3";
    private static final String CONTROLTYPE_S4 = "S4";
    private static final String CONTROLTYPE_I = "I";
    private static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_MODIFY = "ACTION_MODIFY";
    private ActionEvent actionEvent = null;
    QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public void onShow() throws Exception {
        super.onShow();
        this.getResultLines();
    }

    private void initTable() throws Exception {
        AsstAccountCollection asstAccountCollection = this.getCurrentAssign();
        asstAccountCollection.addObjectCollection((IObjectCollection)this.getParentAssign());
        this.markReferenceCollection = asstAccountCollection;
        if (asstAccountCollection != null && asstAccountCollection.size() > 0) {
            IRow row = null;
            int rowIndex = this.tblMain.getRowCount();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (int i = 0; i < asstAccountCollection.size(); ++i) {
                row = null;
                int count = this.tblMain.getRowCount();
                String number = asstAccountCollection.get(i).getNumber();
                for (int j = 0; j < count; ++j) {
                    String preNumber;
                    if (this.tblMain.getRow(j) == null || (preNumber = (String)this.tblMain.getRow(j).getCell("number").getValue()).compareTo(number) <= 0) continue;
                    row = this.tblMain.addRow(j);
                    break;
                }
                if (row == null) {
                    row = this.tblMain.addRow();
                }
                BOSUuid id = asstAccountCollection.get(i).getId();
                Object[] keyValues = new Object[]{id};
                list.add(keyValues);
                row.getCell("id").setValue((Object)id.toString());
                row.getCell("number").setValue((Object)asstAccountCollection.get(i).getNumber());
                row.getCell("name").setValue((Object)String.valueOf(asstAccountCollection.get(i).getName()));
                row.getCell("company.name").setValue((Object)String.valueOf(asstAccountCollection.get(i).getCompany().getName()));
                if (asstAccountCollection.get(i).getDescription() != null) {
                    row.getCell("description").setValue((Object)String.valueOf(asstAccountCollection.get(i).getDescription()));
                }
                row.getCell("isQty").setValue((Object)asstAccountCollection.get(i).isIsQty());
                if (asstAccountCollection.get(i).getMeasureUnit() != null) {
                    row.getCell("measureUnit").setValue((Object)String.valueOf(asstAccountCollection.get(i).getMeasureUnit()));
                }
                if (asstAccountCollection.get(i).getMeasureUnitGroup() != null) {
                    row.getCell("measureUnitGroup").setValue((Object)String.valueOf(asstAccountCollection.get(i).getMeasureUnitGroup()));
                }
                this.tblMain.setRowCount(++rowIndex);
            }
            this.processAllIdList(list);
        }
    }

    private AsstAccountCollection sorterAsstAccount(Object[] obj) {
        int size = obj.length;
        AsstAccountCollection allAsstAccount = new AsstAccountCollection();
        if (size > 0) {
            int i;
            for (i = 0; i < size; ++i) {
                AsstAccountInfo infoPre = (AsstAccountInfo)obj[i];
                String numberPre = infoPre.getNumber();
                for (int j = i + 1; j < size; ++j) {
                    AsstAccountInfo info = (AsstAccountInfo)obj[j];
                    String number = info.getNumber();
                    if (numberPre.compareTo(number) <= 0) continue;
                    AsstAccountInfo temp = infoPre;
                    obj[i] = info;
                    infoPre = info;
                    numberPre = infoPre.getNumber();
                    obj[j] = temp;
                }
            }
            for (i = 0; i < size; ++i) {
                AsstAccountInfo info = (AsstAccountInfo)obj[i];
                info.setName(info.getNumber() + " " + info.getName());
                allAsstAccount.add(info);
            }
        }
        return allAsstAccount;
    }

    private FilterInfo getMegeFilter() {
        FilterInfo filterInfoMerger = new FilterInfo();
        if (this.mainQuery != null) {
            FilterInfo filterInfoMain = this.mainQuery.getFilter();
            FilterItemCollection items = filterInfoMain.getFilterItems();
            int count = items.size();
            for (int i = 0; i < count; ++i) {
                if (!items.get(i).getPropertyName().equals("name") && !items.get(i).getPropertyName().equals("number") && !items.get(i).getPropertyName().equals("description")) continue;
                FilterItemInfo item = (FilterItemInfo)items.get(i).clone();
                item.setPropertyName("asstAccount." + items.get(i).getPropertyName());
                if (CompareType.ISNOT.equals((Object)item.getCompareType()) && item.getCompareValue() != null && "empty".equalsIgnoreCase(item.getCompareValue().toString())) {
                    item.setCompareType(CompareType.NOTEQUALS);
                    item.setCompareValue(null);
                }
                filterInfoMerger.getFilterItems().add(item);
            }
        }
        return filterInfoMerger;
    }

    AsstAccountCollection getCurrentAssign() {
        AsstAccountCollection aATC = new AsstAccountCollection();
        FilterInfo filterInfoMerger = this.getMegeFilter();
        try {
            IAsstAccountReference iAsstAccountReference = AsstAccountReferenceFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            filterInfo.mergeFilter(filterInfoMerger, "and");
            evi.setFilter(filterInfo);
            AsstAccountReferenceCollection aATRC = iAsstAccountReference.getAsstAccountReferenceCollection(evi);
            if (aATRC.size() > 0) {
                IAsstAccount iAsstAccount = AsstAccountFactory.getRemoteInstance();
                EntityViewInfo evitemp = new EntityViewInfo();
                evitemp.getSelector().add("id");
                evitemp.getSelector().add("number");
                evitemp.getSelector().add("name");
                evitemp.getSelector().add("isSystemAsstActItem");
                evitemp.getSelector().add("realDataObjAlias");
                evitemp.getSelector().add("company.name");
                evitemp.getSelector().add("description");
                evitemp.getSelector().add("isQty");
                evitemp.getSelector().add("measureUnit.name");
                evitemp.getSelector().add("measureUnitGroup.name");
                FilterInfo filterTemp = new FilterInfo();
                for (int i = 0; i < aATRC.size(); ++i) {
                    AsstAccountCollection aATCTemp = new AsstAccountCollection();
                    FilterItemInfo filterItem = new FilterItemInfo("id", (Object)aATRC.get(i).getAsstAccount().getId().toString());
                    filterTemp.getFilterItems().add(filterItem);
                    evitemp.setFilter(filterTemp);
                    aATCTemp = iAsstAccount.getAsstAccountCollection(evitemp);
                    aATC.addObjectCollection((IObjectCollection)aATCTemp);
                    filterTemp.getFilterItems().remove(filterItem);
                }
            }
            return aATC;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return aATC;
        }
    }

    AsstAccountCollection getParentAssign() {
        FilterInfo filterInfoMerger = this.getMegeFilter();
        AsstAccountCollection aATCParent = new AsstAccountCollection();
        try {
            IAsstAccountReference iAsstAccountReference = AsstAccountReferenceFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("assignCompany.id");
            evi.getSelector().add("assignCompany.longnumber");
            evi.getSelector().add("asstAccount.id");
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("assignCompany.level", (Object)new Integer(SysContext.getSysContext().getCurrentFIUnit().getLevel()), CompareType.LESS));
            filterInfo.mergeFilter(filterInfoMerger, "and");
            evi.setFilter(filterInfo);
            AsstAccountReferenceCollection aATRC = iAsstAccountReference.getAsstAccountReferenceCollection(evi);
            AsstAccountReferenceCollection aATRCParent = new AsstAccountReferenceCollection();
            if (aATRC.size() > 0) {
                for (int i = 0; i < aATRC.size(); ++i) {
                    if (SysContext.getSysContext().getCurrentFIUnit().getLongNumber().indexOf(aATRC.get(i).getAssignCompany().getLongNumber()) != 0) continue;
                    aATRCParent.addObject((IObjectValue)aATRC.get(i));
                }
            }
            if (aATRCParent.size() > 0) {
                IAsstAccount iAsstAccount = AsstAccountFactory.getRemoteInstance();
                EntityViewInfo evitemp = new EntityViewInfo();
                evitemp.getSelector().add("id");
                evitemp.getSelector().add("number");
                evitemp.getSelector().add("name");
                evitemp.getSelector().add("isSystemAsstActItem");
                evitemp.getSelector().add("realDataObjAlias");
                evitemp.getSelector().add("description");
                evitemp.getSelector().add("company.name");
                evitemp.getSelector().add("company.longnumber");
                evitemp.getSelector().add("isQty");
                evitemp.getSelector().add("measureUnit.name");
                evitemp.getSelector().add("measureUnitGroup.name");
                FilterInfo filterTemp = new FilterInfo();
                for (int i = 0; i < aATRCParent.size(); ++i) {
                    AsstAccountCollection aATCTemp = new AsstAccountCollection();
                    FilterItemInfo filterItem = new FilterItemInfo("id", (Object)aATRCParent.get(i).getAsstAccount().getId().toString());
                    filterTemp.getFilterItems().add(filterItem);
                    evitemp.setFilter(filterTemp);
                    aATCTemp = iAsstAccount.getAsstAccountCollection(evitemp);
                    aATCParent.addObjectCollection((IObjectCollection)aATCTemp);
                    filterTemp.getFilterItems().remove(filterItem);
                }
            }
            if (aATCParent.size() > 0) {
                int i;
                AsstAccountCollection aATCParentTemp = new AsstAccountCollection();
                for (i = 0; i < aATCParent.size(); ++i) {
                    if (SysContext.getSysContext().getCurrentFIUnit().getLongNumber().toString().indexOf(aATCParent.get(i).getCompany().getLongNumber().toString()) != 0) continue;
                    aATCParentTemp.addObject((IObjectValue)aATCParent.get(i));
                }
                if (aATCParentTemp.size() > 0) {
                    for (i = 0; i < aATCParentTemp.size(); ++i) {
                        aATCParent.removeObject(aATCParentTemp.get(i).getId());
                    }
                }
            }
            return aATCParent;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public AuxAccountListUI() throws Exception {
        this.setUITitle(EASResource.getString((String)this.resClassName, (String)"AsstAccountList"));
    }

    public void onLoad() throws Exception {
        this.checkCurrentOrgUnit();
        Icon addnewbg = EASResource.getIcon((String)"imgTbtn_subjectsetting");
        this.AccountSelectButton.setIcon(addnewbg);
        this.menuAccountSelect.setIcon(addnewbg);
        this.menuAccountSelect.setVisible(false);
        Icon impTbtn_imput = EASResource.getIcon((String)"imgTbtn_input");
        this.btnReference.setIcon(impTbtn_imput);
        this.menuReference.setIcon(impTbtn_imput);
        this.menuItemImportData.setEnabled(false);
        this.enuItemAccount.setEnabled(false);
        this.enuItemAccount.setVisible(false);
        this.btnReference.setEnabled(true);
        this.AccountSelectButton.setVisible(false);
        this.actionQuery.setVisible(false);
        super.onLoad();
        this.actionQuery.setVisible(true);
    }

    private void checkCurrentOrgUnit() {
        if (SysContext.getSysContext().getCurrentOrgUnit() == null || !SysContext.getSysContext().getCurrentOrgUnit().isIsCompanyOrgUnit()) {
            MsgBox.showError((String)EASResource.getString((String)this.resClassName, (String)"currentOrgUnitNotCompany"));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionReference_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, AuxAccountListUI> map = new HashMap<String, AuxAccountListUI>();
        map.put("Owner", this);
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.basedata.master.auxacct.client.AsstAccountReferenceEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
        this.getResultLines();
    }

    @Override
    public void accountSelectAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashMap<String, AuxAccountListUI> map = new HashMap<String, AuxAccountListUI>();
        map.put("Owner", this);
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        if (this.tblMain.getSelectManager().size() != 0) {
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            IUIFactory uiFactory = null;
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.basedata.master.auxacct.client.AuxAccountEditUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            this.actionRefresh_actionPerformed(e);
        }
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.basedata.master.auxacct.client.AuxacctGroupEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AsstAccountFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected BOSObjectType getBizObjectType() {
        return new AsstAccountInfo().getBOSType();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.getResultLines();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(ACTION_ADDNEW);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
            this.getResultLines();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.getResultLines();
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.execQuery();
    }

    private void checkPermission(String action) throws Exception {
        if (this.getControlType().equalsIgnoreCase(CONTROLTYPE_S1)) {
            if (!this.getCurrentCompanyCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase(CONTROLTYPE_S3) || this.getControlType().equalsIgnoreCase(CONTROLTYPE_S4)) && !action.equals(ACTION_ADDNEW) && !this.getCurrentCompanyCUID().equals(this.getCUIDFromBizobject())) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    private String getCurrentCUID() {
        if (this.currentCUID == null) {
            this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return this.currentCUID;
    }

    private String getCurrentCompanyID() {
        if (this.currentCompanyID == null) {
            this.currentCompanyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        return this.currentCompanyID;
    }

    private String getCurrentCompanyCUID() {
        if (this.currentCompanyCUID == null) {
            this.currentCompanyCUID = SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString();
        }
        return this.currentCompanyCUID;
    }

    private String getCUIDFromBizobject() throws Exception {
        this.checkSelected();
        return this.getICGF().getCUID(this.getSelectedKeyValue());
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals(ACTION_DELETE)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals(ACTION_MODIFY)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        boolean referenceFlag = false;
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        for (int i = 0; i < this.markReferenceCollection.size(); ++i) {
            if (!row.getCell("id").getValue().toString().equals(this.markReferenceCollection.get(i).getId().toString())) continue;
            referenceFlag = true;
            uiContext.put((Object)"referenceFlag", (Object)referenceFlag);
            break;
        }
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionEvent = e;
        if (this.isDoRefresh(uiWindow)) {
            this.isModify = true;
            this.refresh(e);
            this.getResultLines();
        }
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void getResultLines() {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.actionRefresh_actionPerformed(e);
        this.getResultLines();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject(null);
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(FILTERFIELD_COMPANYID, (Object)this.getCurrentCompanyID()));
        String companyLongNumber = SysContext.getSysContext().getCurrentFIUnit().getLongNumber();
        String[] companyNumber = companyLongNumber.split("!");
        StringBuffer compareLongNumber = new StringBuffer();
        StringBuffer compareLongNumberSet = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < companyNumber.length; ++i) {
            if (i > 0) {
                sb.append("!");
                compareLongNumber.append(",");
                compareLongNumberSet.append(",");
            }
            sb.append(companyNumber[i]);
            compareLongNumber.append(sb.toString());
            compareLongNumberSet.append("'").append(sb.toString()).append("'");
        }
        filter.getFilterItems().add(new FilterItemInfo("company.longNumber", (Object)compareLongNumber.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("glAsstActTypeGrp.id", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("asstActGpDt.asstActType.glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo(FILTERFIELD_CUID, (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("asstActGpDt.asstActType.glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FAsstAccountID from T_BD_AsstAccountReference where FAssignCompanyID in (select fid from t_org_company where flongnumber in(" + compareLongNumberSet.toString() + "))"), CompareType.INNER));
        filter.setMaskString("#0 or (#1 and (#2 or (#3 or(#4 and #5)))) or #6");
        return filter;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi.supportExecutionWithoutFilters();
    }
}

