/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.client;

import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.basedata.common.perf.client.AbstractJobScheduleUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JobScheduleUI
extends AbstractJobScheduleUI {
    private static final long serialVersionUID = -5663663171246790230L;
    private boolean isCancel = true;
    private Date scheduleDate = null;
    private String serverId = null;
    private int prority = 0;

    Date getScheduleDate() {
        return this.scheduleDate;
    }

    String getServerId() {
        return this.serverId;
    }

    int getPrority() {
        return this.prority;
    }

    boolean isCancel() {
        return this.isCancel;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.cmbServerList.setEnabled(false);
        this.radioProrityOld.setSelected(true);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        ArrayList serverList = JobUtils.getJobServiceFacade().getJobServiceInstanceKeys();
        this.cmbServerList.addItem((Object)"");
        this.cmbServerList.addItems(serverList.toArray());
        this.chkServer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JobScheduleUI.this.chkServerChange(e);
            }
        });
    }

    private void chkServerChange(ChangeEvent e) {
        if (this.chkServer.isSelected()) {
            this.cmbServerList.setEnabled(true);
        } else {
            this.cmbServerList.setEnabled(false);
            this.cmbServerList.setSelectedIndex(0);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.validateInput();
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    private void validateInput() {
        if (null == this.delayDatePicker.getValue()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.DelayDateNotBeNull"));
            this.delayDatePicker.requestFocus();
            SysUtil.abort();
        }
        Date delayDate = (Date)this.delayDatePicker.getValue();
        Date delayTime = (Date)this.delayTimePicker.getValue();
        delayDate.setHours(delayTime.getHours());
        delayDate.setMinutes(delayTime.getMinutes());
        delayDate.setSeconds(delayTime.getSeconds());
        if (delayDate.getTime() - System.currentTimeMillis() < 300000L) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.DelayTimeAfterNow"));
            this.delayTimePicker.requestFocus();
            SysUtil.abort();
        } else {
            this.scheduleDate = delayDate;
        }
        if (this.chkServer.isSelected() && this.cmbServerList.getSelectedIndex() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.RunServerNotBeNull"));
            this.cmbServerList.requestFocus();
            SysUtil.abort();
        } else {
            this.serverId = (String)this.cmbServerList.getSelectedItem();
        }
        this.prority = this.radioProrityHigh.isSelected() ? -100 : (this.radioProrityNormal.isSelected() ? 500 : (this.radioProrityLow.isSelected() ? 1000 : -1));
    }
}

