/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.client;

import com.kingdee.bos.appframework.syncUI.StateInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class JobSwingWorker
extends SwingWorker {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.common.perf.client.JobSwingWorker");
    private StateInfo stateInfo;
    private String jobId;
    private JobStateEnum jobStateEnum;

    public JobSwingWorker(String jobId) throws IllegalArgumentException {
        this.jobId = jobId;
        this.jobStateEnum = JobStateEnum.CREATED;
        if (StringUtils.isEmpty((String)jobId)) {
            throw new IllegalArgumentException("Job id must not be null ! ");
        }
    }

    public void stop() {
        try {
            JobInstStatusFacadeFactory.getRemoteInstance().cancel(this.jobId);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showWarning((String)e.getMessage());
            SysUtil.abort();
        }
    }

    public StateInfo getStateInfo() {
        return this.stateInfo;
    }

    void setStateInfo(StateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    public void finished() {
        JobMonitorManager.getInstance().afterJobFinished(this.jobId, this.jobStateEnum);
    }

    public void finishedLater() {
        IUIObject[] arrayUI = UIFrameUtil.findUIObject((String)MessageCenterUI.class.getName());
        IUIObject messageUI = this.findUIByName("com.kingdee.eas.base.message.client.MessageCenterUI", arrayUI);
        if (messageUI != null) {
            MessageCenterUI messageCenterUI = (MessageCenterUI)messageUI;
            messageCenterUI.queryWorkflowNoticeMessage();
            messageCenterUI.refresh();
            messageCenterUI.getUIWindow().show();
        } else {
            UIFrameUtil.setCurTabToMessageCenter();
        }
    }

    protected IUIObject findUIByName(String className, IUIObject[] arrayUI) {
        if (arrayUI != null && arrayUI.length > 0) {
            for (int i = 0; i < arrayUI.length; ++i) {
                if (!className.equals(arrayUI[i].getClass().getName())) continue;
                return arrayUI[i];
            }
        }
        return null;
    }

    public Object construct() {
        try {
            while (!this.isJobFinished()) {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"JobSwingWorker.construct() ", (Throwable)e);
        }
        return null;
    }

    private boolean isJobFinished() {
        return null == this.jobStateEnum || !JobStateEnum.CREATED.equals((Object)this.jobStateEnum) && !JobStateEnum.WAITING.equals((Object)this.jobStateEnum) && !JobStateEnum.RUNNING.equals((Object)this.jobStateEnum) && !JobStateEnum.READY.equals((Object)this.jobStateEnum) && !JobStateEnum.RESCHEDULED.equals((Object)this.jobStateEnum);
    }

    void setJobStateEnum(JobStateEnum jobStateEnum) {
        this.jobStateEnum = jobStateEnum;
    }
}

