/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.customer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.customer.AbstractImportCustomerCompanyFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportCustomerCompanyFacadeControllerBean
extends AbstractImportCustomerCompanyFacadeControllerBean {
    private static final long serialVersionUID = 2715677533923026135L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.customer.ImportCustomerCompanyFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importCustomerCompanyData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("customer");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                CustomerCompanyInfoInfo customerCompanyInfo = new CustomerCompanyInfoInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                CustomerInfo customerInfo = WsCommonUtil.getCustomerInfo(ctx, this.billNumber, cuInfo.getId().toString());
                if (null == customerInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUSTOMERNOTEXISTS", (Context)ctx));
                }
                customerCompanyInfo = this.getCustomerCompanyInfo(ctx, this.billNumber, (String)headPro.get("companyOrgUnit"));
                if ("0".equals(opAttributeName) && null == customerCompanyInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"COMPANYNOTFOUND", (Context)ctx));
                }
                if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null != customerCompanyInfo) {
                    opAttributeName = "0";
                } else if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null == customerCompanyInfo) {
                    customerCompanyInfo = null;
                    customerCompanyInfo = new CustomerCompanyInfoInfo();
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByCustomerCompanyHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsByCustomerCompanyEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)customerCompanyInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    CoreBaseCollection col = new CoreBaseCollection();
                    this.buildBillEnties(ctx, entiesPro, mustValidateEntry, customerCompanyInfo, eo, cuInfo.getId().toString(), opAttributeName, col);
                    ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                    WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)customerCompanyInfo, opAttributeName, headPro, map, "");
                    if ("0".equals(opAttributeName) && null != col && col.size() > 0) {
                        CustomerCompanyBankFactory.getLocalInstance((Context)ctx).save(col);
                    }
                }
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, CustomerCompanyInfoInfo customerCompanyInfo, EntityObjectInfo eo, String cuId, String op, CoreBaseCollection col) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "customerBank", eo);
        CustomerCompanyBankInfo customerCompanyBankinfo = null;
        HashMap entryMap = null;
        if (null != map) {
            CustomerCompanyBankCollection updateCompanyBankCollection = new CustomerCompanyBankCollection();
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                customerCompanyBankinfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                customerCompanyBankinfo = new CustomerCompanyBankInfo();
                WsCommonUtil.setPropertyNumberByXml(ctx, entryMap, "bank", "bank.xml");
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)customerCompanyBankinfo, cuId);
                if ("3".equals(op) || "4".equals(op)) {
                    customerCompanyInfo.getCustomerBank().add(customerCompanyBankinfo);
                }
                if (!"0".equals(op)) continue;
                if (!this.checkBankIsExits(ctx, customerCompanyBankinfo.getBankAccount(), customerCompanyInfo.getId().toString())) {
                    customerCompanyBankinfo.setCustomerCompanyInfo(customerCompanyInfo);
                    col.add((CoreBaseInfo)customerCompanyBankinfo);
                }
                updateCompanyBankCollection.add(customerCompanyBankinfo);
            }
            if (customerCompanyInfo.getCustomerBank() != null && "0".equals(op)) {
                customerCompanyInfo.getCustomerBank().clear();
                customerCompanyInfo.getCustomerBank().addCollection(updateCompanyBankCollection);
            }
            if (entiesPro.size() == 0 && customerCompanyInfo.getBankAccount() != null) {
                customerCompanyBankinfo = new CustomerCompanyBankInfo();
                customerCompanyBankinfo.setBankAccount(customerCompanyInfo.getBankAccount());
                customerCompanyBankinfo.setBank(customerCompanyInfo.getBank());
                customerCompanyBankinfo.setBankAddress(customerCompanyInfo.getBankAddress());
                if ("3".equals(op) || "4".equals(op)) {
                    customerCompanyInfo.getCustomerBank().add(customerCompanyBankinfo);
                }
                if ("0".equals(op) && !this.checkBankIsExits(ctx, customerCompanyBankinfo.getBankAccount(), customerCompanyInfo.getId().toString())) {
                    customerCompanyBankinfo.setCustomerCompanyInfo(customerCompanyInfo);
                    col.add((CoreBaseInfo)customerCompanyBankinfo);
                }
            }
        }
    }

    private CustomerCompanyInfoInfo getCustomerCompanyInfo(Context ctx, String customerNumber, String companyNumber) throws Exception {
        CustomerCompanyInfoInfo companyInfo = null;
        if (null != customerNumber && !"".equals(customerNumber) && null != companyNumber && !"".equals(companyNumber)) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("customer.number", (Object)customerNumber, CompareType.EQUALS));
                fic.add(new FilterItemInfo("companyOrgUnit.number", (Object)companyNumber, CompareType.EQUALS));
                view.setFilter(filter);
                CustomerCompanyInfoCollection col = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfoCollection(view);
                if (null != col && col.size() > 0) {
                    companyInfo = col.get(0);
                }
            }
            catch (BOSException e) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"COMPANYNOTFOUND", (Context)ctx));
            }
        }
        return companyInfo;
    }

    private boolean checkBankIsExits(Context ctx, String bankNum, String customerCompanyId) {
        if (null == bankNum || "".equals(bankNum) || "".equals(customerCompanyId) || null == customerCompanyId) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("customerCompanyInfo.id", (Object)customerCompanyId, CompareType.EQUALS));
        fic.add(new FilterItemInfo("bankAccount", (Object)bankNum, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            CustomerCompanyBankCollection col = CustomerCompanyBankFactory.getLocalInstance((Context)ctx).getCustomerCompanyBankCollection(view);
            if (null != col && col.size() > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            return false;
        }
        return false;
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "Customercompanyinfo_AddNew" : "Customercompanyinfo_Update";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

