/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.customer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.customer.AbstractImportCustomerFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportCustomerFacadeControllerBean
extends AbstractImportCustomerFacadeControllerBean {
    private static final long serialVersionUID = 9174236311385879013L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.customer.ImportCustomerFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";
    private boolean isFlag = true;

    @Override
    protected String _importCustomerData(Context ctx, String xmlData) throws BOSException, EASBizException {
        block18: {
            try {
                Document doc = WsCommonXMLUtil.builderDocument(xmlData);
                if (null == doc) break block18;
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                CustomerInfo customerInfo = new CustomerInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                if (null != opAttributeName && ("0".equals(opAttributeName) || "1".equals(opAttributeName) || "2".equals(opAttributeName) || "5".equals(opAttributeName))) {
                    customerInfo = (CustomerInfo)WsCommonUtil.getCoreBaseInfo(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    if (null == customerInfo) {
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUSTOMERNOTEXISTS", (Context)ctx));
                    }
                    if ("1".equals(opAttributeName)) {
                        customerInfo.setUsedStatus(UsedStatusEnum.APPROVED);
                    } else if ("2".equals(opAttributeName)) {
                        customerInfo.setUsedStatus(UsedStatusEnum.FREEZED);
                    } else if ("5".equals(opAttributeName)) {
                        customerInfo.setUsedStatus(UsedStatusEnum.UNAPPROVE);
                    }
                }
                if (null != opAttributeName && ("3".equals(opAttributeName) || "4".equals(opAttributeName))) {
                    try {
                        WsCommonUtil.validateNumber(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    }
                    catch (Exception ex) {
                        this.isFlag = false;
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATAEXIST", (Context)ctx));
                    }
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByCustomerHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsByCustomerEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                        this.buildBillEnties(ctx, entiesPro, mustValidateEntry, customerInfo, eo, cuInfo.getId().toString());
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    ctx.put((Object)"infoType", (Object)"customer");
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)customerInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    ctx.remove((Object)"infoType");
                }
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                customerInfo.put("isThirdPartFlag", (Object)"isThirdPartFlag");
                WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)customerInfo, opAttributeName, headPro, map, "usedStatus");
                if ("4".equals(opAttributeName)) {
                    customerInfo = (CustomerInfo)WsCommonUtil.getCoreBaseInfo(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    if (null == customerInfo) {
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUSTOMERNOTEXISTS", (Context)ctx));
                    }
                    this.saveCompanyAndSale(ctx, customerInfo);
                }
            }
            catch (Exception e) {
                this.retstatus = this.isFlag ? "1" : "3";
                this.errorMessage = e.getMessage();
            }
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void saveCompanyAndSale(Context ctx, CustomerInfo customerInfo) throws Exception {
        try {
            ICustomerCompanyInfo iCustomerCompany = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            ICustomerSaleInfo iCustomerSales = CustomerSaleInfoFactory.getLocalInstance((Context)ctx);
            if (null != customerInfo.getCU()) {
                SaleOrgUnitInfo saleOrg;
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(customerInfo.getCU().getId()));
                if (company != null) {
                    CustomerCompanyInfoInfo vo = new CustomerCompanyInfoInfo();
                    vo.setCompanyOrgUnit(company);
                    vo.setCustomer(customerInfo);
                    vo.setCU(company.getCU());
                    vo.setCreateTime(TimeStampUtility.getTime());
                    vo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                    vo.setLastUpdateTime(null);
                    vo.setLastUpdateUser(null);
                    vo.setIsFreezeIssueInvoice(false);
                    String accountTableId = null;
                    if (company != null) {
                        if (company.getAccountTable() != null) {
                            accountTableId = company.getAccountTable().getId().toString();
                            String companyOrgId = company.getId().toString();
                            KAClassficationInfo kaClassficationInfo = WsCommonUtil.getDefaultAccountClass("customer", companyOrgId, accountTableId, ctx);
                            vo.setAccountingClassfication(kaClassficationInfo);
                        } else {
                            vo.setAccountingClassfication(null);
                        }
                    }
                    vo.setSettlementCurrency(company.getBaseCurrency());
                    iCustomerCompany.submit((CoreBaseInfo)vo);
                }
                if ((saleOrg = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(customerInfo.getCU().getId()))) != null) {
                    CustomerSaleInfoInfo saleInfo = new CustomerSaleInfoInfo();
                    saleInfo.setSaleOrgUnit(saleOrg);
                    saleInfo.setDeliverOrgUnit(customerInfo);
                    saleInfo.setBillingOrgUnit(customerInfo);
                    saleInfo.setSettlementOrgUnit(customerInfo);
                    saleInfo.setCustomer(customerInfo);
                    saleInfo.setCU(saleOrg.getCU());
                    saleInfo.setIsFreezeDelivery(false);
                    saleInfo.setIsFreezeOrder(false);
                    saleInfo.setCreateTime(TimeStampUtility.getTime());
                    saleInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                    saleInfo.setLastUpdateTime(null);
                    saleInfo.setLastUpdateUser(null);
                    iCustomerSales.submit((CoreBaseInfo)saleInfo);
                }
            }
        }
        catch (Exception e) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"AddCus_Sale_Error", (Locale)ctx.getLocale());
            throw new Exception(msg);
        }
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, CustomerInfo customerInfo, EntityObjectInfo eo, String cuId) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "customerGroupDetails", eo);
        CustomerGroupDetailInfo customerDetialinfo = null;
        HashMap entryMap = null;
        if (null != map) {
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                customerDetialinfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                customerDetialinfo = new CustomerGroupDetailInfo();
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)customerDetialinfo, cuId);
                customerInfo.getCustomerGroupDetails().add(customerDetialinfo);
            }
        }
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "Customer_Update" : "Customer_AddNew";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

