/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.supplier;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.supplier.AbstractImportSupplierPurchaseFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportSupplierPurchaseFacadeControllerBean
extends AbstractImportSupplierPurchaseFacadeControllerBean {
    private static final long serialVersionUID = 3549031676827561832L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.supplier.ImportSupplierPurchaseFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importSupplierPurchaseData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("supplier");
                String purchaseOrgUnitNumber = (String)headPro.get("purchaseOrgUnit");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                SupplierPurchaseInfoInfo supplierPurchaseInfoInfo = new SupplierPurchaseInfoInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                SupplierInfo supplierInfo = WsCommonUtil.getSupplierInfo(ctx, this.billNumber, cuInfo.getId().toString());
                if (null == supplierInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SUPPLIERNOTEXISTS", (Context)ctx));
                }
                supplierPurchaseInfoInfo = this.getSupplierPurchaseInfoInfo(ctx, this.billNumber, purchaseOrgUnitNumber);
                if ("0".equals(opAttributeName) && null == supplierPurchaseInfoInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"PURNOTFOUND", (Context)ctx));
                }
                if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null != supplierPurchaseInfoInfo) {
                    opAttributeName = "0";
                } else if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null == supplierPurchaseInfoInfo) {
                    supplierPurchaseInfoInfo = null;
                    supplierPurchaseInfoInfo = new SupplierPurchaseInfoInfo();
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsBySupplierPurchaseHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsBySupplierPurchaseEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)supplierPurchaseInfoInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    SupplierLinkManCollection col = new SupplierLinkManCollection();
                    this.buildBillEnties(ctx, entiesPro, mustValidateEntry, supplierPurchaseInfoInfo, eo, cuInfo.getId().toString(), opAttributeName, col);
                    ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                    WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)supplierPurchaseInfoInfo, opAttributeName, headPro, map, "");
                }
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, SupplierPurchaseInfoInfo supplierPurchaseInfoInfo, EntityObjectInfo eo, String cuId, String op, SupplierLinkManCollection col) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "supplierLinkMan", eo);
        SupplierLinkManInfo supplierLinkManInfo = null;
        HashMap entryMap = null;
        if (null != map) {
            supplierPurchaseInfoInfo.getSupplierLinkMan().clear();
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                supplierLinkManInfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                supplierLinkManInfo = new SupplierLinkManInfo();
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)supplierLinkManInfo, cuId);
                if ("3".equals(op) || "4".equals(op)) {
                    supplierPurchaseInfoInfo.getSupplierLinkMan().add(supplierLinkManInfo);
                }
                if (!"0".equals(op)) continue;
                supplierLinkManInfo.setSupplierPurchase(supplierPurchaseInfoInfo);
                col.add(supplierLinkManInfo);
            }
            supplierPurchaseInfoInfo.getSupplierLinkMan().addCollection(col);
        }
    }

    private SupplierPurchaseInfoInfo getSupplierPurchaseInfoInfo(Context ctx, String supplierNumber, String purchaseOrgUnitNumber) throws Exception {
        SupplierPurchaseInfoInfo supplierPurchaseInfoInfo = null;
        if (null != supplierNumber && !"".equals(supplierNumber)) {
            try {
                supplierPurchaseInfoInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).getPurChaseInfo(supplierNumber, purchaseOrgUnitNumber);
            }
            catch (BOSException e) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"PURNOTFOUND", (Context)ctx));
            }
        }
        return supplierPurchaseInfoInfo;
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "Supplierpurchaseinfo_AddNew" : "Supplierpurchaseinfo_Update";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

