/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GeneralBatchLog
implements Serializable {
    private static final long serialVersionUID = 3693650109290479801L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.batch.GeneralBatchLog");
    private ArrayList errorSubject = new ArrayList();
    private ArrayList errorDetail = new ArrayList();
    private int recordCount;
    private int successRecordCount;
    private int failRecordCount;
    private boolean isSuccess = true;
    private String title = null;
    private ArrayList exceptionList = new ArrayList();

    public GeneralBatchLog() {
    }

    public GeneralBatchLog(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setSuccessRecordCount(int successRecordCount) {
        this.successRecordCount = successRecordCount;
    }

    public int getSuccessRecordCount() {
        return this.successRecordCount;
    }

    public void setFailRecordCount(int failRecordCount) {
        this.failRecordCount = failRecordCount;
    }

    public int getFailRecordCount() {
        return this.failRecordCount;
    }

    public void addException(String subject, Throwable e) {
        this.exceptionList.add(e);
        this.errorSubject.add(subject);
        String errDetail = subject;
        if (e.getMessage() != null) {
            errDetail = errDetail + "\r\n" + e.getMessage();
        }
        this.errorDetail.add(errDetail);
        logger.error((Object)"exception :", e);
    }

    public void addOtherBatchLog(GeneralBatchLog oldLog) {
        this.errorSubject.addAll(oldLog.errorSubject);
        this.errorDetail.addAll(oldLog.errorDetail);
        this.exceptionList.addAll(oldLog.exceptionList);
        this.setFailRecordCount(this.errorSubject.size());
        this.setSuccessRecordCount(this.successRecordCount + oldLog.successRecordCount);
        this.setRecordCount(this.errorSubject.size() + this.getSuccessRecordCount());
    }

    public String getException(int i) {
        return ((Throwable)this.exceptionList.get(i)).toString();
    }

    public String getErrorSubject(int i) {
        return (String)this.errorSubject.get(i);
    }

    public String getErrorDetail(int i) {
        return (String)this.errorDetail.get(i);
    }

    public int getErrorDetailCount() {
        return this.errorDetail.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ArrayList getErrorSubject() {
        return this.errorSubject;
    }
}

