/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.batch.model.xml;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.batch.Helper;
import com.kingdee.eas.basedata.master.batch.IHandler;
import com.kingdee.eas.basedata.master.batch.model.xml.Element;
import com.kingdee.eas.basedata.master.batch.model.xml.IXMLBuilder;
import com.kingdee.eas.basedata.master.batch.model.xml.XmlElement;
import com.kingdee.eas.basedata.master.batch.model.xml.XmlRequest;
import com.kingdee.util.PropertyContainer;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;

public class XMLBuilder
implements IXMLBuilder {
    private static final String XMLATTRIBUTE_PNAME = "pname";
    private static final String XMLATTRIBUTE_CLASS = "class";
    private Object product = null;
    private Stack stack = new Stack();
    private boolean isAssembleFinished = false;

    @Override
    public void push(XmlElement element) throws Exception {
        String id = element.getAttributes().getValue(XMLATTRIBUTE_PNAME);
        if (id == null || id.length() == 0) {
            id = element.getId();
        }
        Element v = new Element(id);
        Object o = null;
        String className = element.getAttributes().getValue(XMLATTRIBUTE_CLASS);
        if (className != null && className.trim().length() != 0) {
            o = Helper.getObject(className);
            if (o != null && o instanceof IHandler) {
                HashMap<String, String> ls = new HashMap<String, String>();
                Attributes attributes = element.getAttributes();
                int count = attributes.getLength();
                for (int i = 0; i < count; ++i) {
                    ls.put(attributes.getQName(i), attributes.getValue(i));
                }
                ((IHandler)o).handleRequest(new XmlRequest("XmlRequest", ls));
            }
        } else {
            o = element.getValue();
            Element beforeElement = (Element)this.stack.pop();
            if (!beforeElement.getId().equalsIgnoreCase(v.getId())) {
                this.stack.push(beforeElement);
            }
        }
        v.setValue(o);
        this.stack.push(v);
    }

    @Override
    public void assemble() throws Exception {
        this.isAssembleFinished = false;
        if (this.stack.size() > 1) {
            Element behindElement = (Element)this.stack.pop();
            Object behind = behindElement.getValue();
            Element beforeElement = (Element)this.stack.pop();
            Object before = beforeElement.getValue();
            if (before instanceof AbstractObjectCollection) {
                ((AbstractObjectCollection)before).addObject((IObjectValue)((AbstractObjectValue)behind));
            } else if (before instanceof PropertyContainer) {
                ((PropertyContainer)before).put(behindElement.getId(), behind);
            } else {
                throw new Exception("Unforeseen Composite Object Request!");
            }
            this.stack.push(beforeElement);
        } else if (this.stack.size() > 0) {
            this.product = ((Element)this.stack.pop()).getValue();
            this.isAssembleFinished = true;
        }
    }

    @Override
    public boolean isAssembleFinished() {
        return this.isAssembleFinished;
    }

    @Override
    public Object getProduct() {
        return this.product;
    }
}

