/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.MessageUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CSSPUtils {
    private static final Logger logger = Logger.getLogger(CSSPUtils.class);
    private static String oldSessionId = null;
    private static HashMap paramMap = new HashMap();
    private static final String MSG = "msg";
    public static final String PARAM_NON_LEAF4CUSTOMER = "NonLeafAddNewForCustomer";
    public static final String PARAM_NON_LEAF4SUPPLIER = "NonLeafAddNewForSupplier";

    public static CtrlUnitInfo getSysCU() {
        CtrlUnitInfo sysCU = new CtrlUnitInfo();
        sysCU.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        return sysCU;
    }

    public static String getPropertyAlias(Context ctx, AbstractObjectValue dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return propertyName;
        }
        return property.getAlias();
    }

    public static void checMaxkLen(Context ctx, AbstractObjectValue dataBaseInfo, String propertyName, int maxLen) throws BOSException, EASBizException {
        if (ctx == null || dataBaseInfo == null || propertyName == null || maxLen <= 0) {
            return;
        }
        Object object = dataBaseInfo.get(propertyName);
        if (object == null || !(object instanceof String)) {
            return;
        }
        String value = (String)object;
        if (value.length() > maxLen) {
            String propertyAlias = CSSPUtils.getPropertyAlias(ctx, dataBaseInfo, propertyName);
            throw new CustomerSupplierException(CustomerSupplierException.MAX_LEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    public static String getIdsSql(String[] ids) {
        return CSSPUtils.getIdsSql((Object[])ids);
    }

    public static String getIdsSql(Object[] ids) {
        if (ids == null) {
            return null;
        }
        if (ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            sb.append("'").append(ids[i].toString()).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.insert(0, "(");
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    public static boolean isMasterDataParser() {
        return MaterialUtil.getBooleanParam(null, (String)"isMasterDataParser", (boolean)false);
    }

    public static int isInCollection(IObjectValue info, IObjectCollection collection, String keyField) {
        if (info == null || collection == null) {
            return -1;
        }
        Object keyFieldValue = info.get(keyField);
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue tempInfo = collection.getObject(i);
            if (keyFieldValue == null || !keyFieldValue.equals(tempInfo.get(keyField))) continue;
            return i;
        }
        return -1;
    }

    public static int isInCollectionById(IObjectValue info, IObjectCollection collection, String keyField) {
        if (info == null || collection == null || keyField == null || !(info instanceof CoreBaseInfo)) {
            return -1;
        }
        CoreBaseInfo relatedInfo = (CoreBaseInfo)info.get(keyField);
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue value = collection.getObject(i);
            if (!(value.get(keyField) instanceof CoreBaseInfo)) {
                return -1;
            }
            CoreBaseInfo tempInfo = (CoreBaseInfo)value.get(keyField);
            if (relatedInfo == null || tempInfo == null || relatedInfo.getId() == null || tempInfo.getId() == null || !relatedInfo.getId().equals((Object)tempInfo.getId())) continue;
            return i;
        }
        return -1;
    }

    public static boolean isIdEquals(CoreBaseInfo info1, CoreBaseInfo info2) {
        if (info1 == null) {
            if (info2 == null) {
                return true;
            }
            return info2.getId() == null;
        }
        if (info2 == null) {
            if (info1 == null) {
                return true;
            }
            return info1.getId() == null;
        }
        return CSSPUtils.isEquals(info1.getId().toString(), info2.getId().toString());
    }

    public static boolean isEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void showReference(Component owner, String uuid) {
        if (uuid == null || "".equals(uuid)) {
            uuid = JOptionPane.showInputDialog(null, EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"12_CSSPUtils"), "");
        }
        if (uuid == null || "".equals(uuid)) {
            return;
        }
        BOSObjectType bosType = null;
        try {
            bosType = BOSUuid.read((String)uuid).getType();
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"13_CSSPUtils"));
            SysUtil.abort();
        }
        if (bosType == null) {
            MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"14_CSSPUtils"));
            SysUtil.abort();
        }
        String msg = "";
        try {
            msg = FMIsqlFacadeFactory.getRemoteInstance().wholeSearchs(uuid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIContext uic = new UIContext((Object)owner);
        if (msg.length() > 0) {
            MessageUtil.showMessageByModel((UIContext)uic, (String)msg);
        } else {
            MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"15_CSSPUtils"));
        }
    }

    public static boolean isAllowNonLeaf4CUS() {
        return MaterialUtil.getBooleanParam(null, (String)PARAM_NON_LEAF4CUSTOMER, (boolean)false);
    }

    public static boolean isAllowNonLeaf4CUS(Context ctx) {
        return MaterialUtil.getBooleanParam((Context)ctx, (String)PARAM_NON_LEAF4CUSTOMER, (boolean)false);
    }

    public static boolean isAllowNonLeaf4SUP() {
        return MaterialUtil.getBooleanParam(null, (String)PARAM_NON_LEAF4SUPPLIER, (boolean)false);
    }

    public static boolean isAllowNonLeaf4SUP(Context ctx) {
        return MaterialUtil.getBooleanParam((Context)ctx, (String)PARAM_NON_LEAF4SUPPLIER, (boolean)false);
    }

    public static String getParam(String number) {
        String param = null;
        String sessionId = SysContext.getSysContext().getSessionID();
        if (StringUtils.equals((String)sessionId, (String)oldSessionId) && paramMap.get(number) != null) {
            param = paramMap.get(number).toString();
        } else {
            if (!StringUtils.equals((String)sessionId, (String)oldSessionId)) {
                paramMap.clear();
            }
            param = CSSPUtils.getParam(null, null, number);
            paramMap.put(number, param);
            oldSessionId = sessionId;
        }
        return param;
    }

    public static String getParam(Context ctx, String number) {
        if (ctx == null) {
            return CSSPUtils.getParam(number);
        }
        return CSSPUtils.getParam(ctx, null, number);
    }

    public static String getParam(Context ctx, String orgId, String number) {
        String result = null;
        ObjectUuidPK orgPK = null;
        if (orgId != null && !"".equals(orgId)) {
            orgPK = new ObjectUuidPK(orgId);
        }
        try {
            result = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)number, orgPK, (boolean)false);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }

    public static void batchShowReference(Component owner, Map<String, String> idNumberMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String msg = "";
        Iterator<Map.Entry<String, String>> iterator = idNumberMap.entrySet().iterator();
        String notReferenceMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"15_CSSPUtils");
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            String uuid = next.getKey();
            String number = next.getValue();
            if (uuid == null || "".equals(uuid)) {
                uuid = JOptionPane.showInputDialog(null, EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"12_CSSPUtils"), "");
            }
            if (uuid == null || "".equals(uuid)) {
                return;
            }
            BOSObjectType bosType = null;
            try {
                bosType = BOSUuid.read((String)uuid).getType();
            }
            catch (Exception ex) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"13_CSSPUtils"));
                SysUtil.abort();
            }
            if (bosType == null) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPAutoGenerateResource", (String)"14_CSSPUtils"));
                SysUtil.abort();
            }
            try {
                msg = FMIsqlFacadeFactory.getRemoteInstance().wholeSearchs(uuid);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (msg.length() > 0) {
                String numberMsg = number + "|" + msg;
                resultMap.put(uuid, numberMsg);
                continue;
            }
            resultMap.put(uuid, number + "|" + notReferenceMsg);
        }
        UIContext uic = new UIContext((Object)owner);
        IUIWindow uiWindow = null;
        uic.put((Object)MSG, resultMap);
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.master.material.client.BatchReferenceLogUI", (Map)uic, null);
        }
        catch (UIException uIException) {
            // empty catch block
        }
        if (uiWindow != null) {
            uiWindow.show();
        }
    }

    public static void checkHasBalance(Context ctx, IObjectPK customerPK) throws BizBalanceException, UuidException, CustomerSupplierException {
        BizCheckResult hasBalance;
        if (!CSSPUtils.getParam(ctx).booleanValue() && (hasBalance = BizCheckerUtil.hasBalance((Context)ctx, (BOSUuid)BOSUuid.read((String)customerPK.toString()))).isFound()) {
            throw new CustomerSupplierException(CustomerSupplierException.HAS_BALANCE_NOT_FREEZE, new Object[]{hasBalance.getDetailObject((Object)"bizType") == null ? "" : hasBalance.getDetailObject((Object)"bizType")});
        }
    }

    private static Boolean getParam(Context ctx) {
        Boolean freezeHasBalance = false;
        CtrlUnitInfo currentCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String param = null;
        try {
            param = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(currentCU.getId()), (String)"FreezeHasBalance");
        }
        catch (EASBizException e) {
            e.printStackTrace();
            param = null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            param = null;
        }
        freezeHasBalance = param == null ? false : new Boolean(param);
        return freezeHasBalance;
    }

    public static int getF7DisplayMode(String cuId) {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(cuId);
            return Integer.valueOf(ipc.getParamValue((IObjectPK)pk, "F7DISPLAYMODE"));
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecordForUpdateName(Context ctx, String oldName, String newName, String bosType, String number) {
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            String insertSql = "insert into T_BD_DataUpdateNameRecord(FID,FBeforeName,FAfterName,FBosType,FUpdateUserId,FUpdateTime,FBaseDataNumber) values (newbosid('" + bosType + "'),?,?,?,?,now(),?)";
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement(insertSql);
            stmt.setString(1, oldName);
            stmt.setString(2, newName);
            stmt.setString(3, bosType);
            stmt.setString(4, ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            stmt.setString(5, number);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
        catch (Exception e) {
            logger.error((Object)"addRecordForUpdateName failed");
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(stmt, cn);
        }
    }
}

