/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.basedata.master.cssp.AbstractCustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class CustomerCompanyInfoInfo
extends AbstractCustomerCompanyInfoInfo
implements Serializable {
    public static final int MAX_LEN_BANK = 255;
    public static final int MAX_LEN_BANK_ACOUNT = 80;
    public static final int MAX_LEN_BANK_ADDR = 255;

    public CustomerCompanyInfoInfo() {
    }

    protected CustomerCompanyInfoInfo(String pkField) {
        super(pkField);
    }

    public void setCompanyOrgUnit(OrgUnitInfo item) {
        super.setCompanyOrgUnit((CompanyOrgUnitInfo)item);
    }

    public String getLogInfo() {
        if (this.getCustomer() != null && this.getCompanyOrgUnit() != null) {
            return this.getCustomer().getName() + "  " + this.getCompanyOrgUnit().getName();
        }
        return super.getLogInfo();
    }

    public void verify(Context ctx) throws BOSException, EASBizException {
        this.verify();
        if (ctx == null) {
            return;
        }
        String[] checkMaxLenfileds = new String[]{"bank", "bankAccount", "bankAddress"};
        int[] maxLens = new int[]{255, 80, 255};
        for (int i = 0; i < this.getCustomerBank().size(); ++i) {
            CustomerCompanyBankInfo bankInfo = this.getCustomerBank().get(i);
            for (int j = 0; j < checkMaxLenfileds.length; ++j) {
                CSSPUtils.checMaxkLen(ctx, (AbstractObjectValue)bankInfo, checkMaxLenfileds[j], maxLens[j]);
            }
        }
    }

    public void verify() throws BOSException, EASBizException {
        for (int i = 0; i < this.getCustomerBank().size(); ++i) {
            CustomerCompanyBankInfo bankInfo = this.getCustomerBank().get(i);
            this.bankNotAllowNull(bankInfo);
            for (int j = i + 1; j < this.getCustomerBank().size(); ++j) {
                CustomerCompanyBankInfo followbank = this.getCustomerBank().get(j);
                this.bankNotAllowNull(followbank);
                if (bankInfo.getBeneficiary() != null && followbank.getBeneficiary() != null && bankInfo.getBeneficiary().equals(followbank.getBeneficiary()) && bankInfo.getBankAccount().equals(followbank.getBankAccount())) {
                    throw new CustomerSupplierException(CustomerSupplierException.NAMEACOOUNTDUP, new String[]{bankInfo.getBeneficiary(), bankInfo.getBankAccount()});
                }
                if (bankInfo.getBeneficiaryEngName() != null && followbank.getBeneficiaryEngName() != null && bankInfo.getBeneficiaryEngName().equals(followbank.getBeneficiaryEngName()) && bankInfo.getBankAccount().equals(followbank.getBankAccount())) {
                    throw new CustomerSupplierException(CustomerSupplierException.NAMEACOOUNTDUP, new String[]{bankInfo.getBeneficiaryEngName(), bankInfo.getBankAccount()});
                }
                if (!this.isBeneficiaryAndEngEmpty(bankInfo) || !this.isBeneficiaryAndEngEmpty(followbank) || !bankInfo.getBankAccount().equals(followbank.getBankAccount())) continue;
                throw new CustomerSupplierException(CustomerSupplierException.BANKDUP);
            }
        }
    }

    private void bankNotAllowNull(CustomerCompanyBankInfo custBank) throws CustomerSupplierException {
        if (custBank.getBankAccount() == null || custBank.getBankAccount().length() == 0) {
            throw new CustomerSupplierException(CustomerSupplierException.BANKACCOUTNULL);
        }
    }

    private boolean isBeneficiaryAndEngEmpty(CustomerCompanyBankInfo custBank) {
        return StringUtils.isEmpty((String)custBank.getBeneficiary()) && StringUtils.isEmpty((String)custBank.getBeneficiaryEngName());
    }
}

