/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.basedata.master.cssp.AbstractCustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroup;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupException;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.LocaleUtils;
import java.io.Serializable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CustomerInfo
extends AbstractCustomerInfo
implements Serializable {
    private static Logger logger = Logger.getLogger(CustomerInfo.class);

    public CustomerInfo() {
    }

    protected CustomerInfo(String pkField) {
        super(pkField);
    }

    public String getDisplayName() {
        if (this.getBrowseGroup() == null || this.getBrowseGroup().getDisplayName() == null) {
            return this.getName();
        }
        return this.getBrowseGroup().getDisplayName() + "_" + this.getName();
    }

    public String getDisplayName(Locale locale) {
        if (this.getBrowseGroup() == null || this.getBrowseGroup().getDisplayName() == null) {
            return this.getName(locale);
        }
        return this.getBrowseGroup().getDisplayName(locale) + "_" + this.getName(locale);
    }

    public static String getBosType() {
        CustomerInfo customerInfo = new CustomerInfo();
        return customerInfo.getBOSType().toString();
    }

    public void validate() throws BOSException, EASBizException {
        if (this.getTaxRate() != null && this.getTaxRate().doubleValue() < 0.0) {
            throw new CustomerSupplierException(CustomerSupplierException.SUPPLIERTAXRATEINVALID);
        }
    }

    public boolean isValueChange() {
        if (this.oldValues != null) {
            Locale locale = SysContext.getSysContext().getLocale();
            if (!"l1".equals(locale.toString())) {
                this.oldValues.put("name_l1", this.getName(LocaleUtils.locale_l1));
            }
            if (!"l2".equals(locale.toString())) {
                this.oldValues.put("name_l2", this.getName(LocaleUtils.locale_l2));
            }
            if (!"l3".equals(locale.toString())) {
                this.oldValues.put("name_l3", this.getName(LocaleUtils.locale_l3));
            }
        }
        return super.isValueChange();
    }

    public void checkGroupIsLeaf(CustomerInfo customerInfo) throws BOSException, EASBizException {
        CustomerGroupDetailCollection groupDetails = customerInfo.getCustomerGroupDetails();
        for (int i = 0; i < groupDetails.size(); ++i) {
            CSSPGroupInfo group = customerInfo.getBrowseGroup();
            ICSSPGroup iCssp = null;
            CSSPGroupInfo group2 = null;
            try {
                iCssp = CSSPGroupFactory.getLocalInstance(ConfigMDUtil.getContext());
                group2 = iCssp.getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(group.getId()));
            }
            catch (Exception e) {
                logger.error((Object)"\u901a\u8fc7factory\u4ee5\u53caConfigMDUtil.getContext()\u51fa\u95ee\u9898  ", (Throwable)e);
                group2 = new CSSPGroup().getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(group.getId()));
            }
            if (group2 == null || group2.isIsLeaf()) continue;
            throw new CustomerGroupException(CustomerGroupException.NONLEAFADDNEW4CUS, new Object[]{" " + group2.getNumber() + " (" + group2.getName() + ") "});
        }
    }
}

