/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeCollection;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CSStringUtils;
import com.kingdee.eas.basedata.master.cssp.CsManagerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.IBizAnalysisCode;
import com.kingdee.eas.basedata.master.cssp.ICsManager;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.client.AbstractBizAnalysisCodeListUI;
import com.kingdee.eas.basedata.master.cssp.client.BizAnalysisCodeEditUI;
import com.kingdee.eas.basedata.master.cssp.client.CSUtils;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BizAnalysisCodeListUI
extends AbstractBizAnalysisCodeListUI {
    public static final int MAPTYPE_SUPPLIER = 1;
    public static final int MAPTYPE_CUSTOMER = 2;
    private static String[] colName = new String[]{"CSBase.number", "CSBase.name"};
    private static final String TB_KEY = "id";
    private static final String TB_NUM = "CSBase.number";
    private static final String TB_NAME = "CSBase.name";
    private static final String TB_TYPE = "CSBase.csType";
    private static final String TB_ADDRESS = "CSBase.address.name";
    private static final String TB_PERSON = "CSBase.artificialPerson";
    private static final String TB_CREATOR = "creator";
    private static final String TB_ISINTER = "CSBase.isInternalCompany";
    private static final String TB_INTER = "internalCompany";
    private static final String TB_TAXNO = "taxRegistNo";
    private static final String TB_BIZNO = "bizRegistNo";

    public BizAnalysisCodeListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app", "BizAnalysisCodeQuery");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMyWorkButton();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"bizAnalysisCode"));
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)new CustomerTreeSelectionHandler());
        this.loadTree();
        this.menuItemQuery.setVisible(false);
        this.tblMain.checkParsed();
        this.tblMain.getViewManager().setFreezeView(0, 2);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private void initMyWorkButton() {
        this.btnAddNew.setText(null);
        this.btnView.setText(null);
        this.btnUpdate.setText(null);
        this.btnRemove.setText(null);
        this.btnAddNew.setTextIconDisStyle((short)2);
        this.btnView.setTextIconDisStyle((short)2);
        this.btnUpdate.setTextIconDisStyle((short)2);
        this.btnRemove.setTextIconDisStyle((short)2);
        this.btnAddNewMapping.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"addnewMapping"));
        this.btnRemoveMapping.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"removeMapping"));
        this.btnAddNewSupplierMapping.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"addNewSupplierMapping"));
        this.btnAddNew.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnAddNew.setFactType(1);
        this.btnView.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnView.setFactType(1);
        this.btnUpdate.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnUpdate.setFactType(1);
        this.btnRemove.setBorder(BorderFactory.createLineBorder(new Color(0xA2A2A2)));
        this.btnRemove.setFactType(1);
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTree_new"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.btnAddNewMapping.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.btnAddNewSupplierMapping.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.btnRemoveMapping.setIcon(EASResource.getIcon((String)"imgTbtn_deletemapping"));
        this.treeView.getControlPane().add((Component)this.btnAddNew);
        this.treeView.getControlPane().add((Component)this.btnView);
        this.treeView.getControlPane().add((Component)this.btnUpdate);
        this.treeView.getControlPane().add((Component)this.btnRemove);
        this.btnRefresh.setVisible(true);
        this.btnRefresh.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"refresh"));
        this.menuItemImportData.setVisible(true);
        this.menuItemExportData.setVisible(true);
        this.menuItemAddNewMapping.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.menuItemAddNewSupplierMapping.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.menuItemRemoveMapping.setIcon(EASResource.getIcon((String)"imgTbtn_deletemapping"));
        this.menuReferDataBaseD.setIcon(EASResource.getIcon((String)"imgTbtn_adduction"));
    }

    private void loadTree() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo(TB_KEY));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("simpleName"));
        evi.getSelector().add(new SelectorItemInfo("description"));
        evi.getSorter().add(new SorterItemInfo("number"));
        if (evi.getFilter() != null) {
            evi.getFilter().mergeFilter(this.getDataBaseDFilter(), "AND");
        } else {
            evi.setFilter(this.getDataBaseDFilter());
        }
        BizAnalysisCodeCollection vos = null;
        vos = ((IBizAnalysisCode)this.getBizInterface()).getBizAnalysisCodeCollection(evi);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"bizAnalysisCode"));
        if (vos != null) {
            for (int i = 0; i < vos.size(); ++i) {
                root.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)vos.get(i)));
            }
        }
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
    }

    @Override
    public void loadFields() {
    }

    @Override
    public void storeFields() {
    }

    public void onShow() throws Exception {
        this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BizAnalysisCodeFactory.getRemoteInstance();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanAdd();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"KDTree", (Object)this.treeMain);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BizAnalysisCodeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.loadTree();
    }

    private void checkCanAdd() throws Exception {
        this.checkAddPolicy(this.getBizCUPK(), this.getBizObjectType());
    }

    private void checkCanUpdate(BizAnalysisCodeInfo vo) throws Exception {
        if (vo != null) {
            ObjectUuidPK objectPK = new ObjectUuidPK(vo.getId());
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)this.getBizInterface().getValue((IObjectPK)objectPK);
            if (!dataBaseDInfo.getCU().getId().toString().equals(this.getBizCUPK().toString())) {
                this.checkUpdatePolicy(this.getBizCUPK(), this.getBizObjectType());
            }
        }
    }

    private void checkCanDelete(BizAnalysisCodeInfo vo) throws Exception {
        if (vo != null) {
            ObjectUuidPK objectPK = new ObjectUuidPK(vo.getId());
            DataBaseDInfo dataBaseDInfo = (DataBaseDInfo)this.getBizInterface().getValue((IObjectPK)objectPK);
            if (!dataBaseDInfo.getCU().getId().toString().equals(this.getBizCUPK().toString())) {
                this.checkDelPolicy(this.getBizCUPK(), this.getBizObjectType());
            }
        }
    }

    private void checkAddPolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this.getBizCUPK().toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateAddnewable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
    }

    private void checkUpdatePolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this.getBizCUPK().toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateEditable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private void checkDelPolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this.getBizCUPK().toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        if (vo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"plsSelectBizAnalysisCodeFirst"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)vo.getId().toString());
            uiContext.put((Object)"KDTree", (Object)this.treeMain);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BizAnalysisCodeEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        this.loadTree();
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        if (vo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"plsSelectBizAnalysisCodeFirst"));
        } else {
            this.checkCanUpdate(vo);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)vo.getId().toString());
            uiContext.put((Object)"KDTree", (Object)this.treeMain);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BizAnalysisCodeEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        this.loadTree();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private BizAnalysisCodeInfo getSelectedBizAnalysisCode(DefaultKingdeeTreeNode node) {
        Object obj;
        BizAnalysisCodeInfo vo = null;
        if (node != null && (obj = node.getUserObject()) instanceof BizAnalysisCodeInfo) {
            vo = (BizAnalysisCodeInfo)node.getUserObject();
        }
        return vo;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        this.checkCanDelete(vo);
        if (vo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"plsSelectBizAnalysisCodeFirst"));
        } else {
            this.checkCanDelete(vo);
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"DELETE_BIZANALYSIS_CODE")))) {
                try {
                    this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(vo.getId()));
                    this.removeCSBaseBizAnalysisCode(vo);
                    KingdeeTreeModel model = (KingdeeTreeModel)this.treeMain.getModel();
                    model.removeNodeFromParent((MutableTreeNode)node);
                    this.tblMain.removeRows();
                }
                catch (Exception er) {
                    super.handUIException((Throwable)er);
                }
            }
        }
        this.loadTree();
    }

    private void removeCSBaseBizAnalysisCode(BizAnalysisCodeInfo vo) throws Exception {
        int i;
        ICsManager iCsManager = CsManagerFactory.getRemoteInstance();
        CustomerCollection customerVos = iCsManager.getCustomerCollectionByBizCode((IObjectPK)new ObjectUuidPK(vo.getId()));
        SupplierCollection supplierVos = iCsManager.getSupplierCollectionByBizCode((IObjectPK)new ObjectUuidPK(vo.getId()));
        if (customerVos != null) {
            for (i = 0; i < customerVos.size(); ++i) {
                iCsManager.unmapCSBaseBizAnalysisCode((IObjectPK)new ObjectUuidPK(customerVos.get(i).getId()), 2);
            }
        }
        if (supplierVos != null) {
            for (i = 0; i < supplierVos.size(); ++i) {
                iCsManager.unmapCSBaseBizAnalysisCode((IObjectPK)new ObjectUuidPK(supplierVos.get(i).getId()), 1);
            }
        }
    }

    @Override
    public void actionAddNewMapping_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        if (vo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"plsSelectBizAnalysisCodeFirst"));
        } else {
            this.checkCanUpdate(vo);
            KDBizPromptBox f7 = new KDBizPromptBox();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("internalCompany.name"));
            sic.add(new SelectorItemInfo("adminCU.id"));
            sic.add(new SelectorItemInfo("adminCU.name"));
            f7.setSelectorCollection(sic);
            GeneralKDPromptSelectorAdaptor adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)f7, (Component)((Object)new F7CustomerTreeDetailListUI()), (Object)this, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQuery");
            f7.setSelector((KDPromptSelector)adaptor);
            f7.setDataBySelector();
            if (f7.getData() != null) {
                CustomerInfo customerVO = (CustomerInfo)f7.getData();
                BizAnalysisCodeInfo bizCode = customerVO.getBizAnalysisCode();
                if (bizCode != null) {
                    bizCode = BizAnalysisCodeFactory.getRemoteInstance().getBizAnalysisCodeInfo((IObjectPK)new ObjectUuidPK(bizCode.getId()));
                    if (customerVO.getCU().getId().equals((Object)SysContext.getSysContext().getCurrentCtrlUnit().getId())) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"csHasBizCode") + bizCode + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"confirmContinueMapping");
                        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg))) {
                            this.mapCustomer(vo, customerVO);
                        }
                    } else {
                        String cuId = customerVO.getCU().getId().toString();
                        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuId));
                        String cuName = ctrlUnitInfo.toString();
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"update_HasBizCustomer", (Object[])new String[]{customerVO.toString(), cuName, bizCode.toString()}));
                        SysUtil.abort();
                    }
                } else {
                    this.mapCustomer(vo, customerVO);
                }
            }
        }
    }

    @Override
    public void actionAddNewSupplierMapping_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        if (vo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"plsSelectBizAnalysisCodeFirst"));
        } else {
            this.checkCanUpdate(vo);
            KDBizPromptBox f7 = new KDBizPromptBox();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("internalCompany.name"));
            sic.add(new SelectorItemInfo("adminCU.id"));
            sic.add(new SelectorItemInfo("adminCU.name"));
            f7.setSelectorCollection(sic);
            f7.getQueryAgent().setHasCUDefaultFilter(false);
            GeneralKDPromptSelectorAdaptor adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)f7, (Component)((Object)new F7SupplierTreeDetailListUI()), (Object)this, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQuery");
            f7.setSelector((KDPromptSelector)adaptor);
            f7.setDataBySelector();
            if (f7.getData() != null) {
                SupplierInfo supplierVO = (SupplierInfo)f7.getData();
                BizAnalysisCodeInfo bizCode = supplierVO.getBizAnalysisCode();
                if (bizCode != null) {
                    bizCode = BizAnalysisCodeFactory.getRemoteInstance().getBizAnalysisCodeInfo((IObjectPK)new ObjectUuidPK(bizCode.getId()));
                    if (supplierVO.getCU().getId().equals((Object)SysContext.getSysContext().getCurrentCtrlUnit().getId())) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"csHasBizCode") + bizCode + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"confirmContinueMapping");
                        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg))) {
                            this.mapSupplier(vo, supplierVO);
                        }
                    } else {
                        String cuId = supplierVO.getCU().getId().toString();
                        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuId));
                        String cuName = ctrlUnitInfo.toString();
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"update_HasBizSupplier", (Object[])new String[]{supplierVO.toString(), cuName, bizCode.toString()}));
                        SysUtil.abort();
                    }
                } else {
                    this.mapSupplier(vo, supplierVO);
                }
            }
        }
    }

    private void mapCustomer(BizAnalysisCodeInfo vo, CustomerInfo customerVO) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            String internalCompanyID;
            boolean isInternalCompany = (Boolean)this.tblMain.getRow(0).getCell(TB_ISINTER).getValue();
            if (customerVO.isIsInternalCompany() != isInternalCompany) {
                throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
            }
            if (isInternalCompany && !(internalCompanyID = ((CompanyOrgUnitInfo)this.tblMain.getRow(0).getCell(TB_INTER).getValue()).getId().toString()).equals(customerVO.getInternalCompany().getId().toString())) {
                throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
            }
        }
        ICsManager iCsManager = CsManagerFactory.getRemoteInstance();
        iCsManager.mapCSBaseToBizAnalysisCode((IObjectPK)new ObjectUuidPK(customerVO.getId()), (IObjectPK)new ObjectUuidPK(vo.getId()), 2);
        this.refreshCSTable(vo);
    }

    private void mapSupplier(BizAnalysisCodeInfo vo, SupplierInfo supplierVO) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            String internalCompanyID;
            boolean isInternalCompany = (Boolean)this.tblMain.getRow(0).getCell(TB_ISINTER).getValue();
            if (supplierVO.isIsInternalCompany() != isInternalCompany) {
                throw new CustomerSupplierException(CustomerSupplierException.INTERNAL_EXTERNAL_CS_CANNOT_MAPPED);
            }
            if (isInternalCompany && !(internalCompanyID = ((CompanyOrgUnitInfo)this.tblMain.getRow(0).getCell(TB_INTER).getValue()).getId().toString()).equals(supplierVO.getInternalCompany().getId().toString())) {
                throw new CustomerSupplierException(CustomerSupplierException.MAPPED_INTERNAL_COMPANY_NOT_SAME);
            }
        }
        ICsManager iCsManager = CsManagerFactory.getRemoteInstance();
        iCsManager.mapCSBaseToBizAnalysisCode((IObjectPK)new ObjectUuidPK(supplierVO.getId()), (IObjectPK)new ObjectUuidPK(vo.getId()), 1);
        this.refreshCSTable(vo);
    }

    @Override
    public void actionRemoveMapping_actionPerformed(ActionEvent e) throws Exception {
        int index;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        if (vo != null) {
            this.checkCanUpdate(vo);
        }
        if ((index = this.tblMain.getSelectManager().getActiveRowIndex()) > -1) {
            IRow row = this.tblMain.getRow(index);
            BOSUuid id = (BOSUuid)row.getCell(10).getValue();
            if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"confirmDeleteMap")))) {
                ICsManager iCsManager = CsManagerFactory.getRemoteInstance();
                iCsManager.unmapCSBaseBizAnalysisCode((IObjectPK)new ObjectUuidPK(id), 2);
                this.tblMain.removeRow(index);
            }
        } else {
            CSUtils.plsSelectRowFirst((Component)((Object)this));
        }
    }

    protected void refreshCSTable(BizAnalysisCodeInfo vo) throws Exception {
        IRow row;
        int i;
        this.tblMain.removeRows();
        ICsManager iCsManager = CsManagerFactory.getRemoteInstance();
        CustomerCollection customerVos = null;
        SupplierCollection supplierVos = null;
        Object pk = null;
        if (vo != null) {
            customerVos = iCsManager.getCustomerCollectionByBizCode((IObjectPK)new ObjectUuidPK(vo.getId()));
            supplierVos = iCsManager.getSupplierCollectionByBizCode((IObjectPK)new ObjectUuidPK(vo.getId()));
        }
        if (customerVos != null) {
            for (i = 0; i < customerVos.size(); ++i) {
                CustomerInfo customerVO = customerVos.get(i);
                row = this.tblMain.addRow();
                row.getCell(10).setValue((Object)customerVO.getId());
                row.getCell(TB_NUM).setValue((Object)customerVO.getNumber());
                row.getCell(TB_NAME).setValue((Object)customerVO.getName());
                row.getCell(TB_TYPE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customer"));
                row.getCell(TB_ADDRESS).setValue((Object)customerVO.getAddress());
                row.getCell(TB_PERSON).setValue((Object)customerVO.getArtificialPerson());
                row.getCell(TB_CREATOR).setValue((Object)customerVO.getCreator());
                row.getCell(TB_ISINTER).setValue((Object)customerVO.isIsInternalCompany());
                row.getCell(TB_INTER).setValue((Object)customerVO.getInternalCompany());
                row.getCell(TB_TAXNO).setValue((Object)customerVO.getTaxRegisterNo());
                row.getCell(TB_BIZNO).setValue((Object)customerVO.getBizRegisterNo());
                row.getCell(TB_KEY).setValue((Object)vo.getId());
            }
        }
        if (supplierVos != null) {
            for (i = 0; i < supplierVos.size(); ++i) {
                SupplierInfo supplierVO = supplierVos.get(i);
                row = this.tblMain.addRow();
                row.getCell(10).setValue((Object)supplierVO.getId());
                row.getCell(TB_NUM).setValue((Object)supplierVO.getNumber());
                row.getCell(TB_NAME).setValue((Object)supplierVO.getName());
                row.getCell(TB_TYPE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplier"));
                row.getCell(TB_ADDRESS).setValue((Object)supplierVO.getAddress());
                row.getCell(TB_PERSON).setValue((Object)supplierVO.getArtificialPerson());
                row.getCell(TB_CREATOR).setValue((Object)supplierVO.getCreator());
                row.getCell(TB_ISINTER).setValue((Object)supplierVO.isIsInternalCompany());
                row.getCell(TB_INTER).setValue((Object)supplierVO.getInternalCompany());
                row.getCell(TB_TAXNO).setValue((Object)supplierVO.getTaxRegisterNo());
                row.getCell(TB_BIZNO).setValue((Object)supplierVO.getBizRegisterNo());
                row.getCell(TB_KEY).setValue((Object)vo.getId());
            }
        }
        if (this.tblMain.getColumn(TB_ISINTER) != null) {
            this.tblMain.getColumn(TB_ISINTER).getStyleAttributes().setLocked(true);
        }
    }

    protected BOSObjectType getBizObjectType() {
        BOSObjectType bosType = new BOSObjectType("1527B96C");
        return bosType;
    }

    protected String getEditUIName() {
        return BizAnalysisCodeEditUI.class.getName();
    }

    protected void tblMain_doRequestRowSetForNoQueryPK(RequestRowSetEvent e) {
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
    }

    protected void checkTableParsed() {
    }

    protected String getKeyFieldName() {
        return TB_KEY;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        this.loadTree();
        BizAnalysisCodeInfo vo = this.getSelectedBizAnalysisCode(node);
        this.refreshCSTable(vo);
    }

    private FilterInfo getDataBaseDFilter() throws Exception {
        return ((IDataBaseD)this.getBizInterface()).getDatabaseDFilter(this.getBizCUPK(), TB_KEY, this.getAdminCUFieldName());
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        String solutionName = "eas.basedata.common.bizAnalysisCode";
        param.alias = CSStringUtils.getUIResource("bizAnalysisCode");
        param.solutionName = solutionName;
        param.datataskMode = 1;
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.master.cssp.app", "BizAnalysisCodeQuery");
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(this.getDataBaseDFilter());
            dp.putContextParam((Object)"mainQueryPK", (Object)queryPK);
            dp.putContextParam((Object)"mainQuery", (Object)viewInfo);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        String solutionName = "eas.basedata.common.bizAnalysisCode";
        param.alias = CSStringUtils.getUIResource("bizAnalysisCode");
        param.solutionName = solutionName;
        param.datataskMode = 0;
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    class CustomerTreeSelectionHandler
    implements TreeSelectionListener {
        CustomerTreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BizAnalysisCodeListUI.this.treeMain.getLastSelectedPathComponent();
            try {
                BizAnalysisCodeListUI.this.refreshCSTable(BizAnalysisCodeListUI.this.getSelectedBizAnalysisCode(node));
            }
            catch (Exception e1) {
                ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"refreshCSUnderBizAnalysisCodeFailed"), (Throwable)e1);
            }
        }
    }
}

