/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.master.cssp.CSParameterCollection;
import com.kingdee.eas.basedata.master.cssp.CSParameterFactory;
import com.kingdee.eas.basedata.master.cssp.CSParameterInfo;
import com.kingdee.eas.basedata.master.cssp.ICSParameter;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCSParameterSetUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import org.apache.log4j.Logger;

public class CSParameterSetUI
extends AbstractCSParameterSetUI
implements IOtherParam,
ICustomParamUI {
    private static final Logger logger = CoreUIObject.getLogger(CSParameterSetUI.class);
    private CtrlUnitInfo cuInfo = null;
    private CSParameterInfo paramInfo = null;
    private CSParameterInfo currentCSParameterInfo = new CSParameterInfo();

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
    }

    public CSParameterSetUI() throws Exception {
        this.cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initSelected();
    }

    private void initSelected() {
        try {
            this.paramInfo = this.getCSParamInfo(this.cuInfo);
            this.cbBizRegisterNoCustomer.setSelected(this.paramInfo.isCustomerBizRegisterNo());
            this.cbForeignNameCustomer.setSelected(this.paramInfo.isCustomerForeignName());
            this.cbMnemonicCodeCustomer.setSelected(this.paramInfo.isCustomerMnemonicCode());
            this.cbNameCustomer.setSelected(this.paramInfo.isCustomerName());
            this.cbSimpleNameCustomer.setSelected(this.paramInfo.isCustomerSimpleName());
            this.cbTaxRegisterNoCustomer.setSelected(this.paramInfo.isCustomerTaxRegisterNo());
            this.cbCustomerSuppliperName.setSelected(this.paramInfo.isCustomerSuppliperName());
            this.rbNoPromptCustomer.setSelected(this.paramInfo.isCustomerDontSave());
            this.rbPromptCustomer.setSelected(this.paramInfo.isCustomerPrompt());
            this.cbCUUniqueCustomer.setSelected(this.paramInfo.isCustomerCUUnique());
            this.cbBizRegisterNoSupplier.setSelected(this.paramInfo.isSupplierBizRegisterNo());
            this.cbForeignNameSupplier.setSelected(this.paramInfo.isSupplierForeignName());
            this.cbMnemonicCodeSupplier.setSelected(this.paramInfo.isSupplierMnemonicCode());
            this.cbNameSupplier.setSelected(this.paramInfo.isSupplierName());
            this.cbSimpleNameSupplier.setSelected(this.paramInfo.isSupplierSimpleName());
            this.cbTaxRegisterNoSupplier.setSelected(this.paramInfo.isSupplierTaxRegisterNo());
            this.cbSupplierCustomerName.setSelected(this.paramInfo.isSupplierCustomerName());
            this.rbNoPromptSupplier.setSelected(this.paramInfo.isSupplierDontSave());
            this.rbPromptSupplier.setSelected(this.paramInfo.isSupplierPrompt());
            this.cbCUUniqueSupplier.setSelected(this.paramInfo.isSupplierCUUnique());
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        if (!this.rbPromptCustomer.isSelected() && !this.rbNoPromptCustomer.isSelected()) {
            this.rbPromptCustomer.setSelected(true);
            this.rbNoPromptCustomer.setSelected(false);
        }
        if (!this.rbPromptSupplier.isSelected() && !this.rbNoPromptSupplier.isSelected()) {
            this.rbPromptSupplier.setSelected(true);
            this.rbNoPromptSupplier.setSelected(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private CSParameterInfo getCSParamInfo(CtrlUnitInfo cu) throws BOSException, EASBizException {
        ICSParameter iCSParameter = this.getBizInterface();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cu.getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        if (iCSParameter.exists(filter)) {
            CSParameterCollection collection = iCSParameter.getCSParameterCollection(entityViewInfo);
            this.currentCSParameterInfo = collection.get(0);
            return this.currentCSParameterInfo;
        }
        this.setDefaultValue();
        return this.currentCSParameterInfo;
    }

    private void setDefaultValue() {
        CSParameterInfo customerDefaultParam = CSParameterInfo.getCustomerDefaultParam();
        this.currentCSParameterInfo.setCustomerName(customerDefaultParam.isCustomerName());
        this.currentCSParameterInfo.setCustomerSimpleName(customerDefaultParam.isCustomerSimpleName());
        this.currentCSParameterInfo.setCustomerBizRegisterNo(customerDefaultParam.isCustomerBizRegisterNo());
        this.currentCSParameterInfo.setCustomerTaxRegisterNo(customerDefaultParam.isCustomerTaxRegisterNo());
        this.currentCSParameterInfo.setCustomerForeignName(customerDefaultParam.isCustomerForeignName());
        this.currentCSParameterInfo.setCustomerMnemonicCode(customerDefaultParam.isCustomerMnemonicCode());
        this.currentCSParameterInfo.setCustomerPrompt(customerDefaultParam.isCustomerPrompt());
        this.currentCSParameterInfo.setCustomerDontSave(customerDefaultParam.isCustomerDontSave());
        this.currentCSParameterInfo.setCustomerSuppliperName(customerDefaultParam.isCustomerSuppliperName());
        this.currentCSParameterInfo.setCustomerCUUnique(customerDefaultParam.isCustomerCUUnique());
        CSParameterInfo supplierDefaultParam = CSParameterInfo.getSupplierDefaultParam();
        this.currentCSParameterInfo.setSupplierName(supplierDefaultParam.isSupplierName());
        this.currentCSParameterInfo.setSupplierSimpleName(supplierDefaultParam.isSupplierSimpleName());
        this.currentCSParameterInfo.setSupplierBizRegisterNo(supplierDefaultParam.isSupplierBizRegisterNo());
        this.currentCSParameterInfo.setSupplierTaxRegisterNo(supplierDefaultParam.isSupplierTaxRegisterNo());
        this.currentCSParameterInfo.setSupplierForeignName(supplierDefaultParam.isSupplierForeignName());
        this.currentCSParameterInfo.setSupplierMnemonicCode(supplierDefaultParam.isSupplierMnemonicCode());
        this.currentCSParameterInfo.setSupplierPrompt(supplierDefaultParam.isSupplierPrompt());
        this.currentCSParameterInfo.setSupplierDontSave(supplierDefaultParam.isSupplierDontSave());
        this.currentCSParameterInfo.setSupplierCustomerName(supplierDefaultParam.isSupplierCustomerName());
        this.currentCSParameterInfo.setSupplierCUUnique(supplierDefaultParam.isSupplierCUUnique());
    }

    private CSParameterInfo getParaValue() {
        CSParameterInfo value = this.paramInfo;
        if (value == null) {
            value = new CSParameterInfo();
        }
        value.setCu(this.cuInfo);
        boolean btmp = this.cbNameCustomer.isSelected();
        value.setCustomerName(btmp);
        btmp = this.cbSimpleNameCustomer.isSelected();
        value.setCustomerSimpleName(btmp);
        btmp = this.cbForeignNameCustomer.isSelected();
        value.setCustomerForeignName(btmp);
        btmp = this.cbMnemonicCodeCustomer.isSelected();
        value.setCustomerMnemonicCode(btmp);
        btmp = this.cbBizRegisterNoCustomer.isSelected();
        value.setCustomerBizRegisterNo(btmp);
        btmp = this.cbTaxRegisterNoCustomer.isSelected();
        value.setCustomerTaxRegisterNo(btmp);
        btmp = this.cbCustomerSuppliperName.isSelected();
        value.setCustomerSuppliperName(btmp);
        btmp = this.rbPromptCustomer.isSelected();
        value.setCustomerPrompt(btmp);
        btmp = this.rbNoPromptCustomer.isSelected();
        value.setCustomerDontSave(btmp);
        btmp = this.cbCUUniqueCustomer.isSelected();
        value.setCustomerCUUnique(btmp);
        btmp = this.cbNameSupplier.isSelected();
        value.setSupplierName(btmp);
        btmp = this.cbSimpleNameSupplier.isSelected();
        value.setSupplierSimpleName(btmp);
        btmp = this.cbForeignNameSupplier.isSelected();
        value.setSupplierForeignName(btmp);
        btmp = this.cbMnemonicCodeSupplier.isSelected();
        value.setSupplierMnemonicCode(btmp);
        btmp = this.cbBizRegisterNoSupplier.isSelected();
        value.setSupplierBizRegisterNo(btmp);
        btmp = this.cbTaxRegisterNoSupplier.isSelected();
        value.setSupplierTaxRegisterNo(btmp);
        btmp = this.cbSupplierCustomerName.isSelected();
        value.setSupplierCustomerName(btmp);
        btmp = this.rbPromptSupplier.isSelected();
        value.setSupplierPrompt(btmp);
        btmp = this.rbNoPromptSupplier.isSelected();
        value.setSupplierDontSave(btmp);
        btmp = this.cbCUUniqueSupplier.isSelected();
        value.setSupplierCUUnique(btmp);
        return value;
    }

    private ICSParameter getBizInterface() throws BOSException {
        ICSParameter iCSParameter = CSParameterFactory.getRemoteInstance();
        return iCSParameter;
    }

    public void otherParamSave() throws BOSException, EASBizException {
        ICSParameter iCSParameter = this.getBizInterface();
        CSParameterInfo ov = this.getParaValue();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)this.cuInfo.getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        if (iCSParameter.exists(filter)) {
            CSParameterCollection collection = iCSParameter.getCSParameterCollection(entityViewInfo);
            ov.setId(collection.get(0).getId());
            iCSParameter.submit(ov);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.create((String)"751E6F09"));
            iCSParameter.submit((IObjectPK)pk, ov);
        }
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        if (orgType.getValue() != 10) {
            return;
        }
        if (orgUnit == null || orgUnit.getId() == null) {
            return;
        }
        this.cuInfo = new CtrlUnitInfo();
        this.cuInfo.setId(orgUnit.getId());
        try {
            this.loadFields();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

