/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCSSPGroupF7UI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CSSPGroupF7UI
extends AbstractCSSPGroupF7UI {
    private static final Logger logger = CoreUIObject.getLogger(CSSPGroupF7UI.class);
    private ITreeBuilder treeBuilder;
    protected boolean isCanceled = true;
    protected CSSPGroupInfo csspGroupInfo = null;
    private static final String Customer = "1";
    private static final String Supplier = "2";
    private String groupStandardID = null;
    private static final String defaultType = "0";
    private ItemListener groupStandardListener = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.tGroupTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof CSSPGroupInfo) {
            this.csspGroupInfo = (CSSPGroupInfo)treeNode.getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void tGroupTree_mouseClicked(MouseEvent e) throws Exception {
        KDTreeNode treeNode;
        if (e.getClickCount() == 2 && (treeNode = (KDTreeNode)this.tGroupTree.getLastSelectedPathComponent()) != null && treeNode.getUserObject() instanceof CSSPGroupInfo) {
            this.csspGroupInfo = (CSSPGroupInfo)treeNode.getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initGroupStandard(this.getUIContext().get("CSType").toString());
        this.initTree();
    }

    private void initGroupStandard(String type) throws Exception {
        this.groupStandardListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CSSPGroupF7UI.this.itemChanaged(e);
            }
        };
        ICSSPGroupStandard iGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
        this.kDComboBox1.removeItemListener(this.groupStandardListener);
        CSSPGroupStandardCollection stds = iGroupStandard.getCSSPGroupStandard(type, false);
        this.kDComboBox1.removeAllItems();
        if (stds != null) {
            this.kDComboBox1.addItems(stds.toArray());
        }
        this.kDComboBox1.addItemListener(this.groupStandardListener);
        if (this.kDComboBox1.getSelectedItem() != null) {
            this.groupStandardID = ((CSSPGroupStandardInfo)this.kDComboBox1.getSelectedItem()).getId().toString();
        }
    }

    private void itemChanaged(ItemEvent e) {
        this.groupStandardID = ((CSSPGroupStandardInfo)this.kDComboBox1.getSelectedItem()).getId().toString();
        try {
            this.initTree();
            this.tGroupTree.setSelectionRow(0);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void initTree() throws Exception {
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode((Object)this.getRootName());
            ((DefaultTreeModel)this.tGroupTree.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.tGroupTree.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.tGroupTree);
        this.tGroupTree.setShowPopMenuDefaultItem(true);
    }

    private String getRootName() {
        if (this.getUIContext().get("CSType").toString().equals(Supplier)) {
            return EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplier");
        }
        if (this.getUIContext().get("CSType").toString().equals(Customer)) {
            return EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customer");
        }
        return "root";
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private ITreeBase getTreeInterface() throws Exception {
        return CSSPGroupFactory.getRemoteInstance();
    }

    private int getTreeInitialLevel() {
        return 3;
    }

    private int getTreeExpandLevel() {
        return 3;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard", (Object)this.groupStandardID));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)DeletedStatusEnum.NORMAL, CompareType.EQUALS));
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber());
        try {
            filterInfo.mergeFilter(filterInfoCU, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }
}

