/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerTabPageEnum;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierTabPageEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCSSPOrgByCSSPUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CSSPOrgByCSSPUI
extends AbstractCSSPOrgByCSSPUI {
    private static final Logger logger = CoreUIObject.getLogger(CSSPOrgByCSSPUI.class);
    private static final String CUSTOMER = "1";
    private static final String SUPPLIER = "2";
    private int currentPKIndex = -1;
    private ArrayList idList;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.changeCSSPID(6);
        this.query();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.changeCSSPID(7);
        this.query();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.changeCSSPID(8);
        this.query();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.changeCSSPID(9);
        this.query();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initInterface();
        this.initData();
    }

    private void initInterface() {
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
    }

    private void initData() {
        String type = this.getUIContext().get("viewType").toString();
        this.idList = (ArrayList)this.getUIContext().get("idList");
        this.getPKIndex(this.getUIContext().get("currentPK"));
        if (type.equals(SUPPLIER)) {
            this.cmbPropertySelect.addItems(SupplierTabPageEnum.getEnumList().toArray());
            this.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.SupplierCompanyBySuppQuery");
        }
        if (type.equals(CUSTOMER)) {
            this.cmbPropertySelect.addItems(CustomerTabPageEnum.getEnumList().toArray());
            this.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.CustomerCompanyByCustQuery");
        }
    }

    private void query() throws EASBizException, BOSException {
        String queryName = "";
        int page = 0;
        String type = this.getUIContext().get("viewType").toString();
        if (type.equals(CUSTOMER)) {
            page = Integer.valueOf(((CustomerTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            switch (page) {
                case 10: {
                    queryName = "com.kingdee.eas.basedata.master.cssp.app.CustomerCompanyByCustQuery";
                    break;
                }
                case 20: {
                    queryName = "com.kingdee.eas.basedata.master.cssp.app.CustomerSaleByCustQuery";
                }
            }
        }
        if (type.equals(SUPPLIER)) {
            page = Integer.valueOf(((SupplierTabPageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue());
            switch (page) {
                case 10: {
                    queryName = "com.kingdee.eas.basedata.master.cssp.app.SupplierCompanyBySuppQuery";
                    break;
                }
                case 20: {
                    queryName = "com.kingdee.eas.basedata.master.cssp.app.SupplierPurchaseBySuppQuery";
                }
            }
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String id = this.getCurrentPK();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        env.setFilter(filter);
        this.setEntityViewInfo(env);
        this.setQueryInfo(queryName);
        this.setCSSPInfo(id);
        this.refresh();
        this.table.getViewManager().freeze(0, 4);
        this.setChangeRecordButton();
    }

    @Override
    protected void cmbPropertySelect_itemStateChanged(ItemEvent e) throws Exception {
        this.query();
    }

    private void changeCSSPID(int changeAction) throws BOSException, EASBizException {
        switch (changeAction) {
            case 6: {
                this.currentPKIndex = 0;
                break;
            }
            case 7: {
                --this.currentPKIndex;
                break;
            }
            case 8: {
                ++this.currentPKIndex;
                break;
            }
            case 9: {
                if (this.idList == null) {
                    return;
                }
                if (this.idList.size() == 0) {
                    return;
                }
                this.currentPKIndex = this.idList.size() - 1;
            }
        }
    }

    private void setChangeRecordButton() {
        if (this.idList == null) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else if (this.idList.size() <= 1) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else if (this.currentPKIndex <= 0) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        } else if (this.currentPKIndex >= this.idList.size() - 1) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        }
    }

    private String getCurrentPK() {
        return ((Object[])this.idList.get(this.currentPKIndex))[0].toString();
    }

    private void getPKIndex(Object pk) {
        if (pk == null) {
            this.currentPKIndex = 0;
        } else {
            this.currentPKIndex = -1;
            for (int i = 0; i < this.idList.size(); ++i) {
                Object[] pks = (Object[])this.idList.get(i);
                if (!pk.toString().equals(pks[0].toString())) continue;
                this.currentPKIndex = i;
                return;
            }
        }
    }

    private void setCSSPInfo(String pk) throws BOSException, EASBizException {
        String type = this.getUIContext().get("viewType").toString();
        if (type.equals(SUPPLIER)) {
            ISupplier iSupplier = SupplierFactory.getRemoteInstance();
            SupplierInfo supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(pk));
            this.txtNumber.setText(supplierInfo.getNumber());
            this.txtName.setText(supplierInfo.getName());
        }
        if (type.equals(CUSTOMER)) {
            ICustomer iCustomer = CustomerFactory.getRemoteInstance();
            CustomerInfo customerInfo = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(pk));
            this.txtNumber.setText(customerInfo.getNumber());
            this.txtName.setText(customerInfo.getName());
        }
    }
}

