/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.cssp.CSOptionCollection;
import com.kingdee.eas.basedata.master.cssp.CSOptionFactory;
import com.kingdee.eas.basedata.master.cssp.CSOptionInfo;
import com.kingdee.eas.basedata.master.cssp.CSType;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailFactory;
import com.kingdee.eas.basedata.master.cssp.ICSOption;
import com.kingdee.eas.basedata.master.cssp.ICustomerGroupDetail;
import com.kingdee.eas.basedata.master.cssp.ISupplierGroupDetail;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class CSUtils {
    public static void setCustomerCompanyOrgQueryPromptBox(IUIObject owner, KDBizPromptBox promptBox, boolean isMultiSelect) {
        CSUtils.setCustomerPromptBox(owner, promptBox, isMultiSelect);
    }

    public static void setSupplierCompanyOrgQueryPromptBox(IUIObject owner, KDBizPromptBox promptBox, boolean isMultiSelect) {
        CSUtils.setSupplierPromptBox(owner, promptBox, isMultiSelect);
    }

    public static void setCustomerPromptBox(IUIObject owner, KDBizPromptBox promptBox, boolean isMultiSelect) {
        promptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.CustomerInfoQuery");
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$name$");
        promptBox.setEnabledMultiSelection(isMultiSelect);
    }

    public static void setSupplierPromptBox(IUIObject owner, KDBizPromptBox promptBox, boolean isMultiSelect) {
        promptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.PSupplierQuery");
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$name$");
        promptBox.setEnabledMultiSelection(isMultiSelect);
    }

    public static boolean isStringEqual(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null && str2 != null && str2.trim().equals("")) {
            return true;
        }
        if (str1 != null && str1.trim().equals("") && str2 == null) {
            return true;
        }
        return str1 != null && str2 != null && str1.equals(str2);
    }

    public static boolean isObjectBaseInfoEqual(ObjectBaseInfo obj1, ObjectBaseInfo obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.getId().toString().equals(obj2.getId().toString());
    }

    public static boolean isBigDecimalEqual(BigDecimal obj1, BigDecimal obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.compareTo(obj2) == 0;
    }

    public static boolean isDateEqual(Date obj1, Date obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public static void setupUITitle(CoreUIObject ui, String bindedEntityName) {
        if (ui != null) {
            if (ui.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
                ui.setUITitle(bindedEntityName + " - " + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"addnew"));
            } else if (ui.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
                ui.setUITitle(bindedEntityName + " - " + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"edit"));
            } else if (ui.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
                ui.setUITitle(bindedEntityName + " - " + EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"view"));
            }
        }
    }

    public static void plsSelectRowFirst(Component owner) {
        MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
    }

    public static void setFieldsNull(IObjectValue newData) {
        newData.setString("number", null);
        newData.setString("name", null);
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return sm.size() > 0;
    }

    public static String[] getSelectRowFieldValue(KDTable kdtTable, String fieldname) {
        if (!CSUtils.isSelectRow(kdtTable)) {
            return null;
        }
        Object value = null;
        Object exceptValue = null;
        ArrayList<String> retList = new ArrayList<String>();
        int keyField = kdtTable.getColumnIndex(fieldname);
        KDTSelectManager sm = kdtTable.getSelectManager();
        if (sm.get().getMode() == 8) {
            for (int i = 0; i < kdtTable.getRowCount(); ++i) {
                IRow row = kdtTable.getRow(i);
                value = row.getCell(keyField).getValue();
                if (value == null || value.toString().trim().length() == 0) continue;
                String retStr = value.toString();
                retList.add(retStr);
            }
        } else {
            int blockCount = sm.size();
            for (int i = 0; i < blockCount; ++i) {
                KDTSelectBlock block = sm.get(i);
                int bottom = block.getBottom();
                for (int j = block.getTop(); j <= bottom; ++j) {
                    IRow row = kdtTable.getRow(j);
                    value = row.getCell(keyField).getValue();
                    if (value == null || value.toString().trim().length() == 0) continue;
                    String retStr = value.toString();
                    retList.add(retStr);
                }
            }
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static IObjectPK[] convertStringToObjectPK(String[] pkStrs) {
        if (pkStrs == null || pkStrs.length == 0) {
            return null;
        }
        int num = pkStrs.length;
        ObjectUuidPK[] objectPk = new ObjectUuidPK[num];
        for (int i = 0; i < num; ++i) {
            objectPk[i] = new ObjectUuidPK(pkStrs[i]);
        }
        return objectPk;
    }

    public static boolean isExistCSSPGroup(String id, int type) {
        int typeForSupplier = 2;
        int typeForCustomer = 1;
        int defaultType = 0;
        EntityViewInfo view = null;
        FilterInfo filterInfo = null;
        try {
            ISupplierGroupDetail iSupplierDetail;
            AbstractObjectCollection collection;
            ICustomerGroupDetail iCustomerDetail;
            if (type == typeForCustomer) {
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                iCustomerDetail = CustomerGroupDetailFactory.getRemoteInstance();
                if (id != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("customerGroupStandard", (Object)id, CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    collection = iCustomerDetail.getCollection(view);
                    if (collection.size() == 0) {
                        return true;
                    }
                }
            }
            if (type == typeForSupplier) {
                view = new EntityViewInfo();
                filterInfo = new FilterInfo();
                iSupplierDetail = SupplierGroupDetailFactory.getRemoteInstance();
                if (id != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("supplierGroupStandard", (Object)id, CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    collection = iSupplierDetail.getCollection(view);
                    if (collection.size() == 0) {
                        return true;
                    }
                }
            }
            if (type == defaultType) {
                AbstractObjectCollection collection2;
                boolean isExistCustomer = false;
                boolean isExistSupplier = false;
                iCustomerDetail = CustomerGroupDetailFactory.getRemoteInstance();
                if (id != null) {
                    view = new EntityViewInfo();
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("customerGroupStandard", (Object)id, CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    collection2 = iCustomerDetail.getCollection(view);
                    if (collection2.size() == 0) {
                        isExistCustomer = true;
                    }
                }
                iSupplierDetail = SupplierGroupDetailFactory.getRemoteInstance();
                if (id != null) {
                    view = new EntityViewInfo();
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("supplierGroupStandard", (Object)id, CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    collection2 = iSupplierDetail.getCollection(view);
                    if (collection2.size() == 0) {
                        isExistSupplier = true;
                    }
                }
                return isExistCustomer && isExistSupplier;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static CSOptionInfo getCSOptionInfo(CSType csType) throws BOSException, EASBizException {
        CSOptionInfo cSOptionInfo = null;
        ICSOption iCSOption = CSOptionFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("csType", (Object)csType, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        CSOptionCollection cSOptionCollection = iCSOption.getCSOptionCollection(viewInfo);
        if (cSOptionCollection != null && cSOptionCollection.size() > 0) {
            cSOptionInfo = cSOptionCollection.get(0);
        }
        return cSOptionInfo;
    }
}

