/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ICountry;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.client.KAClassficationUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCustomerCompanyUI;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.CustomerEditUI;
import com.kingdee.eas.basedata.master.cssp.util.ShowTradeInfoUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.cbs.AgencybankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CustomerCompanyUI
extends AbstractCustomerCompanyUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerCompanyUI.class);
    private boolean isSuppressF7Event = false;
    private CustomerInfo customerInfo = null;
    private KDWorkButton btnAddBankRow;
    private KDWorkButton btnDeleteBankRow;
    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    protected CtrlUnitInfo curCtrlUnitInfo;
    private Boolean isAllowedEnterBank;
    public final String BENEFICIARY = "beneficiary";
    public final String BANKACCOUNT = "bank";
    public final String BENEFICIARYBANKCOUNTRY = "beneficiaryBankCountry";
    public final String AGENCYBANKCOUNTRY = "agencyBankCountry";
    public final String AGENCYBANKACCOUNT = "agencyBankAccount";

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (curCtrlUnitInfo.isIsCompanyOrgUnit()) {
            this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    @Override
    public void actionCustomerTradeRpt_actionPerformed(ActionEvent e) throws Exception {
        CustomerInfo customerNumber = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (this.customerInfo == null) {
            return;
        }
        customerNumber = this.customerInfo;
        if (this.prmtCompanyOrgUnit.getData() != null && this.prmtCompanyOrgUnit.getData() instanceof CompanyOrgUnitInfo) {
            companyOrgUnitInfo = this.editData.getCompanyOrgUnit();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"TRADERPT_ORG_NULL"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        ShowTradeInfoUtil.showCustomerTradeUI(uiContext, customerNumber.getNumber(), companyOrgUnitInfo);
    }

    @Override
    public void storeFields() {
        this.editData.setCompanyOrgUnit((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData());
        this.editData.setAdminOrgUnit((AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData());
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getParentUI().getUIWindow().close();
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected void showSubmitSuccess() {
        this.getParentUI().showSubmitSuccess(this.getClassAlise());
    }

    protected void showApproveSuccess(String message, String type) {
        this.getParentUI().showApproveSuccess(message, type);
    }

    protected String getClassAlise() {
        return super.getClassAlise();
    }

    protected void showEdit() {
        if (this.getParentUI() != null) {
            this.getParentUI().showEdit(this.getClassAlise());
        }
    }

    protected void showAddNew() {
        if (this.getParentUI() != null) {
            this.getParentUI().showAddNew(this.getClassAlise());
        }
    }

    protected void showView() {
        if (this.getParentUI() != null) {
            this.getParentUI().showView(this.getClassAlise());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setCompanyOrgUnit((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData());
        if (this.editData.getCustomer() != null && this.editData.getCustomer().getUsedStatus() != null) {
            this.customerInfo.setUsedStatus(this.editData.getCustomer().getUsedStatus());
        }
        this.editData.setCustomer(this.customerInfo);
        this.editData.setAdminOrgUnit((AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData());
        if (this.editData.getId() == null && OprtState.EDIT.equals(this.getOprtState())) {
            this.setOprtState(OprtState.ADDNEW);
        }
        super.actionSubmit_actionPerformed(e);
        this.getParentUI().setOprtState(OprtState.EDIT);
        this.setSave(true);
        this.setSaved(true);
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        ICustomerCompanyInfo iBiz = (ICustomerCompanyInfo)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        iBiz.cancel(new IObjectPK[]{pk});
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.showApproveSuccess(this.getClassAlise(), "forbidden");
        this.setSaved(true);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        ICustomerCompanyInfo iBiz = (ICustomerCompanyInfo)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        iBiz.cancelCancel(new IObjectPK[]{pk});
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.showApproveSuccess(this.getClassAlise(), "unforbidden");
        this.setSaved(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.chkCSIsFreezeTicketOrPayNew.setEnabled(true);
        CSClientUtils.setUITitle(this.getParentUI(), this.getOprtState(), EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"financeAttribute"));
        this.updateButtonStatus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this._stateChanged(this.prmtCompanyOrgUnit);
        if (!((IObjectValue)this.getUIContext().get("CURRENT.VO") instanceof CustomerCompanyInfo)) {
            this.getUIContext().put("CURRENT.VO", this.editData);
        }
        super.actionEdit_actionPerformed(e);
        this.chkCSIsFreezeTicketOrPayNew.setEnabled(true);
        CSClientUtils.setUITitle(this.getParentUI(), this.getOprtState(), EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"financeAttribute"));
        this.getParentUI().setOprtState(OprtState.EDIT);
        this.btnRemove.setEnabled(true);
        this.updateButtonStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        try {
            if (this.confirmRemove()) {
                CustomerCompanyInfoFactory.getRemoteInstance().delete((IObjectPK)new ObjectStringPK(this.editData.getId().toString()));
                this.setOprtState("VIEW");
                this.lockUIForViewStatus();
                this.setDataObject(this.createNewData());
                this.loadFields();
                MsgBox.showInfo((String)EASResource.getString((String)"deleteSuccessed"));
            }
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        this.updateButtonStatus();
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    @Override
    protected IObjectValue createNewData() {
        CustomerCompanyInfoInfo companyInfo = new CustomerCompanyInfoInfo();
        companyInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        companyInfo.setCreateTime(TimeStampUtility.getTime());
        this.editData.setIsFreezeIssueInvoice(false);
        return companyInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CustomerCompanyInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        this.isSuppressF7Event = true;
        this.customerInfo = (CustomerInfo)this.getUIContext().get("customer");
        this.initInterface();
        super.loadFields();
        if (this.editData.getId() == null && !this.getOprtState().equals(OprtState.VIEW)) {
            this.initDefaultData();
        }
        String comID = null;
        if (this.editData != null && this.editData.getCompanyOrgUnit() != null) {
            this.prmtCompanyOrgUnit.setData((Object)this.editData.getCompanyOrgUnit());
            this.txtCompanyName.setText(this.editData.getCompanyOrgUnit().getName());
            comID = ((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData()).getId().toString();
        } else if (this.company != null) {
            comID = this.company.getId().toString();
        }
        if (this.editData.getAdminOrgUnit() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getAdminOrgUnit().getId());
            try {
                AdminOrgUnitInfo adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                this.prmtAdminOrgUnit.setData((Object)adminOrgUnit);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
        KAClassficationUtil.setupKACLlassficationF7ByCompany((KDBizPromptBox)this.prmtAccountClass, (int)2, (CompanyOrgUnitInfo)companyInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(PayConditionInfo.getNotNullCompanyFilter((String)comID));
        this.prmtpayCondition.setEntityViewInfo(evi);
        this.initOldData((IObjectValue)this.editData);
        this.initCompany();
        this.isSuppressF7Event = false;
        this.updateButtonStatus();
    }

    private void initCompany() {
    }

    private void initDefaultData() {
        String comID = null;
        if (this.company == null) {
            return;
        }
        if (this.editData.getCompanyOrgUnit() == null) {
            this.prmtCompanyOrgUnit.setData((Object)this.company);
            if (this.company != null) {
                this.txtCompanyName.setText(this.company.getName());
            }
            this.editData.setCompanyOrgUnit(this.company);
        } else {
            this.prmtCompanyOrgUnit.setData((Object)this.editData.getCompanyOrgUnit());
            this.txtCompanyName.setText(this.editData.getCompanyOrgUnit().getName());
        }
        String accountTableId = null;
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
        if (companyInfo != null) {
            comID = companyInfo.getId().toString();
            if (companyInfo.getAccountTable() != null) {
                accountTableId = companyInfo.getAccountTable().getId().toString();
            }
        }
        if (comID != null) {
            try {
                if (this.editData.getAccountingClassfication() == null && accountTableId != null) {
                    try {
                        KAClassficationInfo defaultAccountClass = CSClientUtils.getDefaultAccountClass("customer", comID, accountTableId);
                        this.prmtAccountClass.setData((Object)defaultAccountClass);
                        this.editData.setAccountingClassfication(defaultAccountClass);
                    }
                    catch (PermissionServiceException e) {
                        e.printStackTrace();
                        this.prmtAccountClass.setData(null);
                        this.editData.setAccountingClassfication(null);
                    }
                }
                if (this.editData.getSettlementCurrency() == null) {
                    this.prmtCurrency.setData((Object)CSClientUtils.getDefaultCurrencyInfo((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData()));
                    this.editData.setSettlementCurrency(CSClientUtils.getDefaultCurrencyInfo((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData()));
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        } else {
            this.prmtAccountClass.setData(null);
            this.prmtCurrency.setData(null);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initDefaultOrgUnit(this.curCtrlUnitInfo);
        super.onLoad();
        this.initF7Control();
        this.billingLimit.setNegatived(false);
        this.prmtCompanyOrgUnit.setEnabled(true);
        this.prmtCompanyOrgUnit.setAccessAuthority(0);
        this.tblBank.getColumn("bankAccount").setRequired(true);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
        String format = CtrlFormatUtilities.getDateFormatString();
        this.txtCreateDate.setDatePattern(format);
        this.txtUpdateDate.setDatePattern(format);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initInterface() {
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.menuView.setVisible(false);
        this.txtCompanyName.setEnabled(true);
        this.txtCompanyName.setEditable(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.chkCSIsFreezeTicketOrPayNew.setEnabled(false);
        }
        if (!this.getOprtState().equals(OprtState.VIEW) && this.editData.getId() != null) {
            this.btnRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
        }
        if (this.getUIContext().get("invoiceType") != null) {
            PayInvoiceTypeEnum invoiceType = (PayInvoiceTypeEnum)((Object)this.getUIContext().get("invoiceType"));
            if (invoiceType.equals((Object)PayInvoiceTypeEnum.VALUEADDEDTAXINV)) {
                this.txtBank.setRequired(true);
                this.txtBankAddress.setRequired(true);
                this.txtOpenAccount.setRequired(true);
            } else {
                this.txtBank.setRequired(false);
                this.txtBankAddress.setRequired(false);
                this.txtOpenAccount.setRequired(false);
            }
        }
        this.menuItemCustomerTradeRpt.setEnabled(true);
        if (this.btnAddBankRow == null) {
            this.btnAddBankRow = new KDWorkButton();
            this.actionAddRowBank.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddBankRow = (KDWorkButton)this.gprBank.add((Action)((Object)this.actionAddRowBank));
            this.btnAddBankRow.setText(null);
            this.btnAddBankRow.setSize(new Dimension(22, 19));
            this.btnAddBankRow.setEnabled(true);
        }
        if (this.btnDeleteBankRow == null) {
            this.btnDeleteBankRow = new KDWorkButton();
            this.actionDelRowBank.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteBankRow = (KDWorkButton)this.gprBank.add((Action)((Object)this.actionDelRowBank));
            this.btnDeleteBankRow.setText(null);
            this.btnDeleteBankRow.setSize(new Dimension(22, 19));
            this.btnDeleteBankRow.setEnabled(true);
        }
        this.setBankTable();
    }

    private void setBankTable() {
        String[] BankTab = new String[]{"bankAccount", "accountName", "currency", "openArea"};
        String[] AddressTab = new String[]{"bank", "bankAddress"};
        KDTextField txtForBaseInfoField = new KDTextField();
        txtForBaseInfoField.setMaxLength(80);
        KDTDefaultCellEditor kdtBaseInfoCellEditor = new KDTDefaultCellEditor((JTextField)txtForBaseInfoField);
        this.tblBank.checkParsed();
        for (int i = 0; i < BankTab.length; ++i) {
            this.tblBank.getColumn(BankTab[i]).setEditor((ICellEditor)kdtBaseInfoCellEditor);
        }
        KDTextField txtForAddressField = new KDTextField();
        txtForAddressField.setMaxLength(255);
        KDTDefaultCellEditor kdtAddressCellEditor = new KDTDefaultCellEditor((JTextField)txtForAddressField);
        for (int i = 0; i < AddressTab.length; ++i) {
            this.tblBank.getColumn(AddressTab[i]).setEditor((ICellEditor)kdtAddressCellEditor);
        }
        String param = null;
        try {
            param = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.curCtrlUnitInfo.getId()), (String)"IsAllowedEnterBank");
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.isAllowedEnterBank = param == null ? true : new Boolean(param);
        if (this.getUIContext().get("customer") != null) {
            CustomerInfo customerInfo = (CustomerInfo)this.getUIContext().get("customer");
            KDBizPromptBox prmtBEBank = new KDBizPromptBox();
            prmtBEBank.setQueryInfo("com.kingdee.eas.fm.be.app.F7BEBankQuery");
            prmtBEBank.setDisplayFormat("$name$");
            prmtBEBank.setEditFormat("$number$");
            if (!this.isAllowedEnterBank.booleanValue()) {
                prmtBEBank.setEditable(false);
            }
            prmtBEBank.setCommitFormat("$number$;$name$");
            ExtendParser parser = new ExtendParser(prmtBEBank);
            prmtBEBank.setCommitParser((IParser)parser);
            KDTDefaultCellEditor kdtBEBankCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBEBank);
            this.tblBank.getColumn("bank").setEditor((ICellEditor)kdtBEBankCellEditor);
        }
        if (!this.isAllowedEnterBank.booleanValue()) {
            // empty if block
        }
        if (this.getUIContext().get("customer") != null) {
            KDBizPromptBox prmtAgencyBank = new KDBizPromptBox();
            prmtAgencyBank.setQueryInfo("com.kingdee.eas.fm.cbs.app.AgencybankQuery");
            prmtAgencyBank.setDisplayFormat("$AgencyBankNumber$");
            prmtAgencyBank.setEditFormat("$AgencyBankNumber$");
            prmtAgencyBank.setCommitFormat("$AgencyBankNumber$;$name$");
            ExtendParser parser = new ExtendParser(prmtAgencyBank);
            prmtAgencyBank.setCommitParser((IParser)parser);
            KDTDefaultCellEditor kdtAgencyBankCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtAgencyBank);
            this.tblBank.getColumn("agencyBankAccount").setEditor((ICellEditor)kdtAgencyBankCellEditor);
            ObjectValueRender tblBank_agencyBank_OVR = new ObjectValueRender();
            tblBank_agencyBank_OVR.setFormat((IDataFormat)new BizDataFormat("$AgencyBankNumber$"));
            this.tblBank.getColumn("agencyBankAccount").setRenderer((IBasicRender)tblBank_agencyBank_OVR);
        }
    }

    @Override
    public void actionAddRowBank_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            IRow row = this.tblBank.addRow();
            if (this.tblBank.getRowCount() == 1) {
                row.getCell("isDefault").setValue((Object)true);
            } else {
                row.getCell("isDefault").setValue((Object)false);
            }
        }
    }

    @Override
    public void actionDelRowBank_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLine((Component)((Object)this), this.tblBank);
        }
    }

    private void initF7Control() {
        NewCompanyF7 f7CompanyOrg = new NewCompanyF7((IUIObject)this);
        f7CompanyOrg.setMultiSelect(false);
        f7CompanyOrg.setIsCUFilter(true);
        f7CompanyOrg.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        f7CompanyOrg.setNeedAddOrgRange(false);
        this.prmtCompanyOrgUnit.setSelector((KDPromptSelector)f7CompanyOrg);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)f7CompanyOrg);
        this.prmtCompanyOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.prmtCompanyOrgUnit.addChangeListener((ChangeListener)new F7ChangeEventHandler());
        this.prmtCompanyOrgUnit.setDisplayFormat("$number$");
        this.prmtCompanyOrgUnit.setCommitFormat("$number$");
        this.prmtCompanyOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtCompanyOrgUnit.setHandleCUFilter(false);
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtAdminOrgUnit);
        this.prmtAdminOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtAdminOrgUnit.setEditable(true);
        this.prmtAdminOrgUnit.setEditFormat("$number$");
        this.prmtAdminOrgUnit.setDisplayFormat("$name$");
        this.prmtAdminOrgUnit.setCommitFormat("$number$;$code$");
        NewAdminF7 adminF7 = new NewAdminF7((IUIObject)this);
        adminF7.setNeedAddOrgRange(false);
        adminF7.setIsCUFilter(true);
        if (this.curCtrlUnitInfo != null && this.curCtrlUnitInfo.getId() != null) {
            adminF7.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        }
        adminF7.showCheckBoxOfShowingAllOUs();
        adminF7.setMultiSelect(false);
        adminF7.setContainSealUp(false);
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)adminF7);
        this.prmtOperationer.addChangeListener((ChangeListener)new OperatorChangeEventHandler());
    }

    public void _operatorChanged(KDBizPromptBox f7) {
        if (this.prmtOperationer.getData() != null && this.prmtOperationer.getData() instanceof PersonInfo) {
            PersonInfo operator = (PersonInfo)this.prmtOperationer.getData();
            try {
                AdminOrgUnitInfo adminOrgUnit = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(operator.getId());
                if (adminOrgUnit != null) {
                    this.prmtAdminOrgUnit.setValue((Object)adminOrgUnit);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private CustomerEditUI getParentUI() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof CustomerEditUI); c = c.getParent()) {
        }
        return (CustomerEditUI)((Object)c);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.addCloseButton(this.toolBar);
    }

    private void addCloseButton(KDToolBar toolBar) {
        JToolBar.Separator endSeparator = null;
        KDWorkButton btnCloseTab = null;
        endSeparator = new JToolBar.Separator();
        btnCloseTab = new KDWorkButton();
        endSeparator.setOrientation(1);
        btnCloseTab.setIcon(UIFrameResource.getCommonIcon((String)"imgTbtn_quit"));
        btnCloseTab.setText(UIFrameResource.getString((String)"close"));
        btnCloseTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CustomerCompanyUI.this.actionExitCurrent_actionPerformed(null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        toolBar.add((Component)endSeparator);
        toolBar.add((Component)btnCloseTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _stateChanged(KDBizPromptBox f7) {
        String companyID = null;
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)f7.getData();
        if (companyInfo != null) {
            try {
                CustomerCompanyInfoInfo info = this.getCompanyInfoByOrg((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
                info.setCompanyOrgUnit(companyInfo);
                companyID = companyInfo.getId().toString();
                this.editData = info;
                this.setDataObject((IObjectValue)info);
                this.loadFields();
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    ExceptionHandler.handle((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"loadCustomerCompanyInfoFailed") + e.getMessage()), (Throwable)e);
                }
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"loadCustomerCompanyInfoFailed"), (Throwable)e);
            }
            finally {
                this.txtCompanyName.setText(((CompanyOrgUnitInfo)f7.getData()).getName());
                if (this.editData == null || this.editData.getId() == null) {
                    this.initDefaultData();
                    this.initOldData((IObjectValue)this.editData);
                }
            }
        } else {
            this.txtCompanyName.setText("");
        }
        KAClassficationUtil.setupKACLlassficationF7ByCompany((KDBizPromptBox)this.prmtAccountClass, (int)2, (CompanyOrgUnitInfo)companyInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(PayConditionInfo.getNotNullCompanyFilter((String)companyID));
        this.prmtpayCondition.setEntityViewInfo(evi);
    }

    protected CustomerCompanyInfoInfo getCompanyInfoByOrg(IObjectPK companyOrgPk) throws Exception {
        CustomerCompanyInfoInfo vo = null;
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        vo = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(this.customerInfo.getId()), companyOrgPk, this.getMergedSelector());
        if (vo == null) {
            vo = (CustomerCompanyInfoInfo)this.createNewData();
        }
        return vo;
    }

    protected CustomerCompanyInfoInfo getCompanyInfo(IObjectPK companyOrgPk) throws Exception {
        CustomerCompanyInfoInfo vo = null;
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        vo = iCustomer.getCustomerCompanyInfo(companyOrgPk, this.getMergedSelector());
        if (vo == null) {
            vo = (CustomerCompanyInfoInfo)this.createNewData();
        }
        return vo;
    }

    protected CustomerCompanyInfoInfo getCompanyInfoByNumber(String number) throws Exception {
        CustomerCompanyInfoInfo vo = null;
        if (number != null) {
            vo = ((ICustomer)this.getBizInterface()).getCustomerCompanyInfo(this.customerInfo.getNumber(), number);
        }
        return vo;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getCompanyOrgUnit() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierCompayOrgUnit"));
            this.prmtCompanyOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getSettlementCurrency() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierCurrency"));
            this.prmtCurrency.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getPostalcode() != null && this.editData.getPostalcode().length() > 10) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"postZipCode"));
            this.txtZipCode.requestFocus();
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    public boolean isModify() {
        return super.isModify();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.necessaryFieldsVerify();
        if (((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData()).isIsSealUp()) {
            OUException ouException = new OUException(OUException.CANT_ADDNEW_FOR_SEALED_COMPANY);
            MsgBox.showInfo((String)ouException.getMessage());
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    public void necessaryFieldsVerify() {
        if ((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSCompanyOUNotExist"));
            SysUtil.abort();
        }
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ((CustomerCompanyInfoInfo)newData).setCompanyOrgUnit((CompanyOrgUnitInfo)null);
        ((CustomerCompanyInfoInfo)newData).setFreezeOrgUnit(null);
        ((CustomerCompanyInfoInfo)newData).setCreator(SysContext.getSysContext().getCurrentUserInfo());
        ((CustomerCompanyInfoInfo)newData).setCreateTime(TimeStampUtility.getTime());
        ((CustomerCompanyInfoInfo)newData).setLastUpdateUser(null);
        ((CustomerCompanyInfoInfo)newData).setLastUpdateTime(null);
        ((CustomerCompanyInfoInfo)newData).setCU(this.curCtrlUnitInfo);
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setCompanyOrgUnit((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData());
        this.editData.setCustomer(this.customerInfo);
        if ((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSCompanyOUNotExist"));
            return null;
        }
        IObjectPK pk = null;
        if (this.editData.getCustomer() == null) {
            this.editData.setCustomer(this.customerInfo);
        }
        if (this.editData.getCU() == null) {
            this.editData.setCU(this.curCtrlUnitInfo);
        }
        if (this.editData.getId() == null) {
            pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
            this.editData.setId(BOSUuid.read((String)pk.toString()));
        } else {
            pk = new ObjectUuidPK(this.editData.getId());
            this.getBizInterface().update(pk, (CoreBaseInfo)this.editData);
        }
        this.setDataObject(this.getValue(pk));
        this.oldData = (CustomerCompanyInfoInfo)this.editData.clone();
        return pk;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("companyOrgUnit.accountTable.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("customerBank.*"));
        sic.add(new SelectorItemInfo("customer.usedStatus"));
        return sic;
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection sic = super.getMergedSelector();
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("companyOrgUnit.accountTable.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("customerBank.*"));
        sic.add(new SelectorItemInfo("customer.usedStatus"));
        return sic;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "Customercompanyinfo_AddNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "Customercompanyinfo_Update";
        }
        return "Customercompanyinfo_View";
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    protected void updateButtonStatus() {
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        if (this.editData != null && this.editData.getId() != null) {
            if (this.editData.getUsingStatus() == UsingStatusEnum.FREEZED) {
                this.btnCancel.setVisible(false);
                this.btnCancelCancel.setVisible(true);
            } else {
                this.btnCancel.setVisible(true);
                this.btnCancelCancel.setVisible(false);
            }
        } else {
            this.btnCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
        }
    }

    public void setSaved(boolean flag) {
        super.setSaved(flag);
        this.getParentUI().setSaved(true);
    }

    public void unLockUI() {
        super.unLockUI();
    }

    @Override
    protected void tableBank_editValueChanged(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.tblBank.getColumnIndex("isDefault")) {
            int index = e.getRowIndex();
            boolean flag = (Boolean)e.getOldValue();
            if (!flag) {
                for (int i = 0; i < this.tblBank.getRowCount(); ++i) {
                    if (index == i) continue;
                    this.tblBank.getCell(i, "isDefault").setValue((Object)false);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"IsDefaultNotSelected"));
                this.tblBank.getSelectManager().select(index, colIndex);
            }
        }
    }

    protected void tblBank_editValueChanged(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tblBank_editStopped(KDTEditEvent e) throws Exception {
        ICell cell = this.tblBank.getRow(e.getRowIndex()).getCell(e.getColIndex());
        Object value = e.getValue();
        String fieldName = this.tblBank.getColumnKey(e.getColIndex());
        if ("bank".equals(fieldName)) {
            if (value != null && value instanceof BEBankInfo) {
                this.tblBank.getRow(e.getRowIndex()).getCell("bankEngName").setValue((Object)((BEBankInfo)value).getString("EnglishNames"));
                this.tblBank.getRow(e.getRowIndex()).getCell("bankAddress").setValue((Object)((BEBankInfo)value).getAdress());
                this.tblBank.getRow(e.getRowIndex()).getCell("beneficiaryBankCode").setValue((Object)((BEBankInfo)value).getNumber());
                this.tblBank.getRow(e.getRowIndex()).getCell("bankID").setValue((Object)((BEBankInfo)value).getId());
            } else {
                if (!this.isAllowedEnterBank.booleanValue()) {
                    SysUtil.abort();
                }
                this.tblBank.getRow(e.getRowIndex()).getCell("bankID").setValue(null);
            }
        } else if ("beneficiaryBankCountry".equals(fieldName)) {
            if (value != null && value instanceof CountryInfo) {
                this.tblBank.getRow(e.getRowIndex()).getCell("beneficiaryBankCountryISO").setValue((Object)((CountryInfo)value).getISOCode());
            }
        } else if ("agencyBankCountry".equals(fieldName)) {
            if (value != null && value instanceof CountryInfo) {
                this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankCountryISO").setValue((Object)((CountryInfo)value).getISOCode());
            }
        } else if ("agencyBankAccount".equals(fieldName) && value != null && value instanceof AgencybankInfo) {
            CountryInfo agencyCountry = this.getCountryInfo(((AgencybankInfo)value).getCountry());
            this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankName").setValue((Object)((AgencybankInfo)value).getName());
            this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankSWIFT").setValue((Object)((AgencybankInfo)value).getAgencySwift());
            this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankCountry").setValue((Object)agencyCountry);
            this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankCountryISO").setValue((Object)this.getCountryISO(agencyCountry));
            this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankAddr").setValue((Object)((AgencybankInfo)value).getAddress());
            this.tblBank.getRow(e.getRowIndex()).getCell("agencyBankAccount").setValue((Object)((AgencybankInfo)value).getAgencyBankNumber());
        }
    }

    private CountryInfo getCountryInfo(CountryInfo country) throws BOSException, EASBizException {
        CountryInfo countryInfo = null;
        if (country != null && country.getId() != null) {
            ICountry icountry = CountryFactory.getRemoteInstance();
            countryInfo = icountry.getCountryInfo((IObjectPK)new ObjectStringPK(country.getId().toString()));
        }
        return countryInfo;
    }

    private String getCountryISO(CountryInfo country) {
        String ISO = null;
        if (country != null) {
            ISO = country.getISOCode();
        }
        return ISO;
    }

    class F7ChangeEventHandler
    implements ChangeListener {
        F7ChangeEventHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDBizPromptBox f7 = (KDBizPromptBox)e.getSource();
            if (!CustomerCompanyUI.this.isSuppressF7Event) {
                CustomerCompanyUI.this._stateChanged(f7);
            }
        }
    }

    class OperatorChangeEventHandler
    implements ChangeListener {
        OperatorChangeEventHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDBizPromptBox f7 = (KDBizPromptBox)e.getSource();
            if (!CustomerCompanyUI.this.isSuppressF7Event) {
                CustomerCompanyUI.this._operatorChanged(f7);
            }
        }
    }
}

