/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.client.AddressPromptBox;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CSUntil;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.PaymentItemTypeEnum;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCustomerSaleUI;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.CustomerEditUI;
import com.kingdee.eas.basedata.master.cssp.util.ShowTradeInfoUtil;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CustomerSaleUI
extends AbstractCustomerSaleUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerSaleUI.class);
    protected CustomerLinkManCollection customerLinkManGroups = null;
    protected static final String TB_LINKPERSON = "linkMan";
    protected static final String TB_DUTY = "linkManDuty";
    protected static final String TB_OFFICEPHONE = "officePhone";
    protected static final String TB_CELL = "mobilPhone";
    protected static final String TB_FAX = "fax";
    protected static final String TB_EMAIL = "email";
    protected static final String TB_ADDRESS = "address";
    private boolean isSuppressF7Event = false;
    private CustomerInfo customerInfo = null;
    private KDWorkButton btnAddLinkRow = null;
    private KDWorkButton btnDeleteLinkRow = null;
    private KDWorkButton btnAddAddressRow = null;
    private KDWorkButton btnDeleteAddressRow = null;
    private KDWorkButton btnAddSalerRow = null;
    private KDWorkButton btnDeleteSalerRow = null;
    private int f7DisplayMode = -1;
    private SaleOrgUnitInfo saleOrg = null;
    protected CtrlUnitInfo curCtrlUnitInfo;
    Boolean hasCustomer_ManaPermission;

    @Override
    public void storeFields() {
        this.editData.setSaleOrgUnit((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData());
        super.storeFields();
        this.reSetDeliverAddress();
    }

    private void reSetDeliverAddress() {
        CustomerDeliveryAddressCollection collection = this.editData.getDeliveryAddresses();
        String address = null;
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            address = collection.get(i).getAddress(SysContext.getSysContext().getLocale());
            String strLocale = SysContext.getSysContext().getLocale().toString();
            if (strLocale.equalsIgnoreCase("l2")) {
                this.editData.getDeliveryAddresses().get(i).setAddress(STConverter.sc2tc((String)address), LocaleUtils.locale_l3);
                this.editData.getDeliveryAddresses().get(i).setAddress(address, LocaleUtils.locale_l1);
                continue;
            }
            if (strLocale.equalsIgnoreCase("l3")) {
                this.editData.getDeliveryAddresses().get(i).setAddress(STConverter.tc2sc((String)address), LocaleUtils.locale_l2);
                this.editData.getDeliveryAddresses().get(i).setAddress(address, LocaleUtils.locale_l1);
                continue;
            }
            if (!strLocale.equalsIgnoreCase("l1")) continue;
            this.editData.getDeliveryAddresses().get(i).setAddress(address, LocaleUtils.locale_l2);
            this.editData.getDeliveryAddresses().get(i).setAddress(address, LocaleUtils.locale_l3);
        }
        CacheServiceFactory.getInstance().discardType(BOSObjectType.create((String)"67EDD372"));
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getParentUI().getUIWindow().close();
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkAsst();
        super.actionSave_actionPerformed(e);
    }

    protected void showSubmitSuccess() {
        this.getParentUI().showSubmitSuccess(this.getClassAlise());
    }

    protected void showApproveSuccess(String message, String type) {
        this.getParentUI().showApproveSuccess(message, type);
    }

    protected void showEdit() {
        if (this.getParentUI() != null) {
            this.getParentUI().showEdit(this.getClassAlise());
        }
    }

    protected String getClassAlise() {
        return super.getClassAlise();
    }

    protected void showAddNew() {
        if (this.getParentUI() != null) {
            this.getParentUI().showAddNew(this.getClassAlise());
        }
    }

    protected void showView() {
        if (this.getParentUI() != null) {
            this.getParentUI().showView(this.getClassAlise());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAsst();
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setSaleOrgUnit((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData());
        if (this.editData.getCustomer() != null && this.editData.getCustomer().getUsedStatus() != null) {
            this.customerInfo.setUsedStatus(this.editData.getCustomer().getUsedStatus());
        }
        this.editData.setCustomer(this.customerInfo);
        if (this.editData.getId() == null && OprtState.EDIT.equals(this.getOprtState())) {
            this.setOprtState(OprtState.ADDNEW);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        CustomerDeliveryAddressCollection deliveryAddressCollection = this.editData.getDeliveryAddresses();
        int len = deliveryAddressCollection.size();
        for (int i = 0; i < len; ++i) {
            if (deliveryAddressCollection.get(i).getAddress() == null || deliveryAddressCollection.get(i).getAddress().length() <= 500) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"DELIVERYADDRESSOVERMAXSIZE"));
            SysUtil.abort();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        ICustomerSaleInfo iBiz = (ICustomerSaleInfo)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        iBiz.cancel(new IObjectPK[]{pk});
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.showApproveSuccess(this.getClassAlise(), "forbidden");
        this.setSaved(true);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        ICustomerSaleInfo iBiz = (ICustomerSaleInfo)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        iBiz.cancelCancel(new IObjectPK[]{pk});
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.showApproveSuccess(this.getClassAlise(), "unforbidden");
        this.setSaved(true);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.chkCustomerIsFreezeDelivery.setEnabled(true);
        this.chkCustomerIsFreezeOrder.setEnabled(true);
        CSClientUtils.setUITitle(this.getParentUI(), this.getOprtState(), EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saleAttribute"));
        this.updateButtonStatus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this._stateChanged(this.prmtSaleOrgUnit);
        super.actionEdit_actionPerformed(e);
        this.chkCustomerIsFreezeDelivery.setEnabled(true);
        this.chkCustomerIsFreezeOrder.setEnabled(true);
        CSClientUtils.setUITitle(this.getParentUI(), this.getOprtState(), EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saleAttribute"));
        this.getParentUI().setOprtState(OprtState.EDIT);
        this.btnRemove.setEnabled(true);
        this.updateButtonStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        try {
            if (this.confirmRemove()) {
                CustomerSaleInfoFactory.getRemoteInstance().delete((IObjectPK)new ObjectStringPK(this.editData.getId().toString()));
                this.setOprtState("VIEW");
                this.lockUIForViewStatus();
                this.setDataObject(this.createNewData());
                this.loadFields();
                MsgBox.showInfo((String)EASResource.getString((String)"deleteSuccessed"));
            }
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        this.updateButtonStatus();
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.tblDeliveryAddresses.addRow();
        }
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLine((Component)((Object)this), this.tblDeliveryAddresses);
        }
    }

    @Override
    public void actionAddRowLinkMan_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.tblLinker.addRow();
        }
    }

    @Override
    public void actionDelLinkMan_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLine((Component)((Object)this), this.tblLinker);
        }
    }

    @Override
    public void actionAddRowSaler_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.tblSaler.addRow();
        }
    }

    @Override
    public void actionDelSaler_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLine((Component)((Object)this), this.tblSaler);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        CustomerSaleInfoInfo saleInfo = new CustomerSaleInfoInfo();
        saleInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        saleInfo.setCreateTime(TimeStampUtility.getTime());
        saleInfo.setDeliverPriority(0);
        saleInfo.setIsFreezeDelivery(false);
        saleInfo.setIsFreezeOrder(false);
        saleInfo.setMonthBancanceDay(0);
        saleInfo.setMonthBancanceMonth(0);
        saleInfo.setCashKind(PaymentItemTypeEnum.DEFAULTTYPE);
        return saleInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CustomerSaleInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        this.isSuppressF7Event = true;
        this.customerInfo = (CustomerInfo)this.getUIContext().get("customer");
        this.initInterface();
        super.loadFields();
        if (this.editData.getId() == null && !this.getOprtState().equals(OprtState.VIEW)) {
            this.initDefaultData();
        }
        if (this.editData != null && this.editData.getSaleOrgUnit() != null) {
            this.prmtSaleOrgUnit.setData((Object)this.editData.getSaleOrgUnit());
            this.txtSaleOrgName.setText(this.editData.getSaleOrgUnit().getName());
        }
        if (this.editData.getCashKind() != null) {
            this.editData.setCashKind(PaymentItemTypeEnum.getEnum(this.editData.getCashKind().getValue()));
        } else {
            this.editData.setCashKind(PaymentItemTypeEnum.DEFAULTTYPE);
        }
        this.initOldData((IObjectValue)this.editData);
        this.initSale();
        this.isSuppressF7Event = false;
        this.updateButtonStatus();
    }

    private void initSale() {
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentSaleUnit() != null && SysContext.getSysContext().getCurrentSaleUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.saleOrg = SysContext.getSysContext().getCurrentSaleUnit();
        } else if (curCtrlUnitInfo.isIsSaleOrgUnit()) {
            this.saleOrg = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    private void initDefaultData() {
        String saleID = null;
        if (this.editData.getSaleOrgUnit() == null) {
            this.prmtSaleOrgUnit.setData((Object)this.saleOrg);
            if (this.saleOrg != null) {
                this.txtSaleOrgName.setText(this.saleOrg.getName());
            }
            this.editData.setSaleOrgUnit(this.saleOrg);
        } else {
            this.prmtSaleOrgUnit.setData((Object)this.editData.getSaleOrgUnit());
            this.txtSaleOrgName.setText(this.editData.getSaleOrgUnit().getName());
        }
        if (this.prmtSaleOrgUnit.getData() != null) {
            saleID = ((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData()).getId().toString();
        }
        if (this.editData.getBillingOrgUnit() == null) {
            this.editData.setBillingOrgUnit(this.customerInfo);
        }
        if (this.editData.getDeliverOrgUnit() == null) {
            this.editData.setDeliverOrgUnit(this.customerInfo);
        }
        if (this.editData.getSettlementOrgUnit() == null) {
            this.editData.setSettlementOrgUnit(this.customerInfo);
        }
        this.prmtBillingOrgUnit.setData((Object)this.editData.getBillingOrgUnit());
        this.prmtDeliverOrgUnit.setData((Object)this.editData.getDeliverOrgUnit());
        this.prmtSettlementOrgUnit.setData((Object)this.editData.getSettlementOrgUnit());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initDefaultOrgUnit(this.curCtrlUnitInfo);
        super.onLoad();
        this.prmtDeliverOrgUnit.setCommitFormat("$number$;$name$;$mnemonicCode$");
        this.prmtSettlementOrgUnit.setCommitFormat("$number$;$name$;$mnemonicCode$");
        this.prmtBillingOrgUnit.setCommitFormat("$number$;$name$;$mnemonicCode$");
        if (this.hasCustomer_ManaPermission == null) {
            this.hasCustomer_ManaPermission = CSUntil.hasCustomer_ManaPermission(null);
        }
        if (!this.hasCustomer_ManaPermission.booleanValue() && this.editData.getCreator() != null && this.editData.getCreator().getId() != null && this.editData.getCreator().getId().equals((Object)SysContext.getSysContext().getCurrentUserInfo().getId())) {
            this.tblSaler.getStyleAttributes().setLocked(true);
            this.actionAddRowSaler.setEnabled(false);
            this.actionDelSaler.setEnabled(false);
            this.btnDeleteSalerRow.setEnabled(false);
            this.btnAddSalerRow.setEnabled(false);
        }
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(true);
        this.prmtSaleOrgUnit.setEnabled(true);
        this.prmtSaleOrgUnit.setAccessAuthority(0);
        this.setF7Context();
        String format = CtrlFormatUtilities.getDateFormatString();
        this.txtCreateTimeSales.setDatePattern(format);
        this.txtChangeTimeSale.setDatePattern(format);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    private void initInterface() {
        this.setCurrentToolBar();
        this.setupWorkButton();
        this.initF7Control();
        this.setSaleLinkManTable();
        this.setSalerTable();
    }

    private void setCurrentToolBar() {
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.menuView.setVisible(false);
        this.txtSaleOrgName.setEnabled(true);
        this.txtSaleOrgName.setEditable(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.chkCustomerIsFreezeDelivery.setEnabled(false);
            this.chkCustomerIsFreezeOrder.setEnabled(false);
        }
        if (!this.getOprtState().equals(OprtState.VIEW) && this.editData.getId() != null) {
            this.btnRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
        }
        this.menuItemCustomerTradeRpt.setEnabled(true);
    }

    private void setupWorkButton() {
        if (this.btnAddAddressRow == null) {
            this.btnAddAddressRow = new KDWorkButton();
            this.actionAddRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddAddressRow = (KDWorkButton)this.grpCustomerDeliveryAddresses.add((Action)((Object)this.actionAddRow));
            this.btnAddAddressRow.setText(null);
            this.btnAddAddressRow.setSize(new Dimension(22, 19));
            this.btnAddAddressRow.setEnabled(true);
        }
        if (this.btnDeleteAddressRow == null) {
            this.btnDeleteAddressRow = new KDWorkButton();
            this.actionDeleteRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteAddressRow = (KDWorkButton)this.grpCustomerDeliveryAddresses.add((Action)((Object)this.actionDeleteRow));
            this.btnDeleteAddressRow.setText(null);
            this.btnDeleteAddressRow.setSize(new Dimension(22, 19));
            this.btnDeleteAddressRow.setEnabled(true);
        }
        if (this.btnAddLinkRow == null) {
            this.btnAddLinkRow = new KDWorkButton();
            this.actionAddRowLinkMan.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddLinkRow = (KDWorkButton)this.grpLinker.add((Action)((Object)this.actionAddRowLinkMan));
            this.btnAddLinkRow.setText(null);
            this.btnAddLinkRow.setSize(new Dimension(22, 19));
            this.btnAddLinkRow.setEnabled(true);
        }
        if (this.btnDeleteLinkRow == null) {
            this.btnDeleteLinkRow = new KDWorkButton();
            this.actionDelLinkMan.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteLinkRow = (KDWorkButton)this.grpLinker.add((Action)((Object)this.actionDelLinkMan));
            this.btnDeleteLinkRow.setText(null);
            this.btnDeleteLinkRow.setSize(new Dimension(22, 19));
            this.btnDeleteLinkRow.setEnabled(true);
        }
        if (this.btnAddSalerRow == null) {
            this.btnAddSalerRow = new KDWorkButton();
            this.actionAddRowSaler.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddSalerRow = (KDWorkButton)this.grpSaler.add((Action)((Object)this.actionAddRowSaler));
            this.btnAddSalerRow.setText(null);
            this.btnAddSalerRow.setSize(new Dimension(22, 19));
            this.btnAddSalerRow.setEnabled(true);
        }
        if (this.btnDeleteSalerRow == null) {
            this.btnDeleteSalerRow = new KDWorkButton();
            this.actionDelSaler.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteSalerRow = (KDWorkButton)this.grpSaler.add((Action)((Object)this.actionDelSaler));
            this.btnDeleteSalerRow.setText(null);
            this.btnDeleteSalerRow.setSize(new Dimension(22, 19));
            this.btnDeleteSalerRow.setEnabled(true);
        }
        this.ftxtTransAdvDay.setDataType(1);
        this.ftxtTransAdvDay.setHorizontalAlignment(4);
    }

    private void initF7Control() {
        NewSaleF7 f7SaleOrg = new NewSaleF7((IUIObject)this);
        f7SaleOrg.setMultiSelect(false);
        f7SaleOrg.setIsCUFilter(true);
        f7SaleOrg.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        this.prmtSaleOrgUnit.setSelector((KDPromptSelector)f7SaleOrg);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)f7SaleOrg);
        this.prmtSaleOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.prmtSaleOrgUnit.addChangeListener((ChangeListener)new F7ChangeEventHandler());
        this.prmtSaleOrgUnit.setDisplayFormat("$number$");
        this.prmtSaleOrgUnit.setCommitFormat("$number$");
        this.prmtSaleOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtSaleOrgUnit.setHandleCUFilter(false);
        this.prmtBillingOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtDeliverOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtSettlementOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cashDiscType", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("cashDiscType", (Object)"2"));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filterInfo.setMaskString("(#0 or #1) and (#2 or #3 or #4) ");
        viewInfo.setFilter(filterInfo);
        this.prmtCashDiscount.setEntityViewInfo(viewInfo);
        this.tblDeliveryAddresses.checkParsed();
        KDBizPromptBox f7Address = new KDBizPromptBox();
        if (this.getF7DisPlayMode() == 0) {
            AddressPromptBox addrF7Dlg = new AddressPromptBox((IUIObject)this);
            f7Address.setSelector((KDPromptSelector)addrF7Dlg);
        }
        f7Address.setHistoryRecordEnabled(false);
        f7Address.setMyCommonUseEnabled(false);
        f7Address.setEditorLength(500);
        f7Address.setEditable(true);
        f7Address.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AddressQuery");
        f7Address.setDisplayFormat("$name$");
        f7Address.setEditFormat("$name$");
        f7Address.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        KDTDefaultCellEditor f7AddrEditor = new KDTDefaultCellEditor((IKDEditor)f7Address);
        this.tblDeliveryAddresses.getColumn(TB_ADDRESS).setEditor((ICellEditor)f7AddrEditor);
        this.tblDeliveryAddresses.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    CustomerSaleUI.this.kdtAddressEntrys_Changed(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    CustomerSaleUI.this.handUIException(exc);
                }
            }
        });
        this.tblSaler.checkParsed();
        KDBizPromptBox f7Saler = new KDBizPromptBox();
        f7Saler.setEditable(true);
        f7Saler.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        f7Saler.setDisplayFormat("$number$");
        f7Saler.setEditFormat("$number$");
        f7Saler.setCommitFormat("$number$");
        f7Saler.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.tblSaler.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    CustomerSaleUI.this.kdtSalerEntrys_Changed(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    CustomerSaleUI.this.handUIException(exc);
                }
            }
        });
        KDTDefaultCellEditor f7SalerEditor = new KDTDefaultCellEditor((IKDEditor)f7Saler);
        this.tblSaler.getColumn(0).setEditor((ICellEditor)f7SalerEditor);
        ObjectValueRender tblSaler_person_OVR = new ObjectValueRender();
        tblSaler_person_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblSaler.getColumn("number").setRenderer((IBasicRender)tblSaler_person_OVR);
    }

    private int getF7DisPlayMode() {
        if (this.f7DisplayMode != -1) {
            return this.f7DisplayMode;
        }
        this.f7DisplayMode = CSSPUtils.getF7DisplayMode(this.curCtrlUnitInfo.getId().toString());
        return this.f7DisplayMode;
    }

    protected void kdtAddressEntrys_Changed(int rowIndex, int colIndex) {
        if (this.tblDeliveryAddresses.getCell(rowIndex, colIndex).getValue() instanceof AddressInfo) {
            this.tblDeliveryAddresses.getCell(rowIndex, colIndex).setValue((Object)((AddressInfo)this.tblDeliveryAddresses.getCell(rowIndex, colIndex).getValue()).getName());
        }
    }

    protected void kdtSalerEntrys_Changed(int rowIndex, int colIndex) {
        String TB_NUMBER = "number";
        String fieldName = this.tblSaler.getColumnKey(colIndex);
        if (TB_NUMBER.equalsIgnoreCase(fieldName)) {
            if (this.tblSaler.getCell(rowIndex, "number").getValue() != null && this.tblSaler.getCell(rowIndex, "number").getValue() instanceof PersonInfo) {
                PersonInfo personInfo = (PersonInfo)this.tblSaler.getRow(rowIndex).getCell(colIndex).getValue();
                this.tblSaler.getCell(rowIndex, "name").setValue((Object)personInfo.getName());
            } else {
                this.tblSaler.getCell(rowIndex, "name").setValue(null);
            }
        }
    }

    private void setSalerTable() {
    }

    private void setSaleLinkManTable() {
        String[] linkManBaseInfoTab = new String[]{"linkPerson", "duty", TB_OFFICEPHONE, "cell", TB_FAX};
        String[] emailTab = new String[]{TB_EMAIL};
        String[] zipCodeTab = new String[]{"zipCode"};
        String[] addressTab = new String[]{TB_ADDRESS};
        KDTextField txtForBaseInfoField = new KDTextField();
        txtForBaseInfoField.setMaxLength(40);
        KDTDefaultCellEditor kdtBaseInfoCellEditor = new KDTDefaultCellEditor((JTextField)txtForBaseInfoField);
        this.tblLinker.checkParsed();
        for (int i = 0; i < linkManBaseInfoTab.length; ++i) {
            this.tblLinker.getColumn(linkManBaseInfoTab[i]).setEditor((ICellEditor)kdtBaseInfoCellEditor);
        }
        KDTextField txtForEmailField = new KDTextField();
        txtForEmailField.setMaxLength(80);
        KDTDefaultCellEditor kdtEmailCellEditor = new KDTDefaultCellEditor((JTextField)txtForEmailField);
        for (int i = 0; i < emailTab.length; ++i) {
            this.tblLinker.getColumn(emailTab[i]).setEditor((ICellEditor)kdtEmailCellEditor);
        }
        KDTextField txtForZipCodeField = new KDTextField();
        txtForZipCodeField.setMaxLength(10);
        KDTDefaultCellEditor kdtZipCodeCellEditor = new KDTDefaultCellEditor((JTextField)txtForZipCodeField);
        for (int i = 0; i < zipCodeTab.length; ++i) {
            this.tblLinker.getColumn(zipCodeTab[i]).setEditor((ICellEditor)kdtZipCodeCellEditor);
        }
        KDTextField txtForAddressField = new KDTextField();
        txtForAddressField.setMaxLength(100);
        KDTDefaultCellEditor kdtAddressCellEditor = new KDTDefaultCellEditor((JTextField)txtForAddressField);
        for (int i = 0; i < addressTab.length; ++i) {
            this.tblLinker.getColumn(addressTab[i]).setEditor((ICellEditor)kdtAddressCellEditor);
        }
    }

    private CustomerEditUI getParentUI() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof CustomerEditUI); c = c.getParent()) {
        }
        return (CustomerEditUI)((Object)c);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.addCloseButton(this.toolBar);
    }

    private void addCloseButton(KDToolBar toolBar) {
        JToolBar.Separator endSeparator = null;
        KDWorkButton btnCloseTab = null;
        endSeparator = new JToolBar.Separator();
        btnCloseTab = new KDWorkButton();
        endSeparator.setOrientation(1);
        btnCloseTab.setIcon(UIFrameResource.getCommonIcon((String)"imgTbtn_quit"));
        btnCloseTab.setText(UIFrameResource.getString((String)"close"));
        btnCloseTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CustomerSaleUI.this.actionExitCurrent_actionPerformed(null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        toolBar.add((Component)endSeparator);
        toolBar.add((Component)btnCloseTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _stateChanged(KDBizPromptBox f7) {
        if (f7.getData() != null) {
            SaleOrgUnitInfo orgUnitInfo = (SaleOrgUnitInfo)f7.getData();
            try {
                CustomerSaleInfoInfo info = this.getSaleInfoByOrg((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()));
                info.setSaleOrgUnit(orgUnitInfo);
                this.editData = info;
                this.setDataObject((IObjectValue)info);
                CtrlUnitInfo cu = PerminsionUtil.getCuByOuId((String)orgUnitInfo.getId().toString());
                if (cu != null) {
                    this.initUIMainOrgContext(cu.getId().toString());
                }
                this.setF7Context();
                this.loadFields();
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    ExceptionHandler.handle((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"loadCustomerSaleInfoFailed") + e.getMessage()), (Throwable)e);
                }
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"loadCustomerSaleInfoFailed"), (Throwable)e);
            }
            finally {
                this.txtSaleOrgName.setText(((SaleOrgUnitInfo)f7.getData()).getName());
                if (this.editData == null || this.editData.getId() == null) {
                    this.initDefaultData();
                    this.initOldData((IObjectValue)this.editData);
                }
            }
        } else {
            this.txtSaleOrgName.setText("");
        }
    }

    private void setF7Context() {
        this.prmtchannelType.setF7Context(this.getMainOrgContext());
        this.prmtBillingOrgUnit.setF7Context(this.getMainOrgContext());
        this.prmtDeliverOrgUnit.setF7Context(this.getMainOrgContext());
        this.prmtSettlementOrgUnit.setF7Context(this.getMainOrgContext());
    }

    protected CustomerSaleInfoInfo getSaleInfoByOrg(IObjectPK saleOrgPk) throws Exception {
        CustomerSaleInfoInfo vo = null;
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        vo = iCustomer.getCustomerSaleInfo((IObjectPK)new ObjectUuidPK(this.customerInfo.getId()), saleOrgPk, this.getMergedSelector());
        if (vo == null) {
            vo = (CustomerSaleInfoInfo)this.createNewData();
        }
        return vo;
    }

    protected CustomerSaleInfoInfo getSaleInfo(IObjectPK saleOrgPk) throws Exception {
        CustomerSaleInfoInfo vo = null;
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        vo = iCustomer.getCustomerSaleInfo(saleOrgPk, this.getMergedSelector());
        if (vo == null) {
            vo = (CustomerSaleInfoInfo)this.createNewData();
        }
        return vo;
    }

    protected CustomerSaleInfoInfo getSaleInfoByNumber(String number) throws Exception {
        CustomerSaleInfoInfo vo = null;
        if (number != null) {
            vo = ((ICustomer)this.getBizInterface()).getCustomerSaleInfo(this.customerInfo.getNumber(), number);
        }
        return vo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("billingOrgUnit.number"));
        sic.add(new SelectorItemInfo("billingOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.number"));
        sic.add(new SelectorItemInfo("settlementOrgUnit.name"));
        sic.add(new SelectorItemInfo("settlementOrgUnit.number"));
        sic.add(new SelectorItemInfo("cashDiscount.entries.description"));
        sic.add(new SelectorItemInfo("customer.usedStatus"));
        return sic;
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection sic = super.getMergedSelector();
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("billingOrgUnit.number"));
        sic.add(new SelectorItemInfo("billingOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.number"));
        sic.add(new SelectorItemInfo("settlementOrgUnit.name"));
        sic.add(new SelectorItemInfo("settlementOrgUnit.number"));
        sic.add(new SelectorItemInfo("cashDiscount.entries.description"));
        sic.add(new SelectorItemInfo("customer.usedStatus"));
        return sic;
    }

    public boolean isModify() {
        return super.isModify();
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ((CustomerSaleInfoInfo)newData).setSaleOrgUnit(null);
        ((CustomerSaleInfoInfo)newData).setConsignFreezeOrgUnit(null);
        ((CustomerSaleInfoInfo)newData).setOrderFreezeOrgUnit(null);
        ((CustomerSaleInfoInfo)newData).setCreator(SysContext.getSysContext().getCurrentUserInfo());
        ((CustomerSaleInfoInfo)newData).setCreateTime(TimeStampUtility.getTime());
        ((CustomerSaleInfoInfo)newData).setLastUpdateUser(null);
        ((CustomerSaleInfoInfo)newData).setLastUpdateTime(null);
        ((CustomerSaleInfoInfo)newData).setCU(this.curCtrlUnitInfo);
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setSaleOrgUnit((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData());
        this.editData.setCustomer(this.customerInfo);
        if (this.editData.getCU() == null) {
            this.editData.setCU(this.curCtrlUnitInfo);
        }
        if (this.editData.getCustomer() == null) {
            this.editData.setCustomer(this.customerInfo);
        }
        IObjectPK pk = null;
        if (this.editData.getId() == null) {
            pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        } else {
            pk = new ObjectUuidPK(this.editData.getId());
            this.getBizInterface().update(pk, (CoreBaseInfo)this.editData);
        }
        this.setDataObject(this.getValue(pk));
        this.initOldData((IObjectValue)this.editData);
        return pk;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.necessaryFieldsVerify();
        if (((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData()).isIsSealUp()) {
            OUException ouException = new OUException(OUException.CANT_ADDNEW_FOR_SEALED_SALE);
            MsgBox.showInfo((String)ouException.getMessage());
            SysUtil.abort();
        }
    }

    public void necessaryFieldsVerify() {
        if (this.prmtBillingOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"billingOrgUnitNotNull"));
            SysUtil.abort();
        }
        if (this.prmtSettlementOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"settlementOrgUnitNotNull"));
            SysUtil.abort();
        }
        if (this.prmtDeliverOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"deliverOrgUnitNotNull"));
            SysUtil.abort();
        }
        if (this.prmtSaleOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSCompanyOUNotExist"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCustomerTradeRpt_actionPerformed(ActionEvent e) throws Exception {
        CustomerInfo customerNumber = null;
        CompanyOrgUnitCollection companyOrgUnitInfos = null;
        if (this.customerInfo == null) {
            return;
        }
        customerNumber = this.customerInfo;
        if (this.prmtSaleOrgUnit.getData() != null && this.prmtSaleOrgUnit.getData() instanceof SaleOrgUnitInfo) {
            SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData();
            OrgUnitCollection collection = OrgRelationUtils.getOrgsByRelation((OrgType)OrgType.Sale, (OrgType)OrgType.Company, (BOSUuid)saleOrgUnitInfo.getId());
            companyOrgUnitInfos = new CompanyOrgUnitCollection();
            for (int i = 0; i < collection.size(); ++i) {
                if (!(collection.get(i) instanceof CompanyOrgUnitInfo)) continue;
                companyOrgUnitInfos.add((CompanyOrgUnitInfo)collection.get(i));
            }
            if (companyOrgUnitInfos == null || companyOrgUnitInfos.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"saleOrg_not_Devolve"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"TRADERPT_ORG_NULL"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        ShowTradeInfoUtil.showCustomerTradeUI(uiContext, customerNumber.getNumber(), companyOrgUnitInfos);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "Customersaleinfo_AddNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "Customersaleinfo_Update";
        }
        return "Customersaleinfo_View";
    }

    protected void updateButtonStatus() {
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        if (this.editData != null && this.editData.getId() != null) {
            if (this.editData.getUsingStatus() == UsingStatusEnum.FREEZED) {
                this.btnCancel.setVisible(false);
                this.btnCancelCancel.setVisible(true);
            } else {
                this.btnCancel.setVisible(true);
                this.btnCancelCancel.setVisible(false);
            }
        } else {
            this.btnCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
        }
    }

    private void checkAsst() throws Exception {
        this.checkLinker();
        this.checkDeliveryAddresses();
        this.checkSaler();
    }

    private void checkLinker() throws Exception {
        boolean hasValue = true;
        String[] STRING_OBJS = new String[]{"linkPerson", "duty", TB_OFFICEPHONE, "cell", TB_FAX, TB_EMAIL, "zipCode", TB_ADDRESS};
        int c = this.tblLinker.getRowCount();
        for (int i = 0; i < c; ++i) {
            hasValue = true;
            IRow row = this.tblLinker.getRow(i);
            for (int j = 0; j < STRING_OBJS.length; ++j) {
                String value = (String)row.getCell(STRING_OBJS[j]).getValue();
                if (value == null || value.trim().length() <= 0) continue;
                hasValue = false;
                break;
            }
            if (!hasValue) continue;
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_LINKER);
        }
    }

    private void checkDeliveryAddresses() throws Exception {
        boolean hasValue = true;
        String[] STRING_OBJS = new String[]{TB_ADDRESS};
        int c = this.tblDeliveryAddresses.getRowCount();
        for (int i = 0; i < c; ++i) {
            hasValue = true;
            IRow row = this.tblDeliveryAddresses.getRow(i);
            for (int j = 0; j < STRING_OBJS.length; ++j) {
                String value = (String)row.getCell(STRING_OBJS[j]).getValue();
                if (value == null || value.trim().length() <= 0) continue;
                hasValue = false;
                break;
            }
            if (!hasValue) continue;
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ADDRESSES);
        }
    }

    private void checkSaler() throws Exception {
        boolean hasValue = true;
        String[] STRING_OBJS = new String[]{"number"};
        int c = this.tblSaler.getRowCount();
        for (int i = 0; i < c; ++i) {
            hasValue = true;
            IRow row = this.tblSaler.getRow(i);
            for (int j = 0; j < STRING_OBJS.length; ++j) {
                PersonInfo value = (PersonInfo)row.getCell(STRING_OBJS[j]).getValue();
                if (value == null || value.getId() == null || value.getId().toString().length() <= 0) continue;
                hasValue = false;
                break;
            }
            if (!hasValue) continue;
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_SALER);
        }
    }

    public void setSaved(boolean flag) {
        super.setSaved(flag);
        this.getParentUI().setSaved(true);
    }

    public void unLockUI() {
        super.unLockUI();
    }

    class F7ChangeEventHandler
    implements ChangeListener {
        F7ChangeEventHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDBizPromptBox f7 = (KDBizPromptBox)e.getSource();
            if (!CustomerSaleUI.this.isSuppressF7Event) {
                CustomerSaleUI.this._stateChanged(f7);
            }
        }
    }
}

