/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerTaxFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerTaxInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractCustomerTaxUI;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.CustomerEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

public class CustomerTaxUI
extends AbstractCustomerTaxUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerTaxUI.class);
    private boolean isSuppressF7Event = false;
    private KDWorkButton btnAddTaxRow;
    private KDWorkButton btnDeleteTaxRow;

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.checkFieldIsCorrect();
    }

    public void necessaryFieldsVerify() {
        try {
            this.checkFieldIsCorrect();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void checkFieldIsCorrect() throws BOSException {
        int count = 0;
        HashSet<String> compantTFNSet = new HashSet<String>();
        for (int index = 0; index < this.tblTax.getRowCount(); ++index) {
            ICell defaultBillToCompanyCell;
            boolean defaultBillToCompany;
            ICell taxpayerTypeCell;
            Object taxpayerType;
            ICell billToCompanyNameCell = this.tblTax.getCell(index, "billToCompanyName");
            Object billToCompanyName = billToCompanyNameCell.getValue();
            if (billToCompanyName == null || "".equals(billToCompanyName.toString().trim())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"BillToCompanyNotNull"));
                this.tblTax.getSelectManager().select(index, this.tblTax.getColumnIndex("billToCompanyName"));
                SysUtil.abort();
            }
            if ((taxpayerType = (taxpayerTypeCell = this.tblTax.getCell(index, "taxpayerType")).getValue()) == null || "".equals(taxpayerType.toString().trim())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"TaxPayerTypeNotNull"));
                this.tblTax.getSelectManager().select(index, this.tblTax.getColumnIndex("taxpayerType"));
                SysUtil.abort();
            }
            ICell payInvoiceTypeCell = this.tblTax.getCell(index, "payInvoiceType");
            ICell compantTFNCell = this.tblTax.getCell(index, "compantTFN");
            Object payInvoiceType = payInvoiceTypeCell.getValue();
            Object compantTFN = compantTFNCell.getValue();
            if (payInvoiceType == null || "".equals(payInvoiceType.toString().trim())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"PayInvoiceTypeNotNull"));
                this.tblTax.getSelectManager().select(index, this.tblTax.getColumnIndex("payInvoiceType"));
                SysUtil.abort();
            } else if ("\u4e13\u7528\u53d1\u7968".equals(payInvoiceType.toString()) && compantTFN == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"PayInvoiceTypeWithoutCompantTFN"));
                this.tblTax.getSelectManager().select(index, this.tblTax.getColumnIndex("compantTFN"));
                SysUtil.abort();
            }
            if (compantTFN != null) {
                Pattern pattern = Pattern.compile("[0-9a-zA-Z]+");
                String compantTFNStr = compantTFN.toString();
                if (compantTFNSet.contains(compantTFNStr)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CompantTFNRepeat"));
                    this.tblTax.getSelectManager().select(index, this.tblTax.getColumnIndex("compantTFN"));
                    SysUtil.abort();
                } else {
                    compantTFNSet.add(compantTFNStr);
                }
            }
            if (!(defaultBillToCompany = ((Boolean)(defaultBillToCompanyCell = this.tblTax.getCell(index, "defaultBillToCompany")).getValue()).booleanValue())) continue;
            ++count;
        }
        if (this.tblTax.getRowCount() > 0) {
            CoreBaseCollection coll;
            if (count > 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"DefaultBillToCompanyRepeat"));
                this.tblTax.getSelectManager().select(0, this.tblTax.getColumnIndex("defaultBillToCompany"));
                SysUtil.abort();
            } else if (count == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"DefaultBillToCompanyNotSelected"));
                this.tblTax.getSelectManager().select(0, this.tblTax.getColumnIndex("defaultBillToCompany"));
                SysUtil.abort();
            }
            StringBuilder builder = new StringBuilder(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CompantTFNRepeat") + ":");
            boolean flag = false;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("compantTFN", compantTFNSet, CompareType.INCLUDE));
            if (this.editData.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            }
            if ((coll = CustomerTaxFactory.getRemoteInstance().getCollection(ev)).size() > 0) {
                flag = true;
                for (int i = 0; i < coll.size(); ++i) {
                    builder.append(((CustomerTaxInfo)coll.get(i)).getCompantTFN()).append(",");
                }
            }
            if (flag) {
                builder.deleteCharAt(builder.length() - 1);
                MsgBox.showInfo((String)builder.toString());
                SysUtil.abort();
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK pk = null;
        pk = super.runSubmit();
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        this.initOldData((IObjectValue)this.editData);
        return pk;
    }

    private CustomerEditUI getParentUI() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof CustomerEditUI); c = c.getParent()) {
        }
        return (CustomerEditUI)((Object)c);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
        this.getParentUI().setOprtState(OprtState.EDIT);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getParentUI().getUIWindow().close();
    }

    protected void showApproveSuccess(String message, String type) {
        this.getParentUI().showApproveSuccess(message, type);
    }

    @Override
    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CustomerFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        this.isSuppressF7Event = true;
        this.initInterface();
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.tblTax.checkParsed();
        super.onLoad();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.addCloseButton(this.toolBar);
    }

    private void addCloseButton(KDToolBar toolBar) {
        JToolBar.Separator endSeparator = null;
        KDWorkButton btnCloseTab = null;
        endSeparator = new JToolBar.Separator();
        btnCloseTab = new KDWorkButton();
        endSeparator.setOrientation(1);
        btnCloseTab.setIcon(UIFrameResource.getCommonIcon((String)"imgTbtn_quit"));
        btnCloseTab.setText(UIFrameResource.getString((String)"close"));
        btnCloseTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CustomerTaxUI.this.actionExitCurrent_actionPerformed(null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        toolBar.add((Component)endSeparator);
        toolBar.add((Component)btnCloseTab);
    }

    private void initInterface() {
        this.menuItemAddNew.setVisible(false);
        this.menuView.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        if (this.btnAddTaxRow == null) {
            this.btnAddTaxRow = new KDWorkButton();
            this.actionAddRowTax.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddTaxRow = (KDWorkButton)this.grpTax.add((Action)((Object)this.actionAddRowTax));
            this.btnAddTaxRow.setText(null);
            this.btnAddTaxRow.setSize(new Dimension(22, 19));
            this.btnAddTaxRow.setEnabled(true);
        }
        if (this.btnDeleteTaxRow == null) {
            this.btnDeleteTaxRow = new KDWorkButton();
            this.actionDeleteRowTax.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteTaxRow = (KDWorkButton)this.grpTax.add((Action)((Object)this.actionDeleteRowTax));
            this.btnDeleteTaxRow.setText(null);
            this.btnDeleteTaxRow.setSize(new Dimension(22, 19));
            this.btnDeleteTaxRow.setEnabled(true);
        }
        this.setTaxTable();
    }

    private void setTaxTable() {
        KDTextField txtForLen100 = new KDTextField();
        txtForLen100.setMaxLength(100);
        this.tblTax.getColumn("bankAccount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtForLen100));
        this.tblTax.getColumn("billToCompanyName").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtForLen100));
        KDTextField txtForLen20 = new KDTextField();
        txtForLen20.setMaxLength(20);
        this.tblTax.getColumn("telephone").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtForLen20));
        KDTextField txtForLen200 = new KDTextField();
        txtForLen200.setMaxLength(200);
        this.tblTax.getColumn("address").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtForLen200));
        if (this.getUIContext().get("customer") != null) {
            // empty if block
        }
    }

    @Override
    public void actionAddRowTax_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            IRow row = this.tblTax.addRow();
            if (this.tblTax.getRowCount() == 1) {
                row.getCell("defaultBillToCompany").setValue((Object)true);
            } else {
                row.getCell("defaultBillToCompany").setValue((Object)false);
            }
        }
    }

    @Override
    public void actionDeleteRowTax_actionPerformed(ActionEvent e) throws Exception {
        ICoreBase base = this.getBizInterface();
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLineWithCheckIsRefence(this, this.tblTax, base);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int i = this.editData.getUsedStatus().getValue();
        super.actionEdit_actionPerformed(e);
        CSClientUtils.setUITitle(this.getParentUI(), this.getOprtState(), EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"taxAttribute"));
        this.getParentUI().setOprtState(OprtState.EDIT);
    }

    protected void showSubmitSuccess() {
        this.getParentUI().showSubmitSuccess(this.getClassAlise());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected void checkCustomerTax(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblTax.getColumnIndex("payInvoiceType") && e.getValue().toString().trim().equals(PayInvoiceTypeEnum.VALUEADDEDTAXINV.toString())) {
            this.tblTax.getCell(rowIndex, colIndex + 1).getStyleAttributes().setBackground(new Color(252, 251, 223));
        } else if (colIndex != this.tblTax.getColumnIndex("defaultBillToCompany")) {
            this.tblTax.getCell(rowIndex, colIndex + 1).getStyleAttributes().setBackground(new Color(255, 255, 255, 0));
        }
    }

    @Override
    protected void tblValueChanged(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.tblTax.getColumnIndex("defaultBillToCompany")) {
            int index = e.getRowIndex();
            boolean flag = (Boolean)e.getOldValue();
            if (!flag) {
                for (int i = 0; i < this.tblTax.getRowCount(); ++i) {
                    if (index == i) continue;
                    this.tblTax.getCell(i, "defaultBillToCompany").setValue((Object)false);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"DefaultBillToCompanyNotSelected"));
                this.tblTax.getSelectManager().select(index, colIndex);
            }
        }
    }

    @Override
    protected void tblTaxValue_editStopping(KDTEditEvent e) throws Exception {
    }

    protected String getClassAlise() {
        return super.getClassAlise();
    }

    public void unLockUI() {
        super.unLockUI();
    }
}

