/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.DataMergeEntryInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeFactory;
import com.kingdee.eas.basedata.master.cssp.DataMergeInfo;
import com.kingdee.eas.basedata.master.cssp.DataMergeTypeEnum;
import com.kingdee.eas.basedata.master.cssp.IHeadDetailException;
import com.kingdee.eas.basedata.master.cssp.client.AbstractDataMergeUI;
import com.kingdee.eas.basedata.master.cssp.client.CUFilterProductor;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class DataMergeUI
extends AbstractDataMergeUI {
    private static final Logger logger = CoreUIObject.getLogger(DataMergeUI.class);
    protected static final String TB_DATA = "data";
    protected static final String TB_ISFREEZE = "isFreeze";
    protected KDBizPromptBox prmtSrcData;

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddLine.setEnabled(true);
        this.actionRemoveLine.setEnabled(true);
        this.actionMerge.setEnabled(true);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnMerge.setEnabled(false);
        this.btnMerge.setIcon(EASResource.getIcon((String)"imgTbtn_merge"));
    }

    public void onLoad() throws Exception {
        this.setUITitle(this.getResourceStr("merge2", new String[]{this.getDataTypeName()}));
        this.lbDestData.setBoundLabelText(this.getResourceStr("DestData2", new String[]{this.getDataTypeName()}));
        this.kdtEntries.checkParsed();
        this.kdtEntries.getHeadRow(0).getCell(0).setValue((Object)this.getResourceStr("srcData2", new String[]{this.getDataTypeName()}));
        super.onLoad();
        this.prmtDestData.setQueryInfo(this.getDataQueryInfo());
        this.prmtDestData.setCommitFormat("$number$;$name$");
        this.prmtDestData.setEditFormat("$number$");
        this.prmtDestData.setDisplayFormat("$number$ [$name$]");
        this.prmtDestData.setRequired(true);
        this.prmtDestData.setEntityViewInfo(this.getDataEntityView());
        CUFilterProductor curCUfilterProductor = new CUFilterProductor("CURRENT_CU");
        this.prmtDestData.setFilterInfoProducer((IFilterInfoProducer)curCUfilterProductor);
        this.prmtSrcData = new KDBizPromptBox();
        this.prmtSrcData.setQueryInfo(this.getDataQueryInfo());
        this.prmtSrcData.setCommitFormat("$number$;$name$");
        this.prmtSrcData.setEditFormat("$number$");
        this.prmtSrcData.setDisplayFormat("$number$ [$name$]");
        this.prmtSrcData.setRequired(true);
        this.prmtSrcData.setEntityViewInfo(this.getDataEntityView());
        CUFilterProductor curAndLowerCUfilterProductor = new CUFilterProductor("CUR_AND_LOWER_CU");
        this.prmtSrcData.setFilterInfoProducer((IFilterInfoProducer)curAndLowerCUfilterProductor);
        this.txtLog.setAutoscrolls(true);
        IColumn colData = this.kdtEntries.getColumn(TB_DATA);
        colData.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtSrcData));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$ [$name$]"));
        colData.setRenderer((IBasicRender)avr);
        colData.setRequired(true);
        this.kdtEntries.getColumn(TB_ISFREEZE).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionAddNew_actionPerformed(null);
        }
    }

    private String getResourceStr(String resourceKey, String[] params) {
        String s = EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)resourceKey);
        MessageFormat mf = new MessageFormat(s);
        return mf.format(params);
    }

    protected String getDataQueryInfo() {
        return null;
    }

    protected EntityViewInfo getDataEntityView() {
        return null;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillF7();
    }

    protected void fillF7() {
        if (this.editData != null && this.editData.getDestNumber() != null && this.editData.getDestName() != null) {
            DataBaseDInfo info = new DataBaseDInfo();
            info.setNumber(this.editData.getDestNumber());
            info.setName(this.editData.getDestName());
            this.prmtDestData.setValue((Object)info);
            int size = this.editData.getEntries().size();
            for (int i = 0; i < size; ++i) {
                DataMergeEntryInfo entryInfo = this.editData.getEntries().get(i);
                if (entryInfo == null || entryInfo.getSrcNumber() == null || entryInfo.getSrcName() == null) continue;
                DataBaseDInfo entryDataInfo = new DataBaseDInfo();
                entryDataInfo.setNumber(entryInfo.getSrcNumber());
                entryDataInfo.setName(entryInfo.getSrcName());
                this.kdtEntries.getRow(i).getCell(TB_DATA).setValue((Object)entryDataInfo);
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.prmtDestData.setValue(null);
        this.btnMerge.setEnabled(true);
        this.actionAddLine_actionPerformed(null);
    }

    public void checkModified() throws Exception {
    }

    @Override
    public void actionMerge_actionPerformed(ActionEvent e) throws Exception {
        super.actionMerge_actionPerformed(e);
        DataMergeInfo info = this.createDataMergeInfo();
        this.checkDataMergeInfo(info);
        String type = this.getDataType().getAlias();
        if (2 == MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"csspMatMergeConfirm", (Object[])new Object[]{type, type, type}))) {
            SysUtil.abort();
        }
        try {
            info = DataMergeFactory.getRemoteInstance().merge(info);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"mergeOK"), (String)info.getLogMsg(), (int)1);
        }
        catch (Exception ex) {
            if (ex instanceof IHeadDetailException) {
                IHeadDetailException hde = (IHeadDetailException)((Object)ex);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)hde.getHeadMsg(), (String)hde.getDetailMsg(), (int)hde.getMsgType());
                SysUtil.abort();
            }
            throw ex;
        }
        this.dpkMergeTime.setValue((Object)info.getMergeTime());
        this.txtLog.setText(info.getLogMsg());
        this.btnMerge.setEnabled(false);
        this.btnAddNew.setEnabled(true);
        this.setOprtState("VIEW");
        this.setSaved(true);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (!"ADDNEW".equals(this.getOprtState())) {
            return;
        }
        super.actionAddLine_actionPerformed(e);
        this.kdtEntries.addRow();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (!"ADDNEW".equals(this.getOprtState())) {
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        if (selectRows.length == 0) {
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            this.kdtEntries.removeRow(selectRows[0]);
        }
    }

    protected void checkDataMergeInfo(DataMergeInfo info) throws Exception {
        if (info.getDestId() == null) {
            throw new CustomerSupplierException(CustomerSupplierException.DESTDATAISNULL, new Object[]{this.getDataTypeName()});
        }
        int size = info.getEntries().size();
        if (size < 1) {
            throw new CustomerSupplierException(CustomerSupplierException.SRCDATAISNULL, new Object[]{this.getDataTypeName(), new Integer(1)});
        }
        for (int i = 0; i < size; ++i) {
            DataMergeEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getSrcId() == null) {
                throw new CustomerSupplierException(CustomerSupplierException.SRCDATAISNULL, new Object[]{this.getDataTypeName(), new Integer(i + 1)});
            }
            if (entryInfo.getSrcId().equals(info.getDestId())) {
                throw new CustomerSupplierException(CustomerSupplierException.SRCDESTDATADUP, new Object[]{this.getDataTypeName(), new Integer(i + 1)});
            }
            for (int j = i + 1; j < size; ++j) {
                DataMergeEntryInfo aotherEntryInfo = info.getEntries().get(j);
                if (aotherEntryInfo.getSrcId() == null || !aotherEntryInfo.getSrcId().equals(entryInfo.getSrcId())) continue;
                throw new CustomerSupplierException(CustomerSupplierException.SRCDATADUP, new Object[]{this.getDataTypeName(), new Integer(i + 1), new Integer(j + 1)});
            }
        }
    }

    protected DataMergeInfo createDataMergeInfo() {
        Object o;
        if (this.editData == null) {
            this.editData = new DataMergeInfo();
        }
        if ((o = this.prmtDestData.getData()) != null && o instanceof DataBaseInfo) {
            DataBaseInfo dataBaseInfo = (DataBaseInfo)o;
            this.editData.setDestDataInfo(dataBaseInfo);
            this.editData.setDestId(dataBaseInfo.getId().toString());
            this.editData.setDestNumber(dataBaseInfo.getNumber());
            this.editData.setDestName(dataBaseInfo.getName());
        }
        this.editData.setReason(this.txtReason.getText());
        this.editData.getEntries().clear();
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object isFreeze;
            Object value = this.kdtEntries.getRow(i).getCell(TB_DATA).getValue();
            DataMergeEntryInfo entryInfo = new DataMergeEntryInfo();
            if (value != null && value instanceof DataBaseInfo) {
                DataBaseInfo dataBaseInfo = (DataBaseInfo)value;
                entryInfo.setSrcDataInfo(dataBaseInfo);
                entryInfo.setSrcId(dataBaseInfo.getId().toString());
                entryInfo.setSrcNumber(dataBaseInfo.getNumber());
                entryInfo.setSrcName(dataBaseInfo.getName());
            }
            if ((isFreeze = this.kdtEntries.getRow(i).getCell(TB_ISFREEZE).getValue()) != null && isFreeze instanceof Boolean) {
                entryInfo.setIsFreeze((Boolean)isFreeze);
            }
            this.editData.getEntries().add(entryInfo);
        }
        this.editData.setDataType(this.getDataType());
        return this.editData;
    }

    protected DataMergeTypeEnum getDataType() {
        return null;
    }

    protected String getDataTypeName() {
        if (this.getDataType() != null) {
            return this.getDataType().getAlias();
        }
        return "";
    }

    protected String getListUIName() {
        return null;
    }

    protected IObjectValue createNewData() {
        return new DataMergeInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataMergeFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }
}

