/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.master.cssp.CSSPGroup;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.client.AbstractSupplierGroupListUI;
import com.kingdee.eas.basedata.master.cssp.client.SupplierGroupEditUI;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.client.FilterUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ISupportObjContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class SupplierGroupListUI
extends AbstractSupplierGroupListUI
implements ISupportObjContext {
    private static final Logger logger = CoreUIObject.getLogger(SupplierGroupListUI.class);
    private CtrlUnitInfo curCtrlUnitInfo;

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplierGroup"));
        Icon forbidBG = EASResource.getIcon((String)"imgTbtn_forbid");
        this.btnCancel.setIcon(forbidBG);
        this.btnCancel.setEnabled(true);
        Icon unForbidBG = EASResource.getIcon((String)"imgTbtn_staruse");
        this.btnCancelCancel.setIcon(unForbidBG);
        this.btnCancelCancel.setEnabled(true);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    SupplierGroupListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    SupplierGroupListUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return SupplierGroupEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"CurrentCtrlUnit", (Object)this.curCtrlUnitInfo);
        super.prepareUIContext(uiContext, e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CSSPGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Suppliergroup_AddNew");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Suppliergroup_Update");
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion((String)this.curCtrlUnitInfo.getId().toString(), (String)userId, (String)"Suppliergroup_Delete");
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardType(new CSSPGroup().getType());
        ICSSPGroup iGroup = (ICSSPGroup)this.getBizInterface();
        super.checkSelected();
        String pkid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        CSSPGroupInfo counteryInfo = iGroup.getCSSPGroupInfo((IObjectPK)pk);
        if (!counteryInfo.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (counteryInfo.getDeletedStatus() == DeletedStatusEnum.NORMAL) {
            iGroup.cancel((IObjectPK)pk, (CoreBaseInfo)counteryInfo);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_Forbid _OK"));
        }
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardType(new CSSPGroup().getType());
        ICSSPGroup iGroup = (ICSSPGroup)this.getBizInterface();
        super.checkSelected();
        String pkid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(pkid);
        CSSPGroupInfo counteryInfo = iGroup.getCSSPGroupInfo((IObjectPK)pk);
        if (!counteryInfo.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
        if (counteryInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            iGroup.cancelCancel((IObjectPK)pk, (CoreBaseInfo)counteryInfo);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_Startup_OK"));
        }
        this.refreshList();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return FilterUtil.getS4Filter((CtrlUnitInfo)this.curCtrlUnitInfo);
    }

    public Context getMainContext() {
        return this.getMainOrgContext();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e.getSelectBlock().getBeginRow() == e.getSelectBlock().getEndRow()) {
            if (e.getSelectBlock().getTable().getCell(e.getSelectBlock().getBeginRow(), "id") == null) {
                return;
            }
            String csGroupid = (String)e.getSelectBlock().getTable().getCell(e.getSelectBlock().getBeginRow(), "id").getValue();
            ICSSPGroup icsspGroup = CSSPGroupFactory.getRemoteInstance();
            CSSPGroupInfo csspGroup = icsspGroup.getCSSPGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)csGroupid)));
            if (csspGroup != null) {
                DeletedStatusEnum deletedStatus = csspGroup.getDeletedStatus();
                if (deletedStatus == DeletedStatusEnum.DELETED) {
                    this.btnCancel.setEnabled(false);
                    this.btnCancelCancel.setEnabled(true);
                } else {
                    this.btnCancel.setEnabled(true);
                    this.btnCancelCancel.setEnabled(false);
                }
            }
        } else {
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(true);
        }
    }
}

