/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.master.cssp.AutoAssignSolutionFactory;
import com.kingdee.eas.basedata.master.cssp.util.CommonFilterUtil;
import com.kingdee.eas.basedata.master.cssp.util.RowObject;
import com.kingdee.eas.basedata.master.util.CsspMaterialUtils;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoAssignSolutionUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.cssp.util.AutoAssignSolutionUtil");

    public static Set getVisibleOrgIDs(Context ctx, BOSObjectType objectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        CtrlUnitInfo cui = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK, sic);
        String longNumber = cui.getLongNumber();
        int level = cui.getLevel();
        StringBuffer sql = new StringBuffer(500);
        sql.append("select cu.FID,cu.FLevel,cu.FParentID from T_ORG_CtrlUnit cu inner join T_ORG_CUBDControl bd ").append("on bd.FControlUnitID=cu.FID ").append("where bd.FIsSuperiorViewable=1 and cu.FLongNumber like ? and bd.FBDBOSType=? ").append("order by cu.FLevel asc");
        Object[] params = new String[]{longNumber + "!%", objectType.toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        int baselevel = -1;
        int currentlevel = -1;
        String ctrlUnitID = "";
        String parentCtrlUnitID = "";
        try {
            while (rs.next()) {
                currentlevel = rs.getInt("FLevel");
                ctrlUnitID = rs.getString("FID").trim();
                parentCtrlUnitID = rs.getString("FParentID");
                if (baselevel == -1) {
                    if (currentlevel != level + 1) break;
                    baselevel = currentlevel;
                }
                if (currentlevel == baselevel) {
                    set.add(ctrlUnitID);
                    continue;
                }
                assert (currentlevel > baselevel);
                if (StringUtils.isEmpty((String)parentCtrlUnitID) || !set.contains(parentCtrlUnitID.trim())) continue;
                set.add(ctrlUnitID);
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, (Throwable)e);
        }
        StringBuffer debuginfo = new StringBuffer();
        Object[] array = set.toArray();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            debuginfo.append(array[i].toString() + ",");
        }
        logger.debug((Object)("CUBDControl visible CU list : " + debuginfo.toString()));
        return set;
    }

    public static FilterInfo getInnerFilterInfo(QuerySolutionInfo querySolutionInfo) throws BOSException, EASBizException {
        FilterInfo newFilterInfo = new FilterInfo();
        if (querySolutionInfo == null || StringUtils.isEmpty((String)querySolutionInfo.getEntityViewInfo())) {
            return newFilterInfo;
        }
        StringBuffer sbFormula = new StringBuffer();
        String entityViewInfoStr = querySolutionInfo.getEntityViewInfo();
        if (entityViewInfoStr.toLowerCase().contains("where")) {
            entityViewInfoStr = entityViewInfoStr.substring(5, entityViewInfoStr.length());
        }
        MetaDataPK queryPK = new MetaDataPK(querySolutionInfo.getQueryObjectName());
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(entityViewInfoStr);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            int filterSize = filterInfo.getFilterItems().size();
            ArrayList rowInfos = AutoAssignSolutionUtil.getRowInfos(filterInfo);
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowObject = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                String leftBracket = rowObject.getLeftBracket();
                String rightBracket = rowObject.getRightBracket();
                String logic = rowObject.getLogic();
                rowObject.setLeftBracket(rowObject.getLeftBracket());
                rowObject.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null) {
                    Date dateFrom;
                    Date dateTo;
                    Date dateTo2;
                    Date dateFrom2;
                    Calendar cal;
                    String compValue;
                    String condition = rowObject.getCondition();
                    String compareValue = filterItemInfo.getCompareValue().toString();
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "YESTERDAY")) {
                        newFilterInfo = CommonFilterUtil.getYesterdayFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "TODAY")) {
                        newFilterInfo = CommonFilterUtil.getTodayFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "TOMORROW")) {
                        newFilterInfo = CommonFilterUtil.getTomorrowFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "LASTWEEK")) {
                        newFilterInfo = CommonFilterUtil.getLastWeekFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "THISWEEK")) {
                        newFilterInfo = CommonFilterUtil.getThisWeekFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "NEXTWEEK")) {
                        newFilterInfo = CommonFilterUtil.getNextWeekFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "LASTMONTH")) {
                        newFilterInfo = CommonFilterUtil.getLastMonthFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "THISMONTH")) {
                        newFilterInfo = CommonFilterUtil.getThisMonthFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "NEXTMONTH")) {
                        newFilterInfo = CommonFilterUtil.getNextMonthFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "BEFORETODAY")) {
                        newFilterInfo = CommonFilterUtil.getBeforetoDayFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.equalsIgnoreCase(compareValue, "AFTERTODAY")) {
                        newFilterInfo = CommonFilterUtil.getAftertoDayFilterInfo(newFilterInfo, condition, queryPK);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("IN_X_DAYS_AFTER")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, Integer.parseInt(compValue));
                        newFilterInfo = QueryUtils.getCompareDayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)cal.getTime(), (CompareType)CompareType.getEnum((String)">"));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("IN_X_DAYS_EQUAL")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, Integer.parseInt(compValue));
                        dateFrom2 = cal.getTime();
                        cal.add(5, 1);
                        dateTo2 = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)dateFrom2, (Date)dateTo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("IN_X_DAYS_BEFORE")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, 1);
                        dateFrom2 = cal.getTime();
                        cal.add(5, Integer.parseInt(compValue) - 1);
                        dateTo2 = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)dateFrom2, (Date)dateTo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("X_DAYS_AGO_AFTER")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, -Integer.parseInt(compValue));
                        newFilterInfo = QueryUtils.getCompareDayFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)cal.getTime(), (CompareType)CompareType.getEnum((String)"<"));
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("X_DAYS_AGO_EQUAL")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        cal.add(5, -Integer.parseInt(compValue) + 1);
                        dateTo = cal.getTime();
                        cal.add(5, -1);
                        dateFrom = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)dateFrom, (Date)dateTo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("X_DAYS_AGO_BEFORE")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        dateTo = cal.getTime();
                        cal.add(5, -Integer.parseInt(compValue) + 1);
                        dateFrom = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)dateFrom, (Date)dateTo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (!StringUtil.isEmpty((String)compareValue) && compareValue.toUpperCase(Locale.ENGLISH).startsWith("<>")) {
                        compValue = compareValue.split("\\$")[1];
                        cal = Calendar.getInstance();
                        dateTo = cal.getTime();
                        cal.add(5, -Integer.parseInt(compValue) + 1);
                        dateFrom = cal.getTime();
                        newFilterInfo = QueryUtils.getDayBetweenFilterInfo((FilterInfo)newFilterInfo, (String)condition, (MetaDataPK)queryPK, (Date)dateFrom, (Date)dateTo);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    newFilterInfo.getFilterItems().add(filterInfo.getFilterItems().get(i));
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (filterItemInfo.getPropertyName() == null) continue;
                newFilterInfo.getFilterItems().add(filterInfo.getFilterItems().get(i));
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        newFilterInfo.setEntryilterType(EntryFilterType.ENTRYANYWHERE);
        return newFilterInfo;
    }

    public static ArrayList getRowInfos(FilterInfo filterInfo) {
        int size;
        char[] exp;
        int size2;
        ArrayList<RowObject> target = new ArrayList<RowObject>();
        String expression = filterInfo.getMaskString();
        if (StringUtils.isEmpty((String)expression) && (size2 = filterInfo.getFilterItems().size()) > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < size2; ++i) {
                if (i == size2 - 1) {
                    buffer.append("#").append(i);
                    continue;
                }
                buffer.append("#").append(i).append(" AND ");
            }
            expression = buffer.toString();
        }
        if ((exp = (expression = expression + " AND ").toLowerCase().toCharArray()) != null) {
            int length = exp.length;
            StringBuffer leftBracket = new StringBuffer();
            StringBuffer rightBracket = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                RowObject rowObject;
                char c = exp[i];
                if ("(".equalsIgnoreCase(String.valueOf(c))) {
                    leftBracket.append(String.valueOf(c));
                    continue;
                }
                if (")".equalsIgnoreCase(String.valueOf(c))) {
                    rightBracket.append(String.valueOf(c));
                    continue;
                }
                if ("A".equalsIgnoreCase(String.valueOf(c))) {
                    rowObject = new RowObject();
                    rowObject.setLeftBracket(leftBracket.toString());
                    rowObject.setRightBracket(rightBracket.toString());
                    rowObject.setLogic("AND");
                    target.add(rowObject);
                    leftBracket = new StringBuffer();
                    rightBracket = new StringBuffer();
                    continue;
                }
                if (!"O".equalsIgnoreCase(String.valueOf(c))) continue;
                rowObject = new RowObject();
                rowObject.setLeftBracket(leftBracket.toString());
                rowObject.setRightBracket(rightBracket.toString());
                rowObject.setLogic("OR");
                target.add(rowObject);
                leftBracket = new StringBuffer();
                rightBracket = new StringBuffer();
            }
        }
        if ((size = target.size()) > 0) {
            ((RowObject)target.get(size - 1)).setLogic("");
        }
        return target;
    }

    public static CtrlUnitCollection queryAllLevelCtrlUnits(Context ctx, BOSObjectType objectType, CtrlUnitInfo sourceCtrlUnitInfo, ICtrlUnit iCtrlUnit) throws EASBizException, BOSException {
        StringBuilder oql = new StringBuilder("where longnumber like '" + sourceCtrlUnitInfo.getLongNumber() + "!%' and isousealup = 0");
        List canBeAssignedCUs = AutoAssignSolutionFactory.getLocalInstance(ctx).canBeAssignedCUs(objectType, (IObjectPK)new ObjectUuidPK(sourceCtrlUnitInfo.getId()));
        if (CsspMaterialUtils.isNotEmptyCollection(canBeAssignedCUs)) {
            oql.append(" and id in (");
            for (int y = 0; y < canBeAssignedCUs.size(); ++y) {
                oql.append("'");
                oql.append(canBeAssignedCUs.get(y));
                oql.append("'");
                if (y == canBeAssignedCUs.size() - 1) break;
                oql.append(",");
            }
            oql.append(")");
        }
        CtrlUnitCollection allLevelCtrlUnits = iCtrlUnit.getCtrlUnitCollection(oql.toString());
        return allLevelCtrlUnits;
    }

    public static String convertStr(String mutiResourceStr, String ... param) {
        MessageFormat mf = new MessageFormat(mutiResourceStr);
        String[] arrStr = null;
        if (param != null && param.length > 0) {
            arrStr = new String[param.length];
            for (int i = 0; i < param.length; ++i) {
                arrStr[i] = param[i];
            }
            String formatStr = mf.format(arrStr);
            return formatStr;
        }
        return mutiResourceStr;
    }

    public static boolean StrEquals(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        if (b != null) {
            return b.equals(a);
        }
        return true;
    }
}

