/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.view;

import com.kingdee.bos.ctrl.common.util.list.exception.ObjectNotFoundException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.view.AbstractBatchModifyCSSPGroup;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import org.apache.log4j.Logger;

public class BatchModifyCSSPGroup
extends AbstractBatchModifyCSSPGroup {
    private static final long serialVersionUID = -6205543362714307174L;
    private static final Logger logger = CoreUIObject.getLogger(BatchModifyCSSPGroup.class);
    private String type = null;
    private static final String defaultType = "0";
    private static final String customerType = "1";
    private static final String supplierType = "2";
    public static final Color necessaryColor = new Color(252, 255, 206);

    public BatchModifyCSSPGroup() throws Exception {
    }

    public BatchModifyCSSPGroup(String type) throws Exception {
        if (type.equals("customer_model.xml")) {
            this.type = customerType;
        } else if (type.equals("supplier_model.xml")) {
            this.type = supplierType;
        } else {
            throw new ObjectNotFoundException();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.checkParsed();
        this.loadGroupTable();
        this.kDTable1.addKDTActiveCellListener((KDTActiveCellListener)new CSGroupTableActiveCellHandler());
    }

    private void loadGroupTable() {
        try {
            ICSSPGroupStandard iCSSPGroupStandard = CSSPGroupStandardFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            CtrlUnitInfo ctrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("curCtrlUnitInfo");
            evi.setFilter(EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ctrlUnitInfo.getId().toString(), (String)ctrlUnitInfo.getLongNumber()));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)defaultType, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)this.type, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isBasic", (Object)StandardTypeEnum.basicStandard, CompareType.NOTEQUALS));
            filterInfo.setMaskString("(#0 or #1) and #2");
            evi.getFilter().mergeFilter(filterInfo, "and");
            SorterItemInfo sorterByBasic = new SorterItemInfo("isBasic");
            sorterByBasic.setSortType(SortType.DESCEND);
            evi.getSorter().add(sorterByBasic);
            CSSPGroupStandardCollection groupStandards = iCSSPGroupStandard.getCSSPGroupStandardCollection(evi);
            this.kDTable1.removeRows();
            this.kDTable1.getColumn(0).getStyleAttributes().setLocked(true);
            CSSPGroupStandardInfo stdVO = null;
            if (groupStandards != null && groupStandards.size() > 0) {
                int c = groupStandards.size();
                for (int i = 0; i < c; ++i) {
                    stdVO = groupStandards.get(i);
                    IRow row = this.kDTable1.addRow();
                    row.getCell(0).setValue((Object)stdVO);
                    row.getCell(0).getStyleAttributes().setLocked(true);
                    row.getCell(1).setValue(null);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)e.getMessage(), (Throwable)e);
        }
    }

    private void _activeCellChanged(int rowIndex) {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String queryInfo = null;
        if (this.type.equals(customerType)) {
            queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery";
        } else if (this.type.equals(supplierType)) {
            queryInfo = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierGroupQuery";
        }
        if (this.type.equals(customerType) && !CSSPUtils.isAllowNonLeaf4CUS()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CSSPGROUP.isLeaf", (Object)new Integer(1), CompareType.EQUALS));
        }
        if (this.type.equals(supplierType) && !CSSPUtils.isAllowNonLeaf4SUP()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CSSPGROUP.isLeaf", (Object)new Integer(1), CompareType.EQUALS));
        }
        promptBox.setQueryInfo(queryInfo);
        promptBox.setCommitFormat("$number$;$name$");
        IRow row = this.kDTable1.getRow(rowIndex);
        CSSPGroupStandardInfo std = (CSSPGroupStandardInfo)row.getCell(0).getValue();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)std.getId().toString(), CompareType.EQUALS));
        view.setFilter(filterInfo);
        promptBox.setEntityViewInfo(view);
        this.kDTable1.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public Object getData() {
        Object object = this.constructCSSPGroupData();
        return object;
    }

    private Object constructCSSPGroupData() {
        SupplierGroupDetailCollection supplierDetails = new SupplierGroupDetailCollection();
        CustomerGroupDetailCollection customerDetails = new CustomerGroupDetailCollection();
        AbstractObjectCollection object = null;
        int c = this.kDTable1.getRowCount();
        for (int i = 0; i < c; ++i) {
            IRow row = this.kDTable1.getRow(i);
            CSSPGroupStandardInfo std = (CSSPGroupStandardInfo)row.getCell(0).getValue();
            CSSPGroupInfo grp = (CSSPGroupInfo)row.getCell(1).getValue();
            if (this.type.equals(customerType)) {
                if (grp != null) {
                    CustomerGroupDetailInfo customerDetail = new CustomerGroupDetailInfo();
                    customerDetail.setCustomerGroup(grp);
                    customerDetail.setCustomerGroupStandard(std);
                    customerDetails.add(customerDetail);
                }
                if (i + 1 != this.kDTable1.getRowCount()) continue;
                object = customerDetails;
                continue;
            }
            if (!this.type.equals(supplierType)) continue;
            if (grp != null) {
                SupplierGroupDetailInfo supplierDetail = new SupplierGroupDetailInfo();
                supplierDetail.setSupplierGroup(grp);
                supplierDetail.setSupplierGroupStandard(std);
                supplierDetails.add(supplierDetail);
            }
            if (i + 1 != this.kDTable1.getRowCount()) continue;
            object = supplierDetails;
        }
        return object;
    }

    class CSGroupTableActiveCellHandler
    implements KDTActiveCellListener {
        CSGroupTableActiveCellHandler() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            if (e.getColumnIndex() == 1 && e.getRowIndex() > -1) {
                BatchModifyCSSPGroup.this._activeCellChanged(e.getRowIndex());
            }
        }
    }
}

