/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.util;

import org.apache.log4j.Logger;

public class PerfTimer {
    private long t0 = 0L;
    private long latestGetTimePoint = 0L;
    private long totalCostTime = 0L;

    public long getTotalCostTime() {
        return this.totalCostTime;
    }

    public void setLatestGetTimePoint(long latestGetTimePoint) {
        this.latestGetTimePoint = latestGetTimePoint;
    }

    public PerfTimer() {
        this.reset();
    }

    public void reset() {
        this.latestGetTimePoint = this.t0 = System.currentTimeMillis();
    }

    public long getCumulativeTime() {
        return System.currentTimeMillis() - this.t0;
    }

    public long getCostTime() {
        long now = System.currentTimeMillis();
        long costTime = now - this.latestGetTimePoint;
        this.latestGetTimePoint = now;
        this.totalCostTime += costTime;
        return costTime;
    }

    public void setCurrentAsStartTime() {
        this.setLatestGetTimePoint(System.currentTimeMillis());
    }

    public long getOtherCostTime() {
        return this.getCumulativeTime() - this.getTotalCostTime();
    }

    public String getAnalysisResult(String title) {
        return title + "\tcostTime:" + this.getCostTime() + "\tcumulativeTime:" + this.getCumulativeTime() + "\ttotalCostTime:" + this.getTotalCostTime() + "\totherCostTime:" + this.getOtherCostTime();
    }

    public void addAnalysisResultToLog(String title, Logger logger) {
        logger.info((Object)this.getAnalysisResult(title));
    }
}

