/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.privacy.PrivacyPropertyAccess;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PrivacyDbUtil {
    private static Logger logger = Logger.getLogger(PrivacyDbUtil.class);
    private static List<String> supportPrivacyTables = new ArrayList<String>();
    public static String[] customerCompanyInfo = new String[]{"FID", "FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FAdminCUID", "FComOrgID", "FSettlementCurrencyID", "FSettlementTypeID", "FPaymentTypeID", "FAccountClassID", "FIsTicketFreezed", "FEffectedStatus", "FCustomerID", "FFreezeOrgUnitID", "FContactPerson", "FContactPersonPost", "FPhone", "FMobile", "FFax", "FPostalcode", "FEMail", "FOperationerID", "FAdminOrgUnitID", "FPayConditionID"};
    public static String[] customerCompanyBank = new String[]{"FID", "FBank", "FBankAccount", "FBankAddress", "FBankEngName", "FBeneficiary", "FBeneficiaryEngName", "FBeneficiaryBankCode", "FBeneficiaryAddr", "FBeneficiaryBankCountryID", "FBeneficiaryBankCountryISO", "FBeneficiaryBankSWIFT", "FSettlementParam", "FAgencyBankAccount", "FAgencyBankName", "FAgencyBankSWIFT", "FAgencyBankCountryID", "FAgencyBankCountryISO", "FAgencyBankAddr", "FCustomerCompanyInfoID", "FAccountName", "FCurrency", "FOpenArea", "FISDEFAULT", "FBANKID"};
    public static String[] customerLinkMan = new String[]{"FID", "FPersonID", "FContactPerson", "FContactPersonPost", "FPhone", "FFax", "FMobile", "FPostalcode", "FEmail", "FAddress", "FCustomerSaleID"};
    public static String[] supplierCompanyInfo = new String[]{"FID", "FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FComOrgID", "FSettlementTypeID", "FSettlementCurrencyID", "FSettlementAccount", "FPaymentTypeID", "FAccountClassID", "FIsFreezePayment", "FEffectedStatus", "FFreezeOrgUnitID", "FSupplierID", "FContactPerson", "FContactPersonPost", "FPhone", "FMobile", "FFax", "FPostalcode", "FEMail", "FPAYCONDITIONID"};
    public static String[] supplierCompanyBank = new String[]{"FID", "FBank", "FBankAccount", "FBankAddress", "FBankEngName", "FBeneficiary", "FBeneficiaryEngName", "FBeneficiaryBankCode", "FBeneficiaryAddr", "FBeneficiaryBankCountryID", "FBeneficiaryBankCountryISO", "FBeneficiaryBankSWIFT", "FSettlementParam", "FAgencyBankAccount", "FAgencyBankName", "FAgencyBankSWIFT", "FAgencyBankCountryID", "FAgencyBankCountryISO", "FAgencyBankAddr", "FSupplierCompanyInfoID", "FISDEFAULT", "FBANKID"};
    public static String[] supplierLinkMan = new String[]{"FID", "FPersonID", "FContactPerson", "FContactPersonPost", "FPhone", "FFax", "FMobile", "FPostalcode", "FEMail", "FAddress", "FSupplierPurchaseID"};
    private static Map<String, String[]> tableMap = new HashMap<String, String[]>();

    public static void excuteInsertSql(Context ctx, String sql, String tableName) throws BOSException, SQLException {
        if (StringUtil.isEmpty(sql)) {
            return;
        }
        String[] tableFileds = tableMap.get(tableName);
        String insertPartSql = sql.substring(0, sql.indexOf(")") + 1) + "VALUES" + PrivacyDbUtil.appendPrepare(tableFileds.length);
        String valuePartSql = sql.substring(sql.indexOf(")") + 1, sql.length());
        Connection conn = null;
        PreparedStatement insertPs = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rs = conn.createStatement().executeQuery(valuePartSql);
            insertPs = conn.prepareStatement(insertPartSql);
            while (rs.next()) {
                for (int i = 0; i < tableFileds.length; ++i) {
                    insertPs.setObject(i + 1, rs.getObject(i + 1));
                }
                insertPs.addBatch();
            }
            insertPs.executeBatch();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, insertPs, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)insertPs, (Connection)conn);
    }

    public static boolean isOpenPrivacy(Context ctx, String sql) throws BOSException {
        sql = sql.toUpperCase();
        for (String tableName : supportPrivacyTables) {
            PrivacyPropertyAccess privacyPropertyAccess;
            if (!sql.contains(tableName.toUpperCase()) || (privacyPropertyAccess = PrivacyPropertyManager.getPrivacyPropertyAccess((Context)ctx, (String)tableName.toUpperCase())) == null) continue;
            return true;
        }
        return false;
    }

    private static String appendPrepare(int num) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < num; ++i) {
            sb.append("?").append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    static {
        tableMap.put("customerCompanyInfo", customerCompanyInfo);
        tableMap.put("customercompanybank", customerCompanyBank);
        tableMap.put("customerLinkMan", customerLinkMan);
        tableMap.put("supplierCompanyInfo", supplierCompanyInfo);
        tableMap.put("supplierCompanyBank", supplierCompanyBank);
        tableMap.put("supplierLinkMan", supplierLinkMan);
        supportPrivacyTables.add("T_BD_CUSTOMERCOMPANYINFO");
        supportPrivacyTables.add("T_BD_CUSTOMERCOMPANYBANK");
        supportPrivacyTables.add("T_BD_CUSTOMERLINKMAN");
        supportPrivacyTables.add("T_BD_SUPPLIERCOMPANYINFO");
        supportPrivacyTables.add("T_BD_SUPPLIERCOMPANYBANK");
        supportPrivacyTables.add("T_BD_SUPPLIERLINKMAN");
    }
}

