/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.util;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLUtil {
    public static String getPeriodCondition(String yearField, String periodField, int[] periodRange) {
        StringBuffer sql = new StringBuffer();
        if (periodRange[0] == periodRange[2]) {
            sql.append(yearField).append("=").append(periodRange[0]);
            if (periodRange[1] == periodRange[3]) {
                sql.append(" and " + periodField + "=").append(periodRange[1]);
            } else {
                sql.append(" and " + periodField + ">=").append(periodRange[1]).append(" and " + periodField + "<=").append(periodRange[3]);
            }
        } else {
            sql.append("(" + yearField + ">").append(periodRange[0]).append(" or (" + yearField + "=").append(periodRange[0]).append(" and " + periodField + ">=").append(periodRange[1]).append("))");
            sql.append(" and (" + yearField + "<").append(periodRange[2]).append(" or (" + yearField + "=").append(periodRange[2]).append(" and " + periodField + "<=").append(periodRange[3]).append("))");
        }
        return sql.toString();
    }

    public static String createAutoRangeCondition(String fieldName, String from, String to) {
        if (from == null && to == null) {
            return "(1=1)";
        }
        if (from != null && to != null) {
            int res = from.compareTo(to);
            if (res == 0) {
                return fieldName + "='" + SQLUtil.maskSqlParamValue(from) + "'";
            }
            if (res > 0) {
                String buf = from;
                from = to;
                to = buf;
            }
        }
        StringBuffer sql = new StringBuffer();
        boolean hasFrom = false;
        if (from != null) {
            sql.append(fieldName).append(">='" + SQLUtil.maskSqlParamValue(from) + "'");
            hasFrom = true;
        }
        if (to != null) {
            if (hasFrom) {
                sql.append(" and ");
            }
            sql.append(fieldName).append("<='" + SQLUtil.maskSqlParamValue(to) + "'");
        }
        return sql.toString();
    }

    public static String createAutoRangeCondition(String fieldName, int from, int to) {
        StringBuffer sql = new StringBuffer();
        if (from == to) {
            sql.append(fieldName).append("=").append(from);
        } else {
            sql.append(fieldName).append(">=").append(Math.min(from, to)).append(" and ").append(fieldName).append("<=").append(Math.max(from, to));
        }
        return sql.toString();
    }

    public static String transSelectIntoToSelectTopSql(String sql, int topCount) {
        String KEY_INTO = " into ";
        String KEY_SELECT = "select ";
        String buf = sql.toLowerCase();
        int intoIndex = buf.indexOf(" into ");
        int selectIndex = buf.indexOf("select ");
        if (intoIndex == -1 || selectIndex == -1) {
            throw new RuntimeException("Incorrect sql:" + sql);
        }
        char[] chs = buf.toCharArray();
        boolean hasBeginScan = false;
        int tableNameEndIndex = 0;
        for (int i = intoIndex + " into ".length(); i < chs.length; ++i) {
            if (chs[i] != ' ' && !hasBeginScan) {
                hasBeginScan = true;
                continue;
            }
            if (chs[i] != ' ' || !hasBeginScan) continue;
            tableNameEndIndex = i - 1;
            break;
        }
        StringBuffer result = new StringBuffer();
        result.append(sql.substring(0, selectIndex + "select ".length()));
        if (topCount >= 0) {
            result.append("top ").append(topCount).append(" ");
        }
        result.append(sql.substring(selectIndex + "select ".length(), intoIndex));
        result.append(sql.substring(tableNameEndIndex + 1));
        return result.toString();
    }

    public static String parseSelectIntoTableName(String sql) {
        String KEY_INTO = "into ";
        String buf = sql.toLowerCase();
        int intoIndex = buf.indexOf("into ");
        if (intoIndex == -1) {
            throw new RuntimeException("Incorrect sql:" + sql);
        }
        char[] chs = buf.toCharArray();
        boolean hasBeginScan = false;
        int tableNameBeginIndex = 0;
        for (int i = intoIndex + "into ".length(); i < chs.length; ++i) {
            if (chs[i] != ' ' && !hasBeginScan) {
                hasBeginScan = true;
                tableNameBeginIndex = i;
                continue;
            }
            if (chs[i] != ' ' && chs[i] != '\n' || !hasBeginScan) continue;
            return sql.substring(tableNameBeginIndex, i);
        }
        return sql.substring(tableNameBeginIndex);
    }

    public static String arrayToInList(String[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        for (int i = 0; i < array.length; ++i) {
            sql.append("'" + SQLUtil.maskSqlParamValue(array[i]) + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static String maskSqlParamValue(String value) {
        if (value != null) {
            return value.replaceAll("'", "''");
        }
        return value;
    }

    public static String applyTopLimit(String sql, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("select top ").append(topCount).append(" * from (" + sql + ") as ").append(SQLUtil.getSqlTableAliasName(sql));
        return sb.toString();
    }

    public static String applyLimit(String sql, String orderByFieldName, boolean asc, int index, int length) {
        StringBuffer sb = new StringBuffer();
        sb.append("select top ").append(length).append(" * from (");
        sb.append("select top ").append(index + length).append(" * from (");
        sb.append(sql);
        sb.append(") as ").append(SQLUtil.getSqlTableAliasName(sb.toString()));
        sb.append(" order by ").append(orderByFieldName).append(" desc ");
        sb.append(") as ").append(SQLUtil.getSqlTableAliasName(sb.toString()));
        sb.append(" order by ").append(orderByFieldName).append(" ");
        sb.append(asc ? "desc" : "asc");
        sb.insert(0, "select * from (");
        sb.append(") as ").append(SQLUtil.getSqlTableAliasName(sb.toString()));
        sb.append(" order by ").append(orderByFieldName).append(" ");
        sb.append(asc ? "asc" : "desc");
        return sb.toString();
    }

    public static String applyCountSql(String sql) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) from (").append(sql).append(") as ").append(SQLUtil.getSqlTableAliasName(sql));
        return sb.toString();
    }

    public static String applySelectIntoTableSql(String tableName, String sql) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tableName).append(" select * from (").append(sql).append(") as ").append(SQLUtil.getSqlTableAliasName(sql));
        return sb.toString();
    }

    public static String getSqlTableAliasName(String sql) {
        String tempName = "ALIAS_";
        String buf = sql.toUpperCase();
        int i = 0;
        while (buf.indexOf("ALIAS_" + i) != -1) {
            ++i;
        }
        return "ALIAS_" + i;
    }

    public static String buildCreateTableString(String tableName, ResultSetMetaData rsm) throws SQLException {
        return DBUtil.getKSQLDialect().buildCreateTableString(tableName, rsm);
    }

    public static byte[] getBytes(Object object) {
        byte[] bytes = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return object;
    }

    public static void processFilterView(EntityViewInfo viewInfo, String oldPropertyName, String newPropertyName) {
        FilterItemCollection items = viewInfo.getFilter().getFilterItems();
        for (int i = 0; i < items.size(); ++i) {
            FilterItemInfo item = items.get(i);
            if (item.getPropertyName() == null || !item.getPropertyName().equals(oldPropertyName)) continue;
            item.setPropertyName(newPropertyName);
        }
        SorterItemCollection sorters = viewInfo.getSorter();
        for (int i = 0; i < sorters.size(); ++i) {
            SorterItemInfo sorter = sorters.get(i);
            if (sorter.getPropertyName() == null || !sorter.getPropertyName().equals(oldPropertyName)) continue;
            sorter.setPropertyName(oldPropertyName);
        }
    }
}

