/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.cssp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.basedata.framework.client.BDClientUtil;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.PaymentItemTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.UsingStatusEnum;
import com.kingdee.eas.basedata.master.cssp.client.AbstractSupplierPurchaseUI;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.ICSSPAssistUI;
import com.kingdee.eas.basedata.master.cssp.client.ICSSPAttributeUIHelper;
import com.kingdee.eas.basedata.master.cssp.client.SupplierAttributeUIHelperFactory;
import com.kingdee.eas.basedata.master.cssp.client.SupplierEditUI;
import com.kingdee.eas.basedata.master.cssp.util.ShowTradeInfoUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OUException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewPurchaseF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SupplierPurchaseUI
extends AbstractSupplierPurchaseUI
implements ICSSPAssistUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplierPurchaseUI.class);
    private boolean isSuppressF7Event = false;
    private SupplierInfo supplierInfo = null;
    private static Integer defaultInteger = new Integer(0);
    private KDWorkButton btnAddLine = null;
    private KDWorkButton btnDeleteLine = null;
    private ICSSPAttributeUIHelper uiHelper;
    protected CtrlUnitInfo curCtrlUnitInfo;
    PurchaseOrgUnitInfo purOrg = null;
    protected SupplierEditUI parentUI;

    public void setUiHelper(ICSSPAttributeUIHelper uiHelper) {
        this.uiHelper = uiHelper;
    }

    @Override
    public void storeFields() {
        this.editData.setPurchaseOrgUnit((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData());
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.getParentUI().getUIWindow().close();
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected void showSubmitSuccess() {
        this.getParentUI().showSubmitSuccess(this.getClassAlise());
    }

    protected String getClassAlise() {
        return super.getClassAlise();
    }

    protected void showEdit() {
        if (this.getParentUI() != null) {
            this.getParentUI().showEdit(this.getClassAlise());
        }
    }

    protected void showAddNew() {
        if (this.getParentUI() != null) {
            this.getParentUI().showAddNew(this.getClassAlise());
        }
    }

    protected void showView() {
        if (this.getParentUI() != null) {
            this.getParentUI().showView(this.getClassAlise());
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if ((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CSCompanyOUNotExist"));
            SysUtil.abort();
        }
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setSupplier(this.supplierInfo);
        if (this.editData.getId() == null && OprtState.EDIT.equals(this.getOprtState())) {
            this.setOprtState(OprtState.ADDNEW);
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        ISupplierPurchaseInfo iBiz = (ISupplierPurchaseInfo)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        iBiz.cancel(new IObjectPK[]{pk});
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        ISupplierPurchaseInfo iBiz = (ISupplierPurchaseInfo)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        iBiz.cancelCancel(new IObjectPK[]{pk});
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.chkSupplierIsFreezePurchaseOrder.setEnabled(true);
        CSClientUtils.setUITitle((EditUI)this.getParentUI(), (String)this.getOprtState(), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"purchaseAttribute"));
        this.initPurCollaborationControl();
        this.updateButtonStatus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this._stateChanged(this.prmtPurchaseOrgUnit);
        super.actionEdit_actionPerformed(e);
        this.initPurCollaborationControl();
        this.chkSupplierIsFreezePurchaseOrder.setEnabled(true);
        CSClientUtils.setUITitle((EditUI)this.getParentUI(), (String)this.getOprtState(), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"purchaseAttribute"));
        this.getParentUI().setOprtState(OprtState.EDIT);
        this.btnRemove.setEnabled(true);
        this.updateButtonStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        try {
            if (this.confirmRemove()) {
                this.getBizInterface().delete((IObjectPK)new ObjectStringPK(this.editData.getId().toString()));
                this.setOprtState("VIEW");
                this.lockUIForViewStatus();
                this.setDataObject(this.createNewData());
                this.loadFields();
                MsgBox.showInfo((String)EASResource.getString((String)"deleteSuccessed"));
            }
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        this.updateButtonStatus();
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    @Override
    protected IObjectValue createNewData() {
        SupplierPurchaseInfoInfo info = new SupplierPurchaseInfoInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(TimeStampUtility.getTime());
        info.setGrade("0");
        info.setIsFreezeMakeOrder(false);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SupplierPurchaseInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        DataChangeListener[] dataChangeListeners = BDClientUtil.removeDataChangeListeners((KDPromptBox)this.prmtPurchaseGroup);
        this.isSuppressF7Event = true;
        this.supplierInfo = (SupplierInfo)this.getUIContext().get("supplier");
        this.initInterface();
        super.loadFields();
        if (this.editData.getId() == null && !this.getOprtState().equals(OprtState.VIEW)) {
            this.initDefaultData();
        }
        if (this.editData != null && this.editData.getPurchaseOrgUnit() != null) {
            this.prmtPurchaseOrgUnit.setData((Object)this.editData.getPurchaseOrgUnit());
            this.txtPurchaseOrgName.setText(this.editData.getPurchaseOrgUnit().getName());
        }
        if (this.editData != null && this.editData.getType() != null) {
            this.editData.setType(PaymentItemTypeEnum.getEnum((int)this.editData.getType().getValue()));
        } else {
            this.editData.setType(PaymentItemTypeEnum.DEFAULTTYPE);
        }
        if (this.editData.getGrade() != null && !this.editData.getGrade().equals("")) {
            this.spdgrade.setValue((Object)new Integer(this.editData.getGrade()));
        }
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.getDefaultPurchaser() != null) {
            this.prmtDefaultPurchaser.setText(this.editData.getDefaultPurchaser().getName());
        }
        this.initPurchase();
        this.isSuppressF7Event = false;
        this.updateButtonStatus();
        BDClientUtil.addDataChangeListener((KDPromptBox)this.prmtPurchaseGroup, (DataChangeListener[])dataChangeListeners);
    }

    private void initPurchase() {
    }

    private void initDefaultData() {
        String comID = null;
        if (this.editData.getPurchaseOrgUnit() == null) {
            this.prmtPurchaseOrgUnit.setData((Object)this.purOrg);
            if (this.purOrg != null) {
                this.txtPurchaseOrgName.setText(this.purOrg.getName());
            }
        } else {
            this.prmtPurchaseOrgUnit.setData((Object)this.editData.getPurchaseOrgUnit());
            this.txtPurchaseOrgName.setText(this.editData.getPurchaseOrgUnit().getName());
        }
        if (this.prmtPurchaseOrgUnit.getData() != null) {
            comID = ((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData()).getId().toString();
            this.editData.setPurchaseOrgUnit((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData());
            this.editData.setType(PaymentItemTypeEnum.DEFAULTTYPE);
        }
        if (this.editData.getBillingOrgUnit() == null) {
            this.editData.setBillingOrgUnit(this.supplierInfo);
        }
        if (this.editData.getDeliverOrgUnit() == null) {
            this.editData.setDeliverOrgUnit(this.supplierInfo);
        }
        this.prmtBillOrgUnit.setData((Object)this.editData.getBillingOrgUnit());
        this.prmtDeliverOrgUnit.setData((Object)this.editData.getDeliverOrgUnit());
        this.initPurCollaborationControl();
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initDefaultOrgUnit(this.curCtrlUnitInfo);
        super.onLoad();
        this.prmtPurchaseOrgUnit.setEnabled(true);
        this.prmtPurchaseOrgUnit.setAccessAuthority(0);
        this.tblLinker.getColumn("linkPerson").setRequired(true);
        this.initDefaultPurchaser();
        this.initPurCollaborationControl();
        String format = CtrlFormatUtilities.getDateFormatString();
        this.txtPurCreateDate.setDatePattern(format);
        this.txtPurUpdateDate.setDatePattern(format);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentPurchaseUnit() != null && SysContext.getSysContext().getCurrentPurchaseUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.purOrg = SysContext.getSysContext().getCurrentPurchaseUnit();
        } else if (curCtrlUnitInfo.isIsPurchaseOrgUnit()) {
            this.purOrg = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    private void initInterface() {
        this.setCurrentToolBar();
        this.setWorkButton();
        this.initF7Control();
        this.setPurchaseLinkManTable();
    }

    private void setCurrentToolBar() {
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.menuView.setVisible(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.chkSupplierIsFreezePurchaseOrder.setEnabled(false);
        }
        if (!this.getOprtState().equals(OprtState.VIEW) && this.editData.getId() != null) {
            this.btnRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
        }
        this.menuItemSupplierTradeRpt.setEnabled(true);
    }

    private void initF7Control() {
        NewPurchaseF7 f7PurchaseOrg = new NewPurchaseF7((IUIObject)this);
        f7PurchaseOrg.setMultiSelect(false);
        f7PurchaseOrg.setIsCUFilter(true);
        f7PurchaseOrg.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        this.prmtPurchaseOrgUnit.setSelector((KDPromptSelector)f7PurchaseOrg);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)f7PurchaseOrg);
        this.prmtPurchaseOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.prmtPurchaseOrgUnit.addChangeListener((ChangeListener)new F7ChangeEventHandler());
        this.prmtPurchaseOrgUnit.setDisplayFormat("$number$");
        this.prmtPurchaseOrgUnit.setCommitFormat("$number$");
        this.prmtPurchaseOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtPurchaseOrgUnit.setHandleCUFilter(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cashDiscType", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("cashDiscType", (Object)"3"));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filterInfo.setMaskString("(#0 or #1) and (#2 or #3 or #4) ");
        viewInfo.setFilter(filterInfo);
        this.prmtCashDiscount.setEntityViewInfo(viewInfo);
        this.prmtCashDiscount.setMyCommonUseEnabled(false);
        this.spdgrade.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDSpinner sp = (KDSpinner)e.getSource();
                CSClientUtils.setSpinner((JSpinner)sp, (int)0, (int)100, (Object)sp.getValue());
            }
        });
        this.prmtDefaultPurchaser.setMyCommonUseEnabled(false);
    }

    public void _stateChanged(KDBizPromptBox f7) {
        if (f7.getData() != null) {
            try {
                SupplierPurchaseInfoInfo info = this.getPurchaseInfoByOrg((IObjectPK)new ObjectUuidPK(((PurchaseOrgUnitInfo)f7.getData()).getId()));
                info.setPurchaseOrgUnit((PurchaseOrgUnitInfo)f7.getData());
                this.editData = info;
                this.setDataObject((IObjectValue)info);
                this.loadFields();
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    ExceptionHandler.handle((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"loadSupplierPurchaseInfoFailed") + e.getMessage()), (Throwable)e);
                }
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"loadSupplierPurchaseInfoFailed"), (Throwable)e);
            }
            finally {
                this.txtPurchaseOrgName.setText(((PurchaseOrgUnitInfo)f7.getData()).getName());
            }
        } else {
            this.txtPurchaseOrgName.setText("");
        }
    }

    private SupplierEditUI getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(SupplierEditUI ui) {
        this.parentUI = ui;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.addCloseButton(this.toolBar);
    }

    private void addCloseButton(KDToolBar toolBar) {
        JToolBar.Separator endSeparator = null;
        KDWorkButton btnCloseTab = null;
        endSeparator = new JToolBar.Separator();
        btnCloseTab = new KDWorkButton();
        endSeparator.setOrientation(1);
        btnCloseTab.setIcon(UIFrameResource.getCommonIcon((String)"imgTbtn_quit"));
        btnCloseTab.setText(UIFrameResource.getString((String)"close"));
        btnCloseTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SupplierPurchaseUI.this.actionExitCurrent_actionPerformed(null);
                }
                catch (Exception e1) {
                    SupplierPurchaseUI.this.handUIException(e1);
                }
            }
        });
        toolBar.add((Component)endSeparator);
        toolBar.add((Component)btnCloseTab);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("billingOrgUnit.name"));
        sic.add(new SelectorItemInfo("billingOrgUnit.number"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.number"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.number"));
        sic.add(new SelectorItemInfo("cashDiscount.entries.description"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        return sic;
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection sic = super.getMergedSelector();
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("billingOrgUnit.name"));
        sic.add(new SelectorItemInfo("billingOrgUnit.number"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.number"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.name"));
        sic.add(new SelectorItemInfo("deliverOrgUnit.number"));
        sic.add(new SelectorItemInfo("cashDiscount.entries.description"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        return sic;
    }

    protected SupplierPurchaseInfoInfo getPurchaseInfoByOrg(IObjectPK pk) throws Exception {
        SupplierPurchaseInfoInfo vo = null;
        ISupplierPurchaseInfo iSupplierPurchase = SupplierPurchaseInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        vo = iSupplierPurchase.getPurChaseInfo((IObjectPK)new ObjectUuidPK(this.supplierInfo.getId()), pk, this.getMergedSelector());
        if (vo == null) {
            vo = (SupplierPurchaseInfoInfo)this.createNewData();
        }
        return vo;
    }

    protected SupplierPurchaseInfoInfo getPurchaseInfoByNumber(String number) throws Exception {
        SupplierPurchaseInfoInfo vo = null;
        if (number != null) {
            ISupplierPurchaseInfo iSupplierPurchase = SupplierPurchaseInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            vo = iSupplierPurchase.getPurChaseInfo(this.supplierInfo.getNumber(), number);
        }
        if (vo == null) {
            vo = (SupplierPurchaseInfoInfo)this.createNewData();
        }
        return vo;
    }

    protected SupplierPurchaseInfoInfo getSupplierPurchaseInfo(IObjectPK pk) throws Exception {
        ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance(this.getMainOrgContext());
        return iSupplierPurchaseInfo.getSupplierPurchaseInfoInfo(pk, this.getMergedSelector());
    }

    private void setPurchaseLinkManTable() {
        String[] linkManBaseInfoTab = new String[]{"linkPerson", "duty", "officePhone", "cell", "fax"};
        String[] emailTab = new String[]{"email"};
        String[] zipCodeTab = new String[]{"zipCode"};
        String[] addressTab = new String[]{"address"};
        KDTextField txtForBaseInfoField = new KDTextField();
        txtForBaseInfoField.setMaxLength(40);
        KDTDefaultCellEditor kdtBaseInfoCellEditor = new KDTDefaultCellEditor((JTextField)txtForBaseInfoField);
        this.tblLinker.checkParsed();
        for (int i = 0; i < linkManBaseInfoTab.length; ++i) {
            this.tblLinker.getColumn(linkManBaseInfoTab[i]).setEditor((ICellEditor)kdtBaseInfoCellEditor);
        }
        KDTextField txtForEmailField = new KDTextField();
        txtForEmailField.setMaxLength(80);
        KDTDefaultCellEditor kdtEmailCellEditor = new KDTDefaultCellEditor((JTextField)txtForEmailField);
        for (int i = 0; i < emailTab.length; ++i) {
            this.tblLinker.getColumn(emailTab[i]).setEditor((ICellEditor)kdtEmailCellEditor);
        }
        KDTextField txtForZipCodeField = new KDTextField();
        txtForZipCodeField.setMaxLength(10);
        KDTDefaultCellEditor kdtZipCodeCellEditor = new KDTDefaultCellEditor((JTextField)txtForZipCodeField);
        for (int i = 0; i < zipCodeTab.length; ++i) {
            this.tblLinker.getColumn(zipCodeTab[i]).setEditor((ICellEditor)kdtZipCodeCellEditor);
        }
        KDTextField txtForAddressField = new KDTextField();
        txtForAddressField.setMaxLength(100);
        KDTDefaultCellEditor kdtAddressCellEditor = new KDTDefaultCellEditor((JTextField)txtForAddressField);
        for (int i = 0; i < addressTab.length; ++i) {
            this.tblLinker.getColumn(addressTab[i]).setEditor((ICellEditor)kdtAddressCellEditor);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String numStr;
        boolean isNonNegativInt;
        if (this.editData.getPurchaseOrgUnit() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierPurchaseOrgUnit"));
            this.prmtPurchaseOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getDeliverOrgUnit() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierDeliveryOrg"));
            this.prmtDeliverOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getBillingOrgUnit() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"SupplierBillOrg"));
            this.prmtBillOrgUnit.requestFocus();
            SysUtil.abort();
        }
        if (!(isNonNegativInt = this.isNonNegativeINT(numStr = this.txtResponseTime.getText()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"ResponseTimeCannotBeMinus"));
            this.txtResponseTime.requestFocus();
            this.txtResponseTime.setText("0");
            SysUtil.abort();
        }
        if (!(isNonNegativInt = this.isNonNegativeINT(numStr = this.txtConfirmNum.getText()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"ConfirmNumCannotBeMinus"));
            this.txtConfirmNum.requestFocus();
            this.txtConfirmNum.setText("0");
            SysUtil.abort();
        }
        if (!(isNonNegativInt = this.isNonNegativeINT(numStr = this.txtNoticeAdvance.getText()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"NoticeAdvanceCannotBeMinus"));
            this.txtNoticeAdvance.requestFocus();
            this.txtNoticeAdvance.setText("0");
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    private void setWorkButton() {
        if (this.btnAddLine == null) {
            this.btnAddLine = new KDWorkButton();
            this.actionAddRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btnAddLine = (KDWorkButton)this.grpLinker.add((Action)((Object)this.actionAddRow));
            this.btnAddLine.setText(null);
            this.btnAddLine.setSize(new Dimension(22, 19));
            this.btnAddLine.setEnabled(true);
        }
        if (this.btnDeleteLine == null) {
            this.btnDeleteLine = new KDWorkButton();
            this.actionDeleteRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btnDeleteLine = (KDWorkButton)this.grpLinker.add((Action)((Object)this.actionDeleteRow));
            this.btnDeleteLine.setText(null);
            this.btnDeleteLine.setSize(new Dimension(22, 19));
            this.btnDeleteLine.setEnabled(true);
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.tblLinker.addRow();
        }
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            CSClientUtils.removeLine((Component)((Object)this), (KDTable)this.tblLinker);
        }
    }

    private void updateLinkMan() {
        this.editData.getSupplierLinkMan().clear();
        int c = this.tblLinker.getRowCount();
        for (int i = 0; i < c; ++i) {
            SupplierLinkManInfo linkMan = new SupplierLinkManInfo();
            IRow row = this.tblLinker.getRow(i);
            linkMan.setContactPerson(row.getCell("linkPerson").getValue() != null ? row.getCell("linkPerson").getValue().toString() : null);
            linkMan.setContactPersonPost(row.getCell("duty").getValue() != null ? row.getCell("duty").getValue().toString() : null);
            linkMan.setPhone(row.getCell("officePhone").getValue() != null ? row.getCell("officePhone").getValue().toString() : null);
            linkMan.setMobile(row.getCell("cell").getValue() != null ? row.getCell("cell").getValue().toString() : null);
            linkMan.setFax(row.getCell("fax").getValue() != null ? row.getCell("fax").getValue().toString() : null);
            linkMan.setEmail(row.getCell("email").getValue() != null ? row.getCell("email").getValue().toString() : null);
            linkMan.setPostalcode(row.getCell("zipCode").getValue() != null ? row.getCell("zipCode").getValue().toString() : null);
            linkMan.setAddress(row.getCell("address").getValue() != null ? row.getCell("address").getValue().toString() : null);
            if (row.getCell("linkPerson").getValue() == null && row.getCell("duty").getValue() == null && row.getCell("officePhone").getValue() == null && row.getCell("cell").getValue() == null && row.getCell("fax").getValue() == null && row.getCell("email").getValue() == null && row.getCell("zipCode").getValue() == null && row.getCell("address").getValue() == null) continue;
            linkMan.setSupplierPurchase(this.editData);
            this.editData.getSupplierLinkMan().add(linkMan);
        }
    }

    protected void loadLinkerGroupTable() {
        this.tblLinker.checkParsed();
        this.tblLinker.removeRows();
        SupplierLinkManCollection collection = this.editData.getSupplierLinkMan();
        if (collection != null && collection.size() > 0) {
            int c = collection.size();
            for (int i = 0; i < c; ++i) {
                SupplierLinkManInfo stdVO = collection.get(i);
                IRow row = this.tblLinker.addRow();
                row.getCell("linkPerson").setValue((Object)stdVO.getContactPerson());
                row.getCell("duty").setValue((Object)stdVO.getContactPersonPost());
                row.getCell("officePhone").setValue((Object)stdVO.getPhone());
                row.getCell("cell").setValue((Object)stdVO.getMobile());
                row.getCell("fax").setValue((Object)stdVO.getFax());
                row.getCell("email").setValue((Object)stdVO.getEmail());
                row.getCell("zipCode").setValue((Object)stdVO.getPostalcode());
                row.getCell("address").setValue((Object)stdVO.getAddress());
            }
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ((SupplierPurchaseInfoInfo)newData).setPurchaseOrgUnit(null);
        ((SupplierPurchaseInfoInfo)newData).setFreezeOrgUnit(null);
        ((SupplierPurchaseInfoInfo)newData).setCreator(SysContext.getSysContext().getCurrentUserInfo());
        ((SupplierPurchaseInfoInfo)newData).setCreateTime(TimeStampUtility.getTime());
        ((SupplierPurchaseInfoInfo)newData).setLastUpdateUser(null);
        ((SupplierPurchaseInfoInfo)newData).setLastUpdateTime(null);
        ((SupplierPurchaseInfoInfo)newData).setCU(this.curCtrlUnitInfo);
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setCU(this.curCtrlUnitInfo);
        this.editData.setSupplier(this.supplierInfo);
        IObjectPK pk = null;
        if (this.editData.getCU() == null) {
            this.editData.setCU(this.curCtrlUnitInfo);
        }
        if (this.editData.getSupplier() == null) {
            this.editData.setSupplier(this.supplierInfo);
        }
        if (this.editData.getId() == null) {
            pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        } else {
            pk = new ObjectUuidPK(this.editData.getId());
            this.getBizInterface().update(pk, (CoreBaseInfo)this.editData);
        }
        this.setDataObject(this.getValue(pk));
        this.initOldData((IObjectValue)this.editData);
        return pk;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        try {
            this.uiHelper = SupplierAttributeUIHelperFactory.createBaseUIHelper();
        }
        catch (BOSException exception) {
            this.handleException((Exception)((Object)exception));
        }
        if (((PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData()).isIsSealUp()) {
            OUException ouException = new OUException(OUException.CANT_ADDNEW_FOR_SEALED_PURCHASE);
            MsgBox.showInfo((String)ouException.getMessage());
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    @Override
    public void actionSupplierTradeRpt_actionPerformed(ActionEvent e) throws Exception {
        SupplierInfo supplierNumber = null;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
        if (this.supplierInfo == null) {
            return;
        }
        supplierNumber = this.supplierInfo;
        if (this.prmtPurchaseOrgUnit.getData() != null && this.prmtPurchaseOrgUnit.getData() instanceof PurchaseOrgUnitInfo) {
            purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"TRADERPT_ORG_NULL"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        ShowTradeInfoUtil.showSupplierTradeUI((UIContext)uiContext, (String)supplierNumber.getNumber(), (PurchaseOrgUnitInfo)purchaseOrgUnitInfo);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "Supplierpurchaseinfo_AddNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "Supplierpurchaseinfo_Update";
        }
        return "Supplierpurchaseinfo_View";
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    protected void updateButtonStatus() {
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        if (this.editData != null && this.editData.getId() != null) {
            if (this.editData.getUsingStatus() == UsingStatusEnum.FREEZED) {
                this.btnCancel.setVisible(false);
                this.btnCancelCancel.setVisible(true);
            } else {
                this.btnCancel.setVisible(true);
                this.btnCancelCancel.setVisible(false);
            }
        } else {
            this.btnCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
        }
    }

    @Override
    protected void prmtPurchaseOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.initDefaultPurchaser();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
        if (purchaseOrgUnitInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("purOrg.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            this.prmtPurchaseGroup.setEntityViewInfo(viewInfo);
        }
    }

    @Override
    protected void prmtPurchaseGroup_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isFirstOnload() && this.prmtPurchaseGroup.getData() != null && (PurchaseGroupInfo)e.getOldValue() == null) {
            this.prmtDefaultPurchaser.setData(null);
        } else if (!this.isFirstOnload() && this.prmtPurchaseGroup.getData() != null && !((PurchaseGroupInfo)this.prmtPurchaseGroup.getData()).getId().toString().equals(((PurchaseGroupInfo)e.getOldValue()).getId().toString())) {
            this.prmtDefaultPurchaser.setData(null);
        }
        this.initDefaultPurchaser();
    }

    protected void initDefaultPurchaser() throws Exception {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getData();
        PurchaseGroupInfo purchaseGroupInfo = (PurchaseGroupInfo)this.prmtPurchaseGroup.getData();
        if (purchaseOrgUnitInfo != null && purchaseGroupInfo != null) {
            this.prmtDefaultPurchaser.setEditFormat("$person.number$");
            this.prmtDefaultPurchaser.setDisplayFormat("$person.name$");
            this.prmtDefaultPurchaser.setCommitFormat("$person.number$;$person.idNum$");
            this.prmtDefaultPurchaser.setQueryInfo("com.kingdee.eas.basedata.scm.sm.pur.app.F7PurPersonQuery");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purchaseOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)purchaseGroupInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1");
            viewInfo.setFilter(filterInfo);
            this.prmtDefaultPurchaser.setEntityViewInfo(viewInfo);
        } else {
            this.prmtDefaultPurchaser.setEditFormat("$number$");
            this.prmtDefaultPurchaser.setDisplayFormat("$name$");
            this.prmtDefaultPurchaser.setCommitFormat("$number$;$name$");
            this.prmtDefaultPurchaser.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
            this.prmtDefaultPurchaser.setEntityViewInfo(null);
        }
    }

    protected void initPurCollaborationControl() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.chkIsConfirmPatial.setSelected(true);
            this.chkIsDeliverPlanCollaboration.setSelected(true);
            this.chkIsStoreDirect.setSelected(true);
        }
        if (this.chkIsPurCollaboration.isSelected()) {
            this.chkIsAutoAudit.setEnabled(true);
            this.chkIsConfirmPatial.setEnabled(true);
            this.chkIsDeliverPlanCollaboration.setEnabled(true);
            this.chkIsStoreDirect.setEnabled(true);
            this.txtConfirmNum.setEnabled(true);
            this.txtResponseTime.setEnabled(true);
            this.txtNoticeAdvance.setEnabled(true);
        } else {
            this.chkIsAutoAudit.setEnabled(false);
            this.chkIsConfirmPatial.setEnabled(false);
            this.chkIsDeliverPlanCollaboration.setEnabled(false);
            this.chkIsStoreDirect.setEnabled(false);
            this.txtConfirmNum.setEnabled(false);
            this.txtResponseTime.setEnabled(false);
            this.txtNoticeAdvance.setEnabled(false);
            this.chkIsAutoAudit.setSelected(false);
            this.chkIsConfirmPatial.setSelected(true);
            this.chkIsDeliverPlanCollaboration.setSelected(true);
            this.chkIsStoreDirect.setSelected(true);
            this.txtConfirmNum.setText("0");
            this.txtResponseTime.setText("0");
            this.txtNoticeAdvance.setText("0");
        }
    }

    @Override
    protected void prmtDefaultPurchaser_dataChanged(DataChangeEvent e) throws Exception {
        Object o = e.getNewValue();
        if (o instanceof PurchasePersonInfo) {
            PurchasePersonInfo purchasePersonInfo = (PurchasePersonInfo)o;
            PersonInfo personInfo = purchasePersonInfo.getPerson();
            if (personInfo != null && personInfo.getId() != null && (personInfo.getNumber() == null || personInfo.getNumber().trim().length() == 0 || personInfo.getName() == null || personInfo.getName().trim().length() == 0)) {
                ObjectUuidPK pk = new ObjectUuidPK(personInfo.getId());
                personInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
                purchasePersonInfo.setPerson(personInfo);
                this.editData.setDefaultPurchaser(personInfo);
            }
            this.spdgrade.requestFocus();
        }
    }

    @Override
    protected void chkIsPurCollaboration_stateChanged(ChangeEvent e) throws Exception {
        this.initPurCollaborationControl();
    }

    public boolean isNonNegativeINT(String num) {
        if (num.indexOf("-") != -1 || num.indexOf(".") != -1 || num.indexOf("%") != -1 || num.indexOf("+") != -1) {
            return false;
        }
        try {
            Integer int_num = new Integer(0);
            int n = Integer.parseInt(num.replaceAll(",", ""));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void txtConfirmNum_focusLost(FocusEvent e) throws Exception {
        String confirmNum = this.txtConfirmNum.getText().trim();
        if (confirmNum == null || confirmNum.length() == 0) {
            this.txtConfirmNum.setText("0");
        }
    }

    @Override
    protected void txtNoticeAdvance_focusLost(FocusEvent e) throws Exception {
        String noticeAdvance = this.txtNoticeAdvance.getText().trim();
        if (noticeAdvance == null || noticeAdvance.length() == 0) {
            this.txtNoticeAdvance.setText("0");
        }
    }

    @Override
    protected void txtResponseTime_focusLost(FocusEvent e) throws Exception {
        String responseTime = this.txtResponseTime.getText().trim();
        if (responseTime == null || responseTime.length() == 0) {
            this.txtResponseTime.setText("0");
        }
    }

    public void unLockUI() {
        super.unLockUI();
    }

    class F7ChangeEventHandler
    implements ChangeListener {
        F7ChangeEventHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDBizPromptBox f7 = (KDBizPromptBox)e.getSource();
            if (!SupplierPurchaseUI.this.isSuppressF7Event) {
                SupplierPurchaseUI.this._stateChanged(f7);
            }
        }
    }
}

