/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import java.util.Set;

public class PerminsionUtil {
    private PerminsionUtil() {
    }

    public static CtrlUnitInfo getCuByOuId(String OuId) throws EASBizException, BOSException {
        return PerminsionUtil.getCuByOuId(null, OuId);
    }

    public static CtrlUnitInfo getCuByOuId(Context ctx, String OuId) throws EASBizException, BOSException {
        if (OuId == null || OuId.length() == 0) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("CU.*");
        FullOrgUnitInfo fullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(OuId), sic);
        CtrlUnitInfo cu = null;
        if (fullOrgUnitInfo.getCU() != null) {
            cu = fullOrgUnitInfo.getCU();
        }
        return cu;
    }

    public static void checkCUPerminsionByOuId(Context ctx, String OuId, String UserId, String PerminsionItem) throws BOSException, EASBizException {
        CtrlUnitInfo cu = PerminsionUtil.getCuByOuId(ctx, OuId);
        if (cu == null) {
            return;
        }
        ObjectUuidPK CuPk = new ObjectUuidPK(cu.getId().toString());
        ObjectUuidPK userPk = new ObjectUuidPK(UserId);
        IPermission iPermission = null;
        iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)CuPk, PerminsionItem);
    }

    public static void checkCUPerminsion(String CuId, String UserId, String PerminsionItem) throws BOSException, EASBizException {
        PerminsionUtil.checkCUPerminsion(null, CuId, UserId, PerminsionItem);
    }

    public static void checkCUPerminsion(Context ctx, String CuId, String UserId, String PerminsionItem) throws BOSException, EASBizException {
        ObjectUuidPK CuPk = new ObjectUuidPK(CuId);
        ObjectUuidPK userPk = new ObjectUuidPK(UserId);
        IPermission iPermission = null;
        iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission((IObjectPK)userPk, (IObjectPK)CuPk, PerminsionItem);
    }

    public static boolean isUserOrgRange(String userId, String orgId) throws BOSException, EASBizException {
        return PerminsionUtil.isUserBizOrgRange(null, userId, orgId);
    }

    public static boolean isUserBizOrgRange(Context ctx, String userId, String orgId) throws BOSException, EASBizException {
        if (orgId == null || orgId.trim().length() == 0 || userId == null || userId.trim().length() == 0) {
            return false;
        }
        ObjectUuidPK pk = new ObjectUuidPK(userId);
        Set orgSet = ctx == null ? OrgRangeIncludeSubOrgFactory.getRemoteInstance().getOrgIdsByUserAndType((IObjectPK)pk, OrgRangeType.BIZ_ORG_TYPE) : OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx).getOrgIdsByUserAndType((IObjectPK)pk, OrgRangeType.BIZ_ORG_TYPE);
        return orgSet.contains(orgId);
    }
}

