/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrException;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.client.AbstractAsstAttrValueAddUI;
import com.kingdee.eas.basedata.master.material.util.AsstAttrSeparator;
import com.kingdee.eas.common.client.UIContext;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class AsstAttrValueAddUI
extends AbstractAsstAttrValueAddUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstAttrValueAddUI.class);
    private static final String IS_EDITED_VALUES = "isEditedValues";
    private static final String EDITED_VALUES = "editValues";
    private static final String TB_VALUE_ID = "valueID";
    private static final String BASIC_TYPE_NAME = "basicTypeName";
    private static final String TB_VALUE_NAME = "valueName";
    private static final String TB_VALUE_NUMBER = "valueNumber";
    private static final String ATTR_VALUE_INFO = "attrValueInfo";
    private static final String DETAIL_LIST = "attrTypeCollection";
    private boolean isConfirmed = false;
    private boolean isChanged = false;
    private AsstAttrValueCollection uiValueCollection = new AsstAttrValueCollection();
    private AsstAttrCompondingTypeDetailCollection uiDetailCollection;

    public static AsstAttrValueAddUI showAddUI(Object owner, AsstAttrCompondingTypeDetailCollection detailList) throws UIException {
        UIContext uictx = new UIContext(owner);
        uictx.put((Object)DETAIL_LIST, (Object)detailList);
        uictx.put((Object)IS_EDITED_VALUES, (Object)Boolean.FALSE);
        return AsstAttrValueAddUI.showUI(uictx);
    }

    public static AsstAttrValueAddUI showEditUIByComValue(Object owner, AsstAttrCompondingTypeDetailCollection detailList, AsstAttrValueInfo attrValueInfo) throws UIException {
        UIContext uictx = new UIContext(owner);
        uictx.put((Object)DETAIL_LIST, (Object)detailList);
        uictx.put((Object)IS_EDITED_VALUES, (Object)Boolean.FALSE);
        uictx.put((Object)ATTR_VALUE_INFO, (Object)attrValueInfo);
        return AsstAttrValueAddUI.showUI(uictx);
    }

    public static AsstAttrValueAddUI showEditUIByValueCollection(Object owner, AsstAttrCompondingTypeDetailCollection detailList, AsstAttrValueCollection editedValueCollection) throws UIException {
        UIContext uictx = new UIContext(owner);
        uictx.put((Object)DETAIL_LIST, (Object)detailList);
        uictx.put((Object)IS_EDITED_VALUES, (Object)Boolean.TRUE);
        uictx.put((Object)EDITED_VALUES, (Object)editedValueCollection);
        return AsstAttrValueAddUI.showUI(uictx);
    }

    private static AsstAttrValueAddUI showUI(UIContext uictx) throws UIException {
        String uiname = AsstAttrValueAddUI.class.getName();
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIFactory uif = UIFactory.createUIFactory((String)uimode);
        IUIWindow ui = uif.create(uiname, (Map)uictx);
        ui.show();
        return (AsstAttrValueAddUI)ui.getUIObject();
    }

    public void onShow() throws Exception {
        this.toolBar.setVisible(false);
        super.onShow();
        this.uiDetailCollection = (AsstAttrCompondingTypeDetailCollection)((Object)this.getUIContext().get(DETAIL_LIST));
        Boolean isEditedValues = (Boolean)this.getUIContext().get(IS_EDITED_VALUES);
        if (isEditedValues != null && isEditedValues.booleanValue()) {
            AsstAttrValueCollection uiValueCollection = (AsstAttrValueCollection)((Object)this.getUIContext().get(EDITED_VALUES));
            this.initTableByValueCollection(this.uiDetailCollection, uiValueCollection);
        } else {
            AsstAttrValueInfo attrValueInfo = (AsstAttrValueInfo)this.getUIContext().get(ATTR_VALUE_INFO);
            this.initTableByValueInfo(this.uiDetailCollection, attrValueInfo);
        }
        this.isConfirmed = false;
        this.isChanged = false;
    }

    protected void initWorkButton() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void initTableByValueCollection(AsstAttrCompondingTypeDetailCollection detailList, AsstAttrValueCollection editedValueCollection) throws Exception {
        for (int i = 0; i < detailList.size(); ++i) {
            AsstAttrCompondingTypeDetailInfo detailInfo = detailList.get(i);
            AsstAttrValueInfo tableAttrValueInfo = editedValueCollection.get(i);
            IRow row = this.kDTable1.addRow();
            this.fillRow(row, tableAttrValueInfo, detailInfo);
        }
        this.uiValueCollection = editedValueCollection;
    }

    private void initTableByValueInfo(AsstAttrCompondingTypeDetailCollection detailList, AsstAttrValueInfo attrValueInfo) throws Exception {
        for (int i = 0; i < detailList.size(); ++i) {
            AsstAttrCompondingTypeDetailInfo detailInfo = detailList.get(i);
            IRow row = this.kDTable1.addRow();
            AsstAttrValueInfo tableAttrValueInfo = new AsstAttrValueInfo();
            tableAttrValueInfo.setNumber("");
            if (attrValueInfo != null) {
                String fieldName = detailInfo.getBasictype().getMappingField();
                if (attrValueInfo.get(fieldName) == null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo(fieldName));
                    IAsstAttrValue iaav = AsstAttrValueFactory.getRemoteInstance();
                    attrValueInfo = iaav.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(attrValueInfo.getId()), selector);
                }
                tableAttrValueInfo = AsstAttrValueFactory.getRemoteInstance().getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(attrValueInfo.get(fieldName).toString()));
            }
            this.uiValueCollection.add(tableAttrValueInfo);
            this.fillRow(row, tableAttrValueInfo, detailInfo);
        }
    }

    private void fillRow(IRow row, AsstAttrValueInfo tableAttrValueInfo, AsstAttrCompondingTypeDetailInfo detailInfo) throws ParserException {
        if (detailInfo != null) {
            row.getCell(BASIC_TYPE_NAME).setValue((Object)detailInfo.getBasictype().getName());
            String basicTypeID = detailInfo.getBasictype().getId().toString();
            ICell cell = row.getCell(TB_VALUE_NUMBER);
            row.getCell(TB_VALUE_NUMBER).setEditor((ICellEditor)this.getAttrValueF7Editor(basicTypeID));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
            cell.setRenderer((IBasicRender)avr);
        }
        if (tableAttrValueInfo != null) {
            row.getCell(TB_VALUE_ID).setValue((Object)tableAttrValueInfo.getId());
            row.getCell(TB_VALUE_NUMBER).setValue((Object)tableAttrValueInfo.getNumber());
            row.getCell(TB_VALUE_NUMBER).setUserObject((Object)tableAttrValueInfo);
            row.getCell(TB_VALUE_NAME).setValue((Object)tableAttrValueInfo.getName());
        }
    }

    private KDTDefaultCellEditor getAttrValueF7Editor(String basicTypeID) throws ParserException {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.AsstAttrValueF7Query");
        promptBox.setCommitFormat("$number$");
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$number$");
        promptBox.setEntityViewInfo(new EntityViewInfo("where basictypeid='" + basicTypeID + "'"));
        promptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AsstAttrValueAddUI.this.attrValueChanged(eventObj);
            }
        });
        return new KDTDefaultCellEditor((IKDEditor)promptBox);
    }

    private void attrValueChanged(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue != null && newValue instanceof AsstAttrValueInfo) {
            AsstAttrValueInfo valueInfo = (AsstAttrValueInfo)newValue;
            int rowIndex = this.kDTable1.getEditManager().getEditRowIndex();
            this.kDTable1.getCell(rowIndex, TB_VALUE_ID).setValue((Object)valueInfo.getId());
            this.kDTable1.getCell(rowIndex, TB_VALUE_NUMBER).setUserObject((Object)valueInfo);
            this.kDTable1.getCell(rowIndex, TB_VALUE_NAME).setValue((Object)valueInfo.getName());
            this.uiValueCollection.set(rowIndex, valueInfo);
            this.isChanged = true;
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.checkAttrValue();
        this.isConfirmed = true;
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isConfirmed = false;
        this.disposeUIWindow();
    }

    private void checkAttrValue() throws Exception {
        for (int i = 0; i < this.uiValueCollection.size(); ++i) {
            if (!this.uiValueCollection.get(i).getNumber().equals("")) continue;
            throw new AsstAttrException(AsstAttrException.COMPONDINGTYPE_VALUE_ISNOT_INTEGRITY);
        }
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public AsstAttrValueCollection getValueCollection() {
        return this.uiValueCollection;
    }

    public AsstAttrValueInfo getComValueInfo() {
        AsstAttrValueInfo comAttrValueInfo = new AsstAttrValueInfo();
        StringBuffer valueNumber = new StringBuffer();
        StringBuffer valueName = new StringBuffer();
        StringBuffer type = new StringBuffer();
        if (this.uiDetailCollection.size() != this.uiValueCollection.size()) {
            return comAttrValueInfo;
        }
        for (int i = 0; i < this.uiDetailCollection.size(); ++i) {
            AsstAttrCompondingTypeDetailInfo detailInfo = this.uiDetailCollection.get(i);
            AsstAttrValueInfo simpleValueInfo = this.uiValueCollection.get(i);
            String mappingField = detailInfo.getBasictype().getMappingField();
            comAttrValueInfo.setString(mappingField, simpleValueInfo.getId().toString());
            if (i != 0) {
                valueNumber.append(AsstAttrSeparator.get());
                valueName.append(AsstAttrSeparator.get());
                type.append(AsstAttrSeparator.get());
            }
            valueNumber.append(simpleValueInfo.getNumber());
            valueName.append(simpleValueInfo.getName());
            type.append(detailInfo.getBasictype().getName());
        }
        comAttrValueInfo.setNumber(valueNumber.toString());
        comAttrValueInfo.setName(valueName.toString());
        comAttrValueInfo.setType(type.toString());
        return comAttrValueInfo;
    }
}

