/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.eas.basedata.framework.client.AbstractMasterDataAttributeListUIHelper;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.client.MaterialCompanyListUI;
import com.kingdee.eas.basedata.master.material.util.commonUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.ITableSelectionHelper;
import com.kingdee.eas.framework.batchaction.service.TableSelectionHelper;
import com.kingdee.eas.framework.client.ListUI;
import java.util.HashMap;

public class MaterialCompanyUIHelper
extends AbstractMasterDataAttributeListUIHelper {
    TableSelectionHelper tableSelectionHelper;

    public MaterialCompanyUIHelper(OrgType mainOrgType) {
        super(mainOrgType);
    }

    protected ListUI createListUI() throws Exception {
        this.ui = new MaterialCompanyListUI();
        return this.ui;
    }

    public String getNumberColumns() {
        String sColumns = "AssitInfo.createCOByOrder";
        return sColumns;
    }

    public void initCtrl(ListUI listUI) {
        listUI.getMainTable().addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                MaterialCompanyUIHelper.this.setCompanyDynCostPrecision(e.getFirstRow(), e.getLastRow());
            }
        });
    }

    public String getOnloadPermItemName() {
        return "bd_materialCom_view";
    }

    private void setCompanyDynCostPrecision(int begin, int last) {
        KDTable tblMain = this.ui.getMainTable();
        for (int rowIndex = begin; rowIndex < last + 1; ++rowIndex) {
            Integer pricePrecision = (Integer)tblMain.getRow(rowIndex).getCell("pricePrecision").getValue();
            ICell cell = tblMain.getRow(rowIndex).getCell("AssitInfo.standardCost");
            if (cell == null || pricePrecision == null) continue;
            cell.getStyleAttributes().setNumberFormat(commonUtils.getNumberFormat(pricePrecision, true));
        }
    }

    public Class getClzIBizFactory(ActionLevelEnum actionLevel) {
        return MaterialCompanyInfoFactory.class;
    }

    public ITableSelectionHelper getTableSelectionHelper() {
        if (this.tableSelectionHelper == null) {
            this.tableSelectionHelper = new TableSelectionHelper(this.ui);
            this.tableSelectionHelper.setTableProperty(this.getMainListUI(), this.getMainListUI().getMainQueryPK(), this.getMainListUI().getMainTable(), "assid", null, "number", null, "CU.id");
            HashMap<String, String> col2query = new HashMap<String, String>();
            col2query.put("assid", "AssitInfo.id");
            this.tableSelectionHelper.setColMapQueryName(col2query);
        }
        return this.tableSelectionHelper;
    }

    public String getActionMethod(BatchActionEnum actionEnum) {
        if (actionEnum.equals((Object)BatchActionEnum.AUDIT)) {
            return "approve";
        }
        if (actionEnum.equals((Object)BatchActionEnum.UNAUDIT)) {
            return "unApprove";
        }
        if (actionEnum.equals((Object)BatchActionEnum.DISABLE)) {
            return "freeze";
        }
        if (actionEnum.equals((Object)BatchActionEnum.ENABLE)) {
            return "unFreeze";
        }
        return null;
    }
}

