/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialGroupF7UI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class MaterialGroupF7UI
extends AbstractMaterialGroupF7UI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialGroupF7UI.class);
    private ITreeBuilder treeBuilder;
    protected boolean isCanceled = true;
    protected MaterialGroupInfo materialGroupInfo = null;
    private CtrlUnitInfo curCtrlUnitInfo = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.tGroupTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof MaterialGroupInfo) {
            this.materialGroupInfo = (MaterialGroupInfo)treeNode.getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CU");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initTree();
    }

    private void initTree() throws Exception {
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getDefaultFilterForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode((Object)this.getRootName());
            ((DefaultTreeModel)this.tGroupTree.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.tGroupTree.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.tGroupTree);
        this.tGroupTree.setShowPopMenuDefaultItem(true);
    }

    @Override
    protected void tGroupTree_mouseClicked(MouseEvent e) throws Exception {
        KDTreeNode treeNode;
        if (e.getClickCount() == 2 && (treeNode = (KDTreeNode)this.tGroupTree.getLastSelectedPathComponent()) != null && treeNode.getUserObject() instanceof MaterialGroupInfo) {
            this.materialGroupInfo = (MaterialGroupInfo)treeNode.getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"material");
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private ITreeBase getTreeInterface() throws Exception {
        return MaterialGroupFactory.getRemoteInstance();
    }

    private int getTreeInitialLevel() {
        return 3;
    }

    private int getTreeExpandLevel() {
        return 3;
    }

    private MaterialGroupStandardInfo getBaseMaterialGroupStandard() {
        try {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection coll = iMaterialGroupStandard.getBaseMaterialGroupStandardColl();
            if (coll != null && coll.size() != 0) {
                return coll.get(0);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return null;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
        MaterialGroupStandardInfo standard = this.getBaseMaterialGroupStandard();
        if (standard != null && standard.getId() != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard", (Object)standard.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
            try {
                filterInfoCU.mergeFilter(filterInfo, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filterInfoCU;
    }
}

