/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.PageEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialOrgByMatUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class MaterialOrgByMatUI
extends AbstractMaterialOrgByMatUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialOrgByMatUI.class);
    private int currentPKIndex = -1;
    private ArrayList idList;
    public final String strTakeOutZeroFormat = "%{0.##########}f";
    public final String strNumFormatForTwo = "%{0.##}f";
    public final String strNumFormatForFour = "%{0.####}f";
    public final String strNumFormatForSix = "%{0.######}f";
    protected CommonQueryDialog cqd;
    protected int page = -1;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cmbPropertySelect_itemStateChanged(ItemEvent e) throws Exception {
        this.query();
    }

    @Override
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialID(6);
        this.query();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialID(9);
        this.query();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialID(8);
        this.query();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.changeMaterialID(7);
        this.query();
    }

    @Override
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.idList = (ArrayList)this.getUIContext().get("idList");
        this.getPKIndex(this.getUIContext().get("currentPK"));
        MaterialClientTools.setEnumToCmb((JComboBox)this.cmbPropertySelect);
        this.cmbPropertySelect.setSelectedIndex(0);
        this.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialFIForOUQuery");
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.query();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.query();
    }

    private void query() throws EASBizException, BOSException {
        String queryName = "";
        if (this.page != ((PageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue()) {
            this.cqd = null;
            this.innerFilter = null;
        }
        this.page = ((PageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue();
        switch (this.page) {
            case 1: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialFIForOUQuery";
                break;
            }
            case 5: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialCostForOUQuery";
                break;
            }
            case 2: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialPurForOUQuery";
                break;
            }
            case 3: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialSalesForOUQuery";
                break;
            }
            case 4: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialInvForOUQuery";
                break;
            }
            case 6: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialPlanForOUQuery";
                break;
            }
            case 7: {
                queryName = "com.kingdee.eas.basedata.master.material.app.MaterialProfitForOUQuery";
            }
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String materialId = this.getCurrentPK();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialId));
        env.setFilter(filter);
        this.setEntityViewInfo(env);
        this.setQueryInfo(queryName);
        this.setMaterialInfo(materialId);
        this.refresh();
        this.setStandardCostPrecision();
        this.setColumnFormat(this.page);
        this.hideColumn(this.page);
        this.setChangeRecordButton();
        int colOrg = this.page == 7 ? this.table.getColumnIndex("profit.name") : this.table.getColumnIndex("orgUnit.name");
        this.table.getViewManager().setFreezeView(0, colOrg + 1);
        KDTSortManager sortManager = new KDTSortManager(this.table);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(2);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setSortable(true);
        }
    }

    private void setColumnFormat(int page) {
        switch (page) {
            case 1: {
                this.table.getColumn("FIInfo.standardCost").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
                break;
            }
            case 2: {
                this.table.getColumn("Purchasing.price").getStyleAttributes().setNumberFormat("%{0.######}f");
                this.table.getColumn("Purchasing.priceTop").getStyleAttributes().setNumberFormat("%{0.######}f");
                break;
            }
            case 3: {
                this.table.getColumn("Sales.lowerQuantity").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("Sales.price").getStyleAttributes().setNumberFormat("%{0.######}f");
                break;
            }
            case 4: {
                this.table.getColumn("Inventory.reBookQty").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("Inventory.consumeSpeed").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("Inventory.fixationBatchQty").getStyleAttributes().setNumberFormat("%{0.####}f");
                break;
            }
            case 6: {
                this.table.getColumn("materialPlan.scrapRate").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.reBookQty").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.consumeSpeed").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.fixationBatchQty").getStyleAttributes().setNumberFormat("%{0.##}f");
                this.table.getColumn("materialPlan.maxBatchQty").getStyleAttributes().setNumberFormat("%{0.##}f");
                this.table.getColumn("materialPlan.minBatchQty").getStyleAttributes().setNumberFormat("%{0.##}f");
                this.table.getColumn("materialPlan.roundUpMulitpleQty").getStyleAttributes().setNumberFormat("%{0.##}f");
                this.table.getColumn("materialPlan.batchIncQty").getStyleAttributes().setNumberFormat("%{0.##}f");
                this.table.getColumn("materialPlan.rptInHightLimit").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.rptInLowLimit").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.rcvInHightLimit").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.rcvInLowLimit").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.issInHightLimit").getStyleAttributes().setNumberFormat("%{0.####}f");
                this.table.getColumn("materialPlan.issInLowLimit").getStyleAttributes().setNumberFormat("%{0.####}f");
            }
        }
    }

    private void setStandardCostPrecision() {
        block5: {
            int page;
            block4: {
                page = ((PageEnum)((Object)this.cmbPropertySelect.getSelectedItem())).getValue();
                if (page != 1) break block4;
                int size = this.table.getRowCount();
                for (int index = 0; index < size; ++index) {
                    if (this.table.getCell(index, "pricePrecision").getValue() == null || this.table.getCell(index, "FIInfo.standardCost").getValue() == null) continue;
                    Object tempobject = null;
                    BigDecimal standardCost = null;
                    tempobject = this.table.getCell(index, "FIInfo.standardCost").getValue();
                    if (StringUtil.isNumber((String)tempobject.toString())) {
                        standardCost = new BigDecimal(tempobject.toString());
                    }
                    int precision = 2;
                    tempobject = this.table.getCell(index, "pricePrecision").getValue();
                    if (StringUtil.isInt((String)tempobject.toString())) {
                        precision = Integer.parseInt(tempobject.toString());
                    }
                    if (standardCost == null) continue;
                    this.table.getCell(index, "FIInfo.standardCost").setValue((Object)standardCost.setScale(precision, 4));
                }
                break block5;
            }
            if (page != 4) break block5;
            String[] strArray = new String[]{"invMultiUnit.baseConvsRate", "Inventory.qtySafety", "Inventory.qtyMin", "Inventory.qtyMax"};
            for (int i = 0; i < strArray.length; ++i) {
                if (this.table.getColumn(strArray[i]) == null) continue;
                this.table.getColumn(strArray[i]).getStyleAttributes().setNumberFormat("%{0.##########}f");
            }
        }
    }

    private void hideColumn(int page) {
        switch (page) {
            case 1: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
                break;
            }
            case 5: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
                break;
            }
            case 2: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
                break;
            }
            case 3: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
                break;
            }
            case 4: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
                break;
            }
            case 6: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
                break;
            }
            case 7: {
                this.table.getColumn("number").getStyleAttributes().setHided(true);
                this.table.getColumn("name").getStyleAttributes().setHided(true);
                this.table.getColumn("model").getStyleAttributes().setHided(true);
            }
        }
    }

    private void changeMaterialID(int changeAction) throws BOSException, EASBizException {
        switch (changeAction) {
            case 6: {
                this.currentPKIndex = 0;
                break;
            }
            case 7: {
                --this.currentPKIndex;
                break;
            }
            case 8: {
                ++this.currentPKIndex;
                break;
            }
            case 9: {
                if (this.idList == null) {
                    return;
                }
                if (this.idList.size() == 0) {
                    return;
                }
                this.currentPKIndex = this.idList.size() - 1;
            }
        }
    }

    private void setChangeRecordButton() {
        if (this.idList == null) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else if (this.idList.size() <= 1) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else if (this.currentPKIndex <= 0) {
            this.btnFirst.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        } else if (this.currentPKIndex >= this.idList.size() - 1) {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        } else {
            this.btnFirst.setEnabled(true);
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.btnLast.setEnabled(true);
        }
    }

    private String getCurrentPK() {
        return ((Object[])this.idList.get(this.currentPKIndex))[0].toString();
    }

    private void getPKIndex(Object pk) {
        if (pk == null) {
            this.currentPKIndex = 0;
        } else {
            this.currentPKIndex = -1;
            for (int i = 0; i < this.idList.size(); ++i) {
                Object[] pks = (Object[])this.idList.get(i);
                if (!pk.toString().equals(pks[0].toString())) continue;
                this.currentPKIndex = i;
                return;
            }
        }
    }

    private void setMaterialInfo(String pk) throws BOSException, EASBizException {
        IMaterial iMat = MaterialFactory.getRemoteInstance();
        MaterialInfo info = iMat.getMaterialInfo((IObjectPK)new ObjectUuidPK(pk));
        this.txtNumber.setText(info.getNumber());
        this.txtName.setText(info.getName());
        this.txtModel.setText(info.getModel());
    }

    @Override
    protected void dataFilter() {
        if (this.queryInfo == null) {
            return;
        }
        Object tempViewInfo = null;
        if (this.cqd == null) {
            this.cqd = new CommonQueryDialog();
            this.cqd.setOwner((Component)((Object)this));
            this.cqd.setQueryObjectPK((IMetaDataPK)new MetaDataPK(this.queryInfo.getPackage(), this.queryInfo.getName()));
            this.cqd.setWidth(480);
            this.cqd.setParentUIClassName("CommonF7_" + this.queryInfo.getFullName());
            if (this.innerFilter != null) {
                this.cqd.setEntityViewInfo(this.innerFilter);
            }
        }
        if (this.cqd.show()) {
            this.innerFilter = this.cqd.getEntityViewInfoResult();
            this.rowSet = null;
            this.refreshData(true);
        }
    }
}

