/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.ConvsRelationEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MeasureUnitTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.client.AbstractMultiMeasureUnitEditUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MultiMeasureUnitEditUI
extends AbstractMultiMeasureUnitEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MultiMeasureUnitEditUI.class);
    public MaterialInfo materialInfo = null;
    protected BigDecimal MAXVAL = new BigDecimal("999999999999999999.99999");
    protected BigDecimal ZERO = new BigDecimal("0.00");
    protected BigDecimal MINVAL = new BigDecimal("-999999999999999999.99999");
    protected BigDecimal MAXINTVAL = new BigDecimal("9999999999");
    protected BigDecimal MAXPRECISION = new BigDecimal("8");
    private int FIXROWS = 2;
    String resClassName = "com.kingdee.eas.basedata.assistant.client.assistantResource";
    private IMeasureUnit iMeasureunit = MeasureUnitFactory.getRemoteInstance();

    public String getUITitle() {
        String strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_Titile");
        return strTitle;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            int i;
            MaterialInfo minfo = (MaterialInfo)this.getUIContext().get("materialInfo");
            IMaterial imat = MaterialFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseUnit.*"));
            sic.add(new SelectorItemInfo("assistUnit.*"));
            sic.add(new SelectorItemInfo("seqUnit.*"));
            this.materialInfo = imat.getMaterialInfo((IObjectPK)new ObjectUuidPK(minfo.getId()), sic);
            if (this.materialInfo == null || this.materialInfo.getId() == null) {
                return;
            }
            this.txtMaterialName.setText(this.materialInfo.getName());
            this.txtMaterialNumber.setText(this.materialInfo.getNumber());
            this.txtMode.setText(this.materialInfo.getModel());
            this.bizPromptBaseUnit.setData((Object)this.materialInfo.getBaseUnit());
            IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getRemoteInstance();
            String strMaterialId = this.materialInfo.getId().toString().trim();
            MultiMeasureUnitCollection collection = iMultiMeasureUnit.getDataByMaterial(strMaterialId);
            this.tabDetail.removeRows();
            IRow iRow = null;
            BOSUuid baseUnitId = null;
            BOSUuid assistUnitId = null;
            BOSUuid seqUnitId = null;
            if (this.materialInfo.getBaseUnit() != null) {
                baseUnitId = this.materialInfo.getBaseUnit().getId();
            }
            if (this.materialInfo.getAssistUnit() != null) {
                assistUnitId = this.materialInfo.getAssistUnit().getId();
            }
            if (this.materialInfo.getSeqUnit() != null) {
                seqUnitId = this.materialInfo.getSeqUnit().getId();
            }
            ArrayList<MultiMeasureUnitInfo> measureUnitInfoList = new ArrayList<MultiMeasureUnitInfo>();
            MultiMeasureUnitInfo baseUnitInfo = null;
            MultiMeasureUnitInfo assistUnitInfo = null;
            MultiMeasureUnitInfo seqUnitInfo = null;
            if (collection != null && collection.size() > 0) {
                MultiMeasureUnitInfo aMultiMeasureUnitInfo;
                for (i = 0; i < collection.size(); ++i) {
                    aMultiMeasureUnitInfo = collection.get(i);
                    if (baseUnitId != null && aMultiMeasureUnitInfo.getMeasureUnit().getId().equals((Object)baseUnitId)) {
                        baseUnitInfo = aMultiMeasureUnitInfo;
                    }
                    if (assistUnitId != null && aMultiMeasureUnitInfo.getMeasureUnit().getId().equals((Object)assistUnitId)) {
                        assistUnitInfo = aMultiMeasureUnitInfo;
                    }
                    if (seqUnitId == null || !aMultiMeasureUnitInfo.getMeasureUnit().getId().equals((Object)seqUnitId)) continue;
                    seqUnitInfo = aMultiMeasureUnitInfo;
                }
                if (baseUnitInfo != null) {
                    collection.remove(baseUnitInfo);
                    measureUnitInfoList.add(baseUnitInfo);
                }
                if (assistUnitInfo != null) {
                    collection.remove(assistUnitInfo);
                    measureUnitInfoList.add(assistUnitInfo);
                }
                if (seqUnitInfo != null && seqUnitInfo.getId() != null && baseUnitInfo != null && !seqUnitInfo.getId().equals((Object)baseUnitInfo.getId())) {
                    collection.remove(seqUnitInfo);
                    measureUnitInfoList.add(seqUnitInfo);
                }
                this.FIXROWS = measureUnitInfoList.size();
                for (i = 0; i < this.FIXROWS; ++i) {
                    aMultiMeasureUnitInfo = (MultiMeasureUnitInfo)measureUnitInfoList.get(i);
                    iRow = this.tabDetail.addRow(i);
                    this.fillDataToTable(iRow, aMultiMeasureUnitInfo);
                }
                for (i = this.FIXROWS; i < collection.size() + this.FIXROWS; ++i) {
                    aMultiMeasureUnitInfo = collection.get(i - this.FIXROWS);
                    iRow = this.tabDetail.addRow(i);
                    this.fillDataToTable(iRow, aMultiMeasureUnitInfo);
                }
            }
            for (i = 0; i < this.FIXROWS; ++i) {
                this.LockRow(i);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void LockRow(int row) {
        IRow iRow = this.tabDetail.getRow(row);
        iRow.getCell("measureUnit").getStyleAttributes().setLocked(true);
        iRow.getCell("qtyPrecision").getStyleAttributes().setLocked(false);
        if (row == 0) {
            iRow.getCell("baseConvsRate").getStyleAttributes().setLocked(true);
        } else {
            iRow.getCell("baseConvsRate").getStyleAttributes().setLocked(false);
        }
        iRow.getCell("convsUnit").getStyleAttributes().setLocked(true);
        iRow.getCell("isUseConvsUnit").getStyleAttributes().setLocked(true);
        iRow.getCell("isBasicUnit").getStyleAttributes().setLocked(true);
        iRow.getCell("measureUnitType").getStyleAttributes().setLocked(true);
    }

    public void fillDataToTable(IRow iRow, MultiMeasureUnitInfo aMultiMeasureUnitInfo) throws Exception {
        iRow.setUserObject((Object)aMultiMeasureUnitInfo);
        iRow.getCell("measureUnit").setValue((Object)aMultiMeasureUnitInfo.getMeasureUnit());
        iRow.getCell("qtyPrecision").setValue((Object)new Integer(aMultiMeasureUnitInfo.getQtyPrecision()));
        iRow.getCell("baseConvsRate").setValue((Object)aMultiMeasureUnitInfo.getBaseConvsRate());
        iRow.getCell("convsUnit").setValue((Object)aMultiMeasureUnitInfo.getConvsUnit());
        iRow.getCell("isUseConvsUnit").setValue((Object)new Boolean(aMultiMeasureUnitInfo.isIsUseConvsUnit()));
        iRow.getCell("isBasicUnit").setValue((Object)new Boolean(aMultiMeasureUnitInfo.isIsBasicUnit()));
        iRow.getCell("measureUnitType").setValue((Object)aMultiMeasureUnitInfo.getMeasureUnitType());
        iRow.getCell("isStatUnit").setValue((Object)new Boolean(aMultiMeasureUnitInfo.isIsStatUnit()));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tabDetail.checkParsed();
        this.bizPromptBaseUnit.setEnabled(false);
        this.txtMaterialName.setEditable(false);
        this.txtMaterialNumber.setEditable(false);
        this.txtMode.setEditable(false);
        Boolean editEnabled = (Boolean)this.getUIContext().get("editEnabled");
        if (editEnabled.booleanValue()) {
            this.btnAddRow.setEnabled(true);
            this.btnInsertRow.setEnabled(true);
            this.btnDeleteRow.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.tabDetail.getStyleAttributes().setLocked(false);
        } else {
            this.btnAddRow.setEnabled(false);
            this.btnInsertRow.setEnabled(false);
            this.btnDeleteRow.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.tabDetail.getStyleAttributes().setLocked(true);
        }
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddRow.setToolTipText(this.resHelper.getString("btnAddRow.text"));
        this.btnInsertRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnInsertRow.setToolTipText(this.resHelper.getString("btnInsertRow.text"));
        this.btnDeleteRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDeleteRow.setToolTipText(this.resHelper.getString("btnDeleteRow.text"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setToolTipText(this.resHelper.getString("btnSave.text"));
        this.tabDetail.getColumn("seq").getStyleAttributes().setHided(true);
        this.tabDetail.getColumn("isBasicUnit").getStyleAttributes().setHided(true);
        this.tabDetail.getColumn("measureUnitType").getStyleAttributes().setHided(true);
        this.tabDetail.getSelectManager().setSelectMode(2);
        KDBizPromptBox bizPromptMeasureUnit = new KDBizPromptBox();
        bizPromptMeasureUnit.setEditable(true);
        bizPromptMeasureUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        bizPromptMeasureUnit.setDisplayFormat("$number$");
        bizPromptMeasureUnit.setEditFormat("$number$");
        bizPromptMeasureUnit.setCommitFormat("$number$;$name$");
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), bizPromptMeasureUnit);
        this.tabDetail.getColumn("measureUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptMeasureUnit));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$[$name$]"));
        this.tabDetail.getColumn("measureUnit").setRenderer((IBasicRender)avr);
        KDBizPromptBox bizPromptConvsUnit = new KDBizPromptBox();
        bizPromptConvsUnit.setEditable(true);
        bizPromptConvsUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
        bizPromptConvsUnit.setDisplayFormat("$name$");
        bizPromptConvsUnit.setEditFormat("$number$");
        bizPromptConvsUnit.setCommitFormat("$number$");
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), bizPromptConvsUnit);
        this.tabDetail.getColumn("convsUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptConvsUnit));
        ObjectValueRender avr2 = new ObjectValueRender();
        avr2.setFormat((IDataFormat)new BizDataFormat("$number$[$name$]"));
        this.tabDetail.getColumn("convsUnit").setRenderer((IBasicRender)avr2);
        this.tabDetail.getColumn("baseConvsRate").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.getNewFormatTxtField(10, false)));
        this.tabDetail.getColumn("baseConvsRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tabDetail.getColumn("baseConvsRate").getStyleAttributes().setNumberFormat("%{#.##########}f");
        this.tabDetail.getColumn("baseConvsRate").setWidth(150);
        KDFormattedTextField txtField1 = new KDFormattedTextField(0);
        txtField1.setMaximumValue((Comparable)this.MAXPRECISION);
        txtField1.setMinimumValue((Comparable)this.ZERO);
        txtField1.setNegatived(false);
        txtField1.setHorizontalAlignment(4);
        txtField1.setRemoveingZeroInDispaly(true);
        txtField1.setRemoveingZeroInEdit(true);
        this.tabDetail.getColumn("qtyPrecision").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtField1));
        this.tabDetail.getColumn("qtyPrecision").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDCheckBox checkBoxIsUseConvsUnit = new KDCheckBox();
        this.tabDetail.getColumn("isUseConvsUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBoxIsUseConvsUnit));
        this.tabDetail.getColumn("isUseConvsUnit").setWidth(150);
        KDCheckBox checkBoxIsBasicUnit = new KDCheckBox();
        this.tabDetail.getColumn("isBasicUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBoxIsBasicUnit));
        KDCheckBox checkBoxIsStatUnit = new KDCheckBox();
        this.tabDetail.getColumn("isStatUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBoxIsStatUnit));
        this.tabDetail.getColumn("isStatUnit").setWidth(150);
        this.tabDetail.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
                MultiMeasureUnitEditUI.this.tableIsStatUnitChanged(e);
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                MultiMeasureUnitEditUI.this.tableValueChanged(e);
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.tabDetail.addKDTMouseListener(new KDTMouseListener(){
            Boolean editEnabled;
            {
                this.editEnabled = (Boolean)MultiMeasureUnitEditUI.this.getUIContext().get("editEnabled");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableClicked(KDTMouseEvent e) {
                if (!this.editEnabled.booleanValue()) {
                    return;
                }
                try {
                    if (MultiMeasureUnitEditUI.this.tabDetail.getSelectManager().get() != null) {
                        int ibeginRow = MultiMeasureUnitEditUI.this.tabDetail.getSelectManager().get().getBeginRow();
                        int iEndrow = MultiMeasureUnitEditUI.this.tabDetail.getSelectManager().get().getEndRow();
                        if (iEndrow - ibeginRow > 0) {
                            return;
                        }
                        if (ibeginRow != -1) {
                            for (int i = iEndrow; i > ibeginRow - 1; --i) {
                                if (i <= MultiMeasureUnitEditUI.this.FIXROWS - 1) {
                                    MultiMeasureUnitEditUI.this.btnDeleteRow.setEnabled(false);
                                    continue;
                                }
                                MultiMeasureUnitEditUI.this.btnDeleteRow.setEnabled(true);
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    MultiMeasureUnitEditUI.this.handUIException(exc);
                }
            }
        });
        this.loadFields();
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        IRow iRow = null;
        int iRowCount = this.tabDetail.getRowCount();
        iRow = this.tabDetail.addRow(iRowCount);
        if (iRow == null) {
            return;
        }
        MultiMeasureUnitInfo aMultiMeasureUnitInfo = new MultiMeasureUnitInfo();
        aMultiMeasureUnitInfo.setMaterial(this.materialInfo);
        aMultiMeasureUnitInfo.setBaseConvsRate(new BigDecimal("1"));
        aMultiMeasureUnitInfo.setIsUseConvsUnit(false);
        aMultiMeasureUnitInfo.setIsBasicUnit(false);
        aMultiMeasureUnitInfo.setIsStatUnit(false);
        this.fillDataToTable(iRow, aMultiMeasureUnitInfo);
        aMultiMeasureUnitInfo.setMeasureUnitType(MeasureUnitTypeEnum.COMMON);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertRow_actionPerformed(e);
        IRow iRow = null;
        if (this.tabDetail.getSelectManager() == null || this.tabDetail.getSelectManager().get() == null) {
            int iRowCount = this.tabDetail.getRowCount();
            iRow = this.tabDetail.addRow(iRowCount);
        } else {
            int ibeginRow = this.tabDetail.getSelectManager().get().getBeginRow();
            int iRowCount = this.tabDetail.getRowCount();
            iRow = ibeginRow != -1 ? (ibeginRow <= this.FIXROWS - 1 ? this.tabDetail.addRow(this.FIXROWS) : this.tabDetail.addRow(ibeginRow)) : this.tabDetail.addRow(iRowCount);
        }
        MultiMeasureUnitInfo aMultiMeasureUnitInfo = new MultiMeasureUnitInfo();
        aMultiMeasureUnitInfo.setMaterial(this.materialInfo);
        aMultiMeasureUnitInfo.setBaseConvsRate(new BigDecimal("1"));
        aMultiMeasureUnitInfo.setIsUseConvsUnit(false);
        aMultiMeasureUnitInfo.setIsBasicUnit(false);
        aMultiMeasureUnitInfo.setIsStatUnit(false);
        aMultiMeasureUnitInfo.setMeasureUnitType(MeasureUnitTypeEnum.COMMON);
        this.fillDataToTable(iRow, aMultiMeasureUnitInfo);
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteRow_actionPerformed(e);
        if (this.tabDetail.getSelectManager() == null || this.tabDetail.getSelectManager().get() == null) {
            return;
        }
        int ibeginRow = this.tabDetail.getSelectManager().get().getBeginRow();
        int iEndrow = this.tabDetail.getSelectManager().get().getEndRow();
        if (ibeginRow != -1) {
            for (int i = iEndrow; i > ibeginRow - 1 && i > this.FIXROWS - 1; --i) {
                this.tabDetail.removeRow(i);
            }
        }
    }

    public MultiMeasureUnitInfo getBasicUnit(int iRowCount) {
        IRow iRow = null;
        for (int i = 0; i < iRowCount; ++i) {
            iRow = this.tabDetail.getRow(i);
            MultiMeasureUnitInfo aMultiMeasureUnitInfo = (MultiMeasureUnitInfo)iRow.getUserObject();
            Object IsStatUnit = aMultiMeasureUnitInfo.get("isbasicunit");
            if (IsStatUnit == null || !((Boolean)aMultiMeasureUnitInfo.get("isbasicunit")).booleanValue()) continue;
            return aMultiMeasureUnitInfo;
        }
        return null;
    }

    public Boolean checkRateAndPre(MultiMeasureUnitInfo basicUnit, IRow unit) {
        if (basicUnit.get("qtyPrecision").equals(unit.getCell("qtyPrecision").getValue()) && !new Double(basicUnit.get("baseConvsRate").toString()).equals(new Double(unit.getCell("baseConvsRate").getValue().toString()))) {
            return false;
        }
        return true;
    }

    protected final boolean confirmDialog(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)msg));
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        boolean checkFlag = true;
        super.actionSave_actionPerformed(e);
        this.storeFields();
        MultiMeasureUnitCollection collection = new MultiMeasureUnitCollection();
        int iRowCount = this.tabDetail.getRowCount();
        if (iRowCount == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        String strTemp = "";
        String strNo = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_No");
        String strRow = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_Row");
        int seq = 0;
        IRow iRow = null;
        MeasureUnitInfo seqUnit = this.materialInfo.getSeqUnit();
        MultiMeasureUnitInfo basicUnitMeasure = this.getBasicUnit(iRowCount);
        for (int i = 0; i < iRowCount; ++i) {
            Boolean flag;
            MeasureUnitInfo convsUnit;
            iRow = this.tabDetail.getRow(i);
            MultiMeasureUnitInfo aMultiMeasureUnitInfo = (MultiMeasureUnitInfo)iRow.getUserObject();
            if (i == 1) {
                if (!MeasureUnitTypeEnum.ASSIST.equals((Object)((MeasureUnitTypeEnum)((Object)iRow.getCell("measureUnitType").getValue())))) {
                    ++seq;
                } else if (iRow.getCell("isStatUnit").getValue().toString().equals("true")) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"AssistUnitCannotBeStatUnit"));
                    KDCheckBox checkBoxIsStatUnit = new KDCheckBox();
                    this.tabDetail.getColumn("isStatUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)checkBoxIsStatUnit));
                    this.tabDetail.getColumn("isStatUnit").setWidth(150);
                    return;
                }
            }
            aMultiMeasureUnitInfo.setSeq(seq);
            MeasureUnitInfo measureUnit = (MeasureUnitInfo)iRow.getCell("measureUnit").getValue();
            if (measureUnit == null) {
                strTemp = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Mult_Not_Nulli_MeasureUnit");
                if (sb.toString().length() == 0) {
                    sb.append(strNo + (i + 1) + strRow + strTemp);
                    continue;
                }
                sb.append(";");
                sb.append(strNo + (i + 1) + strRow + strTemp);
                continue;
            }
            aMultiMeasureUnitInfo.setMeasureUnit(measureUnit);
            Integer qtyPrecision = (Integer)iRow.getCell("qtyPrecision").getValue();
            if (qtyPrecision == null || qtyPrecision < 0) {
                strTemp = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_Precision_Invalide");
                if (sb.toString().length() == 0) {
                    sb.append(strNo + (i + 1) + strRow + strTemp);
                } else {
                    sb.append(";");
                    sb.append(strNo + (i + 1) + strRow + strTemp);
                }
            } else {
                aMultiMeasureUnitInfo.setQtyPrecision(qtyPrecision);
            }
            BigDecimal baseConvsRate = (BigDecimal)iRow.getCell("baseConvsRate").getValue();
            if (baseConvsRate == null || baseConvsRate.compareTo(this.ZERO) != 1) {
                if (i != 0) {
                    strTemp = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_ChangeRate_MorethanZore");
                    if (sb.toString().length() == 0) {
                        sb.append(strNo + (i + 1) + strRow + strTemp);
                    } else {
                        sb.append(";");
                        sb.append(strNo + (i + 1) + strRow + strTemp);
                    }
                }
            } else if (seqUnit != null && measureUnit.getId().equals((Object)seqUnit.getId())) {
                boolean isInt = MaterialClientTools.checkBigDecimalIsInt(baseConvsRate);
                if (isInt) {
                    aMultiMeasureUnitInfo.setBaseConvsRate(baseConvsRate);
                } else {
                    strTemp = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SeqUnit_BaseRate_IsInt");
                    if (sb.toString().length() == 0) {
                        sb.append(strNo + (i + 1) + strRow + strTemp);
                    } else {
                        sb.append(";");
                        sb.append(strNo + (i + 1) + strRow + strTemp);
                    }
                }
            } else {
                aMultiMeasureUnitInfo.setBaseConvsRate(baseConvsRate);
            }
            if ((convsUnit = (MeasureUnitInfo)iRow.getCell("convsUnit").getValue()) == null && i > this.FIXROWS - 1) {
                aMultiMeasureUnitInfo.setConvsUnit(null);
            } else {
                aMultiMeasureUnitInfo.setConvsUnit(convsUnit);
            }
            aMultiMeasureUnitInfo.setIsUseConvsUnit((Boolean)iRow.getCell("isUseConvsUnit").getValue());
            if (iRow.getCell("convsRelation").getValue() != null) {
                aMultiMeasureUnitInfo.setConvsRelation((ConvsRelationEnum)((Object)iRow.getCell("convsRelation").getValue()));
            }
            aMultiMeasureUnitInfo.setIsBasicUnit((Boolean)iRow.getCell("isBasicUnit").getValue());
            aMultiMeasureUnitInfo.setIsStatUnit((Boolean)iRow.getCell("isStatUnit").getValue());
            if (aMultiMeasureUnitInfo.getMeasureUnit() == null && aMultiMeasureUnitInfo.getConvsUnit() == null) continue;
            aMultiMeasureUnitInfo.setMeasureUnitType((MeasureUnitTypeEnum)((Object)iRow.getCell("measureUnitType").getValue()));
            String strMsg = EASResource.getString((String)this.resClassName, (String)"qtyEqualButCofNotEquals");
            if (checkFlag && !(flag = this.checkRateAndPre(basicUnitMeasure, iRow)).booleanValue()) {
                checkFlag = false;
                if (!this.confirmDialog(strMsg)) {
                    SysUtil.abort();
                }
            }
            collection.add(aMultiMeasureUnitInfo);
            ++seq;
        }
        if (sb.toString().length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            SysUtil.abort();
        }
        IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getRemoteInstance();
        iMultiMeasureUnit.saveDataByMaterial(collection);
        if (this.getMessageText() == null) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_Titile") + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        }
        this.setShowMessagePolicy(1);
        this.showMessage();
    }

    public void tableIsStatUnitChanged(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        if (this.tabDetail.getSelectManager() == null || this.tabDetail.getSelectManager().get() == null) {
            return;
        }
        int colIsStatUnit = this.tabDetail.getColumnIndex("isStatUnit");
        if (selectCol == colIsStatUnit) {
            for (int i = 0; i < this.tabDetail.getRowCount(); ++i) {
                if (i == selectRow) continue;
                this.tabDetail.getCell(i, colIsStatUnit).setValue((Object)new Boolean(false));
            }
        }
    }

    public void tableValueChanged(KDTEditEvent e) {
        int selectRow = e.getRowIndex();
        int selectCol = e.getColIndex();
        if (selectRow <= this.FIXROWS - 1) {
            this.LockRow(selectRow);
        } else {
            if (this.tabDetail.getSelectManager() == null || this.tabDetail.getSelectManager().get() == null) {
                return;
            }
            IRow iRowSelect = this.tabDetail.getRow(selectRow);
            MeasureUnitInfo aMeasureUnitInfo = (MeasureUnitInfo)iRowSelect.getCell("measureUnit").getValue();
            if (aMeasureUnitInfo != null && aMeasureUnitInfo.getId().toString().length() > 0) {
                String fieldName;
                int iRowCount = this.tabDetail.getRowCount();
                for (int i = 0; i < iRowCount; ++i) {
                    IRow iRow;
                    MeasureUnitInfo bMeasureUnitInfo;
                    if (i == selectRow || (bMeasureUnitInfo = (MeasureUnitInfo)(iRow = this.tabDetail.getRow(i)).getCell("measureUnit").getValue()) == null || !aMeasureUnitInfo.getId().toString().equals(bMeasureUnitInfo.getId().toString())) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_Dup_MeasureUnit"));
                    iRowSelect.getCell("measureUnit").setValue(null);
                }
                MeasureUnitInfo cMeasureUnitInfo = (MeasureUnitInfo)iRowSelect.getCell("convsUnit").getValue();
                if (cMeasureUnitInfo != null && aMeasureUnitInfo.getId().toString().equals(cMeasureUnitInfo.getId().toString())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Multi_ConvUnitEqualMeasureUnit"));
                    iRowSelect.getCell("convsUnit").setValue(null);
                }
                if ("measureUnit".equalsIgnoreCase(fieldName = this.tabDetail.getColumnKey(selectCol))) {
                    try {
                        MeasureUnitInfo resultMeasure = this.iMeasureunit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aMeasureUnitInfo.getId()));
                        if (resultMeasure != null && resultMeasure.getId() != null && resultMeasure.getId().toString().length() > 0) {
                            MaterialInfo materialInfo = (MaterialInfo)this.getUIContext().get("materialInfo");
                            iRowSelect.getCell("qtyPrecision").setValue((Object)new Integer(resultMeasure.getQtyPrecision()));
                            MultiMeasureUnitInfo multiInfo = this.getMultiMeasureUnit(materialInfo, resultMeasure);
                            iRowSelect.getCell("baseConvsRate").setValue((Object)multiInfo.getBaseConvsRate());
                        }
                    }
                    catch (EASBizException e1) {
                        this.handUIException(e1);
                    }
                    catch (BOSException e1) {
                        this.handUIException(e1);
                    }
                }
            }
        }
    }

    private MultiMeasureUnitInfo getMultiMeasureUnit(MaterialInfo info, MeasureUnitInfo unitInfo) throws BOSException, EASBizException {
        MultiMeasureUnitInfo multiInfo = new MultiMeasureUnitInfo();
        if (unitInfo.getCoefficient() != null) {
            MeasureUnitInfo baseUnitInfo = this.iMeasureunit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(info.getBaseUnit().getId()));
            if (baseUnitInfo.getMeasureUnitGroup() != null && unitInfo.getMeasureUnitGroup() != null) {
                if (baseUnitInfo.getMeasureUnitGroup().getId().equals((Object)unitInfo.getMeasureUnitGroup().getId())) {
                    BigDecimal baseConvsRate = unitInfo.getCoefficient().divide(baseUnitInfo.getCoefficient(), 6, 4);
                    if (baseConvsRate.setScale(6, 4).compareTo(new BigDecimal(0.0)) == 0) {
                        multiInfo.setBaseConvsRate(new BigDecimal("1"));
                    }
                    multiInfo.setBaseConvsRate(this.formatBigDecimal(baseConvsRate));
                } else {
                    multiInfo.setBaseConvsRate(new BigDecimal("1"));
                }
            } else {
                multiInfo.setBaseConvsRate(new BigDecimal("1"));
            }
        } else {
            multiInfo.setBaseConvsRate(new BigDecimal("1"));
        }
        return multiInfo;
    }

    public BigDecimal formatBigDecimal(BigDecimal data) {
        String dataString = data.toString();
        if (dataString.indexOf(".") == -1) {
            return data;
        }
        char[] charArray = data.toString().toCharArray();
        int size = charArray.length;
        for (int index = size - 1; index >= 0; --index) {
            if (charArray[index] != '0' && charArray[index] != '.') {
                String subString = dataString.substring(0, index + 1);
                BigDecimal newBigDecimal = new BigDecimal(subString);
                return newBigDecimal;
            }
            if (charArray[index] != '.') continue;
            String subString = dataString.substring(0, index);
            BigDecimal newBigDecimal = new BigDecimal(subString);
            return newBigDecimal;
        }
        return data;
    }

    protected KDFormattedTextField getNewFormatTxtField(int precision, boolean canMinus) {
        KDFormattedTextField txtField = new KDFormattedTextField(1);
        txtField.setPrecision(precision);
        txtField.setMaximumValue((Comparable)this.MAXVAL);
        txtField.setMinimumValue((Comparable)this.ZERO);
        txtField.setNegatived(canMinus);
        txtField.setHorizontalAlignment(4);
        return txtField;
    }
}

