/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CollectJavaLib {
    public StringBuffer sbf = new StringBuffer();
    public ArrayList list = new ArrayList();

    public void collectRootDirectory(File file) {
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                System.out.println(files[i].getName());
            }
        }
    }

    public void collectForMoreFile(File[] files) {
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                this.collect(files[i]);
            }
        }
    }

    public void collect(File file) {
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile() && files[i].getName().endsWith(".jar")) {
                    this.list.add(files[i].getAbsolutePath());
                    continue;
                }
                this.collect(files[i]);
            }
        }
    }

    public String outLibToStr() {
        StringBuffer sbf = new StringBuffer();
        int size = this.list.size();
        sbf.append(";");
        for (int i = 0; i < size; ++i) {
            sbf.append(this.list.get(i));
            sbf.append(";");
        }
        return sbf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeLibFile(String fileName) {
        try {
            StringBuffer sbf = new StringBuffer();
            sbf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sbf.append("<eclipse-userlibraries version=\"1\">\n");
            sbf.append("<library name=\"" + new File(fileName).getName() + "\" systemlibrary=\"false\">\n");
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                sbf.append("<archive path=\"");
                sbf.append(this.list.get(i));
                sbf.append("\"/>\n");
            }
            sbf.append("</library>\n");
            sbf.append("</eclipse-userlibraries>");
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(fileName));
                out.write(sbf.toString());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String version = "705GA";
        File[] files1 = new File[]{new File("V:/client/trd"), new File("V:/common/trd"), new File("V:/server/trd")};
        CollectJavaLib test1 = new CollectJavaLib();
        test1.collectForMoreFile(files1);
        test1.makeLibFile("W:/eas/dev/myuserlibraries/trdlib" + version + ".userlibraries");
        File[] files2 = new File[]{new File("V:/client/bos"), new File("V:/common/bos"), new File("V:/server/bos")};
        CollectJavaLib test2 = new CollectJavaLib();
        test2.collectForMoreFile(files2);
        test2.makeLibFile("W:/eas/dev/myuserlibraries/boslib" + version + ".userlibraries");
        File[] files3 = new File[]{new File("V:/client/eas"), new File("V:/common/eas"), new File("V:/server/eas")};
        CollectJavaLib test3 = new CollectJavaLib();
        test3.collectForMoreFile(files3);
        test3.makeLibFile("W:/eas/dev/myuserlibraries/easlib" + version + ".userlibraries");
        File[] files4 = new File[]{new File("V:/web")};
        CollectJavaLib test4 = new CollectJavaLib();
        test4.collectForMoreFile(files4);
        test4.makeLibFile("W:/eas/dev/myuserlibraries/lib" + version + "_web.userlibraries");
    }
}

