/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.tools.client;

import com.kingdee.eas.basedata.master.material.tools.SqlEditorServerFactory;
import com.kingdee.eas.basedata.master.material.tools.client.Command;
import com.kingdee.eas.basedata.master.material.tools.client.CommandExecutorHelper;
import com.kingdee.eas.basedata.master.material.tools.client.SqlEditorUI;
import com.kingdee.eas.tm.im.util.ExplorerUtil;
import com.kingdee.eas.util.SysUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class CommandExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.tools.client.CommandExecutor");
    SqlEditorUI ui = null;

    protected SqlEditorUI getUi() {
        return this.ui;
    }

    public CommandExecutor(SqlEditorUI ui) {
        this.ui = ui;
    }

    @Command(description="\u6a21\u7cca\u67e5\u627e\u7528dep\u505a\u8fc7\u6269\u5c55\u7684\u5143\u6570\u636e,\u53ef\u4ee5\u68c0\u67e5\u67d0\u4e9b\u5143\u6570\u636e\u662f\u5426\u7528dep\u505a\u8fc7\u6269\u5c55")
    public void search_dep_metas(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String metaName = null;
        metaName = CommandExecutorHelper.getParam(paramMap, "m", true);
        if (CommandExecutorHelper.isEmpty(metaName)) {
            return;
        }
        String ksql = "select * from t_con_dynamicmetadata where upper(fmetadatapk) like '%" + metaName.toUpperCase() + "%'";
        this.ui.executeSQL(ksql.toString(), false);
    }

    @Command(description="\u67e5\u8be2\u5143\u6570\u636e\u52a0\u8f7d\u5217\u8868")
    public void show_meta_list(Map paramMap) throws Exception {
        this.ui.info("Client:" + System.getProperty("metadata.path"));
        Object returnValue = SqlEditorServerFactory.getRemoteInstance().invokeMethod("getMetaPath", null);
        this.ui.info("Server:" + returnValue);
    }

    @Command(description="\u663e\u793a\u7cfb\u7edf\u5c5e\u6027")
    public void show_sys_pro(Map paramMap) throws Exception {
        Object returnValue;
        String propertityName = null;
        this.checkParamBlank(paramMap);
        propertityName = CommandExecutorHelper.getParam(paramMap, "p", true);
        if (CommandExecutorHelper.isEmpty(propertityName)) {
            return;
        }
        String proClient = System.getProperty(propertityName);
        if (proClient != null) {
            this.ui.info("Client:" + proClient);
        }
        if ((returnValue = SqlEditorServerFactory.getRemoteInstance().invokeMethod("getSysProperty", new Object[]{propertityName})) != null) {
            this.ui.info("Server:" + returnValue);
        }
    }

    private void printPro(String propertityName) throws Exception {
        Object returnValue;
        String proClient = System.getProperty(propertityName);
        if (proClient != null) {
            this.ui.info("Client:" + proClient);
        }
        if ((returnValue = SqlEditorServerFactory.getRemoteInstance().invokeMethod("getSysProperty", new Object[]{propertityName})) != null) {
            this.ui.info("Server:" + returnValue);
        }
    }

    @Command(description="\u67e5\u770b\u7c7b\u52a0\u8f7d\u5217\u8868")
    public void show_class_list(Map paramMap) throws Exception {
        this.printPro("java.class.path");
    }

    @Command(description="\u663e\u793aJava\u76f8\u5173\u4fe1\u606f")
    public void show_java_info(Map paramMap) throws Exception {
        this.ui.info("Java Version:");
        this.printPro("java.version");
        this.ui.info("Java Vendor:");
        this.printPro("java.vendor");
        this.ui.info("Java Home:");
        this.printPro("java.home");
        this.ui.info("JVM Version:");
        this.printPro("java.vm.version");
        this.ui.info("JVM Vendor:");
        this.printPro("java.vm.vendor");
        this.ui.info("JVM Name:");
        this.printPro("java.vm.name");
        this.ui.info("Java Class Version:");
        this.printPro("java.class.version");
        this.ui.info("OS Name:");
        this.printPro("os.name");
        this.ui.info("OS Version:");
        this.printPro("os.version");
        this.ui.info("App Directory:");
        this.printPro("user.dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="\u67e5\u770b\u7c7b\u52a0\u8f7d\u8def\u5f84\uff0c\u53ef\u4ee5\u68c0\u67e5\u662f\u5426\u8fdb\u884c\u4e86\u4e8c\u6b21\u5f00\u53d1\u6216\u6253\u4e86\u79c1\u5305")
    public void show_class_path(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        ZipFile jf = null;
        InputStream input = null;
        try {
            String sClassName = null;
            sClassName = CommandExecutorHelper.getParam(paramMap, "c", true);
            if (CommandExecutorHelper.isEmpty(sClassName)) {
                return;
            }
            for (String s : sClassName.split(",")) {
                if (paramMap.containsKey("server")) {
                    Object returnValue = SqlEditorServerFactory.getRemoteInstance().invokeMethod("getCodeSource", new Object[]{s});
                    if (returnValue instanceof Exception) {
                        this.ui.info("An error happends\n" + returnValue);
                        return;
                    }
                    if (!(returnValue instanceof String)) continue;
                    this.ui.info(returnValue.toString());
                    return;
                }
                s = s.replace(".", "/") + ".class";
                this.ui.info("Client class loader:" + ClassLoader.getSystemClassLoader());
                URL url = ClassLoader.getSystemClassLoader().getResource(s);
                if (url == null) {
                    this.ui.info("Class not found!");
                    return;
                }
                String src = url.getFile();
                if (src == null) continue;
                this.ui.info(src);
                src = src.replaceAll("\\\\", "/");
                if (src.indexOf("!") <= -1) continue;
                jf = new JarFile(src.substring(src.indexOf("/"), src.indexOf("!")));
                JarEntry entry = ((JarFile)jf).getJarEntry("META-INF/MANIFEST.MF");
                input = ((JarFile)jf).getInputStream(entry);
                String info = this.readFile(input);
                jf.close();
                this.ui.info(info);
            }
        }
        catch (ZipException e) {
            this.ui.info(e.toString());
        }
        finally {
            if (jf != null) {
                jf.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    private String readFile(InputStream input) throws Exception {
        String returnValue = "";
        InputStreamReader isr = new InputStreamReader(input);
        BufferedReader reader = new BufferedReader(isr);
        String line = "";
        while ((line = reader.readLine()) != null) {
            returnValue = returnValue + line + "\n";
        }
        reader.close();
        return returnValue;
    }

    protected void show_session_active_oracle(Map paramMap) throws Exception {
        String sql = "/*dialect*/ select * from v$session where username is not null and status = 'ACTIVE' order by logon_time, sid";
        this.ui.executeSQL(sql.toString(), false);
    }

    @Command(description="\u67e5\u8be2\u6d3b\u52a8\uff08\u5835\u585e\uff09\u7684\u4f1a\u8bdd")
    public void show_session_active(Map paramMap) throws Exception {
        CommandExecutorHelper.dbTypeRouter(this, "show_session_active", paramMap);
    }

    protected void show_sql_active_oracle(Map paramMap) throws Exception {
        String sql = "/*dialect*/ select s2.*,s1.sid,s1.serial#,s1.username,osuser,machine from v$session s1 inner join v$sqlarea s2 on s1.sql_id=s2.sql_id where username is not null and status = 'ACTIVE' order by logon_time desc";
        this.ui.executeSQL(sql.toString(), false);
    }

    @Command(description="\u67e5\u8be2\u6d3b\u52a8\uff08\u5835\u585e\uff09\u7684sql")
    public void show_sql_active(Map paramMap) throws Exception {
        CommandExecutorHelper.dbTypeRouter(this, "show_sql_active", paramMap);
    }

    protected void analyze_oracle(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        if (paramMap.containsKey("all")) {
            Map datacenterMap = (Map)SqlEditorServerFactory.getRemoteInstance().invokeMethod("getDatacenterMap", null);
            String dbuser = (String)datacenterMap.get("dbuser");
            if (dbuser == null || "".equals(dbuser)) {
                return;
            }
            String sql = "/*dialect*/ begin dbms_utility.analyze_schema('" + dbuser.toUpperCase() + "','COMPUTE'); end;";
            this.ui.executeSQL(sql.toString(), false);
            return;
        }
        String sTables = null;
        sTables = CommandExecutorHelper.getParam(paramMap, "t", true);
        if (CommandExecutorHelper.isEmpty(sTables)) {
            return;
        }
        for (String s : sTables.split(",")) {
            String sql = "/*dialect*/ analyze table " + s.trim() + " compute statistics";
            this.ui.info("start to analyze " + s.trim() + "...");
            this.ui.executeSQL(sql.toString(), false);
        }
    }

    @Command(description="\u6570\u636e\u5e93\u7edf\u8ba1\u5206\u6790")
    public void analyze(Map paramMap) throws Exception {
        CommandExecutorHelper.dbTypeRouter(this, "analyze", paramMap);
    }

    @Command(description="\u67e5\u8be2\u6570\u636e\u5e93\u7248\u672c\u4fe1\u606f")
    public void show_db_version(Map paramMap) throws Exception {
        CommandExecutorHelper.dbTypeRouter(this, "show_db_version", paramMap);
    }

    protected void show_db_version_oracle(Map paramMap) throws Exception {
        StringBuffer sql = new StringBuffer("/*dialect*/ ");
        sql.append("select banner from sys.v_$version");
        this.ui.executeSQL(sql.toString(), false);
    }

    protected void show_db_version_sqlServer(Map paramMap) throws Exception {
        StringBuffer sql = new StringBuffer("/*dialect*/ ");
        sql.append("select @@version");
        this.ui.executeSQL(sql.toString(), false);
    }

    protected void show_db_version_db2(Map paramMap) throws Exception {
        StringBuffer sql = new StringBuffer("/*dialect*/ ");
        sql.append("select * from sysibm.sysversions");
        this.ui.executeSQL(sql.toString(), false);
    }

    @Command(description="\u663e\u793a\u547d\u4ee4\u884c\u652f\u6301\u5de5\u5177\u76f8\u5173\u4fe1\u606f")
    public void info(Map paramMap) {
        this.ui.info(this.ui.getStringFromFile("doc/_info.txt"));
    }

    private void checkParamBlank(Map paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            this.ui.info("Parameter for this command is required");
            SysUtil.abort();
            return;
        }
    }

    @Command(description="\u67e5\u770b\u8868\u5b9a\u4e49")
    public void show_table_def(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String tableName = null;
        tableName = CommandExecutorHelper.getParam(paramMap, "t", true);
        if (CommandExecutorHelper.isEmpty(tableName)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SHOW COLUMNS FROM " + tableName.toUpperCase());
        this.ui.executeSQL(sql.toString(), false);
    }

    @Command(description="\u67e5\u770b\u7d22\u5f15")
    public void show_index(Map paramMap) throws Exception {
        CommandExecutorHelper.dbTypeRouter(this, "show_index", paramMap);
    }

    protected void show_index_oracle(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String tableName = null;
        tableName = CommandExecutorHelper.getParam(paramMap, "t", true);
        if (CommandExecutorHelper.isEmpty(tableName)) {
            return;
        }
        StringBuffer sql = new StringBuffer("/*dialect*/ ");
        sql.append("select * from user_ind_columns  where table_name=upper('" + tableName.toUpperCase() + "') order by index_name,column_position");
        this.ui.executeSQL(sql.toString(), false);
    }

    protected void show_index_sqlServer(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String tableName = null;
        tableName = CommandExecutorHelper.getParam(paramMap, "t", true);
        if (CommandExecutorHelper.isEmpty(tableName)) {
            return;
        }
        StringBuffer sql = new StringBuffer("/*dialect*/ ");
        sql.append("SELECT sysobjects.name tablename,sysindexes.name indexnae,syscolumns.name columnname,key_ordinal FROM  sys.index_columns,sysobjects,sysindexes,syscolumns  where sys.index_columns.object_id = sysobjects.id and sys.index_columns.index_id = sysindexes.indid and sys.index_columns.object_id = sysindexes.id and sys.index_columns.column_id = syscolumns.colid and sys.index_columns.object_id = syscolumns.id and upper(sysobjects.name)= '" + tableName.toUpperCase() + "' order by sysobjects.name,sysindexes.name ,key_ordinal");
        this.ui.executeSQL(sql.toString(), false);
    }

    protected void show_index_db2(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String tableName = null;
        tableName = CommandExecutorHelper.getParam(paramMap, "t", true);
        if (CommandExecutorHelper.isEmpty(tableName)) {
            return;
        }
        StringBuffer sql = new StringBuffer("/*dialect*/ ");
        sql.append("SELECT * FROM SYSIBM.SYSINDEXES where UCASE(tbname)='" + tableName.toUpperCase() + "' order by name");
        this.ui.executeSQL(sql.toString(), false);
    }

    @Command(description="\u6839\u636ekey\u503c\u83b7\u53d6SQL")
    public void getsql(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String key = CommandExecutorHelper.getParam(paramMap, "k", true);
        if (CommandExecutorHelper.isEmpty(key)) {
            return;
        }
        String sql = this.ui.getStringFromFile("sql/" + key + "_ksql.sql");
        String suffix = null;
        if (CommandExecutorHelper.isEmpty(sql)) {
            int dbType = this.ui.getDBType();
            if (dbType == 7 || dbType == 8 || dbType == 2) {
                suffix = "_oracle";
            } else if (dbType == 3) {
                suffix = "_sqlServer";
            } else if (dbType == 1) {
                suffix = "_db2";
            }
            if (suffix != null) {
                sql = this.ui.getStringFromFile("sql/" + key + suffix + ".sql");
            }
        }
        if (sql == null || "".equals(sql)) {
            this.ui.info("NO sql is founded!");
            return;
        }
        int selStart = this.ui.getSqlEditor().getSelectionStart();
        this.ui.getSqlEditor().replaceSelection(sql);
        this.ui.getSqlEditor().setSelectionStart(selStart);
        if (suffix == null) {
            this.ui.info("K-sql is founded,You can execute it by clicking \"F5\"!");
        } else {
            this.ui.info("Dialect sql is founded!You can execute it by clicking \"CTRL+E\"!");
        }
    }

    @Command(description="\u6839\u636ekey\u503c\u83b7\u53d6SQL\u5e76\u7acb\u5373\u6267\u884c")
    public void exesql(Map paramMap) throws Exception {
        this.checkParamBlank(paramMap);
        String key = CommandExecutorHelper.getParam(paramMap, "k", true);
        if (CommandExecutorHelper.isEmpty(key)) {
            return;
        }
        String sql = this.ui.getStringFromFile("sql/" + key + "_ksql.sql");
        String suffix = null;
        if (CommandExecutorHelper.isEmpty(sql)) {
            int dbType = this.ui.getDBType();
            if (dbType == 7 || dbType == 8 || dbType == 2) {
                suffix = "_oracle";
            } else if (dbType == 3) {
                suffix = "_sqlServer";
            } else if (dbType == 1) {
                suffix = "_db2";
            }
            if (suffix != null) {
                sql = this.ui.getStringFromFile("sql/" + key + suffix + ".sql");
            }
        }
        if (sql == null || "".equals(sql)) {
            this.ui.info("NO sql is founded!");
            return;
        }
        if (suffix != null) {
            sql = "/*dialect*/ " + sql;
        }
        this.ui.executeSQL(sql.toString(), false);
    }

    @Command(description="\u663e\u793aJAVA\u5806\u6808")
    public void show_java_dump(Map paramMap) throws Exception {
        String webUrlRoot = this.getWebUrlRoot();
        if (webUrlRoot == null) {
            return;
        }
        if (!ExplorerUtil.isURL((String)webUrlRoot)) {
            logger.error((Object)("involid url:" + webUrlRoot));
            return;
        }
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + webUrlRoot + "/easportal/tools/threaddump.jsp");
    }

    protected String getWebUrlRoot() throws Exception {
        Object returnValue;
        String s1 = System.getProperty("EAS_SERVER");
        s1 = s1.substring(s1.indexOf("//") + 2);
        int endPoint = s1.indexOf(":");
        String url = null;
        if (endPoint >= 0) {
            url = s1.substring(0, s1.lastIndexOf(":"));
        }
        if ((returnValue = SqlEditorServerFactory.getRemoteInstance().invokeMethod("getSysProperty", new Object[]{"cas.client.serverName"})) == null) {
            return null;
        }
        String casServerName = returnValue.toString();
        String port = ":6888";
        if (casServerName.indexOf(":") >= 0) {
            port = casServerName.substring(casServerName.indexOf(":"));
        }
        String serverUrl = "http://" + url + port;
        return serverUrl;
    }

    @Command(description="\u6e05\u9664\u5ba2\u6237\u7aef\u4e0b\u8f7d\u7f13\u5b58\uff0c\u89e6\u53d1\u6240\u6709\u5ba2\u6237\u7aef\u66f4\u65b0jar\u5305")
    public void clear_client_load_cache(Map paramMap) throws Exception {
        String webUrlRoot = this.getWebUrlRoot();
        if (webUrlRoot == null) {
            return;
        }
        if (!ExplorerUtil.isURL((String)webUrlRoot)) {
            logger.error((Object)("involid url:" + webUrlRoot));
            return;
        }
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + webUrlRoot + "/easupdater/clear");
    }
}

