/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.tools.client;

import com.kingdee.eas.basedata.master.material.tools.client.CommandExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommandExecutorHelper {
    private static final Logger logger = Logger.getLogger(CommandExecutorHelper.class);

    public static String getParam(Map paramMap, String paramName) {
        return CommandExecutorHelper.getParam(paramMap, paramName, false);
    }

    public static String getParam(Map paramMap, String paramName, boolean isDefaultParam) {
        String paramValue = null;
        if (paramMap.get(paramName) != null && !"".equals(paramMap.get(paramName))) {
            paramValue = paramMap.get(paramName).toString();
        } else if (isDefaultParam && paramMap.size() == 1 && paramMap.containsValue(0)) {
            paramValue = (String)paramMap.keySet().toArray()[0];
        }
        return paramValue;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static void dbTypeRouter(CommandExecutor ce, String curMethodName, Map paramMap) throws Exception {
        int dbType = ce.getUi().getDBType();
        try {
            Method m = null;
            if (dbType == 7 || dbType == 8 || dbType == 2) {
                m = ce.getClass().getDeclaredMethod(curMethodName + "_oracle", Map.class);
            } else if (dbType == 3) {
                m = ce.getClass().getDeclaredMethod(curMethodName + "_sqlServer", Map.class);
            } else if (dbType == 1) {
                m = ce.getClass().getDeclaredMethod(curMethodName + "_db2", Map.class);
            } else {
                ce.getUi().info("This command is not supported by this database type(code:" + dbType + ") yet.");
                return;
            }
            m.invoke((Object)ce, paramMap);
        }
        catch (NoSuchMethodException e) {
            ce.getUi().info("This command is not supported by this database type(code:" + dbType + ") yet.");
            return;
        }
        catch (IllegalArgumentException e) {
            ce.getUi().handUIException(e);
        }
        catch (IllegalAccessException e) {
            ce.getUi().handUIException(e);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            if (e1 instanceof Exception) {
                throw (Exception)e1;
            }
            logger.error((Object)e1.getMessage(), e1);
        }
    }
}

