/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.tools.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.util.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlStmtParser;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.core.SqlResult;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.master.material.tools.SqlEditorServerFactory;
import com.kingdee.eas.basedata.master.material.tools.client.BDSQLEditorStyleModel;
import com.kingdee.eas.basedata.master.material.tools.client.Command;
import com.kingdee.eas.basedata.master.material.tools.client.CommandExecutorHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EnvUtils;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.fm.common.client.FMIsqlUI;
import com.kingdee.eas.fm.common.client.FMIsqlUIHandler;
import com.kingdee.eas.fm.common.client.KDTMenuManager;
import com.kingdee.eas.fm.common.client.SQLStmtInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ScriptUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.SwingUtilities;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Undefined;

public class SqlEditorUI
extends FMIsqlUI {
    protected static final int COMMAND_QUERY = 0;
    protected static final int COMMAND_PARAM_QUERY = 1;
    int currentQuery = -1;
    private static final Logger logger = CoreUIObject.getLogger(SqlEditorUI.class);
    protected KDBizPromptBox prmptCommand;
    protected MyDataChangeHandler changeHandler = new MyDataChangeHandler();
    Object oCommandExecutor = null;
    protected int dbType = -1;

    public SqlEditorUI() throws Exception {
        this.jbInit();
        this.initCommandExecutor();
        this.initAssist();
        this.txtScript.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() && e.getKeyCode() == 10) {
                    SqlEditorUI.this.doCommand();
                } else if (e.isAltDown() && e.getKeyCode() == 47) {
                    SqlEditorUI.this.doAssist();
                }
            }
        });
    }

    protected void initAssist() throws Exception {
        IFMIsqlFacade isql = FMIsqlFacadeFactory.getRemoteInstance();
        ArrayList<String> pubMethod = new ArrayList<String>();
        Method[] methods = this.oCommandExecutor.getClass().getMethods();
        isql.executeSql("delete from t_bd_commandlib");
        for (int i = 0; i < methods.length; ++i) {
            StringBuffer sb = new StringBuffer(100);
            Command command = methods[i].getAnnotation(Command.class);
            if (command == null) continue;
            pubMethod.add(methods[i].getName());
            sb.append("insert into T_BD_CommandLib(fid,fname,fdescription) ");
            sb.append(" values (newbosid('F8B05243'),'" + methods[i].getName() + "','" + command.description() + "');\n");
            isql.executeSql(sb.toString());
        }
        this.txtScript.setStyleModel((EditorStyleModel)new BDSQLEditorStyleModel(pubMethod));
        String sqlParam = this.getStringFromFile("sql/init.sql");
        String[] arraySqlParam = sqlParam.split(";");
        for (int i = 0; i < arraySqlParam.length; ++i) {
            isql.executeSql(arraySqlParam[i]);
        }
    }

    protected void doAssist() {
        try {
            String condition;
            if (this.getSqlEditor().getSelectionEnd() - this.getSqlEditor().getSelectionStart() == 0 && !this.doSelect4Assist()) {
                return;
            }
            String sql = this.getSqlEditor().getSelectedText();
            if (sql == null) {
                sql = "";
            }
            if ("".equals(condition = sql.trim())) {
                condition = "%";
            }
            this.prmptCommand.removeDataChangeListener((DataChangeListener)this.changeHandler);
            this.prmptCommand.setText(condition);
            this.prmptCommand.addDataChangeListener((DataChangeListener)this.changeHandler);
            this.prmptCommand.commitEdit();
        }
        catch (ParseException e1) {
            logger.error((Object)e1);
        }
    }

    protected void doCommand() {
        try {
            if (this.getSqlEditor().getSelectionEnd() - this.getSqlEditor().getSelectionStart() != 0) {
                String sql = this.getSql();
                if (EmptyUtil.isEmpty((String)sql)) {
                    return;
                }
                if (sql.trim().indexOf("@") == 0) {
                    this.doCommandInner();
                } else {
                    this.info("Command simbol '@' is not found");
                }
            } else if (this.doSelect()) {
                this.doCommandInner();
            }
        }
        catch (ClassNotFoundException e1) {
            this.handUIException(e1);
        }
        catch (IllegalAccessException e1) {
            this.handUIException(e1);
        }
        catch (InvocationTargetException e1) {
            this.handUIException(e1);
        }
        catch (InstantiationException e1) {
            this.handUIException(e1);
        }
    }

    protected boolean doSelect() {
        String content = this.getSqlEditor().getText();
        content = content.replaceAll("\r\n", "\n");
        int preEnterPos = content.lastIndexOf("\n", this.getSqlEditor().getSelectionEnd() - 1);
        int startPos = content.lastIndexOf("@", this.getSqlEditor().getSelectionEnd() - 1);
        if (startPos < 0 || startPos < preEnterPos) {
            this.info("Command simbol '@' is not found in this line!");
            return false;
        }
        this.getSqlEditor().setSelectionStart(startPos);
        this.getSqlEditor().setSelectionEnd(this.getSqlEditor().getSelectionEnd());
        return true;
    }

    protected boolean doSelect4Assist() {
        String[] arrayCommand;
        String content = this.getSqlEditor().getText();
        content = content.replaceAll("\r\n", "\n");
        int preEnterPos = content.lastIndexOf("\n", this.getSqlEditor().getSelectionEnd() - 1);
        int startPos = content.lastIndexOf("@", this.getSqlEditor().getSelectionEnd() - 1);
        if (startPos < 0 || startPos < preEnterPos) {
            this.info("Command simbol '@' is not found in this line!");
            return false;
        }
        this.switchQuery4Command();
        String command = content.substring(startPos, this.getSqlEditor().getSelectionEnd());
        if (command.indexOf(" ") >= 0 && !CommandExecutorHelper.isEmpty((arrayCommand = command.split(" "))[0])) {
            startPos = content.indexOf(" ", startPos);
            if (arrayCommand[0].equals("@getsql") || arrayCommand[0].equals("@exesql")) {
                this.switchQuery4Param();
            } else {
                return false;
            }
        }
        this.getSqlEditor().setSelectionStart(startPos + 1);
        this.getSqlEditor().setSelectionEnd(this.getSqlEditor().getSelectionEnd());
        return true;
    }

    private void jbInit() throws Exception {
        this.prmptCommand = new KDBizPromptBox();
        this.prmptCommand.setName("prmptCommand");
        this.prmptCommand.addDataChangeListener((DataChangeListener)this.changeHandler);
        this.prmptCommand.setVisible(false);
        this.prmptCommand.setFilterInfoProducer(new IFilterInfoProducer(){

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public FilterInfo getFilterInfo() {
                return null;
            }
        });
        this.switchQuery4Command();
    }

    private void switchQuery4Command() {
        if (this.currentQuery == 0) {
            return;
        }
        this.prmptCommand.setQueryInfo("com.kingdee.eas.basedata.master.material.tools.app.CommandLibQuery");
        this.prmptCommand.setDisplayFormat("$name$");
        this.prmptCommand.setEditFormat("$name$");
        this.prmptCommand.setCommitFormat("$name$;$description$;");
        this.prmptCommand.setEntityViewInfo(null);
        this.currentQuery = 0;
    }

    private void switchQuery4Param() {
        if (this.currentQuery == 1) {
            return;
        }
        this.prmptCommand.setQueryInfo("com.kingdee.eas.basedata.master.material.tools.app.ParamValueLibQuery");
        this.prmptCommand.setDisplayFormat("$paramValue$");
        this.prmptCommand.setEditFormat("$paramValue$");
        this.prmptCommand.setCommitFormat("$paramValue$;$description$;");
        try {
            this.prmptCommand.setEntityViewInfo(new EntityViewInfo("where commandName='getsql'"));
        }
        catch (ParserException e) {
            this.handleException((Exception)((Object)e));
        }
        this.currentQuery = 1;
    }

    protected void prmptCommand_dataChanged(DataChangeEvent e) {
        this.getSqlEditor().replaceSelection(this.prmptCommand.getText());
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmptCommand.setBounds(new Rectangle(0, 0, 170, 19));
        this.add((Component)this.prmptCommand, null);
    }

    public StyledEditor getSqlEditor() {
        return this.txtScript;
    }

    private String getSql() {
        String txt = this.txtScript.getSelectedText();
        if (EmptyUtil.isEmpty((String)txt)) {
            txt = this.txtScript.getText();
        }
        return txt;
    }

    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        String sql = this.getSql();
        if (EmptyUtil.isEmpty((String)sql)) {
            return;
        }
        this.executeSQL(sql, true);
    }

    private void doCommandInner() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String[] arrayCommandLine = this.getSql().trim().split(" ");
        Hashtable<String, Object> paramMap = new Hashtable<String, Object>();
        if (arrayCommandLine.length > 2) {
            this.info("Invalid command format!");
            return;
        }
        if (arrayCommandLine.length == 2) {
            String paramList = arrayCommandLine[1];
            String[] arrayParamList = paramList.split(";");
            for (int i = 0; i < arrayParamList.length; ++i) {
                if ("".equals(arrayParamList[i])) continue;
                if (arrayParamList[i].endsWith(":") || arrayParamList[i].startsWith(":")) {
                    this.info("Invalid param format '" + arrayParamList[i] + "'");
                    return;
                }
                String[] param = arrayParamList[i].split(":");
                String paramKey = null;
                String paramValue = null;
                if (param.length == 2) {
                    paramKey = param[0];
                    paramValue = param[1];
                    paramMap.put(paramKey, paramValue);
                }
                if (param.length > 2) {
                    this.info("Invalid param format '" + arrayParamList[i] + "'");
                    return;
                }
                if (param.length != 1) continue;
                paramKey = param[0];
                paramMap.put(paramKey, 0);
            }
        }
        try {
            Method m = this.oCommandExecutor.getClass().getMethod(arrayCommandLine[0].substring(1), Map.class);
            if (this.beforeExeCommand(arrayCommandLine[0].substring(1), this, paramMap)) {
                if (m.getModifiers() != 1) {
                    this.info("This command is not exist");
                }
                m.invoke(this.oCommandExecutor, paramMap);
            }
            this.info2("Command '" + arrayCommandLine[0].substring(1) + "' is completed!<<<<<<");
        }
        catch (NoSuchMethodException ee) {
            this.info("This command is not exist");
        }
        catch (InvocationTargetException ee) {
            this.handUIException(ee.getCause());
        }
        catch (Exception ee) {
            this.handleException(ee);
        }
    }

    protected void initCommandExecutor() {
        try {
            Class<?> commandExecutor = Class.forName("com.kingdee.eas.basedata.master.material.tools.client.CommandExecutor");
            this.oCommandExecutor = commandExecutor.getConstructor(SqlEditorUI.class).newInstance(new Object[]{this});
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected boolean beforeExeCommand(String method, SqlEditorUI sqlEditUI, Map paramMap) {
        this.info("Start to execute command '" + method + "'>>>>>>");
        if (paramMap.containsKey("help")) {
            String help_info = this.getStringFromFile("doc/help_" + method + ".txt");
            if (help_info == null) {
                this.error("Help document for this command is not exist");
                return false;
            }
            this.info(help_info);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringFromFile(String url) {
        String result = "";
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(url);
        if (input == null) {
            return null;
        }
        try {
            InputStreamReader reader = new InputStreamReader(input);
            BufferedReader br = new BufferedReader(reader);
            String temp = null;
            while ((temp = br.readLine()) != null) {
                result = result + temp + "\n";
            }
            String string = result;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            this.handUIException(e);
            String string = null;
            return string;
        }
        catch (IOException e) {
            this.handUIException(e);
            String string = null;
            return string;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public KDTextArea getTxtMsg() {
        return this.txtMsg;
    }

    public int getDBType() {
        if (this.dbType == -1) {
            try {
                Object oDBType = SqlEditorServerFactory.getRemoteInstance().invokeMethod("getDBType", null);
                this.dbType = (Integer)oDBType;
            }
            catch (EASBizException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.dbType;
    }

    protected void executeSQL(String sql, boolean tryToEditable) throws BOSException, EASBizException, SQLException {
        SimpleTimer st = new SimpleTimer();
        IFMIsqlFacade isql = FMIsqlFacadeFactory.getRemoteInstance();
        SqlResult rs = null;
        try {
            rs = isql.executeSql(sql);
        }
        catch (BOSException exp) {
            this.fillException((Exception)((Object)exp));
        }
        long time = st.getTime();
        if (rs != null) {
            this.showResult(rs, sql, tryToEditable);
        }
        this.scrpRowsets.repaint();
        this.info2("Sql is executed completely! use time:" + time + "\tend time " + new Date());
    }

    private void showResult(SqlResult rs, String sql, boolean tryToEditable) throws SQLException {
        SQLStmtInfo sqlStmtInfo;
        String nsql = sql;
        if (sql.startsWith("/*dialect*/")) {
            nsql = sql.substring("/*dialect*/".length());
        }
        try {
            Lexer lexer = new Lexer(nsql);
            TokenList _tokList = new TokenList(lexer);
            SqlStmt sqlStmt = new SqlStmtParser(_tokList).stmt();
            sqlStmtInfo = FMIsqlUIHandler.getSQLStmtInfo((SqlStmt)sqlStmt);
        }
        catch (ParserException pe) {
            sqlStmtInfo = new SQLStmtInfo();
            sqlStmtInfo.canAudoUpdate = false;
            sqlStmtInfo.isSelect = false;
        }
        List rowSets = rs.getRowSets();
        if (rowSets == null || rowSets.size() <= 0) {
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        } else if (rowSets.size() > 1) {
            KDPanel pan = new KDPanel();
            pan.setLayout((LayoutManager)new BoxLayout((Container)pan, 1));
            pan.setSize(this.scrpRowsets.getSize());
            this.scrpRowsets.getViewport().add((Component)pan);
            for (int i = 0; i < rowSets.size(); ++i) {
                KDTable table = new KDTable();
                KDTMenuManager tableMenuMgr = new KDTMenuManager(table);
                tableMenuMgr.setTempFile(EnvUtils.getTempDir());
                table.getSelectManager().setSelectMode(15);
                table.getDataRequestManager().setDataRequestMode(0);
                this.fillData(table, (IRowSet)rowSets.get(i), sqlStmtInfo);
                table.setEditable(tryToEditable && sqlStmtInfo.canAudoUpdate);
                table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                    public void editStopped(KDTEditEvent e) {
                        SqlEditorUI.this.table_editStopped(e);
                    }
                });
                pan.add((Component)table);
            }
            this.tabMain.setSelectedComponent((Component)this.scrpRowsets);
        } else if (rowSets.size() == 1) {
            KDTable table = new KDTable();
            KDTMenuManager tableMenuMgr = new KDTMenuManager(table);
            tableMenuMgr.setTempFile(EnvUtils.getTempDir());
            table.getSelectManager().setSelectMode(15);
            table.getDataRequestManager().setDataRequestMode(0);
            this.fillData(table, (IRowSet)rowSets.get(0), sqlStmtInfo);
            table.setEditable(tryToEditable && sqlStmtInfo.canAudoUpdate);
            table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    SqlEditorUI.this.table_editStopped(e);
                }
            });
            this.scrpRowsets.getViewport().add((Component)table);
            this.scrpRowsets.getViewport().setLayout(new GridLayout(rowSets.size(), 1));
            this.tabMain.setSelectedComponent((Component)this.scrpRowsets);
        }
        if (rs.getUpdateCount() > 0) {
            this.info2("update Count:" + rs.getUpdateCount());
        }
    }

    public void info(String msg) {
        if (this.tabMain.getSelectedIndex() != 0) {
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
        this.getTxtMsg().append(msg + "\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SqlEditorUI.this.scrpMsg.getVerticalScrollBar().setValue(SqlEditorUI.this.scrpMsg.getVerticalScrollBar().getMaximum());
            }
        });
    }

    public void error(String msg) {
        this.info(msg);
        SysUtil.abort();
    }

    public void info2(String msg) {
        this.getTxtMsg().append(msg + "\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SqlEditorUI.this.scrpMsg.getVerticalScrollBar().setValue(SqlEditorUI.this.scrpMsg.getVerticalScrollBar().getMaximum());
            }
        });
    }

    public void fillException(Exception exp) {
        logger.error((Object)"", (Throwable)exp);
        this.error(exp.getMessage());
        this.tabMain.setSelectedComponent((Component)this.scrpMsg);
    }

    public void actionGCClient_actionPerformed(ActionEvent e) throws Exception {
        super.actionGCClient_actionPerformed(e);
        String rst = null;
        rst = SqlEditorUI.gc();
        if (rst != null) {
            this.getTxtMsg().append("\nresult :\n" + rst.toString());
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    public void actionGCServer_actionPerformed(ActionEvent e) throws Exception {
        super.actionGCServer_actionPerformed(e);
        IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
        String rst = null;
        try {
            rst = facade.gc();
        }
        catch (BOSException exp) {
            this.fillException((Exception)((Object)exp));
        }
        if (rst != null) {
            this.getTxtMsg().append("\nresult :\n" + rst.toString());
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    public void actionRunScriptClient_actionPerformed(ActionEvent e) throws Exception {
        super.actionRunScriptClient_actionPerformed(e);
        Object rst = null;
        String sql = this.getSql();
        if (EmptyUtil.isEmpty((String)sql)) {
            return;
        }
        try {
            rst = ScriptUtil.evalExpr((String)sql, null);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        if (rst != null) {
            if (rst instanceof Undefined) {
                Undefined new_name = (Undefined)rst;
                rst = new_name.readResolve();
            }
            if (rst instanceof TestResult) {
                TestResult trst = (TestResult)rst;
                Enumeration er = trst.errors();
                while (er.hasMoreElements()) {
                    TestFailure n = (TestFailure)er.nextElement();
                    this.getTxtMsg().append("\nresult :\n" + n.trace());
                }
            }
            this.getTxtMsg().append("\nresult :\n" + rst.toString());
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    public void actionRunScriptServer_actionPerformed(ActionEvent e) throws Exception {
        super.actionRunScriptServer_actionPerformed(e);
        IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
        Object rst = null;
        try {
            String script = this.getSql();
            rst = facade.runScript(script);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        if (rst != null) {
            this.getTxtMsg().append("\nresult :\n" + rst.toString());
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    public void actionTransSql_actionPerformed(ActionEvent e) throws Exception {
        super.actionTransSql_actionPerformed(e);
        IFMIsqlFacade facade = FMIsqlFacadeFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer();
        String script = this.getSql();
        sb.append("ksql:\n" + script);
        sb.append("\n");
        String rst = null;
        try {
            rst = facade.transSql(script, 1);
            sb.append("DB2_UDB:\n" + rst);
            sb.append("\n");
            rst = facade.transSql(script, 3);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        try {
            sb.append("MS_SQL_Server:\n" + rst);
            sb.append("\n");
            rst = facade.transSql(script, 2);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        try {
            sb.append("Oracle:\n" + rst);
            sb.append("\n");
            rst = facade.transSql(script, 7);
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        try {
            sb.append("Oracle9:\n" + rst);
            sb.append("\n");
        }
        catch (Exception exp) {
            this.fillException(exp);
        }
        if (sb != null) {
            this.getTxtMsg().append("\nresult :\n" + sb.toString());
            this.tabMain.setSelectedComponent((Component)this.scrpMsg);
        }
    }

    public void actionExcuteDialect_actionPerformed(ActionEvent e) throws Exception {
        this.excuteDialect(e);
    }

    private void excuteDialect(ActionEvent e) throws Exception {
        String sql = this.getSql();
        if (EmptyUtil.isEmpty((String)sql)) {
            return;
        }
        sql = "/*dialect*/ ".intern() + sql;
        this.executeSQL(sql, true);
    }

    class MyDataChangeHandler
    implements DataChangeListener {
        MyDataChangeHandler() {
        }

        public void dataChanged(DataChangeEvent e) {
            try {
                SqlEditorUI.this.prmptCommand_dataChanged(e);
            }
            catch (Exception exc) {
                SqlEditorUI.this.handUIException(exc);
            }
        }
    }
}

