/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialCostInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialCostUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LowTimer;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialCostUI
extends AbstractMaterialCostUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCostUI.class);
    private HashMap parentCTX = null;
    private String materialID = null;
    EventsListener event = new EventsListener();
    private MaterialInfo material = null;
    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private boolean tag = false;
    private CtrlUnitInfo curCtrlUnitInfo;

    @Override
    protected IObjectValue createNewData() {
        MaterialCostInfo costInfo = new MaterialCostInfo();
        costInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        costInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        costInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        costInfo.setMaterial(this.material);
        costInfo.setStoreType(StoreType.SOURCE_MATERIAL);
        costInfo.setCreateTime(new Timestamp(new Date().getTime()));
        return costInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialCostFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public void loadFields() {
        this.removeEventsListerner();
        super.loadFields();
        this.addEventsListener();
        this.initByInfo();
        this.storeFields();
    }

    private void initByInfo() {
        this.setSubmitSaveButton();
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    private void doInit() {
        this.setPrintEnable();
        this.loadStoreTypeEnum((JComboBox)this.comboStoreType);
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        NewCompanyF7 comF7 = new NewCompanyF7();
        comF7.setIsCUFilter(true);
        comF7.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)comF7);
        this.prmtOrgUnit.setSelector((KDPromptSelector)comF7);
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        this.prmtOrgUnit.setEntityViewInfo(viewInfo);
        this.prmtOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtOrgUnit.setHandleCUFilter(false);
        this.setDefaultCostItemFilter();
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    private void initPrmtExpense() {
        this.prmtExpense.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7ExpenseQuery");
        this.prmtExpense.setDisplayFormat("$name$");
        this.prmtExpense.setEditFormat("$number$");
        this.prmtExpense.setCommitFormat("$number$");
    }

    private void setExpenseItemFilter() {
        CtrlUnitInfo cu = null;
        String cuId = "";
        if (this.prmtOrgUnit.getValue() != null) {
            if (this.prmtOrgUnit.getValue() instanceof FullOrgUnitInfo) {
                FullOrgUnitInfo org = (FullOrgUnitInfo)this.prmtOrgUnit.getValue();
                cu = org.getCU();
                cuId = cu.getId().toString();
            } else {
                cuId = "errorId";
            }
        } else {
            cuId = "errorId";
        }
        String ineerSql = "select FDATABASEDID from t_bd_databasedassign WHERE FBOSOBJECTTYPE = '4A255827' and FASSIGNCUID = '" + cuId + "'";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ineerSql, CompareType.INNER));
        filterInfo.setMaskString("#0 OR #1");
        viewInfo.setFilter(filterInfo);
        this.prmtExpense.setEntityViewInfo(viewInfo);
    }

    private void setDefaultCostItemFilter() {
        EntityViewInfo view = new EntityViewInfo();
        try {
            view.setFilter(CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "adminCU.id"));
            view.getFilter().getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        this.prmtDefaultCostItem.setEntityViewInfo(view);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    private void setCostObjectGroupFilter(String companyid) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial", (Object)this.editData.getMaterial().getId(), CompareType.EQUALS));
        if (companyid != null && !"".equals(companyid)) {
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyid, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            IMaterialCompanyInfo imc = MaterialCompanyInfoFactory.getRemoteInstance();
            MaterialCompanyInfoCollection mcColl = imc.getMaterialCompanyInfoCollection(view);
            EntityViewInfo env = new EntityViewInfo();
            filter = new FilterInfo();
            if (mcColl.size() != 0) {
                if (mcColl.get(0).getAccountType() != null && mcColl.get(0).getAccountType().getValue() == 5) {
                    filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)"4", CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)"4", CompareType.NOTEQUALS));
                }
            }
            filter.getFilterItems().add(new FilterItemInfo("relatedType", (Object)Integer.valueOf(0).toString()));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Integer.valueOf(1).toString()));
            filter.setMaskString("#0 and #1 and #2");
            env.setFilter(filter);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addEventsListener() {
        this.prmtOrgUnit.addChangeListener((ChangeListener)this.event);
        this.comboStoreType.addItemListener((ItemListener)this.event);
    }

    private void removeEventsListerner() {
        this.prmtOrgUnit.removeChangeListener((ChangeListener)this.event);
        this.comboStoreType.removeItemListener((ItemListener)this.event);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        MaterialClientTools.addCloseButton((KDToolBar)this.toolBar, (EditUI)this);
    }

    private void setSubmitSaveButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
                int vostatus = this.editData.getInt("status");
                this.setActionButtonVisible(vostatus);
            } else {
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnCancel.setVisible(false);
                this.menuItemCancel.setVisible(false);
                this.btnCancelCancel.setVisible(false);
                this.menuItemCancelCancel.setVisible(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            return;
        }
        if (this.material != null && this.material.getStatus() == UsedStatusEnum.FREEZED) {
            this.btnAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            if (!this.btnRemove.isVisible()) {
                this.menuItemRemove.setEnabled(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setEnabled(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            return;
        }
        this.btnAddNew.setEnabled(true);
        if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
            int vostatus = this.editData.getInt("status");
            if (vostatus == 0) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(true);
            } else if (vostatus == 1) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.btnCancel.setEnabled(true);
                this.menuItemCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
                this.menuItemCancelCancel.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
            }
            this.setActionButtonVisible(vostatus);
            if (this.material != null && this.material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                this.btnApprove.setEnabled(false);
            }
        } else {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.menuItemCancelCancel.setVisible(false);
            } else if (this.editData != null) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            }
        }
    }

    private void setActionButtonVisible(int vostatus) {
        if (vostatus == 0) {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else if (vostatus == 1) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.menuItemCancelCancel.setVisible(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setSubmitSaveButton();
        this.doFieldPermission();
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCost(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCost(1);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCost(2);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCost(3);
    }

    private void doActionOtherCost(int actionenumvalue) throws Exception {
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
            IMaterialCost icost = (IMaterialCost)this.getBizInterface();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            MaterialClientTools.doActionOtherProperty((int)actionenumvalue, (MaterialPropertyBaseInfo)this.editData, (IMaterialPropertyBase)icost, (IObjectPK)pk, (MaterialInfo)this.material);
            IObjectValue newValue = this.getValue((IObjectPK)pk);
            this.getUIContext().put("InitDataObject", newValue);
            this.setDataObject(newValue);
            this.loadFields();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selects = super.getSelectors();
        selects.add("orgUnit.CU.id");
        selects.add("defaultCostItem");
        selects.add("effectedStatus");
        selects.add("status");
        selects.add("material.*");
        return selects;
    }

    private void loadStoreTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<StoreType> model = new DefaultComboBoxModel<StoreType>();
        Iterator i = StoreType.iterator();
        while (i.hasNext()) {
            StoreType e = (StoreType)i.next();
            if (e.getValue() <= 0) continue;
            model.addElement(e);
        }
        cb.setModel(model);
    }

    protected void comboStoreType_itemStateChanged(ItemEvent e) throws Exception {
    }

    protected void chkCostIsCreateCostObject_itemStateChanged(ItemEvent e) throws Exception {
    }

    public void prmtOrg_stateChanged(ChangeEvent e) throws BOSException {
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.prmtOrgUnit.getValue();
        MaterialCostInfo info = null;
        String orgID = "";
        if (org != null) {
            LowTimer timer = new LowTimer();
            timer.reset();
            orgID = org.getId().toString();
            info = this.getCostInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)orgID, (String)"material.id", (String)this.materialID));
            logger.info((Object)("899\u884c\u8017\u7528\u65f6\u95f4\uff1a" + timer.msValue()));
            this.tag = false;
        }
        if (info == null) {
            info = (MaterialCostInfo)this.createNewData();
            if (org != null) {
                info.setOrgUnit(org.castToFullOrgUnitInfo());
            }
            this.tag = true;
        }
        this.setDataObject((IObjectValue)info);
        this.loadFields();
        this.setExpenseItemFilter();
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (curCtrlUnitInfo.isIsCompanyOrgUnit()) {
            this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    public void onLoad() throws Exception {
        if (this.editData == null) {
            this.parentCTX = MaterialClientTools.getParentCTX((EditUI)this);
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.parentCTX.get("CurrentCtrlUnit");
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.initDefaultOrgUnit(this.curCtrlUnitInfo);
            this.getMaterialID();
            this.getDefaultCostInfo();
        }
        this.doInit();
        super.onLoad();
        this.prmtOrgUnit.setEnabled(true);
        this.prmtOrgUnit.setAccessAuthority(0);
        this.initPrmtExpense();
        this.setExpenseItemFilter();
        this.pkCreateTime.setDatePattern("yyyy-MM-dd");
        this.pkLastUpdateTime.setDatePattern("yyyy-MM-dd");
    }

    protected void loadData() throws Exception {
        if (this.parentCTX != null && this.materialID != null && !this.materialID.equalsIgnoreCase(this.parentCTX.get("ID").toString())) {
            this.getMaterialID();
            this.getDefaultCostInfo();
        }
        this.getMaterialID();
        if ("EDIT".equalsIgnoreCase(this.getOprtState()) || "ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            this.unLockUI();
        }
        super.loadData();
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)pk, this.getMergedSelector());
            this.setDataObject((IObjectValue)info);
            this.loadFields();
        }
        this.tag = false;
    }

    private void getDefaultCostInfo() throws BOSException {
        if (this.materialID != null) {
            MaterialCostInfo comInfo = null;
            MaterialCostCollection colls = null;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.materialID));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("orgunit.id"));
            colls = MaterialCostFactory.getRemoteInstance().getMaterialCostCollection(viewInfo);
            comInfo = this.company == null || this.company.getId() == null ? null : this.getCostInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)this.company.getId().toString(), (String)"material.id", (String)this.materialID));
            if (colls != null) {
                RealModeIDList idLists = new RealModeIDList();
                int currentPKIndex = -1;
                for (int i = 0; i < colls.size(); ++i) {
                    MaterialCostInfo info = colls.get(i);
                    idLists.add(i, info.getId().toString());
                    if (comInfo == null || !info.getOrgUnit().getId().toString().equals(comInfo.getOrgUnit().getId().toString())) continue;
                    currentPKIndex = i;
                    this.getUIContext().put("ID", comInfo.getId().toString());
                    this.tag = false;
                }
                if (currentPKIndex == -1 && idLists != null && idLists.size() != 0) {
                    currentPKIndex = 0;
                }
                idLists.setCurrentIndex(currentPKIndex);
                this.getUIContext().put("IDList", idLists);
            }
            if (comInfo == null) {
                comInfo = (MaterialCostInfo)this.createNewData();
            }
            this.getUIContext().put("InitDataObject", comInfo);
        }
    }

    private MaterialCostInfo getCostInfoByFilter(FilterInfo filterinfo) throws BOSException {
        MaterialCostInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        SelectorItemCollection selectors = viewInfo.getSelector();
        Iterator t = this.getMergedSelector().iterator();
        while (t.hasNext()) {
            selectors.add((SelectorItemInfo)t.next());
        }
        LowTimer timer1 = new LowTimer();
        timer1.reset();
        MaterialCostCollection con = MaterialCostFactory.getRemoteInstance().getMaterialCostCollection(viewInfo);
        logger.info((Object)("1085\u884c\u8017\u7528\u65f6\u95f4\uff1a" + timer1.msValue()));
        if (con != null && con.size() >= 1) {
            info = con.get(0);
        }
        return info;
    }

    private void getMaterialID() {
        if (this.parentCTX == null) {
            MaterialClientTools.getParentCTX((EditUI)this);
        }
        if (this.parentCTX != null) {
            this.materialID = this.parentCTX.get("ID").toString();
            this.material = (MaterialInfo)this.parentCTX.get("MATERIAL_DATA");
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        if (!oprtType.equalsIgnoreCase(this.getOprtState())) {
            super.setOprtState(oprtType);
            if (this.parentCTX != null && !this.oprtState.equalsIgnoreCase("ADDNEW")) {
                this.parentCTX.put("MATERIAL_UI_STATUS", oprtType);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String strMsg = null;
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        if (this.editData.getOrgUnit() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ComOU_NOT_NULL");
            this.prmtOrgUnit.requestFocus();
            MaterialClientTools.showError((String)strMsg);
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("InitDataObject", this.editData);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tag) {
            this.loadData();
        } else {
            super.actionRemove_actionPerformed(e);
        }
        if (this.editData != null && this.editData.getId() == null) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", null);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.company != null && this.editData.getOrgUnit().getId().equals((Object)this.company.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.company != null && this.editData.getOrgUnit().getId().equals((Object)this.company.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
        this.tag = false;
    }

    private void setPrintEnable(boolean enablead) {
        this.btnPrint.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrint.setEnabled(enablead);
        this.btnPrintPreview.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrintPreview.setEnabled(enablead);
        this.separatorFW2.setVisible(enablead);
        this.kDSeparator3.setVisible(enablead);
    }

    private void setPrintEnable() {
        this.setPrintEnable(false);
    }

    public boolean isModify() {
        ArrayList<String> arr1 = new ArrayList<String>();
        arr1.add(new String("tagState"));
        ArrayList<Boolean> arr2 = new ArrayList<Boolean>();
        Boolean boolTag = new Boolean(this.tag);
        arr2.add(0, boolTag);
        this.getUIContext().put(arr1, arr2);
        if (this.prmtOrgUnit.getValue() != null && this.tag) {
            return true;
        }
        return super.isModify();
    }

    protected void addVOChangeListener(IVOChangeListener listener) {
        super.addVOChangeListener(null);
    }

    @Override
    protected void prmtDefaultCostItem_willCommit(CommitEvent e) throws Exception {
        super.prmtDefaultCostItem_willCommit(e);
        Object object = this.prmtOrgUnit.getData();
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(CostItemFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentBizOrg.getCU().getId()), "id", "adminCU.id"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        this.prmtDefaultCostItem.setEntityViewInfo(view);
    }

    @Override
    protected void prmtDefaultCostItem_willShow(SelectorEvent e) throws Exception {
        super.prmtDefaultCostItem_willShow(e);
        Object object = this.prmtOrgUnit.getData();
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(CostItemFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentBizOrg.getCU().getId()), "id", "adminCU.id"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        this.prmtDefaultCostItem.setEntityViewInfo(view);
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "bd_materialCost_addNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "bd_materialCost_update";
        }
        return "bd_materialCost_view";
    }

    private class EventsListener
    implements ChangeListener,
    ItemListener {
        private EventsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            try {
                if (source.equals(MaterialCostUI.this.prmtOrgUnit)) {
                    MaterialCostUI.this.prmtOrg_stateChanged(e);
                }
            }
            catch (Exception ex) {
                MaterialCostUI.this.handUIException(ex);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                Object source = e.getSource();
                if (source.equals(MaterialCostUI.this.comboStoreType)) {
                    MaterialCostUI.this.comboStoreType_itemStateChanged(e);
                }
            }
            catch (Exception e1) {
                MaterialCostUI.this.handUIException(e1);
            }
        }
    }
}

