/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.material.AbstractMaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialOffsetEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.ReplaceModeEnum;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ExceptionUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MaterialPlanInfo
extends AbstractMaterialPlanInfo
implements Serializable {
    public static final int MIN_OFFSET = 0;
    public static final int MAX_OFFSET = 999;
    public static final BigDecimal MAX_DEFAULT = new BigDecimal(Integer.MAX_VALUE);
    public static final BigDecimal VALUE_0 = new BigDecimal(0);
    public static final BigDecimal VALUE_100 = new BigDecimal(100);
    public static final int HALF_UP = 4;
    public static final int INT_PRECISION = 0;
    public static final int RATE_PRECISION = 2;
    public static final int QTY_PRECISION = 4;
    public static final String MTS10 = "MTS10";
    public static final String MTS11 = "MTS11";
    public static final String MTS20 = "MTS20";
    public static final String MTO10 = "MTO10";
    public static final String ETO10 = "ETO10";
    public static final String MSNULL = null;

    public MaterialPlanInfo() {
    }

    protected MaterialPlanInfo(String pkField) {
        super(pkField);
    }

    public String getLogInfo() {
        MaterialInfo matInfo = this.getMaterial();
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName();
        }
        return this.getId().toString();
    }

    public int getUnitPrecision(Context ctx) throws EASBizException, BOSException {
        int precision = 8;
        MultiMeasureUnitInfo multiUnit = null;
        try {
            IMultiMeasureUnit iMultiUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            multiUnit = iMultiUnit.getMultiUnit(this.getMaterial().getId().toString(), this.getProductUnit().getId().toString());
        }
        catch (EASBizException ee) {
            throw ee;
        }
        catch (BOSException be) {
            throw be;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (multiUnit != null) {
            precision = multiUnit.getQtyPrecision();
        }
        return precision;
    }

    public void verify() throws BOSException, EASBizException {
        this.verify(null);
    }

    public void verify(Context ctx) throws BOSException, EASBizException {
        MaterialProductEnum product;
        MaterialProvideTypeEnum provideType;
        ManufactureStrategyInfo manufactureStrategy;
        PlanningModeEnum planningMode;
        ThrowModeEnum throwMode;
        MaterialAttributeEnum materialAttr;
        BigDecimal value;
        if (this.getOrgUnit() == null) {
            throw new MaterialBaseException(MaterialBaseException.INVOU_NOT_NULL_EXCEPTION);
        }
        if (this.getMaterialAttr() == null) {
            throw new MaterialBaseException(MaterialBaseException.MATERIALATTRIBUTE_NOT_NULL_EXCEPTION);
        }
        if (this.getProductUnit() == null) {
            throw new MaterialBaseException(MaterialBaseException.INVPTODUCTUNIT_NOT_NULL_EXCEPTION);
        }
        if (this.isIsCheck() && this.getQualityOrg() == null) {
            String propName = CSSPUtils.getPropertyAlias((Context)ctx, (AbstractObjectValue)this, (String)"qualityOrg");
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{propName});
        }
        if (this.isIsMergeSign() && this.getReqUniteRule() == null) {
            throw new MaterialBaseException(MaterialBaseException.REQUNITERULE_NOT_NULL);
        }
        int intValue = this.getForwardDaysOffset();
        if (intValue < 0 || intValue > 999) {
            this.setForwardDaysOffset(0);
        }
        if ((intValue = this.getBackwardDaysOffset()) < 0 || intValue > 999) {
            this.setBackwardDaysOffset(0);
        }
        if ((intValue = this.getProduceLeadTime()) < 0) {
            this.setProduceLeadTime(0);
        }
        if ((intValue = this.getRecevingLeadTime()) < 0) {
            this.setRecevingLeadTime(0);
        }
        if ((intValue = this.getForwardProcessTime()) < 0) {
            this.setForwardProcessTime(0);
        }
        if ((intValue = this.getBackwardProcessTime()) < 0) {
            this.setBackwardProcessTime(0);
        }
        if ((value = this.getYield()) != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) <= 0 || value.compareTo(VALUE_100) > 0) {
                value = VALUE_100;
            }
            this.setYield(value);
        } else {
            this.setYield(VALUE_100);
        }
        value = this.getScrapRate();
        if (value != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(VALUE_100) >= 0) {
                value = VALUE_0;
            }
            this.setScrapRate(value);
        } else {
            this.setScrapRate(VALUE_0);
        }
        value = this.getReBookQty();
        if (value != null) {
            if ((value = value.setScale(4, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setReBookQty(value);
        } else {
            this.setReBookQty(VALUE_0);
        }
        value = this.getConsumeSpeed();
        if (value != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setConsumeSpeed(value);
        } else {
            this.setConsumeSpeed(VALUE_0);
        }
        int unitPrecision = this.getUnitPrecision(ctx);
        value = this.getFixationBatchQty();
        if (value != null) {
            if ((value = value.setScale(unitPrecision, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setFixationBatchQty(value);
        }
        if ((value = this.getMaxBatchQty()) != null) {
            if ((value = value.setScale(unitPrecision, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setMaxBatchQty(value);
        }
        if ((intValue = this.getInterval()) < 0) {
            this.setInterval(0);
        }
        if ((value = this.getMinBatchQty()) != null) {
            if ((value = value.setScale(unitPrecision, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setMinBatchQty(value);
        }
        if ((value = this.getRoundUpMulitpleQty()) != null) {
            if ((value = value.setScale(unitPrecision, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setRoundUpMulitpleQty(value);
        }
        if ((value = this.getBatchIncQty()) != null) {
            if ((value = value.setScale(unitPrecision, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setBatchIncQty(value);
        }
        if ((value = this.getIssInHightLimit()) != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setIssInHightLimit(value);
        } else {
            this.setIssInHightLimit(VALUE_0);
        }
        value = this.getIssInLowLimit();
        if (value != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(VALUE_100) >= 0) {
                value = VALUE_0;
                throw new MaterialBaseException(MaterialBaseException.ISSINLOWLMT_LESSTRANEXCEPTION);
            }
            this.setIssInLowLimit(value);
        } else {
            this.setIssInLowLimit(VALUE_0);
        }
        value = this.getRptInHightLimit();
        if (value != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setRptInHightLimit(value);
        }
        if ((value = this.getRptInLowLimit()) != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(VALUE_100) >= 0) {
                value = VALUE_0;
                throw new MaterialBaseException(MaterialBaseException.RPTINLOWLMT_LESSTHANEXCEPTION);
            }
            this.setRptInLowLimit(value);
        }
        if ((value = this.getRcvInHightLimit()) != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                value = VALUE_0;
            }
            this.setRcvInHightLimit(value);
        }
        if ((value = this.getRcvInLowLimit()) != null) {
            if ((value = value.setScale(2, 4)).compareTo(VALUE_0) < 0 || value.compareTo(VALUE_100) >= 0) {
                value = VALUE_0;
                throw new MaterialBaseException(MaterialBaseException.RCVINLOWLMT_LESSTRANEXCEPTION);
            }
            this.setRcvInLowLimit(value);
        }
        if (this.getProvideType() == null) {
            this.setProvideType(MaterialProvideTypeEnum.CURRENTORGPROVIDE);
        }
        if (MaterialProvideTypeEnum.CURRENTORGPROVIDE == this.getProvideType()) {
            StorageOrgUnitInfo supplyOrgUnit = new StorageOrgUnitInfo();
            supplyOrgUnit.setId(this.getOrgUnit().getId());
            this.setSupplyOrgUnit(supplyOrgUnit);
        } else if (MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE == this.getProvideType() || MaterialProvideTypeEnum.SPANORGPROVIDE == this.getProvideType() || MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE == this.getProvideType()) {
            if (this.getSupplyOrgUnit() == null) {
                throw new MaterialBaseException(MaterialBaseException.SUPPLYORGUNIT_NOT_NULL);
            }
            if (this.getSupplyOrgUnit() != null && this.getSupplyOrgUnit().getId() != null && this.getSupplyOrgUnit().getId().equals((Object)this.getOrgUnit().getId())) {
                throw new MaterialBaseException(MaterialBaseException.SUPPLY_ORG_ERROR);
            }
        }
        if (this.getManufactureStrategy() != null && this.getOffsetMode() == MaterialOffsetEnum.NONE) {
            this.setOffsetMode(MaterialOffsetEnum.OFFSETFORWARD);
        }
        if ((materialAttr = this.getMaterialAttr()) == MaterialAttributeEnum.PHANTOMPART) {
            this.setReplaceMode(ReplaceModeEnum.NONE);
        }
        if (ThrowModeEnum.FLOW == (throwMode = this.getThrowMode())) {
            if (this.getProductLine() == null) {
                throw new MaterialBaseException(MaterialBaseException.PRODUCTLINE_NOT_NULL);
            }
        } else {
            this.setProductLine(null);
        }
        if ((planningMode = this.getPlanningMode()) == PlanningModeEnum.MPS || planningMode == PlanningModeEnum.MRP) {
            if (this.getManufactureStrategy() == null) {
                throw new MaterialBaseException(MaterialBaseException.MANU_STRAGY_NOT_NULL);
            }
        } else {
            this.setManufactureStrategy(null);
        }
        if ((manufactureStrategy = this.getManufactureStrategy()) != null) {
            if ((materialAttr == MaterialAttributeEnum.PHANTOMPART || materialAttr == MaterialAttributeEnum.EXTERNALPROCESSINPART || materialAttr == MaterialAttributeEnum.FABRICATEDPART) && (MTS10.equals(manufactureStrategy.getNumber()) || MTS11.equals(manufactureStrategy.getNumber()) || MTS20.equals(manufactureStrategy.getNumber()))) {
                this.setIsConfigable(false);
            }
            if ("GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(manufactureStrategy.getId().toString()) || "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(manufactureStrategy.getId().toString())) {
                this.setThrowMode(ThrowModeEnum.DISCRETE);
            }
            if ((planningMode == PlanningModeEnum.MPS || planningMode == PlanningModeEnum.MRP) && ETO10.equals(manufactureStrategy.getNumber())) {
                this.setIsProductLinePlan(false);
            }
        }
        if (manufactureStrategy == null) {
            this.setThrowMode(ThrowModeEnum.DISCRETE);
            this.setIsConfigable(false);
        }
        if (manufactureStrategy != null && ("GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(manufactureStrategy.getId().toString()) || "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(manufactureStrategy.getId().toString()))) {
            if (this.getIsolatedRule() == null || IsolatedRuleEnum.NONE.equals((Object)this.getIsolatedRule())) {
                this.setIsolatedRule(IsolatedRuleEnum.ITEM_TRACKNO);
            }
        } else {
            this.setIsolatedRule(IsolatedRuleEnum.NONE);
        }
        if ((MaterialProvideTypeEnum.SPANORGPROVIDE == (provideType = this.getProvideType()) || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE == provideType) && MaterialIssueModeEnum.STRAIGHT == this.getIssMode()) {
            throw new MaterialBaseException(MaterialBaseException.ISSUEMODE_ERR1);
        }
        if ((MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE == provideType || MaterialProvideTypeEnum.SPANORGPROVIDE == provideType || MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE == provideType) && materialAttr != MaterialAttributeEnum.EXTERNALPROCESSINPART) {
            throw new MaterialBaseException(MaterialBaseException.ATTRIBUTE_ERR);
        }
        if ((MaterialProvideTypeEnum.SPANORGPROVIDE == provideType || MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE == provideType) && this.isIsStockAllot()) {
            throw new MaterialBaseException(MaterialBaseException.ISSTOCKALLOT_ERR);
        }
        if (MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE == provideType && this.getIssMode() != MaterialIssueModeEnum.STRAIGHT && this.getMaterialAttr() != MaterialAttributeEnum.OTHER && this.getOutputType() == MaterialProductEnum.RELATEDPRODUCT && this.getOutputType() == MaterialProductEnum.BYPRODUCT) {
            throw new MaterialBaseException(MaterialBaseException.ISSUEMODE_ERR);
        }
        if (this.getOutputType() == null) {
            this.setOutputType(MaterialProductEnum.OTHER);
        }
        if (this.getIssMode() == null) {
            this.setIssMode(MaterialIssueModeEnum.PRODUCEISSMODE);
        }
        if (MaterialAttributeEnum.OTHER == this.getMaterialAttr()) {
            this.setIssMode(MaterialIssueModeEnum.NOTISSMODE);
        }
        if (MaterialProductEnum.BYPRODUCT == (product = this.getOutputType()) || MaterialProductEnum.RELATEDPRODUCT == product) {
            this.setIssMode(MaterialIssueModeEnum.NOTISSMODE);
        }
        if (!this.isIsStockAllot()) {
            this.setFromInvOrg(null);
            this.setFromWarehouse(null);
        } else if (this.getFromInvOrg() != null) {
            if (this.getProvideType() == MaterialProvideTypeEnum.CURRENTORGPROVIDE) {
                // empty if block
            }
            if (this.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                // empty if block
            }
            if (this.getFromWarehouse() != null && ctx != null) {
                this.verifyWarehouse(ctx, this.getFromWarehouse().getId().toString(), this.getFromInvOrg().getId().toString());
            }
        } else {
            throw new MaterialBaseException(MaterialBaseException.MATERIALPLAN_FROMHOUSEWARE_NOTNULL);
        }
        if (ctx != null) {
            this.verifyStorageOrgUnit(ctx, this.getSupplyOrgUnit(), 1);
            this.verifyStorageOrgUnit(ctx, this.getFromInvOrg(), 2);
        }
        if (this.getPurOrg() != null && this.getPurOrg().getId() != null && ctx != null) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUtilRel.getToUnit(this.getOrgUnit().getId().toString(), 4, 3);
            boolean isInRelatCollection = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                if (!this.getPurOrg().getId().equals((Object)orgCol.get(i).getId())) continue;
                isInRelatCollection = true;
            }
            if (!isInRelatCollection) {
                throw new MaterialBaseException(MaterialBaseException.NOTRELATPURORG);
            }
        }
    }

    private void verifyStorageOrgUnit(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, int storageOrgUnitType) throws BOSException, EASBizException {
        if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
            IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
            viewInfo.setFilter(filterInfo);
            StorageOrgUnitCollection storageOrgUnitCollection = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
            if (storageOrgUnitCollection.size() <= 0) {
                if (1 == storageOrgUnitType) {
                    throw new MaterialBaseException(MaterialBaseException.MATERIALPLAN_SUPPLYORGUNIT_ISBIZUNIT);
                }
                if (2 == storageOrgUnitType) {
                    throw new MaterialBaseException(MaterialBaseException.MATERIALPLAN_FROMHOUSEWARE_ISBIZUNIT);
                }
            }
        }
    }

    private void verifyWarehouse(Context ctx, String warehouseId, String storageOrgId) throws BOSException, EASBizException {
        if (warehouseId != null && warehouseId.length() > 0 && storageOrgId != null && storageOrgId.length() > 0) {
            SQLUtil sb = new SQLUtil();
            sb.appendSql("select WAREHOUSE.FID warehouseID,WAREHOUSE.FWHSTATE whState,SOAccreditWH.FSTATUS soState from T_DB_WAREHOUSE WAREHOUSE inner join T_DB_SOAccreditWH SOAccreditWH ");
            sb.appendSql(" on WAREHOUSE.FID = SOAccreditWH.FWarehouseID");
            sb.appendSql(" and WAREHOUSE.FID = '").appendSql(warehouseId).appendSql("' ");
            sb.appendSql(" and SOAccreditWH.FStorageOrgID ='").appendSql(storageOrgId).appendSql("' ");
            try {
                ResultSet rs = sb.exeQuery(ctx);
                if (!rs.next()) {
                    throw new MaterialBaseException(MaterialBaseException.MATERIALPLAN_FROMHOUSEWARE_ILLEGAL);
                }
                if (!rs.getString("whState").equals("1") || rs.getInt("soState") != 1) {
                    throw new MaterialBaseException(MaterialBaseException.MATERIALPLAN_FROMHOUSEWARE_ILLEGAL2);
                }
            }
            catch (SQLException e) {
                throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            }
        }
    }
}

