/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.TaxDataInfo;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialSalesUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialSalesUI
extends AbstractMaterialSalesUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialSalesUI.class);
    private HashMap parentCTX = null;
    private String materialID = null;
    EventsListener event = new EventsListener();
    private MaterialInfo material = null;
    private int pricePrecision = 2;
    private int baseqtyPrecision = 2;
    private SaleOrgUnitInfo saleOrg = null;
    private boolean tag = false;
    public static final BigDecimal MAXVAL_BigDecimal = new BigDecimal("999999999999.9999999");
    private CtrlUnitInfo curCtrlUnitInfo;

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        MaterialClientTools.addCloseButton((KDToolBar)this.toolBar, (EditUI)this);
    }

    @Override
    public void loadFields() {
        this.removeEventsListerner();
        super.loadFields();
        this.addEventsListener();
        MaterialClientTools.setF7MeasureUnit((KDBizPromptBox)this.prmtUnit, (String)this.materialID);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtPrice, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.pricePrecision);
        this.txtPrice.setMaximumValue((Comparable)MAXVAL_BigDecimal);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtLowerQuantity, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.baseqtyPrecision);
        this.txtLowerQuantity.setMaximumValue((Comparable)MAXVAL_BigDecimal);
        this.setSubmitSaveButton();
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtIssueTopRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.HUNDRED_INT, (Comparable)MaterialClientTools.ZERO_INT, (int)2, (Number)new Integer(this.editData.getIssueTopRatio()));
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtIssueBottomRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.HUNDRED_INT, (Comparable)MaterialClientTools.ZERO_INT, (int)2, (Number)new Integer(this.editData.getIssueBottomRatio()));
        this.storeFields();
        FullOrgUnitInfo org = null;
        if (this.editData != null && (org = this.editData.getOrgUnit()) != null) {
            this.initUIMainOrgContext(org.getId().toString());
        }
        try {
            MaterialUtil.setQualityOrgF7((KDBizPromptBox)this.prmtQualityOrg, (OrgUnitInfo)org, (int)2, (int)32);
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    private void chkIsCheck_stateChanged() {
        if (this.chkIsConsignCheck.isSelected()) {
            this.prmtQualityOrg.setRequired(true);
        } else {
            this.prmtQualityOrg.setRequired(false);
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtOrgUnit;
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    private void doInit() {
        NewSaleF7 saleOrgF7 = new NewSaleF7();
        saleOrgF7.setMultiSelect(false);
        saleOrgF7.setIsCUFilter(true, false);
        saleOrgF7.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)saleOrgF7);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)saleOrgF7);
        this.prmtOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        this.prmtOrgUnit.setEntityViewInfo(viewInfo);
        this.prmtOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtOrgUnit.setHandleCUFilter(false);
        String ineerSql = "select FDATABASEDID from t_bd_databasedassign WHERE FBOSOBJECTTYPE = '91E210CA' and FASSIGNCUID = '" + this.curCtrlUnitInfo.getId().toString() + "'";
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)ineerSql, CompareType.INNER));
        fi.setMaskString("#0 OR #1");
        evi.setFilter(fi);
        this.prmtTaxData.setEntityViewInfo(evi);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtTaxRate, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)2);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtIssueTopRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.HUNDRED_INT, (Comparable)MaterialClientTools.ZERO_INT, (int)2, (Number)new Integer(this.editData.getIssueTopRatio()));
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtIssueBottomRatio, (boolean)false, (boolean)false, (Comparable)MaterialClientTools.HUNDRED_INT, (Comparable)MaterialClientTools.ZERO_INT, (int)2, (Number)new Integer(this.editData.getIssueBottomRatio()));
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spDaydAhead, (int)0, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spDaysDelay, (int)0, (int)-1);
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.txtCheapRate.setPrecision(4);
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialSalesInfo saleInfo = new MaterialSalesInfo();
        saleInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        saleInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        saleInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        if (this.material != null) {
            saleInfo.setMaterial(this.material);
            saleInfo.setUnit(this.material.getBaseUnit());
        }
        saleInfo.setAbcType(ABCEnum.NOTSELECT);
        saleInfo.setIsReturn(true);
        saleInfo.setIsnotCheckOnReturn(true);
        saleInfo.setCreateTime(new Timestamp(new Date().getTime()));
        saleInfo.setIssueTopRatio(0);
        saleInfo.setIssueBottomRatio(0);
        return saleInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialSalesFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selects = super.getSelectors();
        selects.add("effectedStatus");
        selects.add("status");
        selects.add("material.*");
        return selects;
    }

    private void addEventsListener() {
        this.prmtOrgUnit.addChangeListener((ChangeListener)this.event);
        this.prmtTaxData.addChangeListener((ChangeListener)this.event);
        this.chkIsConsignCheck.addChangeListener((ChangeListener)this.event);
    }

    private void removeEventsListerner() {
        this.prmtOrgUnit.removeChangeListener((ChangeListener)this.event);
        this.prmtTaxData.removeChangeListener((ChangeListener)this.event);
        this.chkIsConsignCheck.removeChangeListener((ChangeListener)this.event);
    }

    public void prmtOrg_stateChanged(ChangeEvent e) throws BOSException {
        SaleOrgUnitInfo org = (SaleOrgUnitInfo)this.prmtOrgUnit.getValue();
        MaterialSalesInfo info = null;
        if (org != null) {
            info = this.getSaleInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)org.getId().toString(), (String)"material.id", (String)this.materialID));
            this.tag = false;
        }
        if (info == null) {
            info = (MaterialSalesInfo)this.createNewData();
            if (org != null) {
                info.setOrgUnit(org.castToFullOrgUnitInfo());
            }
            this.tag = true;
        }
        this.setDataObject((IObjectValue)info);
        this.loadFields();
    }

    public void prmtTaxData_stateChanged(ChangeEvent e) {
        TaxDataInfo taxData = (TaxDataInfo)this.prmtTaxData.getValue();
        if (taxData == null) {
            this.txtTaxRate.setValue(null);
            this.txtTaxRate.setEditable(false);
        } else {
            this.txtTaxRate.setEditable(true);
            this.txtTaxRate.setValue((Object)taxData.getTaxRate());
        }
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentSaleUnit() != null && SysContext.getSysContext().getCurrentSaleUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.saleOrg = SysContext.getSysContext().getCurrentSaleUnit();
        } else if (curCtrlUnitInfo.isIsSaleOrgUnit()) {
            this.saleOrg = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    public void onLoad() throws Exception {
        if (this.editData == null) {
            this.parentCTX = MaterialClientTools.getParentCTX((EditUI)this);
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.parentCTX.get("CurrentCtrlUnit");
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.initDefaultOrgUnit(this.curCtrlUnitInfo);
            this.getMaterialID();
            this.getDefaultSalesInfo();
        }
        this.setPrintEnable();
        super.onLoad();
        this.doInit();
        this.prmtOrgUnit.setEnabled(true);
        this.prmtOrgUnit.setAccessAuthority(0);
    }

    private void getDefaultSalesInfo() throws BOSException {
        if (this.materialID != null) {
            MaterialSalesInfo saleInfo = null;
            MaterialSalesCollection colls = null;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.materialID));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("orgunit.id"));
            colls = MaterialSalesFactory.getRemoteInstance().getMaterialSalesCollection(viewInfo);
            if (this.saleOrg != null && this.saleOrg.getId() != null) {
                saleInfo = this.getSaleInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)this.saleOrg.getId().toString(), (String)"material.id", (String)this.materialID));
            }
            if (colls != null) {
                RealModeIDList idLists = new RealModeIDList();
                int currentPKIndex = -1;
                for (int i = 0; i < colls.size(); ++i) {
                    MaterialSalesInfo info = colls.get(i);
                    idLists.add(i, info.getId().toString());
                    if (saleInfo == null || !info.getOrgUnit().getId().toString().equals(saleInfo.getOrgUnit().getId().toString())) continue;
                    currentPKIndex = i;
                    this.getUIContext().put("ID", saleInfo.getId().toString());
                    this.tag = false;
                }
                if (currentPKIndex == -1 && idLists != null && idLists.size() != 0) {
                    currentPKIndex = 0;
                }
                idLists.setCurrentIndex(currentPKIndex);
                this.getUIContext().put("IDList", idLists);
            }
            if (saleInfo == null) {
                saleInfo = (MaterialSalesInfo)this.createNewData();
            }
            this.getUIContext().put("InitDataObject", saleInfo);
        }
    }

    private MaterialSalesInfo getSaleInfoByFilter(FilterInfo filterinfo) throws BOSException {
        MaterialSalesInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        SelectorItemCollection selectors = viewInfo.getSelector();
        Iterator t = this.getMergedSelector().iterator();
        while (t.hasNext()) {
            selectors.add((SelectorItemInfo)t.next());
        }
        MaterialSalesCollection con = MaterialSalesFactory.getRemoteInstance().getMaterialSalesCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            info = con.get(0);
        }
        return info;
    }

    private void getMaterialID() {
        if (this.parentCTX == null) {
            MaterialClientTools.getParentCTX((EditUI)this);
        }
        if (this.parentCTX != null) {
            this.materialID = this.parentCTX.get("ID").toString();
            this.material = (MaterialInfo)this.parentCTX.get("MATERIAL_DATA");
            String t = (String)this.parentCTX.get("BASEQTY_PRECISION");
            if (t != null && t.length() > 0) {
                this.baseqtyPrecision = Integer.parseInt(t);
            }
            if ((t = (String)this.parentCTX.get("PRICE_PRECISION")) != null && t.length() > 0) {
                this.pricePrecision = Integer.parseInt(t);
            }
        }
    }

    private void setSubmitSaveButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
                int vostatus = this.editData.getInt("status");
                this.setActionButtonVisible(vostatus);
            } else {
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnCancel.setVisible(false);
                this.menuItemCancel.setVisible(false);
                this.btnCancelCancel.setVisible(false);
                this.menuItemCancelCancel.setVisible(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            return;
        }
        if (this.material != null && this.material.getStatus() == UsedStatusEnum.FREEZED) {
            this.btnAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            if (!this.btnRemove.isVisible()) {
                this.menuItemRemove.setEnabled(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setEnabled(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            return;
        }
        this.btnAddNew.setEnabled(true);
        if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
            int vostatus = this.editData.getInt("status");
            if (vostatus == 0) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(true);
            } else if (vostatus == 1) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.btnCancel.setEnabled(true);
                this.menuItemCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
                this.menuItemCancelCancel.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
            }
            this.setActionButtonVisible(vostatus);
            if (this.material != null && this.material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                this.btnApprove.setEnabled(false);
            }
        } else {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            } else if (this.editData != null) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            }
        }
    }

    private void setActionButtonVisible(int vostatus) {
        if (vostatus == 0) {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else if (vostatus == 1) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.menuItemCancelCancel.setVisible(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setSubmitSaveButton();
        this.doFieldPermission();
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherSales(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherSales(1);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherSales(2);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherSales(3);
    }

    private void doActionOtherSales(int actionenumvalue) throws Exception {
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
            IMaterialSales isales = (IMaterialSales)this.getBizInterface();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            MaterialClientTools.doActionOtherProperty((int)actionenumvalue, (MaterialPropertyBaseInfo)this.editData, (IMaterialPropertyBase)isales, (IObjectPK)pk, (MaterialInfo)this.material);
            IObjectValue newValue = this.getValue((IObjectPK)pk);
            this.getUIContext().put("InitDataObject", newValue);
            this.setDataObject(newValue);
            this.loadFields();
        }
    }

    protected void loadData() throws Exception {
        if (this.parentCTX != null && this.materialID != null && !this.materialID.equalsIgnoreCase(this.parentCTX.get("ID").toString())) {
            this.getMaterialID();
            this.getDefaultSalesInfo();
        }
        this.getMaterialID();
        if ("EDIT".equalsIgnoreCase(this.getOprtState()) || "ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            this.unLockUI();
        }
        super.loadData();
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)pk, this.getMergedSelector());
            this.setDataObject((IObjectValue)info);
            this.loadFields();
        }
        this.tag = false;
    }

    @Override
    public void setOprtState(String oprtType) {
        if (!oprtType.equalsIgnoreCase(this.getOprtState())) {
            super.setOprtState(oprtType);
            if (this.parentCTX != null && !this.oprtState.equalsIgnoreCase("ADDNEW")) {
                this.parentCTX.put("MATERIAL_UI_STATUS", oprtType);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String strMsg = null;
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        if (this.editData.getOrgUnit() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SalesOU_NOT_NULL");
            this.prmtOrgUnit.requestFocus();
            MaterialClientTools.showError((String)strMsg);
        }
        if ((e.getSource().equals(this.btnSubmit) || e.getSource().equals(this.menuItemSubmit)) && this.editData.getUnit() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SalesUnit_NOT_NULL");
            this.prmtUnit.requestFocus();
            MaterialClientTools.showError((String)strMsg);
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("InitDataObject", this.editData);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tag) {
            this.loadData();
        } else {
            super.actionRemove_actionPerformed(e);
        }
        if (this.editData != null && this.editData.getId() == null) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", null);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.saleOrg != null && this.editData.getOrgUnit().getId().equals((Object)this.saleOrg.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.saleOrg != null && this.editData.getOrgUnit().getId().equals((Object)this.saleOrg.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
        this.tag = false;
    }

    private void setPrintEnable(boolean enablead) {
        this.btnPrint.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrint.setEnabled(enablead);
        this.btnPrintPreview.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrintPreview.setEnabled(enablead);
        this.separatorFW2.setVisible(enablead);
        this.kDSeparator3.setVisible(enablead);
    }

    private void setPrintEnable() {
        this.setPrintEnable(false);
    }

    public boolean isModify() {
        ArrayList<String> arr1 = new ArrayList<String>();
        arr1.add(new String("tagState"));
        ArrayList<Boolean> arr2 = new ArrayList<Boolean>();
        Boolean boolTag = new Boolean(this.tag);
        arr2.add(0, boolTag);
        this.getUIContext().put(arr1, arr2);
        if (this.prmtOrgUnit.getValue() != null && this.tag) {
            return true;
        }
        return super.isModify();
    }

    protected void addVOChangeListener(IVOChangeListener listener) {
        super.addVOChangeListener(null);
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "bd_materialSale_addNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "bd_materialSale_update";
        }
        return "bd_materialSale_view";
    }

    private class EventsListener
    implements ChangeListener {
        private EventsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            try {
                if (source.equals(MaterialSalesUI.this.prmtOrgUnit)) {
                    MaterialSalesUI.this.prmtOrg_stateChanged(e);
                } else if (source.equals(MaterialSalesUI.this.prmtTaxData)) {
                    MaterialSalesUI.this.prmtTaxData.removeChangeListener((ChangeListener)MaterialSalesUI.this.event);
                    MaterialSalesUI.this.prmtTaxData_stateChanged(e);
                    MaterialSalesUI.this.prmtTaxData.addChangeListener((ChangeListener)MaterialSalesUI.this.event);
                } else if (source.equals(MaterialSalesUI.this.chkIsConsignCheck)) {
                    MaterialSalesUI.this.chkIsCheck_stateChanged();
                }
            }
            catch (Exception ex) {
                MaterialSalesUI.this.handUIException(ex);
            }
        }
    }
}

