/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.mm.qm.ProductIDFactory;
import com.kingdee.eas.basedata.mm.qm.ProductIDInfo;
import com.kingdee.eas.basedata.mm.qm.client.AbstractProductIDListUI;
import com.kingdee.eas.basedata.mm.qm.client.ProductIDEditUI;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.st.basedata.STBDException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ProductIDListUI
extends AbstractProductIDListUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)ProductIDListUI.class);
    private static final String thisMsg = "com.kingdee.eas.basedata.mm.qm.STBDResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    protected String getEditUIName() {
        return ProductIDEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return UIFactoryName.MODEL;
    }

    private IObjectPK[] getSelectedListPK() {
        ArrayList listId = this.getSelectedIdValues();
        ObjectStringPK[] ids = new ObjectStringPK[listId.size()];
        if (listId != null && listId.size() > 0) {
            int num = listId.size();
            for (int i = 0; i < num; ++i) {
                ids[i] = new ObjectStringPK(listId.get(i).toString());
            }
        }
        return ids;
    }

    protected boolean isMutexControlOK(String id) {
        if (id == null) {
            return false;
        }
        try {
            this.pubFireVOChangeListener(id);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request"));
            return false;
        }
    }

    protected void releaseMutexControl(String id) {
        try {
            this.setOprtState("RELEASEALL");
            this.pubFireVOChangeListener(id);
        }
        catch (Throwable ex) {
            this.handUIException(ex);
        }
    }

    private boolean isUsed(ProductIDInfo productIDInfo) {
        boolean isUsed = false;
        if (productIDInfo != null) {
            isUsed = productIDInfo.isIsEnabled();
        }
        return isUsed;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Object o;
        IObjectPK[] pks = this.getSelectedListPK();
        ICoreBase ie = this.getBizInterface();
        ProductIDInfo productIDInfo = null;
        if (pks.length > 0 && (productIDInfo = (ProductIDInfo)ie.getValue(pks[0])).getId() != null && !this.isMutexControlOK(productIDInfo.getId().toString())) {
            return;
        }
        if (this.isUsed(productIDInfo)) {
            throw new STBDException(STBDException.EXC_ISUSED);
        }
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0 && (o = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), "isEnabled").getValue()) instanceof Boolean && ((Boolean)o).booleanValue()) {
            throw new STBDException(STBDException.EXC_ISUSED);
        }
        super.actionEdit_actionPerformed(e);
        if (productIDInfo != null && productIDInfo.getId() != null) {
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        this.actionRefresh_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int row;
        IRow iRow;
        Object o;
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block == null || block.getTop() == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((o = (iRow = this.tblMain.getRow(row = block.getTop())).getCell("isEnabled").getValue()) instanceof Boolean && ((Boolean)o).booleanValue()) {
            throw new STBDException(STBDException.EXC_ISUSED_DELETE);
        }
        super.actionRemove_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        ObjectStringPK[] pks = new ObjectStringPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            Object obj = ids.get(i);
            if (!(obj instanceof String)) continue;
            pks[i] = new ObjectStringPK((String)ids.get(i));
        }
        ProductIDFactory.getRemoteInstance().unForbid((IObjectPK[])pks);
        this.refreshList();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)thisMsg, (String)"ProductIDUnForbidOK"));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        ObjectStringPK[] pks = new ObjectStringPK[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            Object obj = ids.get(i);
            if (!(obj instanceof String)) continue;
            pks[i] = new ObjectStringPK((String)ids.get(i));
        }
        ProductIDFactory.getRemoteInstance().forbid((IObjectPK[])pks);
        this.refreshList();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)thisMsg, (String)"ProductIDForbidOK"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProductIDFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ProductIDInfo objectValue = new ProductIDInfo();
        return objectValue;
    }
}

