/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.mm.qm.AnalysisTypeEnum;
import com.kingdee.eas.basedata.mm.qm.ClientUIException;
import com.kingdee.eas.basedata.mm.qm.IQIItem;
import com.kingdee.eas.basedata.mm.qm.ProjectAttributeEnum;
import com.kingdee.eas.basedata.mm.qm.QIItemException;
import com.kingdee.eas.basedata.mm.qm.QIItemFactory;
import com.kingdee.eas.basedata.mm.qm.QIItemGroupInfo;
import com.kingdee.eas.basedata.mm.qm.QIItemInfo;
import com.kingdee.eas.basedata.mm.qm.QIItemType;
import com.kingdee.eas.basedata.mm.qm.QIStandardException;
import com.kingdee.eas.basedata.mm.qm.ValueTypeEnum;
import com.kingdee.eas.basedata.mm.qm.client.AbstractQIItemEditUI;
import com.kingdee.eas.basedata.mm.qm.client.QMClientUtils;
import com.kingdee.eas.basedata.mm.qm.client.utils.ClientUIUtils;
import com.kingdee.eas.basedata.mm.qm.qiItemGroupUtils.DefaultValueUtils;
import com.kingdee.eas.basedata.mm.qm.utils.NumericUtils;
import com.kingdee.eas.basedata.mm.qm.utils.QMUtils;
import com.kingdee.eas.basedata.mm.qm.utils.STCodingRuleUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.st.common.util.STUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class QIItemEditUI
extends AbstractQIItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger((Class)QIItemEditUI.class);
    private static final String TitleResource = "com.kingdee.eas.basedata.mm.qm.client.QmResource";
    private String columnGroupName1 = null;
    private String columnGroupName2 = null;
    private String columnGroupName3 = null;
    private String columnGroupName4 = null;
    private String columnGroupName5 = null;
    private QIItemGroupInfo groupInfo = null;
    private ItemListener valueTypeListener = null;

    protected String getEditUIName() {
        return QIItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QIItemFactory.getRemoteInstance();
    }

    public void txtNumber_validate() throws Exception {
    }

    protected IObjectValue createNewData() {
        QIItemInfo objectValue = new QIItemInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setType(QIItemType.CONSTITUENT);
        objectValue.setAnalysisType(AnalysisTypeEnum.BYQUANTITATIVE);
        objectValue.setPrecision(2);
        objectValue.setIsAudit(true);
        objectValue.setValueType(ValueTypeEnum.NUMBER);
        objectValue.setProjectAttribut(ProjectAttributeEnum.CHECK);
        objectValue.setAuditor(SysContext.getSysContext().getCurrentUserInfo());
        QIItemGroupInfo info = null;
        if (this.getUIContext().containsKey("qiItemGroup")) {
            info = (QIItemGroupInfo)this.getUIContext().get("qiItemGroup");
            objectValue.setQIItemGroup(info);
        } else {
            objectValue.setGroupName1(this.columnGroupName1);
            objectValue.setGroupName2(this.columnGroupName2);
            objectValue.setGroupName3(this.columnGroupName3);
            objectValue.setGroupName4(this.columnGroupName4);
            objectValue.setGroupName5(this.columnGroupName5);
            objectValue.setQIItemGroup(this.groupInfo);
        }
        objectValue.setIsVisibleForQIC(true);
        return objectValue;
    }

    private void setDefaultValueStatus() {
        Object o = this.valueType.getSelectedItem();
        if (o instanceof ValueTypeEnum) {
            ValueTypeEnum valueType = (ValueTypeEnum)((Object)o);
            if (valueType.equals((Object)ValueTypeEnum.NUMBER) || valueType.equals((Object)ValueTypeEnum.TEXT) || valueType.equals((Object)ValueTypeEnum.ENUM)) {
                this.txtdefaultValue.setEnabled(true);
                if (valueType.equals((Object)ValueTypeEnum.ENUM)) {
                    this.txtdefaultValue.setRequired(true);
                } else {
                    this.txtdefaultValue.setRequired(false);
                }
            } else {
                this.txtdefaultValue.setEnabled(false);
            }
        }
    }

    public void onLoad() throws Exception {
        QMClientUtils.removeItemListeners((JComponent)this.analysisType);
        super.onLoad();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnForbid.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnUnForbid.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        if (QMUtils.isNotNull((Object)this.editData.getAnalysisType())) {
            this.setFieldLockedByAnalysisType(this.editData.getAnalysisType());
        }
        this.analysisType.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent e) {
                try {
                    QIItemEditUI.this.analysisType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    QIItemEditUI.this.handUIException(exc);
                }
            }
        });
        this.setToolBarStatus();
        this.btnUnForbid.setVisible(false);
        this.btnForbid.setVisible(false);
        if (this.valueTypeListener == null) {
            this.valueTypeListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    QIItemEditUI.this.setDefaultValueStatus();
                }
            };
            this.valueType.addItemListener(this.valueTypeListener);
        }
        if ("EDIT".equalsIgnoreCase(this.getOprtState())) {
            this.lockSystemEdit();
        }
    }

    private void setToolBarStatus() {
        this.btnSave.setVisible(false);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            // empty if block
        }
    }

    private void analysisType_itemStateChanged(ItemEvent e) {
        AnalysisTypeEnum analysisType;
        if (e.getStateChange() == 1 && QMUtils.isNotNull((Object)(analysisType = (AnalysisTypeEnum)((Object)e.getItem())))) {
            this.setFieldLockedByAnalysisType(analysisType);
        }
    }

    private void setFieldLockedByAnalysisType(AnalysisTypeEnum analysisType) {
    }

    public String getUITitle() {
        String strTitle = null;
        strTitle = "ADDNEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState()) ? ClientUIUtils.getUITitle(TitleResource, "QIItemTitle", this.getOprtState()) : super.getUITitle();
        return strTitle;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Object o;
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            return;
        }
        if (StringUtils.isEmpty((String)QMClientUtils.getBizMultiLangBoxValue(this.txtName))) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.EXC_FIELD_CANNOT_NULL, new String[]{QMUtils.getResource("QIITEM_FIELD_NAME")})));
        }
        if (this.txtdefaultValue.isRequired() && StringUtils.isEmpty((String)this.txtdefaultValue.getText())) {
            this.txtdefaultValue.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.EXC_FIELD_CANNOT_NULL, new String[]{QMUtils.getResource("QIITEM_FIELD_DEFAULTVALUE")})));
        }
        if ((o = this.valueType.getSelectedItem()) instanceof ValueTypeEnum) {
            String defaultValue;
            ValueTypeEnum valueType = (ValueTypeEnum)((Object)o);
            if (valueType.equals((Object)ValueTypeEnum.ENUM) && !DefaultValueUtils.isEnumString(defaultValue = this.txtdefaultValue.getText())) {
                throw new QIItemException(QIItemException.ISNOT_ENUMSTRING);
            }
            if (valueType.equals((Object)ValueTypeEnum.NUMBER) && !StringUtils.isEmpty((String)(defaultValue = this.txtdefaultValue.getText())) && !NumericUtils.isBigDecimal(defaultValue)) {
                throw new QIItemException(QIItemException.ISNOT_NUMBERSTRING);
            }
        }
        this.checkValidity();
        if (StringUtils.isEmpty((String)this.txtprecision.getText())) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.EXC_FIELD_CANNOT_NULL, new String[]{QMUtils.getResource("QIITEM_FIELD_PRECISION")})));
        }
        int precision = 0;
        try {
            precision = Integer.parseInt(this.txtprecision.getText());
        }
        catch (NumberFormatException ne) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIStandardException(QIStandardException.EXC_FIELD_PRECISION_NOTALLOW)));
        }
        if (precision < 0 || precision > 10) {
            this.txtprecision.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIStandardException(QIStandardException.EXC_FIELD_PRECISION_NOTALLOW)));
        }
        ClientUIException uiexc = null;
        String billID = null;
        if (!"ADDNEW".equals(this.getOprtState())) {
            billID = this.editData.getId().toString();
        }
        if (STUtils.isNotNull((Object)((Object)(uiexc = ClientUIUtils.checkBaseDataDup("T_QM_QIItem", billID, (JTextField)this.txtNumber, null))))) {
            super.handUIExceptionAndAbort((Exception)((Object)uiexc));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billID, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)QMClientUtils.getBizMultiLangBoxValue(this.txtName), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("qiItemGroup.id", (Object)this.groupInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        if (QIItemFactory.getRemoteInstance().getQIItemCollection(viewInfo).size() > 0) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.SAMENAME_SAMEGROUP)));
        }
    }

    private void controlBtnAuditAndForbid() {
        this.btnAudit.setEnabled(!this.editData.isIsAudit() && !this.editData.isIsForbid());
        this.btnUnAudit.setEnabled(this.editData.isIsAudit());
        this.btnForbid.setEnabled(!this.editData.isIsForbid());
        this.btnUnForbid.setEnabled(this.editData.isIsForbid());
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        QIItemInfo qiItemInfo = (QIItemInfo)newData;
        qiItemInfo.setId(null);
        qiItemInfo.setNumber(null);
        qiItemInfo.setName(null);
        qiItemInfo.setIsAudit(true);
        qiItemInfo.setAuditor(null);
        qiItemInfo.setAuditDate(null);
    }

    protected void unLockUI() {
        super.unLockUI();
        if (QMUtils.isNotNull(this.analysisType.getSelectedItem())) {
            AnalysisTypeEnum analysistype = (AnalysisTypeEnum)((Object)this.analysisType.getSelectedItem());
            this.setFieldLockedByAnalysisType(analysistype);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("parent.*"));
        return selectors;
    }

    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            dataObject.put("parent", this.getUIContext().get("ParentNode"));
        }
        super.setDataObject(dataObject);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void loadFields() {
        super.loadFields();
        this.controlBtnAuditAndForbid();
        this.columnGroupName1 = this.editData.getGroupName1();
        this.columnGroupName2 = this.editData.getGroupName2();
        this.columnGroupName3 = this.editData.getGroupName3();
        this.columnGroupName4 = this.editData.getGroupName4();
        this.columnGroupName5 = this.editData.getGroupName5();
        this.groupInfo = this.editData.getQIItemGroup();
        this.setDefaultValueStatus();
    }

    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid id = this.editData.getId();
        if (this.editData == null || this.editData.getId() == null) {
            String msg = QMUtils.getResource("qiBillCantAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        String logInfo = this.editData.getNumber() + " " + this.editData.getName();
        IQIItem iQIItem = QIItemFactory.getRemoteInstance();
        iQIItem.audit(id.toString(), logInfo);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        MsgBox.showInfo((Component)((Object)this), (String)"\u6838\u51c6\u6210\u529f!");
        this.controlBtnAuditAndForbid();
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid id = this.editData.getId();
        if (this.editData == null || this.editData.getId() == null) {
            String msg = QMUtils.getResource("qiBillCantAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        String logInfo = this.editData.getNumber() + " " + this.editData.getName();
        IQIItem iQIItem = QIItemFactory.getRemoteInstance();
        iQIItem.unAudit(id.toString(), logInfo);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        MsgBox.showInfo((Component)((Object)this), (String)"\u53cd\u6838\u51c6\u6210\u529f!");
        this.controlBtnAuditAndForbid();
    }

    public void actionForbid_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid id = this.editData.getId();
        if (this.editData == null || this.editData.getId() == null) {
            String msg = QMUtils.getResource("qiBillCantForbid");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        String logInfo = this.editData.getNumber() + " " + this.editData.getName();
        IQIItem iQIItem = QIItemFactory.getRemoteInstance();
        iQIItem.forbid(id.toString(), logInfo);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        MsgBox.showInfo((Component)((Object)this), (String)"\u7981\u7528\u6210\u529f!");
        this.controlBtnAuditAndForbid();
    }

    public void actionUnForbid_actionPerformed(ActionEvent e) throws Exception {
        BOSUuid id = this.editData.getId();
        if (this.editData == null || this.editData.getId() == null) {
            String msg = QMUtils.getResource("qiBillCantForbid");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        String logInfo = this.editData.getNumber() + " " + this.editData.getName();
        IQIItem iQIItem = QIItemFactory.getRemoteInstance();
        iQIItem.unForbid(id.toString(), logInfo);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        MsgBox.showInfo((Component)((Object)this), (String)"\u53cd\u7981\u7528\u6210\u529f!");
        this.controlBtnAuditAndForbid();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.txtNumber.requestFocus();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.columnGroupName1 = this.editData.getGroupName1();
        this.columnGroupName2 = this.editData.getGroupName2();
        this.columnGroupName3 = this.editData.getGroupName3();
        this.columnGroupName4 = this.editData.getGroupName4();
        this.columnGroupName5 = this.editData.getGroupName5();
        this.groupInfo = this.editData.getQIItemGroup();
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (BOSException e1) {
            MsgBox.showError((String)e1.getMessage());
        }
        this.txtNumber.requestFocus();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.controlBtnAuditAndForbid();
        this.txtNumber.setEnabled(false);
        this.txtNumber.setEditable(false);
        this.lockSystemEdit();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionRemove_actionPerformed(e);
        }
        catch (CanNotDeleteException deleteException) {
            if (deleteException instanceof ObjectReferedException) {
                super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_DELETE_QIITEM)));
            }
            MsgBox.showInfo((String)deleteException.getMessage());
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.requestFocus();
    }

    private void checkValidity() {
        String number = this.txtNumber.getText();
        String name = QMClientUtils.getBizMultiLangBoxValue(this.txtName);
        if (this.isIncludeSpace(number)) {
            this.txtNumber.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NUMBER_ISINCLUDESPACE)));
        }
        if (this.isBeginUnderLine(number)) {
            this.txtNumber.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NUMBER_ISBEGINUNDERLINE)));
        }
        if (this.isBeginDot(number)) {
            this.txtNumber.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NUMBER_ISBEGINDOT)));
        }
        if (this.isIncludeLawlessChar(number)) {
            this.txtNumber.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NUMBER_INCLUDE_LAWLESSCHAR)));
        }
        if (this.isIncludeSpace(name)) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NAME_ISINCLUDESPACE)));
        }
        if (this.isBeginUnderLine(name)) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NANE_ISBEGINUNDERLINE)));
        }
        if (this.isBeginDot(name)) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NAME_ISBEGINDOT)));
        }
        if (this.isIncludeLawlessChar(name)) {
            this.txtName.requestFocus();
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.NAME_INCLUDE_LAWLESSCHAR)));
        }
    }

    private boolean isIncludeSpace(String str) {
        return str.indexOf(" ") >= 0;
    }

    private boolean isBeginUnderLine(String str) {
        return str.indexOf("_") == 0;
    }

    private boolean isBeginDot(String str) {
        return str.indexOf(".") == 0;
    }

    private boolean isIncludeLawlessChar(String str) {
        return str.indexOf("\u3001") >= 0 || str.indexOf("\u3002") >= 0;
    }

    protected void setAutoNumberByOrg(String orgType) {
        super.setAutoNumberByOrg(orgType);
        STCodingRuleUtils.setNumberEnabledForBaseData(orgType, (IObjectValue)this.editData, this.txtNumber, this.txtName, this.getOprtState());
    }

    private void lockSystemEdit() {
        String id = this.editData.getId().toString();
        if (id.equals("hofzbgEQEADgABApwKgS+Ua0gOo=") || id.equals("at6iigETEADgAAeZwKgSqUa0gOo=")) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.txtSimpleName.setEnabled(false);
            this.prmtunit.setEnabled(false);
            this.analysisType.setEnabled(false);
            this.txtprecision.setEnabled(false);
            this.projectAttribut.setEnabled(false);
            this.valueType.setEnabled(false);
            this.txtdefaultValue.setEnabled(false);
            this.prmtQiItemGroup.setEnabled(false);
            this.chkisModify.setEnabled(false);
            this.chkisVisibleForQIC.setEnabled(false);
            this.txtSeqNo.requestFocus();
        }
    }
}

