/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.mm.qm.IQIItem;
import com.kingdee.eas.basedata.mm.qm.QIItemException;
import com.kingdee.eas.basedata.mm.qm.QIItemFactory;
import com.kingdee.eas.basedata.mm.qm.QIItemGroupFactory;
import com.kingdee.eas.basedata.mm.qm.QIItemGroupInfo;
import com.kingdee.eas.basedata.mm.qm.QIItemInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardException;
import com.kingdee.eas.basedata.mm.qm.client.AbstractQIItemListUI;
import com.kingdee.eas.basedata.mm.qm.client.QIItemEditUI;
import com.kingdee.eas.basedata.mm.qm.client.QIItemGroupEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class QIItemListUI
extends AbstractQIItemListUI
implements KDPromptSelector {
    private static final long serialVersionUID = 8494478224804160339L;
    private static final Logger logger = CoreUIObject.getLogger((Class)QIItemListUI.class);
    private boolean isF7Use;
    private boolean isMultiSelect = false;
    private F7Render f7Delegate;
    private KDTSelectBlock sb = null;
    private static final String resource = "com.kingdee.eas.basedata.mm.qm.QMBDResource";

    public QIItemListUI(HashMap ctx) throws Exception {
        this.isF7Use = true;
        this.f7Delegate = new F7Render((ListUI)this, (Map)ctx);
        this.f7Delegate.init();
    }

    public void show() {
        if (this.isF7Use) {
            this.setMoveEnabled(false);
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    private void setMoveEnabled(boolean isEnabled) {
        this.btnMoveTree.setEnabled(isEnabled);
        this.menuItemMoveTree.setEnabled(isEnabled);
        this.actionMoveTree.setEnabled(isEnabled);
        this.btnGroupMoveTree.setEnabled(isEnabled);
        this.menuItemGroupMoveTree.setEnabled(isEnabled);
        this.actionGroupMoveTree.setEnabled(isEnabled);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mainQuery.setIngorePreOrders(true);
        this.tblMain.getColumn("isForbid").getStyleAttributes().setHided(true);
        this.tblMain.setColumnMoveable(true);
    }

    protected boolean initDefaultFilter() {
        if (this.isF7Use) {
            return true;
        }
        return super.initDefaultFilter();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public Object getData() {
        if (!this.isMultiSelect) {
            return this.f7Delegate.getF7Data();
        }
        Object[] keyValues = this.getSelectedIdValues().toArray();
        if (keyValues != null) {
            if (keyValues.length <= 0) {
                return null;
            }
            try {
                ICoreBase iBiz = this.getBizInterface();
                ObjectUuidPK pk = null;
                QIItemInfo[] qIItemInfo = new QIItemInfo[keyValues.length];
                int c = keyValues.length;
                for (int i = 0; i < c; ++i) {
                    pk = new ObjectUuidPK(BOSUuid.read((String)keyValues[i].toString()));
                    qIItemInfo[i] = (QIItemInfo)iBiz.getValue((IObjectPK)pk);
                }
                return qIItemInfo;
            }
            catch (Exception er) {
                super.handUIException((Throwable)er);
            }
        }
        return null;
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(800, 600));
                if (ctx == null) {
                    ctx = new HashMap();
                }
                this.f7Delegate = new F7Render((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public void setFilter(FilterInfo filterInfo) {
        EntityViewInfo v = new EntityViewInfo();
        v.setFilter(filterInfo);
        this.setDefaultEntityViewInfo(v);
    }

    public QIItemListUI() throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode) {
            if (treeNode.getChildCount() > 0) {
                super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.ONLY_ADD_QIITEM_LOWEST)));
            }
            String[] groupNames = this.getGroupName(treeNode);
            this.getUIContext().put("qiItemGroup", this.getSelectedNodInfo());
            this.getUIContext().put("groupNames", groupNames);
            super.actionAddNew_actionPerformed(e);
        }
    }

    private String[] getGroupName(KDTreeNode treeNode) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (KDTreeNode currentTreeNode = treeNode; null != currentTreeNode && null != currentTreeNode.getParent(); currentTreeNode = (KDTreeNode)currentTreeNode.getParent()) {
            QIItemGroupInfo groupInfo = (QIItemGroupInfo)currentTreeNode.getUserObject();
            if (groupInfo == null) continue;
            groupNameList.add(groupInfo.getName());
        }
        String[] groupNames = new String[groupNameList.size()];
        int count = groupNameList.size();
        for (int i = 0; i < count; ++i) {
            groupNames[i] = groupNameList.get(count - 1 - i).toString();
        }
        return groupNames;
    }

    protected String getEditUIName() {
        return QIItemEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QIItemFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        QIItemInfo objectValue = new QIItemInfo();
        return objectValue;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QIItemGroupFactory.getRemoteInstance();
    }

    public void checkPermissionOnLoad() throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK((ItemAction)this.actionOnLoad), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionOnLoad);
    }

    protected String getRootName() {
        return "\u8d28\u68c0\u9879\u76ee";
    }

    protected String getQueryFieldName() {
        return "qIItemGroup.id";
    }

    private QIItemGroupInfo getSelectedNodInfo() {
        QIItemGroupInfo ruleGroupInfo = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            ruleGroupInfo = (QIItemGroupInfo)treeNode.getUserObject();
        }
        return ruleGroupInfo;
    }

    protected String getGroupEditUIName() {
        return QIItemGroupEditUI.class.getName();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        this.sb = this.tblMain.getSelectManager().get();
        QIItemInfo qIItemInfo = null;
        ObjectUuidPK detail = new ObjectUuidPK(this.getSelectedKeyValue());
        try {
            qIItemInfo = (QIItemInfo)this.getBizInterface().getValue((IObjectPK)detail);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (qIItemInfo.getQIItemGroup() == null || qIItemInfo.getQIItemGroup().getId() == null) {
            return null;
        }
        return new ObjectUuidPK(qIItemInfo.getQIItemGroup().getId());
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode && treeNode.getParent() == null) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_ADD_ONEGROUP)));
        }
        if (this.hasQIItem()) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_ADD_GROUP_QIITEM)));
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        String number;
        this.checkTreeNodeSelected(e);
        boolean temp = this.isIsIncludeChild();
        this.setIsIncludeChild(true);
        super.buildTreeFilter();
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode && this.getSelectedNodInfo() != null && this.getSelectedNodInfo().getLevel() == 1 && ((number = this.getSelectedNodInfo().getNumber()).equals("1") || number.equals("2") || number.equals("3") || number.equals("4"))) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_REMOVE)));
        }
        boolean flag = this.hasQIItem();
        this.setIsIncludeChild(temp);
        if (flag) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIStandardException(QIStandardException.CAN_NOT_REMOVETREE_THAT_HAVE_ENTRY)));
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo mainFilter = super.getDefaultFilterForQuery();
        if (!this.isF7Use) {
            return mainFilter;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isAudit", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isForbid", (Object)"0", CompareType.EQUALS));
        if (mainFilter != null && FilterUtility.hasFilterItem((FilterInfo)mainFilter)) {
            if (null != filter) {
                try {
                    mainFilter.mergeFilter(filter, "AND");
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            return mainFilter;
        }
        return filter;
    }

    protected String getEditUIModal() {
        return UIFactoryName.MODEL;
    }

    protected String getSelectDetailTreeName() {
        return "qIItemGroup";
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        String number;
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode && this.getSelectedNodInfo() != null && this.getSelectedNodInfo().getLevel() == 1 && ((number = this.getSelectedNodInfo().getNumber()).equals("1") || number.equals("2") || number.equals("3") || number.equals("4"))) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_MOVETREE_GROUPONE)));
        }
        if (null != (treeNode = e.getTargetNode())) {
            if (treeNode.getParent() == null) {
                super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_MOVETREE_TOROOT)));
            } else {
                QIItemGroupInfo groupInfo = (QIItemGroupInfo)treeNode.getUserObject();
                if (groupInfo != null && this.hasQIItem(groupInfo.getId().toString())) {
                    super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_MOVETREE)));
                }
            }
        }
        try {
            IIDList ids = this.getSelectedKeyValues();
            int count = ids.size();
            for (int i = 0; i < count; ++i) {
                QIItemFactory.getRemoteInstance().isReferenced((IObjectPK)new ObjectStringPK(ids.getID(i)));
            }
        }
        catch (ObjectReferedException e1) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_MOVETREE_REFERENCE)));
        }
        catch (Exception e2) {
            // empty catch block
        }
        super.moveGroupTreeNode(e);
        try {
            this.treeMain_valueChanged(null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private boolean hasQIItem() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode) {
            QIItemGroupInfo groupInfo = (QIItemGroupInfo)treeNode.getUserObject();
            return this.hasQIItem(groupInfo.getId().toString());
        }
        return false;
    }

    private boolean hasQIItem(String qIItemGroupID) {
        boolean flag = false;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("qIItemGroup.id", (Object)qIItemGroupID, CompareType.EQUALS));
            filterInfo.setMaskString("#0");
            viewInfo.setFilter(filterInfo);
            flag = !QIItemFactory.getRemoteInstance().getCollection(viewInfo).isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        StringBuffer numbers = new StringBuffer();
        ArrayList ids = super.getSelectedIdValues();
        if (ids != null) {
            boolean hasException = false;
            QIItemInfo aQIStandardInfo = null;
            int num = ids.size();
            for (int i = 0; i < num; ++i) {
                try {
                    this.pubFireVOChangeListener(ids.get(i).toString());
                }
                catch (Throwable ex) {
                    if (num == 1) {
                        this.handUIException(ex);
                        return;
                    }
                    hasException = true;
                    continue;
                }
                try {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
                    BOSUuid id = BOSUuid.read((String)ids.get(i).toString());
                    if (!this.getBizInterface().exists((IObjectPK)pk)) continue;
                    IQIItem iQIStandard = QIItemFactory.getRemoteInstance();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    aQIStandardInfo = iQIStandard.getQIItemInfo((IObjectPK)pk, sic);
                    if (aQIStandardInfo == null) continue;
                    String logInfo = aQIStandardInfo.getNumber() + " " + aQIStandardInfo.getName();
                    if (!aQIStandardInfo.isIsAudit()) {
                        iQIStandard.audit(id.toString(), logInfo);
                    } else if (numbers.length() == 0) {
                        numbers.append(aQIStandardInfo.getNumber());
                    } else {
                        numbers.append("\u3001");
                        numbers.append(aQIStandardInfo.getNumber());
                    }
                }
                catch (Exception onfe) {
                    if (num == 1) {
                        this.refreshList();
                        throw onfe;
                    }
                    hasException = true;
                }
                try {
                    this.pubFireVOChangeListener(ids.get(i).toString());
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (hasException) {
                this.refreshList();
                throw new QIItemException(QIItemException.PARTOFAUDITEDBILL_CANNOT_BE_AUDIT);
            }
        }
        if (numbers.length() != 0) {
            String temp = EASResource.getString((String)"com.kingdee.eas.basedata.mm.qm.QMBDResource.QIItemHasAudit");
            numbers.append(temp);
            this.setMessageText(numbers.toString());
            this.showMessage();
        }
        this.refresh(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK[] pks;
        int i;
        ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
        ObjectUuidPK id = null;
        StringBuffer logInfo = new StringBuffer();
        if (this.tblMain.getSelectManager().size() > 0) {
            int size = this.tblMain.getSelectManager().size();
            for (i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("id").getValue() == null || !((Boolean)row.getCell("isAudit").getValue()).booleanValue()) continue;
                    id = new ObjectUuidPK(row.getCell("id").getValue().toString());
                    pkList.add(id);
                    logInfo.append(row.getCell("number").getValue().toString()).append(" ");
                    logInfo.append(row.getCell("name").getValue().toString()).append(" ");
                }
            }
            if (pkList.isEmpty()) {
                throw new QIItemException(QIItemException.LIST_UNAUDIT_EMPTY);
            }
        }
        if (pkList.size() > 0) {
            pks = new ObjectUuidPK[pkList.size()];
            pkList.toArray(pks);
        } else {
            pks = new ObjectUuidPK[]{};
        }
        this.checkSelected();
        IQIItem iTechnicsRouteFacade = QIItemFactory.getRemoteInstance();
        for (i = 0; i < pks.length; ++i) {
            iTechnicsRouteFacade.unAudit(pks[i].toString(), logInfo.toString());
        }
        this.refresh(e);
        String msg = QIItemListUI.getResource("QIITEM_LIST_UNAUDIT_OK");
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    private static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)resource, (String)strKey);
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        QIItemGroupInfo groupInfo;
        KDTreeNode treeNode = e.getTargetNode();
        if (null != treeNode && (groupInfo = (QIItemGroupInfo)treeNode.getUserObject()) != null && !groupInfo.isIsLeaf()) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIItemException(QIItemException.CANT_MOVEITEM_NOTLEAF)));
        }
        try {
            ArrayList ids = this.getSelectedIdValues();
            int count = ids.size();
            for (int i = 0; i < count; ++i) {
                QIItemFactory.getRemoteInstance().isReferenced((IObjectPK)new ObjectStringPK(ids.get(i).toString()));
            }
        }
        catch (ObjectReferedException e1) {
            super.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.moveTreeNode(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTree_actionPerformed(e);
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }
}

