/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.mm.qm.IQIStandard;
import com.kingdee.eas.basedata.mm.qm.IQIStandardFacade;
import com.kingdee.eas.basedata.mm.qm.QIBizTypeInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardException;
import com.kingdee.eas.basedata.mm.qm.QIStandardFacadeFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardGroupFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardGroupInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardInfo;
import com.kingdee.eas.basedata.mm.qm.client.AbstractQIStandardListUI;
import com.kingdee.eas.basedata.mm.qm.client.BillHeadQiStdF7Invoker;
import com.kingdee.eas.basedata.mm.qm.client.MaterialCantNotFoundException;
import com.kingdee.eas.basedata.mm.qm.client.QIStandardEditUI;
import com.kingdee.eas.basedata.mm.qm.client.QIStandardFilterUI;
import com.kingdee.eas.basedata.mm.qm.client.QIStandardGroupEditUI;
import com.kingdee.eas.basedata.mm.qm.client.QiStandardF7Invoker;
import com.kingdee.eas.basedata.mm.qm.utils.STClientUtils;
import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class QIStandardListUI
extends AbstractQIStandardListUI
implements KDPromptSelector {
    private QiStandardF7Invoker invoker = null;
    private static final long serialVersionUID = 320092459450918876L;
    private static final Logger logger = CoreUIObject.getLogger((Class)QIStandardListUI.class);
    private boolean isF7Use;
    private F7Render f7Delegate;
    private KDTSelectBlock sb = null;
    private static final String resource = "com.kingdee.eas.basedata.mm.qm.QMBDResource";

    public QIStandardListUI(HashMap ctx) throws Exception {
        this.isF7Use = true;
        this.f7Delegate = new F7Render((ListUI)this, (Map)ctx);
        this.f7Delegate.init();
    }

    public void show() {
        if (this.isF7Use) {
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    protected boolean initDefaultFilter() {
        if (this.isF7Use) {
            return true;
        }
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        if (this.isF7Use) {
            return !this.f7Delegate.isF7HasCuDefaultFilter();
        }
        return super.isIgnoreCUFilter();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        viewInfo.setIngorePreOrders(false);
        return exec;
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
            if (STQMUtils.isNotNull(this.sb)) {
                this.tblMain.getSelectManager().select(this.sb);
            }
        }
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(800, 600));
                if (ctx == null) {
                    ctx = new HashMap<String, SelectorItemCollection>();
                }
                if (this.invoker != null) {
                    ctx.put("SelectorCollection", this.getF7ForMaterialFilterSelectors());
                }
                this.f7Delegate = new F7Render((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (MaterialCantNotFoundException ex) {
                this.invoker.showErrorMsg();
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
    }

    public QIStandardListUI() throws Exception {
    }

    protected String getEditUIModal() {
        return UIFactoryName.EDITWIN;
    }

    public void loadFields() {
        IColumn c = this.tblMain.getColumn("qIStandardEntry.seq");
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        this.mainQuery.setIngorePreOrders(true);
        this.tblMain.setColumnMoveable(true);
        IColumn c = this.tblMain.getColumn("qIStandardEntry.seq");
        KDTColumns tc = this.tblMain.getColumns();
        c.getStyleAttributes().setHided(false);
        this.actionBathAssign.setVisible(true);
        this.actionViewAssigned.setVisible(true);
        this.actionAssignDataBaseD.setVisible(false);
        this.actionReferDataBaseD.setVisible(false);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        String[] QTY_COLUMNS = new String[]{"qIStandardEntry.lower", "qIStandardEntry.upper"};
        try {
            STClientUtils.initColumnsPrecision(rowSet, "qIStandardEntry.precision", QTY_COLUMNS);
        }
        catch (SQLException e) {
            super.handUIException((Throwable)e);
        }
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"number", "name", "simpleName", "description", "judgeType", "exeStandard", "isAudited", "isForbid", "qiBizType.name", "postState.name", "modifyType.name", "creator.name", "createTime", "updator.name", "lastUpdateTime", "auditor.name", "auditDate", "creator.name", "createTime", "updator.name", "lastUpdateTime", "auditor.name", "auditDate"};
        return strMergeColKeys;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        StringBuffer numbers = new StringBuffer();
        ArrayList ids = super.getSelectedIdValues();
        if (ids != null) {
            boolean hasException = false;
            QIStandardInfo aQIStandardInfo = null;
            int num = ids.size();
            for (int i = 0; i < num; ++i) {
                try {
                    this.pubFireVOChangeListener(ids.get(i).toString());
                }
                catch (Throwable ex) {
                    if (num == 1) {
                        this.handUIException(ex);
                        return;
                    }
                    hasException = true;
                    continue;
                }
                try {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
                    BOSUuid id = BOSUuid.read((String)ids.get(i).toString());
                    if (!this.getBizInterface().exists((IObjectPK)pk)) continue;
                    IQIStandard iQIStandard = QIStandardFactory.getRemoteInstance();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("isAudited"));
                    aQIStandardInfo = iQIStandard.getQIStandardInfo((IObjectPK)pk, sic);
                    if (aQIStandardInfo == null) continue;
                    String logInfo = aQIStandardInfo.getNumber() + " " + aQIStandardInfo.getName();
                    if (!aQIStandardInfo.isIsAudited()) {
                        IQIStandardFacade iQIStandardFacade = QIStandardFacadeFactory.getRemoteInstance();
                        iQIStandardFacade.auditQIStandard(id.toString(), logInfo);
                    } else if (numbers.length() == 0) {
                        numbers.append(aQIStandardInfo.getNumber());
                    } else {
                        numbers.append("\u3001");
                        numbers.append(aQIStandardInfo.getNumber());
                    }
                }
                catch (Exception onfe) {
                    if (num == 1) {
                        this.refreshList();
                        throw onfe;
                    }
                    hasException = true;
                }
                try {
                    this.pubFireVOChangeListener(ids.get(i).toString());
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (hasException) {
                this.refreshList();
                throw new QIStandardException(QIStandardException.PARTOFAUDITEDBILL_CANNOT_BE_AUDIT);
            }
        }
        if (numbers.length() != 0) {
            String temp = EASResource.getString((String)"com.kingdee.eas.basedata.mm.qm.QMBDResource.StandardHasAudit");
            numbers.append(temp);
            MsgBox.showInfo((Component)((Object)this), (String)numbers.toString());
        } else {
            String msg = QIStandardListUI.getResource("QISTANDARD_LIST_AUDIT_OK");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
        }
        this.refresh(e);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK[] pks;
        int i;
        ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
        ObjectUuidPK id = null;
        StringBuffer logInfo = new StringBuffer();
        if (this.tblMain.getSelectManager().size() > 0) {
            int size = this.tblMain.getSelectManager().size();
            for (i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("id").getValue() == null || !((Boolean)row.getCell("isAudited").getValue()).booleanValue()) continue;
                    id = new ObjectUuidPK(row.getCell("id").getValue().toString());
                    pkList.add(id);
                    logInfo.append(row.getCell("number").getValue().toString()).append(" ");
                    logInfo.append(row.getCell("name").getValue().toString()).append(" ");
                }
            }
            if (pkList.isEmpty()) {
                throw new QIStandardException(QIStandardException.LIST_UNAUDIT_EMPTY);
            }
        }
        if (pkList.size() > 0) {
            pks = new ObjectUuidPK[pkList.size()];
            pkList.toArray(pks);
        } else {
            pks = new ObjectUuidPK[]{};
        }
        this.checkSelected();
        try {
            IQIStandardFacade iTechnicsRouteFacade = QIStandardFacadeFactory.getRemoteInstance();
            for (i = 0; i < pks.length; ++i) {
                iTechnicsRouteFacade.unAuditQIStandard(pks[i].toString(), logInfo.toString());
            }
        }
        catch (Exception tre) {
            this.handleException(tre);
            return;
        }
        this.refresh(e);
        String msg = QIStandardListUI.getResource("QISTANDARD_LIST_UNAUDIT_OK");
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    private static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)resource, (String)strKey);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (null != treeNode) {
            this.getUIContext().put("qiStandardGroup", this.getSelectedNodInfo());
            super.actionAddNew_actionPerformed(e);
        }
    }

    protected String getEditUIName() {
        return QIStandardEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QIStandardFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        QIStandardInfo objectValue = new QIStandardInfo();
        return objectValue;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return QIStandardGroupFactory.getRemoteInstance();
    }

    public void checkPermissionOnLoad() throws EASBizException, BOSException {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK((ItemAction)this.actionOnLoad), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionOnLoad);
    }

    protected String getRootName() {
        return "\u8d28\u68c0\u6807\u51c6";
    }

    protected String getQueryFieldName() {
        return "qiStandardGroup.id";
    }

    private QIStandardGroupInfo getSelectedNodInfo() {
        QIStandardGroupInfo ruleGroupInfo = null;
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            ruleGroupInfo = (QIStandardGroupInfo)treeNode.getUserObject();
        }
        return ruleGroupInfo;
    }

    protected String getGroupEditUIName() {
        return QIStandardGroupEditUI.class.getName();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        this.sb = this.tblMain.getSelectManager().get();
        QIStandardInfo qIStandardInfo = null;
        ObjectUuidPK detail = new ObjectUuidPK(this.getSelectedKeyValue());
        if (detail == null) {
            return null;
        }
        try {
            qIStandardInfo = (QIStandardInfo)this.getBizInterface().getValue((IObjectPK)detail);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (qIStandardInfo.getQiStandardGroup() == null || qIStandardInfo.getQiStandardGroup().getId() == null) {
            return null;
        }
        return new ObjectUuidPK(qIStandardInfo.getQiStandardGroup().getId());
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        boolean temp = this.isIsIncludeChild();
        this.setIsIncludeChild(true);
        super.buildTreeFilter();
        boolean flag = QIStandardFactory.getRemoteInstance().getCollection(this.mainQuery).isEmpty();
        this.setIsIncludeChild(temp);
        if (!flag) {
            super.handUIExceptionAndAbort((Exception)((Object)new QIStandardException(QIStandardException.CAN_NOT_REMOVETREE_THAT_HAVE_ENTRY)));
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    public FilterInfo getDefaultFilterForQuery() {
        FilterInfo mainFilter = super.getDefaultFilterForQuery();
        if (!this.isF7Use) {
            return mainFilter;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isAudited", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isForbid", (Object)"0", CompareType.EQUALS));
        if (this.invoker != null) {
            try {
                BillHeadQiStdF7Invoker billinvoker;
                QIBizTypeInfo qti;
                MaterialInfo material;
                MaterialInfo mi = material = this.invoker.getMaterial();
                filter.getFilterItems().add(new FilterItemInfo("materialEntry.material.id", (Object)mi.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("materialEntry.isForbid", (Object)"0", CompareType.EQUALS));
                if (this.invoker instanceof BillHeadQiStdF7Invoker && STQMUtils.isNotNull(qti = (billinvoker = (BillHeadQiStdF7Invoker)this.invoker).getQIBizType())) {
                    filter.getFilterItems().add(new FilterItemInfo("qiBizType.number", (Object)qti.getNumber(), CompareType.EQUALS));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MaterialCantNotFoundException();
            }
        }
        if (mainFilter != null && FilterUtility.hasFilterItem((FilterInfo)mainFilter)) {
            if (null != filter) {
                try {
                    mainFilter.mergeFilter(filter, "AND");
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            return mainFilter;
        }
        return filter;
    }

    protected String getSelectDetailTreeName() {
        return "qiStandardGroup";
    }

    public QiStandardF7Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(QiStandardF7Invoker invoker) {
        this.invoker = invoker;
    }

    private SelectorItemCollection getF7ForMaterialFilterSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("type.*"));
        sic.add(new SelectorItemInfo("isActivity"));
        sic.add(new SelectorItemInfo("judgeType"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("qiStandardGroup.*"));
        sic.add(new SelectorItemInfo("isForbid"));
        sic.add(new SelectorItemInfo("qiBizType.*"));
        sic.add(new SelectorItemInfo("exeStandard"));
        sic.add(new SelectorItemInfo("postState.id"));
        sic.add(new SelectorItemInfo("postState.number"));
        sic.add(new SelectorItemInfo("postState.name"));
        sic.add(new SelectorItemInfo("qIStandardEntry.qiItem.*"));
        sic.add(new SelectorItemInfo("qIStandardEntry.qiCondition"));
        sic.add(new SelectorItemInfo("qIStandardEntry.precision"));
        sic.add(new SelectorItemInfo("qIStandardEntry.valueType"));
        sic.add(new SelectorItemInfo("qIStandardEntry.projectAttribut"));
        sic.add(new SelectorItemInfo("qIStandardEntry.defaultValue"));
        sic.add(new SelectorItemInfo("qIStandardEntry.expression"));
        sic.add(new SelectorItemInfo("qIStandardEntry.unit.*"));
        sic.add(new SelectorItemInfo("qIStandardEntry.isModify"));
        sic.add(new SelectorItemInfo("qIStandardEntry.seq"));
        sic.add(new SelectorItemInfo("qIStandardEntry.id"));
        sic.add(new SelectorItemInfo("qIStandardEntry.number"));
        sic.add(new SelectorItemInfo("qIStandardEntry.name"));
        sic.add(new SelectorItemInfo("qIStandardEntry.isRequired"));
        sic.add(new SelectorItemInfo("qIStandardEntry.isJudge"));
        sic.add(new SelectorItemInfo("qIStandardEntry.upper"));
        sic.add(new SelectorItemInfo("qIStandardEntry.lower"));
        sic.add(new SelectorItemInfo("qIStandardEntry.remark"));
        sic.add(new SelectorItemInfo("qIStandardEntry.upCompare"));
        sic.add(new SelectorItemInfo("qIStandardEntry.lowCompare"));
        sic.add(new SelectorItemInfo("materialEntry.isForbid"));
        sic.add(new SelectorItemInfo("materialEntry.id"));
        sic.add(new SelectorItemInfo("materialEntry.material.*"));
        sic.add(new SelectorItemInfo("materialEntry.material.number"));
        sic.add(new SelectorItemInfo("materialEntry.material.model"));
        sic.add(new SelectorItemInfo("materialEntry.material.name"));
        sic.add(new SelectorItemInfo("isAudited"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog conditionDialog = super.initCommonQueryDialog();
        try {
            QIStandardFilterUI userPanel = new QIStandardFilterUI();
            if (userPanel != null) {
                conditionDialog.addUserPanel((KDPanel)userPanel);
            }
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return conditionDialog;
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        MetaDataPK pkQuery = new MetaDataPK("com.kingdee.eas.basedata.mm.qm.app.QIStandardQueryForListForAssign");
        if (pkQuery == null) {
            EntityObjectInfo eoi1 = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizInterface().getType());
            String queryName = eoi1.getExtendedProperty("defaultF7Query");
            pkQuery = new MetaDataPK(queryName);
        }
        return pkQuery;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            String id = this.getSelectedKeyValue().toString();
            boolean isAudit = QIStandardFacadeFactory.getRemoteInstance().isAudit(id);
            if (isAudit) {
                throw new QIStandardException(QIStandardException.EXC_QISTANDARD_AUDIT);
            }
        }
        super.actionEdit_actionPerformed(e);
    }
}

