/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.eas.basedata.mm.qm.utils.STQMUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateUtils {
    public static final int KEY_STARTDATE = 0;
    public static final int KEY_ENDDATE = 1;
    public static final int NANOS_MAX = 999999999;
    public static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public static Date dateAddByMonth(Date date, int addMonth) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        c.set(2, month + 1);
        return c.getTime();
    }

    public static Timestamp DateToTime(Date date) {
        return STQMUtils.isNotNull(date) ? new Timestamp(date.getTime()) : new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public static Date timeToDate(Timestamp time) {
        return STQMUtils.isNotNull(time) ? new Date(time.getTime()) : DateUtils.now();
    }

    public static Date simpleDate(Date date) throws ParseException {
        Date d = STQMUtils.isNotNull(date) ? date : new Date();
        return format.parse(format.format(d));
    }

    public static int compareByDate(Date dateLeft, Date dateRight) throws ParseException {
        Date ld = DateUtils.simpleDate(dateLeft);
        Date sd = DateUtils.simpleDate(dateRight);
        return ld.compareTo(sd);
    }

    public static int compareToNowByDate(Date date) throws ParseException {
        return DateUtils.compareByDate(null, date);
    }

    public static Date now() {
        return Calendar.getInstance().getTime();
    }

    public static Timestamp nowTime() {
        return DateUtils.DateToTime(DateUtils.now());
    }

    public static Timestamp nowStart() {
        return DateUtils.time(null, 0);
    }

    public static Timestamp nowEnd() {
        return DateUtils.time(null, 1);
    }

    public static Timestamp startTime(Date date) {
        return DateUtils.time(date, 0);
    }

    public static Timestamp endTime(Date date) {
        return DateUtils.time(date, 1);
    }

    public static Timestamp time(Date date, int key) {
        Date d = STQMUtils.isNotNull(date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        Timestamp t = null;
        if (0 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(0);
        } else if (1 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        }
        return t;
    }

    public static Timestamp queryTime(Date date, int key) {
        Date d = STQMUtils.isNotNull(date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        Timestamp t = null;
        if (0 == key) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(0);
        } else if (1 == key) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            t = new Timestamp(calendar.getTimeInMillis());
            t.setNanos(999999999);
        }
        return t;
    }

    public static Timestamp firstDateOfMonth(Date date) {
        Date d = STQMUtils.isNotNull(date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        Timestamp t = null;
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        t = new Timestamp(calendar.getTimeInMillis());
        t.setNanos(0);
        return t;
    }

    public static Timestamp lastDateOfMonth(Date date) {
        Date d = STQMUtils.isNotNull(date) ? date : new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(2, 1);
        Timestamp t = null;
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        calendar.add(5, -1);
        t = new Timestamp(calendar.getTimeInMillis());
        t.setNanos(0);
        return t;
    }
}

