/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class MaterialGroupUtils {
    private static Map materialLongNumberMap = new HashMap();
    private static String TRIM = "";

    public static String getMaterialGroupName(Context ctx, String materialId, int materialGroupLevel) throws EASBizException, BOSException {
        if (materialId != null) {
            MaterialGroupInfo group = MaterialGroupUtils.getMaterialGroup(ctx, materialId);
            if (group != null) {
                return MaterialGroupUtils.getGroupName(ctx, group, materialGroupLevel);
            }
            return TRIM;
        }
        return TRIM;
    }

    public static String getMaterialGroupName(Context ctx, MaterialInfo material, int materialGroupLevel) throws EASBizException, BOSException {
        if (material != null && material.getId() != null) {
            return MaterialGroupUtils.getMaterialGroupName(ctx, material.getId().toString(), materialGroupLevel);
        }
        return TRIM;
    }

    public static String getMaterialGroupName(Context ctx, MaterialInfo material) throws EASBizException, BOSException {
        if (material != null && material.getId() != null) {
            return MaterialGroupUtils.getMaterialGroupName(ctx, material.getId().toString());
        }
        return TRIM;
    }

    public static String getMaterialGroupName(Context ctx, String materialId) throws EASBizException, BOSException {
        if (materialId != null) {
            MaterialGroupInfo group = MaterialGroupUtils.getMaterialGroup(ctx, materialId);
            if (group != null) {
                return group.getName();
            }
            return TRIM;
        }
        return TRIM;
    }

    private static MaterialGroupInfo getMaterialGroup(Context ctx, String materialId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)materialId)) {
            MaterialGroupInfo group = (MaterialGroupInfo)materialLongNumberMap.get(materialId);
            if (group == null) {
                IMaterial iMaterial = null;
                iMaterial = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("materialGroup.*"));
                MaterialInfo material = iMaterial.getMaterialInfo((IObjectPK)new ObjectStringPK(materialId), selector);
                group = material.getMaterialGroup();
                materialLongNumberMap.put(materialId, group);
            }
            return group;
        }
        return null;
    }

    private static String getGroupName(Context ctx, MaterialGroupInfo group, int materialGroupLevel) throws BOSException, EASBizException {
        if (group == null) {
            return TRIM;
        }
        int num = 0;
        String longNumber = group.getLongNumber();
        char ch = '!';
        if (longNumber != null) {
            char[] chs = longNumber.trim().toCharArray();
            char[] copys = new char[longNumber.length() + 1];
            System.arraycopy(chs, 0, copys, 0, chs.length);
            copys[copys.length - 1] = ch;
            int size = copys.length;
            for (int i = 0; i < size; ++i) {
                if (ch == copys[i]) {
                    ++num;
                }
                if (num != materialGroupLevel) continue;
                longNumber = String.valueOf(copys);
                longNumber = longNumber.substring(0, i);
                break;
            }
            if (num != materialGroupLevel) {
                return TRIM;
            }
            IMaterialGroup iGroup = null;
            iGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
            ev.setFilter(filter);
            MaterialGroupCollection collection = iGroup.getMaterialGroupCollection(ev);
            if (collection.size() != 0) {
                String groupName = collection.get(0).getName();
                if (groupName == null) {
                    groupName = TRIM;
                }
                return groupName;
            }
        }
        return TRIM;
    }
}

