/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeEntryCollection;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeEntryInfo;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeFactory;
import com.kingdee.eas.basedata.mm.qm.ModifyTypeInfo;
import com.kingdee.eas.basedata.mm.qm.QIItemFactory;
import com.kingdee.eas.basedata.mm.qm.QIItemInfo;
import com.kingdee.eas.basedata.mm.qm.QIStandardFactory;
import com.kingdee.eas.basedata.mm.qm.QIStandardInfo;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class ModifyTypeCalculateUtils {
    private static final long INFLATED = Long.MIN_VALUE;
    private static final int MAX_COMPACT_DIGITS = 18;
    private Context ctx = null;
    ModifyTypeEntryCollection entryCol = new ModifyTypeEntryCollection();

    public ModifyTypeCalculateUtils(QIStandardInfo qiStandardInfo, Context ctx) {
        if (qiStandardInfo == null || qiStandardInfo.getId() == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u8d28\u68c0\u6807\u51c6Info\u4e3a\u7a7a\uff01");
        }
        this.ctx = ctx;
        ObjectStringPK qistandardpk = new ObjectStringPK(qiStandardInfo.getId().toString());
        try {
            QIStandardInfo qiStandard = null;
            qiStandard = ctx == null ? QIStandardFactory.getRemoteInstance().getQIStandardInfo((IObjectPK)qistandardpk, ModifyTypeCalculateUtils.getQIStandardSelectors()) : QIStandardFactory.getLocalInstance(ctx).getQIStandardInfo((IObjectPK)qistandardpk, ModifyTypeCalculateUtils.getQIStandardSelectors());
            ModifyTypeInfo modifyTypeInfo = qiStandard.getModifyType();
            this.init(modifyTypeInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ModifyTypeCalculateUtils(ModifyTypeInfo modifyTypeInfo, Context ctx) {
        if (modifyTypeInfo == null || modifyTypeInfo.getId() == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u4fee\u7ea6\u65b9\u5f0fInfo\u4e3a\u7a7a\uff01");
        }
        this.ctx = ctx;
        try {
            this.init(modifyTypeInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(ModifyTypeInfo modifyTypeInfo) throws Exception {
        ObjectStringPK modifytypepk = new ObjectStringPK(modifyTypeInfo.getId().toString());
        if (this.ctx == null) {
            ModifyTypeInfo modifyType = ModifyTypeFactory.getRemoteInstance().getModifyTypeInfo((IObjectPK)modifytypepk, ModifyTypeCalculateUtils.getModifyTypeSelectors());
            this.entryCol = modifyType.getEntries();
        } else {
            ModifyTypeInfo modifyType = ModifyTypeFactory.getLocalInstance(this.ctx).getModifyTypeInfo((IObjectPK)modifytypepk, ModifyTypeCalculateUtils.getModifyTypeSelectors());
            this.entryCol = modifyType.getEntries();
        }
    }

    public BigDecimal modifyCalculate(QIItemInfo qiItemInfo, BigDecimal toCheckValue) throws Exception {
        if (qiItemInfo == null || qiItemInfo.getId() == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u8d28\u68c0\u9879\u76eeInfo\u4e3a\u7a7a\uff01");
        }
        if (toCheckValue == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u5f85\u68c0\u9a8c\u6570\u4e3a\u7a7a\uff01");
        }
        ObjectStringPK qiitempk = new ObjectStringPK(qiItemInfo.getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        QIItemInfo qiItem = null;
        qiItem = this.ctx == null ? QIItemFactory.getRemoteInstance().getQIItemInfo((IObjectPK)qiitempk, sic) : QIItemFactory.getLocalInstance(this.ctx).getQIItemInfo((IObjectPK)qiitempk, sic);
        if (!qiItem.isIsModify()) {
            return toCheckValue;
        }
        if (this.entryCol.size() == 0) {
            return toCheckValue;
        }
        int size = this.entryCol.size();
        for (int i = 0; i < size; ++i) {
            boolean isOK;
            QIItemInfo qiItemCompare;
            ModifyTypeEntryInfo entry = this.entryCol.get(i);
            if (entry == null || entry.getId() == null || (qiItemCompare = entry.getQiItem()) == null || qiItemCompare.getId() == null || !qiItem.getId().toString().equals(qiItemCompare.getId().toString()) || !(isOK = this.checkBeModifiedIn(toCheckValue, entry.getUpCompare(), entry.getLowCompare(), entry.getUpper(), entry.getLower()))) continue;
            double checkValue = toCheckValue.doubleValue();
            double offset = entry.getModifyOffset().doubleValue();
            int digitals = entry.getValidDigits();
            int multiple = entry.getMultiple().getValue();
            double afterModifiedValue = ModifyTypeCalculateUtils.modifyDouble(checkValue, offset, digitals, multiple);
            return new BigDecimal(String.valueOf(afterModifiedValue));
        }
        return toCheckValue;
    }

    private boolean checkBeModifiedIn(BigDecimal toBeModified, CompareSignStringEnum upCompare, CompareSignStringEnum lowCompare, BigDecimal upper, BigDecimal lower) {
        if (toBeModified == null) {
            return false;
        }
        if (CompareSignStringEnum.NULLSIGN.equals((Object)upCompare) && CompareSignStringEnum.NULLSIGN.equals((Object)lowCompare)) {
            return true;
        }
        if (CompareSignStringEnum.NULLSIGN.equals((Object)upCompare) && !CompareSignStringEnum.NULLSIGN.equals((Object)lowCompare)) {
            String str1;
            if (lower == null) {
                throw new IllegalArgumentException("\u4e0b\u9650\u6bd4\u8f83\u7b26\u4e0d\u4e3a\u7a7a\uff0c\u4e0b\u9650\u503c\u4e3a\u7a7a\u7684\u9519\u8bef\uff01");
            }
            if (toBeModified.compareTo(lower) > 0) {
                return true;
            }
            if (toBeModified.compareTo(lower) == 0 && (str1 = lowCompare.getValue()).indexOf(61) != -1) {
                return true;
            }
        } else if (!CompareSignStringEnum.NULLSIGN.equals((Object)upCompare) && CompareSignStringEnum.NULLSIGN.equals((Object)lowCompare)) {
            String str1;
            if (upper == null) {
                throw new IllegalArgumentException("\u4e0a\u9650\u6bd4\u8f83\u7b26\u4e0d\u7a7a\uff0c\u4e0a\u9650\u5236\u4e3a\u7a7a\u7684\u9519\u8bef\uff01");
            }
            if (toBeModified.compareTo(upper) < 0) {
                return true;
            }
            if (toBeModified.compareTo(upper) == 0 && (str1 = upCompare.getValue()).indexOf(61) != -1) {
                return true;
            }
        } else {
            if (lower == null) {
                throw new IllegalArgumentException("\u4e0b\u9650\u6bd4\u8f83\u7b26\u4e0d\u4e3a\u7a7a\uff0c\u4e0b\u9650\u503c\u4e3a\u7a7a\u7684\u9519\u8bef\uff01");
            }
            if (upper == null) {
                throw new IllegalArgumentException("\u4e0a\u9650\u6bd4\u8f83\u7b26\u4e0d\u7a7a\uff0c\u4e0a\u9650\u5236\u4e3a\u7a7a\u7684\u9519\u8bef\uff01");
            }
            if (toBeModified.compareTo(lower) > 0 && toBeModified.compareTo(upper) < 0) {
                return true;
            }
            if (toBeModified.compareTo(lower) == 0) {
                String str1 = lowCompare.getValue();
                return str1.indexOf(61) != -1;
            }
            if (toBeModified.compareTo(upper) == 0) {
                String str1 = upCompare.getValue();
                return str1.indexOf(61) != -1;
            }
        }
        return false;
    }

    private static double modifyCalStep2And3(double toBeModified, double offset, int multiple, boolean needMultiple) {
        char charCheck;
        int i;
        double tobeModifiedTemp = 0.0;
        double offsetTemp = 0.0;
        if (needMultiple) {
            tobeModifiedTemp = toBeModified * (double)multiple;
            offsetTemp = offset * (double)multiple;
        } else {
            tobeModifiedTemp = toBeModified / (double)multiple;
            offsetTemp = offset;
        }
        double modifyValue = tobeModifiedTemp;
        String plainString = ModifyTypeCalculateUtils.toPlainString(new BigDecimal(String.valueOf(tobeModifiedTemp)));
        plainString.trim();
        StringBuffer checkStrBuf = new StringBuffer(plainString);
        checkStrBuf.setLength(plainString.length());
        int dotIndexOfCheck = checkStrBuf.indexOf(".");
        String offsetStr = ModifyTypeCalculateUtils.toPlainString(new BigDecimal(String.valueOf(offsetTemp)));
        offsetStr.trim();
        int dotIndexOfOffset = offsetStr.indexOf(".");
        int dex = 0;
        if (offsetTemp >= 1.0) {
            dex = -dotIndexOfOffset;
        } else {
            String sub = offsetStr.substring(dotIndexOfOffset + 1);
            char[] chs = sub.toCharArray();
            for (i = chs.length - 1; i >= 0; --i) {
                char ch = chs[i];
                if (ch == '0') continue;
                dex = i + 1;
                break;
            }
        }
        int checkIndex = dotIndexOfCheck + dex + 1;
        if (checkIndex < 0) {
            return toBeModified;
        }
        if (checkIndex >= checkStrBuf.length()) {
            int size = checkIndex - checkStrBuf.length() + 1;
            for (i = 0; i < size; ++i) {
                checkStrBuf.append('0');
            }
        }
        if ((charCheck = checkStrBuf.charAt(checkIndex)) == '.') {
            charCheck = checkStrBuf.charAt(++checkIndex);
        }
        String answer = checkStrBuf.substring(0, checkIndex);
        modifyValue = Double.parseDouble(answer);
        if (charCheck < '5') {
            if (dex < 0) {
                modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
            }
        } else if (charCheck == '5') {
            String sub = checkStrBuf.substring(checkIndex + 1);
            char[] chs = sub.toCharArray();
            if (chs == null || chs.length == 0) {
                char remain = checkStrBuf.charAt(checkIndex - 1);
                if (remain == '.') {
                    remain = checkStrBuf.charAt(checkIndex - 2);
                }
                if (remain % 2 == 0) {
                    if (dex < 0) {
                        modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
                    }
                } else if (dex < 0) {
                    modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
                    modifyValue += Math.pow(10.0, Math.abs(dex) - 1);
                } else if (dex > 0) {
                    modifyValue += Math.pow(0.1, Math.abs(dex));
                }
            } else {
                boolean isAllZero = true;
                for (int i2 = 0; i2 < chs.length; ++i2) {
                    char ch = chs[i2];
                    if (ch == '.' || ch == '0') continue;
                    if (dex < 0) {
                        modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
                        modifyValue += Math.pow(10.0, Math.abs(dex) - 1);
                    } else if (dex > 0) {
                        modifyValue += Math.pow(0.1, Math.abs(dex));
                    }
                    isAllZero = false;
                    break;
                }
                if (isAllZero) {
                    char remain = checkStrBuf.charAt(checkIndex - 1);
                    if (remain == '.') {
                        remain = checkStrBuf.charAt(checkIndex - 2);
                    }
                    if (remain % 2 == 0) {
                        if (dex < 0) {
                            modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
                        }
                    } else if (dex < 0) {
                        modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
                        modifyValue += Math.pow(10.0, Math.abs(dex) - 1);
                    } else if (dex > 0) {
                        modifyValue += Math.pow(0.1, Math.abs(dex));
                    }
                }
            }
        } else if (dex < 0) {
            modifyValue *= Math.pow(10.0, Math.abs(dex) - 1);
            modifyValue += Math.pow(10.0, Math.abs(dex) - 1);
        } else if (dex > 0) {
            modifyValue += Math.pow(0.1, Math.abs(dex));
        }
        return modifyValue;
    }

    public static double modifyDouble(double toBeModified, double offset, int validDigitals, int multiple) {
        boolean transfer = false;
        double modifyValue = toBeModified;
        if (toBeModified < 0.0) {
            modifyValue = Math.abs(toBeModified);
            transfer = true;
        }
        modifyValue = ModifyTypeCalculateUtils.modifyCalStep2And3(modifyValue, offset, multiple, true);
        modifyValue = ModifyTypeCalculateUtils.modifyCalStep2And3(modifyValue, offset, multiple, false);
        BigDecimal step3bd = new BigDecimal(String.valueOf(modifyValue));
        BigInteger intVal = ModifyTypeCalculateUtils.toIntValue(step3bd);
        int scale = step3bd.scale();
        String str = intVal.toString(10);
        int len = str.length();
        StringBuffer buf = new StringBuffer(str);
        double result = 0.0;
        if (validDigitals >= len) {
            for (int i = 0; i < validDigitals - len; ++i) {
                buf.append('0');
                ++scale;
            }
            result = Double.parseDouble(ModifyTypeCalculateUtils.getValueString(1, buf.toString(), scale));
        } else {
            int newScale;
            char ch = buf.charAt(validDigitals);
            buf.delete(validDigitals, buf.length());
            if (ch >= '5') {
                long value = Long.parseLong(buf.toString());
                buf = new StringBuffer(String.valueOf(++value));
            }
            if ((newScale = scale - (len - validDigitals)) < 0) {
                int v = Math.abs(newScale);
                for (int i = 0; i < v; ++i) {
                    buf.append('0');
                }
                result = Double.parseDouble(buf.toString());
            } else {
                result = Double.parseDouble(ModifyTypeCalculateUtils.getValueString(1, buf.toString(), newScale));
            }
        }
        if (transfer) {
            result = -result;
        }
        return result;
    }

    public static double modifyFormula() {
        return 0.0;
    }

    public static BigDecimal modifyCalculate(QIItemInfo qiItemInfo, BigDecimal toCheckValue, ModifyTypeInfo modifyTypeInfo) throws Exception {
        return null;
    }

    public static BigDecimal modifyCalculate(QIItemInfo qiItemInfo, BigDecimal toCheckValue, QIStandardInfo qiStandardInfo) throws Exception {
        return null;
    }

    public static SelectorItemCollection getModifyTypeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.qiItem.*"));
        return sic;
    }

    public static SelectorItemCollection getQIStandardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("modifyType.*"));
        return sic;
    }

    private static String getValueString(int signum, String intString, int scale) {
        StringBuffer buf;
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
            if (signum < 0) {
                buf.insert(0, '-');
            }
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    public static BigInteger toIntValue(BigDecimal bd) {
        if (bd == null) {
            return null;
        }
        String dbValue = bd.toString();
        if (dbValue == null) {
            return null;
        }
        int scaleTemp = bd.scale();
        int singnum = bd.signum();
        if (scaleTemp < 0) {
            bd.setScale(0);
        }
        char[] in = dbValue.toCharArray();
        int offset = 0;
        int len = dbValue.length();
        int precision = 0;
        int scale = 0;
        long intCompact = Long.MIN_VALUE;
        BigInteger intVal = null;
        try {
            char[] quick;
            boolean isneg = false;
            if (in[offset] == '-') {
                isneg = true;
                ++offset;
                --len;
            } else if (in[offset] == '+') {
                ++offset;
                --len;
            }
            int dotoff = -1;
            int cfirst = offset;
            long exp = 0L;
            if (len > in.length) {
                throw new NumberFormatException();
            }
            char[] coeff = new char[len];
            while (len > 0) {
                char c = in[offset];
                if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                    coeff[precision] = c;
                    ++precision;
                } else if (c == '.') {
                    if (dotoff >= 0) {
                        throw new NumberFormatException();
                    }
                    dotoff = offset;
                } else {
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException();
                    }
                    c = in[++offset];
                    --len;
                    boolean negexp = false;
                    if (c == '-' || c == '+') {
                        negexp = c == '-';
                        c = in[++offset];
                        --len;
                    }
                    if (len <= 0) {
                        throw new NumberFormatException();
                    }
                    while (len > 10 && Character.digit(c, 10) == 0) {
                        c = in[++offset];
                        --len;
                    }
                    if (len > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int v;
                        if (c >= '0' && c <= '9') {
                            v = c - 48;
                        } else {
                            v = Character.digit(c, 10);
                            if (v < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        exp = exp * 10L + (long)v;
                        if (len == 1) break;
                        c = in[++offset];
                        --len;
                    }
                    if (negexp) {
                        exp = -exp;
                    }
                    if ((long)((int)exp) == exp) break;
                    throw new NumberFormatException();
                }
                ++offset;
                --len;
            }
            if (precision == 0) {
                throw new NumberFormatException();
            }
            if (dotoff >= 0) {
                scale = precision - (dotoff - cfirst);
            }
            if (exp != 0L) {
                // empty if block
            }
            int first = 0;
            while ((coeff[first] == '0' || Character.digit(coeff[first], 10) == 0) && precision > 1) {
                --precision;
                ++first;
            }
            if (!isneg) {
                quick = new char[precision];
                System.arraycopy(coeff, first, quick, 0, precision);
            } else {
                quick = new char[precision + 1];
                quick[0] = 45;
                System.arraycopy(coeff, first, quick, 1, precision);
            }
            if (precision <= 18) {
                intCompact = Long.parseLong(new String(quick));
            } else {
                intVal = new BigInteger(String.valueOf(quick), 10);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException e) {
            throw new NumberFormatException();
        }
        if (intVal == null) {
            intVal = BigInteger.valueOf(intCompact);
        }
        return intVal;
    }

    public static String toPlainString(BigDecimal bd) {
        int scale = bd.scale();
        BigInteger intVal = ModifyTypeCalculateUtils.toIntValue(bd);
        if (scale < 0) {
            StringBuffer buf = new StringBuffer(intVal.toString());
            int size = Math.abs(scale);
            for (int i = 0; i < size; ++i) {
                buf.append('0');
            }
            return buf.toString();
        }
        if (scale == 0) {
            StringBuffer buf = new StringBuffer(intVal.toString());
            buf.append(".0");
            return buf.toString();
        }
        return ModifyTypeCalculateUtils.getValueString(bd.signum(), intVal.abs().toString(), scale);
    }
}

