/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.mm.qm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.mm.qm.client.KDTableUtils;
import com.kingdee.eas.basedata.mm.qm.utils.QtyMultiMeasureUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PrecisionUtils {
    private static Map precisionMap = new HashMap();
    private static PrecisionUtils instance;
    private static final int DEFAULT_PRECISION = 4;
    private static final int ERROR_PRECISION = -1;
    private static final int NULL_PRECISION = -2;

    private PrecisionUtils() {
    }

    public static PrecisionUtils getInstance() {
        if (instance == null) {
            instance = new PrecisionUtils();
        }
        return instance;
    }

    public void batchLoad(KDTable table, String materialField, String unitField) throws BOSException {
        if (PrecisionUtils.checkData(table, materialField, unitField)) {
            ArrayList<Object> materialList = new ArrayList<Object>();
            ArrayList<Object> unitList = new ArrayList<Object>();
            int size = table.getRowCount();
            for (int i = 0; i < size; ++i) {
                Object materialObj = KDTableUtils.getFieldValue(table, i, materialField);
                Object unitObj = KDTableUtils.getFieldValue(table, i, unitField);
                if (!(materialObj instanceof MaterialInfo) || !(unitObj instanceof MeasureUnitInfo)) continue;
                materialList.add(materialObj);
                unitList.add(unitObj);
            }
            this.batchLoad(materialList, unitList);
        }
    }

    private static boolean checkData(KDTable table, String materialField, String unitField) {
        return table != null && KDTableUtils.getColumn(table, materialField) != null && KDTableUtils.getColumn(table, unitField) != null;
    }

    public synchronized void batchLoad(ArrayList materialList, ArrayList unitList) throws BOSException {
        if (this.checkInput(materialList, unitList)) {
            try {
                ArrayList<MaterialInfo> mList = new ArrayList<MaterialInfo>();
                ArrayList<MeasureUnitInfo> uList = new ArrayList<MeasureUnitInfo>();
                int size = materialList.size();
                for (int i = 0; i < size; ++i) {
                    MaterialInfo material = (MaterialInfo)materialList.get(i);
                    MeasureUnitInfo unit = (MeasureUnitInfo)unitList.get(i);
                    if (material == null || material.getId() == null || unit == null || unit.getId() == null) break;
                    int precision = this.innerGetPrecision(material.getId().toString(), unit.getId().toString());
                    if (precision != -2) continue;
                    mList.add(material);
                    uList.add(unit);
                }
                HashMap<Integer, String> materialIDMap = new HashMap<Integer, String>();
                HashMap unitMap = new HashMap();
                int size2 = mList.size();
                for (int i = 0; i < size2; ++i) {
                    Integer key = new Integer(i);
                    materialIDMap.put(key, ((MaterialInfo)mList.get(i)).getId().toString());
                    unitMap.put(key, uList.get(i));
                }
                Map map = QtyMultiMeasureUtils.getMultiUnitsPrecision(null, materialIDMap, unitMap, null, null);
                precisionMap.putAll(map);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private boolean checkInput(ArrayList materialList, ArrayList unitList) {
        if (materialList == null || unitList == null || materialList.size() == unitList.size()) {
            return false;
        }
        return !materialList.contains(null) && !unitList.contains(null);
    }

    private int innerGetPrecision(String materialID, String unitID) {
        if (StringUtils.isEmpty((String)materialID) || StringUtils.isEmpty((String)unitID)) {
            return -1;
        }
        String key = materialID + unitID;
        if (precisionMap.get(key) == null) {
            return -2;
        }
        return (Integer)precisionMap.get(key);
    }

    public synchronized int getPrecision(Context ctx, String materialID, String unitID) throws EASBizException, BOSException {
        int precision = this.innerGetPrecision(materialID, unitID);
        if (precision == -1) {
            return 4;
        }
        if (precision == -2) {
            String key = materialID + unitID;
            precision = QtyMultiMeasureUtils.qtyPrecision(ctx, materialID, unitID);
            precisionMap.put(key, new Integer(precision));
            return precision;
        }
        return precision;
    }

    public synchronized int getPrecision(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        if (material == null || material.getId() == null || unit == null || unit.getId() == null) {
            return 4;
        }
        return this.getPrecision(null, material.getId().toString(), unit.getId().toString());
    }

    public static void setPrecision(KDTable table, String materialField, String unitField, String[] qtyFields) throws BOSException, EASBizException {
        if (PrecisionUtils.checkData(table, materialField, unitField, qtyFields)) {
            PrecisionUtils.getInstance().batchLoad(table, materialField, unitField);
            int size = table.getRowCount();
            for (int i = 0; i < size; ++i) {
                Object materialObj = KDTableUtils.getFieldValue(table, i, materialField);
                Object unitObj = KDTableUtils.getFieldValue(table, i, unitField);
                if (!(materialObj instanceof MaterialInfo) || !(unitObj instanceof MeasureUnitInfo)) continue;
                int precision = PrecisionUtils.getInstance().getPrecision((MaterialInfo)materialObj, (MeasureUnitInfo)unitObj);
                KDTableUtils.setBigDecimalFieldsPrecision(precision, table, i, qtyFields);
            }
        }
    }

    private static boolean checkData(KDTable table, String materialField, String unitField, String[] qtyFields) {
        return table != null && KDTableUtils.getColumn(table, materialField) != null && KDTableUtils.getColumn(table, unitField) != null && qtyFields != null;
    }
}

